/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.storage.graph.neo4j;

import com.geoway.atlas.common.error.VerificationException;
import com.geoway.atlas.common.error.VerificationException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.storage.graph.common.GraphDbStorageInfo$;
import java.io.Serializable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Neo4jGraphDbStorageInfo$
implements LazyLogging {
    public static Neo4jGraphDbStorageInfo$ MODULE$;
    private final String STORAGE_DRIVER_CLASS;
    private final String STORAGE_NAME;
    private final String CONNECT_HEAD;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new Neo4jGraphDbStorageInfo$();
    }

    private Logger logger$lzycompute() {
        Neo4jGraphDbStorageInfo$ neo4jGraphDbStorageInfo$ = this;
        synchronized (neo4jGraphDbStorageInfo$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String STORAGE_DRIVER_CLASS() {
        return this.STORAGE_DRIVER_CLASS;
    }

    public String STORAGE_NAME() {
        return this.STORAGE_NAME;
    }

    public String CONNECT_HEAD() {
        return this.CONNECT_HEAD;
    }

    public <T> Object runQuery(Map<String, String> storageParams, String[] queries, Function1<Result, T> resultHandler, ClassTag<T> evidence$1) {
        Object object;
        String connectionHost = (String)storageParams.apply((Object)GraphDbStorageInfo$.MODULE$.GRAPH_CONNECT_HOST());
        String userName = (String)storageParams.apply((Object)GraphDbStorageInfo$.MODULE$.GRAPH_USERNAME());
        String password = (String)storageParams.apply((Object)GraphDbStorageInfo$.MODULE$.GRAPH_PASSWORD());
        Driver driver = GraphDatabase.driver((String)new StringBuilder(0).append(this.CONNECT_HEAD()).append(connectionHost).toString(), (AuthToken)AuthTokens.basic((String)userName, (String)password));
        ObjectRef session = ObjectRef.create(null);
        try {
            try {
                session.elem = driver.session();
                Object results = evidence$1.newArray(queries.length);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queries)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)queryIndex -> {
                    long startTime = System.currentTimeMillis();
                    MODULE$.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(34).append("\u6267\u884c\u67e5\u8be2\n             |").append(queries[queryIndex]).append("\n             |").toString())).stripMargin());
                    Result result = ((Session)session$1.elem).run(queries[queryIndex]);
                    ScalaRunTime$.MODULE$.array_update(results, queryIndex, resultHandler.apply((Object)result));
                    long endTime = System.currentTimeMillis();
                    MODULE$.logger().info(new StringBuilder(6).append("\u67e5\u8be2\u8017\u65f6: ").append(endTime - startTime).toString());
                });
                object = results;
            }
            catch (Throwable throwable) {
                this.logger().error(ExceptionUtils.getStackTrace((Throwable)throwable));
                String x$1 = new StringBuilder(10).append("Neo4j\u6267\u884c\u5931\u8d25:").append(ExceptionUtils.getRootCauseMessage((Throwable)throwable)).toString();
                Thread x$2 = VerificationException$.MODULE$.apply$default$2(x$1);
                int x$3 = VerificationException$.MODULE$.apply$default$3(x$1);
                throw new VerificationException(x$1, x$2, x$3);
            }
        }
        catch (Throwable throwable) {
            if ((Session)session.elem != null) {
                ((Session)session.elem).close();
            }
            try {
                driver.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        Object object2 = object;
        if ((Session)session.elem != null) {
            ((Session)session.elem).close();
        }
        try {
            driver.close();
        }
        catch (Throwable throwable) {}
        return object2;
    }

    private Neo4jGraphDbStorageInfo$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.STORAGE_DRIVER_CLASS = "org.neo4j.spark.DataSource";
        this.STORAGE_NAME = "neo4j";
        this.CONNECT_HEAD = "bolt://";
    }
}

