/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentState;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.jdbc.GeoToolsJdbcProxyUtils;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCUpdateFeatureWriter;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class AJDBCInsertFeatureWriter
extends JDBCFeatureReader
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private final JDBCFeatureReader.ResultSetFeature[] buffer;
    private int curBufferPos = 0;

    public AJDBCInsertFeatureWriter(String sql, Connection cx, JDBCFeatureSource featureSource, Query query) throws SQLException, IOException {
        super(sql, cx, featureSource, featureSource.getSchema(), query);
        this.md = this.rs.getMetaData();
        this.buffer = new JDBCFeatureReader.ResultSetFeature[this.dataStore.getBatchInsertSize()];
    }

    public AJDBCInsertFeatureWriter(PreparedStatement ps, Connection cx, JDBCFeatureSource featureSource, Query query) throws SQLException, IOException {
        super(ps, cx, featureSource, featureSource.getSchema(), query);
        this.md = this.rs.getMetaData();
        this.buffer = new JDBCFeatureReader.ResultSetFeature[this.dataStore.getBatchInsertSize()];
    }

    public AJDBCInsertFeatureWriter(JDBCUpdateFeatureWriter other) throws IOException {
        super((JDBCFeatureReader)other);
        this.buffer = new JDBCFeatureReader.ResultSetFeature[this.dataStore.getBatchInsertSize()];
    }

    private JDBCFeatureReader.ResultSetFeature getOrCreateRSF() throws IOException {
        JDBCFeatureReader.ResultSetFeature result = this.buffer[this.curBufferPos];
        if (result == null) {
            try {
                this.buffer[this.curBufferPos] = result = new JDBCFeatureReader.ResultSetFeature((JDBCFeatureReader)this, this.rs, this.cx);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    public boolean hasNext() throws IOException {
        return false;
    }

    public SimpleFeature next() throws IOException {
        JDBCFeatureReader.ResultSetFeature rsf = this.getOrCreateRSF();
        rsf.init(null);
        return rsf;
    }

    public void remove() throws IOException {
    }

    public void write() throws IOException {
        if (++this.curBufferPos >= this.buffer.length) {
            this.flush();
        }
    }

    protected void cleanup() throws IOException {
        try {
            this.flush();
        }
        catch (Throwable throwable) {
            for (int i = 0; i < this.buffer.length && this.buffer[i] != null; ++i) {
                this.buffer[i].close();
                this.buffer[i] = null;
            }
            super.cleanup();
            throw throwable;
        }
        for (int i = 0; i < this.buffer.length && this.buffer[i] != null; ++i) {
            this.buffer[i].close();
            this.buffer[i] = null;
        }
        super.cleanup();
    }

    private void flush() throws IOException {
        if (this.curBufferPos == 0) {
            return;
        }
        try {
            List<JDBCFeatureReader.ResultSetFeature> features = Arrays.asList(Arrays.copyOfRange(this.buffer, 0, this.curBufferPos));
            boolean hasFid = GeoToolsJdbcProxyUtils.insert(this.dataStore, features, this.featureType, this.st.getConnection());
            if (hasFid) {
                for (JDBCFeatureReader.ResultSetFeature cur : features) {
                    String fid = (String)cur.getUserData().get("fid");
                    cur.setID(fid);
                    SimpleFeature orig = (SimpleFeature)cur.getUserData().get("_original_");
                    if (orig != null) {
                        ((FeatureIdImpl)orig.getIdentifier()).setID(fid);
                        orig.getUserData().putAll(cur.getUserData());
                        orig.getUserData().remove("_original_");
                    }
                    ContentEntry entry = this.featureSource.getEntry();
                    ContentState state = entry.getState(this.tx);
                    state.fireFeatureAdded((FeatureSource)this.featureSource, (Feature)cur);
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            this.curBufferPos = 0;
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            super.close();
        }
    }
}

