/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.geoway.atlas.common.config.AtlasSystemProperties;
import com.geoway.atlas.common.error.IoException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.geotools.data.Query;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.LimitingVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueCountVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.visitor.ExpressionTypeVisitor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.jdbc.AttributeRange;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JoinInfo;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.VirtualTable;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;

public class GeoToolsJdbcRangeUtils {
    public static final String OPTIMIZE_FILTER = "atlas.data.vector.jdbc.filter.optimize";

    public static AttributeRange getRange(JDBCDataStore jdbcDataStore, SimpleFeatureType sft, String attributeName, Query query) {
        MaxVisitor maxVisitor = new MaxVisitor(attributeName, sft);
        MinVisitor minVisitor = new MinVisitor(attributeName, sft);
        Connection cx = jdbcDataStore.createConnection();
        try {
            if (Boolean.parseBoolean(AtlasSystemProperties.getProperty((String)OPTIMIZE_FILTER, (String)"false")) && !Filter.INCLUDE.toString().equals(query.getFilter().toString())) {
                GeoToolsJdbcRangeUtils.getAggregateValue(jdbcDataStore, (FeatureVisitor)maxVisitor, sft, query, cx);
                GeoToolsJdbcRangeUtils.getAggregateValue(jdbcDataStore, (FeatureVisitor)minVisitor, sft, query, cx);
            } else {
                jdbcDataStore.getAggregateValue((FeatureVisitor)maxVisitor, sft, query, cx);
                jdbcDataStore.getAggregateValue((FeatureVisitor)minVisitor, sft, query, cx);
            }
        }
        catch (IOException ioException) {
            String message = "\u6267\u884csql\u8fc7\u7a0b\u4e2d\u53d1\u751fio\u5f02\u5e38:" + ExceptionUtils.getRootCauseMessage((Throwable)ioException);
            jdbcDataStore.getLogger().log(Level.SEVERE, message, ioException);
            throw new IoException("\u6267\u884csql\u8fc7\u7a0b\u4e2d\u53d1\u751fio\u5f02\u5e38:" + message, Thread.currentThread(), 3);
        }
        finally {
            jdbcDataStore.closeSafe(cx);
        }
        try {
            AttributeRange attributeRange = new AttributeRange(attributeName, minVisitor.getMin(), maxVisitor.getMax());
            if (minVisitor.getMin() == null || maxVisitor.getMax() == null) {
                return new AttributeRange(attributeName, new Integer(0), new Integer(0));
            }
            return attributeRange;
        }
        catch (IllegalStateException illegalStateException) {
            String message = "\u9488\u5bf9\u6570\u636e:" + sft.getTypeName() + ", \u5217:" + attributeName + ", \u8fc7\u6ee4\u6761\u4ef6:" + ECQL.toCQL((Filter)query.getFilter()) + ", \u8fdb\u884c\u6700\u5927\u503c\u6700\u5c0f\u503c\u67e5\u8be2\u65f6\u4ea7\u751f\u5f02\u5e38!, \u5f02\u5e38\u4fe1\u606f:" + ExceptionUtils.getMessage((Throwable)illegalStateException);
            jdbcDataStore.getLogger().warning(message);
            return new AttributeRange(attributeName, new Integer(0), new Integer(0));
        }
    }

    private static boolean fullySupports(JDBCDataStore jdbcDataStore, List<Expression> expressions) {
        return expressions.stream().allMatch(e -> GeoToolsJdbcRangeUtils.fullySupports(jdbcDataStore, e));
    }

    private static boolean fullySupports(JDBCDataStore jdbcDataStore, Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Null expression can not be unpacked");
        }
        FilterCapabilities filterCapabilities = jdbcDataStore.getFilterCapabilities();
        if (!filterCapabilities.supports(expression.getClass())) {
            return false;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expression;
            return GeoToolsJdbcRangeUtils.fullySupports(jdbcDataStore, be.getExpression1()) && GeoToolsJdbcRangeUtils.fullySupports(jdbcDataStore, be.getExpression2());
        }
        if (expression instanceof org.opengis.filter.expression.Function) {
            org.opengis.filter.expression.Function function = (org.opengis.filter.expression.Function)expression;
            for (Expression fe : function.getParameters()) {
                if (GeoToolsJdbcRangeUtils.fullySupports(jdbcDataStore, fe)) continue;
                return false;
            }
        }
        return true;
    }

    private static GeometryDescriptor getGeometryDescriptor(SimpleFeatureType featureType, Expression expression) {
        if (!(expression instanceof PropertyName)) {
            return null;
        }
        PropertyName pn = (PropertyName)expression;
        AttributeDescriptor ad = featureType.getDescriptor(pn.getPropertyName());
        if (ad instanceof GeometryDescriptor) {
            return (GeometryDescriptor)ad;
        }
        return null;
    }

    private static boolean isSupportedGroupBy(JDBCDataStore jdbcDataStore, SimpleFeatureType featureType, GroupByVisitor visitor) {
        return visitor.getGroupByAttributes().stream().allMatch(xp -> {
            if (!GeoToolsJdbcRangeUtils.fullySupports(jdbcDataStore, xp)) {
                return false;
            }
            Class type = (Class)xp.accept((ExpressionVisitor)new ExpressionTypeVisitor((FeatureType)featureType), null);
            if (type == null || !Geometry.class.isAssignableFrom(type)) {
                return true;
            }
            return GeoToolsJdbcRangeUtils.getGeometryDescriptor(featureType, xp) != null && jdbcDataStore.dialect.canGroupOnGeometry();
        });
    }

    private static List<Expression> getExpressions(FeatureVisitor visitor) {
        if (visitor instanceof CountVisitor) {
            return null;
        }
        List<Expression> result = null;
        if (visitor instanceof UniqueVisitor) {
            result = ((UniqueVisitor)visitor).getExpressions();
        } else {
            try {
                Object expr;
                Method g = visitor.getClass().getMethod("getExpression", null);
                if (g != null && (expr = g.invoke((Object)visitor, null)) instanceof Expression) {
                    result = Arrays.asList((Expression)expr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static List<Expression> getAggregateExpression(JDBCDataStore jdbcDataStore, FeatureVisitor visitor) {
        FeatureVisitor aggregateVisitor = jdbcDataStore.isGroupByVisitor(visitor) ? ((GroupByVisitor)visitor).getAggregateVisitor() : visitor;
        List<Expression> expressions = GeoToolsJdbcRangeUtils.getExpressions(aggregateVisitor);
        if (expressions == null || expressions.isEmpty()) {
            return null;
        }
        return expressions;
    }

    private static List<Object> getListValues(JDBCDataStore jdbcDataStore, Connection cx, SimpleFeatureType featureType, ResultSet rs, List<Expression> groupBy, Function<Object, Object> converter, Hints hints) throws SQLException, IOException {
        ArrayList<Object> results = new ArrayList<Object>();
        Object result = null;
        while (rs.next()) {
            if (groupBy == null || groupBy.isEmpty()) {
                Object value = rs.getObject(1);
                result = converter.apply(value);
                results.add(result);
                continue;
            }
            results.add(jdbcDataStore.extractValuesFromResultSet(cx, featureType, rs, groupBy, converter, hints));
        }
        return results;
    }

    private static List<Object> getUniqueMultiAttr(List<String> attributeNames, ResultSet resultSet, Function<Object, Object> converter) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (resultSet.next()) {
            LinkedList<Object> uniqueValues = new LinkedList<Object>();
            for (String attr : attributeNames) {
                Object object = resultSet.getObject(attr);
                object = converter.apply(object);
                uniqueValues.add(object);
            }
            result.add(uniqueValues);
        }
        return result;
    }

    private static List<Object> getUniqueResult(JDBCDataStore jdbcDataStore, UniqueVisitor uniqueVisitor, Connection cx, SimpleFeatureType featureType, ResultSet rs, List<Expression> groupBy, Function<Object, Object> converter, Hints hints) throws SQLException, IOException {
        List<Object> results = uniqueVisitor.getExpressions().size() > 1 ? GeoToolsJdbcRangeUtils.getUniqueMultiAttr(uniqueVisitor.getAttrNames(), rs, converter) : GeoToolsJdbcRangeUtils.getListValues(jdbcDataStore, cx, featureType, rs, groupBy, converter, hints);
        return results;
    }

    private static boolean hasComplexExpressions(List<Expression> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return false;
        }
        return expressions.stream().anyMatch(x -> !(x instanceof PropertyName));
    }

    private static FilterToSQL getFilterToSQL(JDBCDataStore jdbcDataStore, SimpleFeatureType fullSchema) {
        return jdbcDataStore.getSQLDialect() instanceof PreparedStatementSQLDialect ? jdbcDataStore.createPreparedFilterToSQL(fullSchema) : jdbcDataStore.createFilterToSQL(fullSchema);
    }

    private static String getAggregateExpressionAlias(int idx) {
        return "gt_agg_" + idx;
    }

    private static void applySearchHints(JDBCDataStore jdbcDataStore, SimpleFeatureType featureType, Query query, StringBuffer sql) {
        if (jdbcDataStore.virtualTables.containsKey(featureType.getTypeName()) && !jdbcDataStore.dialect.applyHintsOnVirtualTables()) {
            return;
        }
        jdbcDataStore.dialect.handleSelectHints(sql, featureType, query);
    }

    private static List<FilterToSQL> doSelectAggregateSQL(JDBCDataStore jdbcDataStore, String function, List<Expression> expressions, List<Expression> groupByExpressions, SimpleFeatureType featureType, Query query, LimitingVisitor visitor, StringBuffer sql) throws SQLException, IOException {
        JoinInfo join = !query.getJoins().isEmpty() ? JoinInfo.create((Query)query, (SimpleFeatureType)featureType, (JDBCDataStore)jdbcDataStore) : null;
        ArrayList<FilterToSQL> toSQL = new ArrayList<FilterToSQL>();
        boolean queryLimitOffset = jdbcDataStore.checkLimitOffset(query.getStartIndex(), query.getMaxFeatures());
        boolean visitorLimitOffset = visitor == null ? false : visitor.hasLimits() && jdbcDataStore.getSQLDialect().isLimitOffsetSupported();
        boolean groupByComplexExpressions = GeoToolsJdbcRangeUtils.hasComplexExpressions(groupByExpressions);
        String filterFieldName = "";
        String suffixSql = "";
        StringBuffer tmpSql = new StringBuffer();
        StringBuffer sqlBak = new StringBuffer();
        if (queryLimitOffset && !visitorLimitOffset && !groupByComplexExpressions) {
            if (join != null) {
                tmpSql.append("SELECT ");
                jdbcDataStore.getSQLDialect().encodeColumnName(null, join.getPrimaryAlias(), tmpSql);
                tmpSql.append(".* FROM ");
            } else {
                tmpSql.append("SELECT * FROM ");
            }
        } else {
            tmpSql.append("SELECT ");
            FilterToSQL filterToSQL = GeoToolsJdbcRangeUtils.getFilterToSQL(jdbcDataStore, featureType);
            if (groupByExpressions != null && !groupByExpressions.isEmpty()) {
                try {
                    int i = 1;
                    for (Expression expression : groupByExpressions) {
                        GeometryDescriptor gd = GeoToolsJdbcRangeUtils.getGeometryDescriptor(featureType, expression);
                        if (gd != null) {
                            jdbcDataStore.getSQLDialect().encodeGeometryColumn(gd, null, jdbcDataStore.getDescriptorSRID((AttributeDescriptor)gd), null, tmpSql);
                        } else {
                            tmpSql.append(filterToSQL.encodeToString(expression));
                        }
                        if (groupByComplexExpressions) {
                            tmpSql.append(" as ").append(GeoToolsJdbcRangeUtils.getAggregateExpressionAlias(i++));
                        }
                        tmpSql.append(", ");
                    }
                }
                catch (FilterToSQLException e) {
                    throw new RuntimeException("Failed to encode group by expressions", e);
                }
            }
            if (groupByComplexExpressions) {
                if (expressions != null) {
                    int size = expressions.size();
                    for (int i = 0; i < size; ++i) {
                        Expression expr = expressions.get(i);
                        try {
                            String colName = filterToSQL.encodeToString(expr);
                            tmpSql.append(colName);
                            tmpSql.append(" as gt_agg_src_").append(colName.replaceAll("\"", ""));
                            if (i >= size - 1) continue;
                            tmpSql.append(",");
                            continue;
                        }
                        catch (FilterToSQLException e) {
                            throw new RuntimeException("Failed to encode group by expressions", e);
                        }
                    }
                } else {
                    tmpSql.setLength(tmpSql.length() - 2);
                }
            } else {
                try {
                    filterFieldName = filterToSQL.encodeToString(expressions.get(0));
                }
                catch (FilterToSQLException e) {
                    throw new RuntimeException(e);
                }
                jdbcDataStore.encodeFunction(function, expressions, tmpSql, filterToSQL);
            }
            toSQL.add(filterToSQL);
            tmpSql.append(" FROM ");
        }
        if (join != null) {
            jdbcDataStore.encodeTableJoin(featureType, join, query, tmpSql);
        } else {
            sqlBak.append(tmpSql);
            suffixSql = tmpSql + "a";
            tmpSql = new StringBuffer("SELECT " + filterFieldName + " FROM ");
            jdbcDataStore.encodeTableName(featureType.getTypeName(), sqlBak, VirtualTable.setKeepWhereClausePlaceHolderHint((Query)query));
            jdbcDataStore.encodeTableName(featureType.getTypeName(), tmpSql, VirtualTable.setKeepWhereClausePlaceHolderHint((Query)query));
        }
        if (join != null) {
            toSQL.addAll(jdbcDataStore.encodeWhereJoin(featureType, join, tmpSql));
        } else {
            Filter filter = query.getFilter();
            if (filter != null && !Filter.INCLUDE.equals(filter)) {
                tmpSql.append(" WHERE ");
                sqlBak.append(" WHERE ");
                jdbcDataStore.filter(featureType, filter, tmpSql);
                toSQL.add(jdbcDataStore.filter(featureType, filter, sqlBak));
            }
        }
        if (jdbcDataStore.getSQLDialect().isAggregatedSortSupported(function)) {
            jdbcDataStore.sort(featureType, query.getSortBy(), null, tmpSql);
        }
        if (visitorLimitOffset) {
            jdbcDataStore.applyLimitOffset(tmpSql, Integer.valueOf(visitor.getStartIndex()), visitor.getMaxFeatures());
        } else if (queryLimitOffset) {
            jdbcDataStore.applyLimitOffset(tmpSql, query.getStartIndex(), query.getMaxFeatures());
        }
        boolean isUniqueCount = visitor instanceof UniqueCountVisitor;
        if (queryLimitOffset || groupByComplexExpressions || isUniqueCount) {
            boolean countQuery;
            StringBuffer sql2 = new StringBuffer("SELECT ");
            try {
                if (groupByExpressions != null && !groupByExpressions.isEmpty()) {
                    FilterToSQL filterToSQL = GeoToolsJdbcRangeUtils.getFilterToSQL(jdbcDataStore, featureType);
                    int i = 1;
                    for (Expression expression : groupByExpressions) {
                        if (groupByComplexExpressions) {
                            sql2.append(GeoToolsJdbcRangeUtils.getAggregateExpressionAlias(i++));
                        } else {
                            sql2.append(filterToSQL.encodeToString(expression));
                        }
                        sql2.append(",");
                    }
                    toSQL.add(filterToSQL);
                }
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException("Failed to encode group by expressions", e);
            }
            FilterToSQL filterToSQL = GeoToolsJdbcRangeUtils.getFilterToSQL(jdbcDataStore, featureType);
            boolean bl = countQuery = isUniqueCount || groupByComplexExpressions && "count".equals(function);
            if (countQuery) {
                sql2.append("count(*)");
            } else if (groupByComplexExpressions) {
                sql2.append(function).append("(");
                int size = expressions.size();
                for (int i = 0; i < size; ++i) {
                    Expression expr = expressions.get(i);
                    try {
                        String aliasSuffix = filterToSQL.encodeToString(expr).replaceAll("\"", "");
                        sql2.append("gt_agg_src_").append(aliasSuffix);
                        if (i >= size - 1) continue;
                        sql2.append(",");
                        continue;
                    }
                    catch (FilterToSQLException e) {
                        throw new RuntimeException("Failed to encode column alias in group by.", e);
                    }
                }
                sql2.append(")");
            } else {
                jdbcDataStore.encodeFunction(function, expressions, sql2, filterToSQL);
            }
            toSQL.add(filterToSQL);
            sql2.append(" AS gt_result_");
            sql2.append(" FROM (");
            tmpSql.insert(0, sql2);
            tmpSql.append(") gt_limited_");
        }
        FilterToSQL filterToSQL = GeoToolsJdbcRangeUtils.getFilterToSQL(jdbcDataStore, featureType);
        tmpSql = new StringBuffer("with a as (" + tmpSql + ") " + suffixSql);
        jdbcDataStore.encodeGroupByStatement(groupByExpressions, tmpSql, filterToSQL, groupByComplexExpressions);
        toSQL.add(filterToSQL);
        GeoToolsJdbcRangeUtils.applySearchHints(jdbcDataStore, featureType, query, tmpSql);
        sql.append(tmpSql);
        return toSQL;
    }

    protected static PreparedStatement selectAggregateSQLPS(JDBCDataStore jdbcDataStore, String function, List<Expression> attributes, List<Expression> groupByExpressions, SimpleFeatureType featureType, Query query, LimitingVisitor visitor, Connection cx) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        List<FilterToSQL> toSQL = GeoToolsJdbcRangeUtils.doSelectAggregateSQL(jdbcDataStore, function, attributes, groupByExpressions, featureType, query, visitor, sql);
        jdbcDataStore.getLogger().info(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString(), 1003, 1007);
        ps.setFetchSize(jdbcDataStore.fetchSize);
        jdbcDataStore.setPreparedFilterValues(ps, toSQL, cx);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAggregateValue(JDBCDataStore jdbcDataStore, FeatureVisitor visitor, SimpleFeatureType featureType, Query query, Connection cx) throws IOException {
        if (!(!jdbcDataStore.isGroupByVisitor(visitor) || jdbcDataStore.dialect.isGroupBySupported() && GeoToolsJdbcRangeUtils.isSupportedGroupBy(jdbcDataStore, featureType, (GroupByVisitor)visitor))) {
            return null;
        }
        String function = jdbcDataStore.matchAggregateFunction(visitor);
        if (function == null) {
            return null;
        }
        FilterCapabilities caps = jdbcDataStore.getFilterCapabilities();
        PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(caps, featureType, null);
        query.getFilter().accept((FilterVisitor)splitter, null);
        if (!splitter.getFilterPost().equals(Filter.INCLUDE)) {
            return null;
        }
        List<Expression> aggregateExpressions = null;
        if (!jdbcDataStore.isCountVisitor(visitor) && (aggregateExpressions = GeoToolsJdbcRangeUtils.getAggregateExpression(jdbcDataStore, visitor)) != null && !GeoToolsJdbcRangeUtils.fullySupports(jdbcDataStore, aggregateExpressions)) {
            return null;
        }
        LimitingVisitor limitingVisitor = null;
        if (visitor instanceof LimitingVisitor) {
            limitingVisitor = (LimitingVisitor)visitor;
        }
        List groupByExpressions = jdbcDataStore.extractGroupByExpressions(visitor);
        try {
            Object result = null;
            List<Object> results = new ArrayList();
            Statement st = null;
            ResultSet rs = null;
            try {
                if (jdbcDataStore.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                    st = GeoToolsJdbcRangeUtils.selectAggregateSQLPS(jdbcDataStore, function, aggregateExpressions, groupByExpressions, featureType, query, limitingVisitor, cx);
                    rs = st.executeQuery();
                } else {
                    String sql = jdbcDataStore.selectAggregateSQL(function, aggregateExpressions, groupByExpressions, featureType, query, limitingVisitor);
                    jdbcDataStore.getLogger().info(sql);
                    st = cx.createStatement();
                    st.setFetchSize(jdbcDataStore.getFetchSize());
                    rs = st.executeQuery(sql);
                }
                Function converter = jdbcDataStore.getSQLDialect().getAggregateConverter(visitor, featureType);
                if (visitor.getClass().equals(UniqueVisitor.class)) {
                    UniqueVisitor uniqueVisitor = (UniqueVisitor)visitor;
                    results = GeoToolsJdbcRangeUtils.getUniqueResult(jdbcDataStore, uniqueVisitor, cx, featureType, rs, groupByExpressions, converter, query.getHints());
                } else {
                    results = GeoToolsJdbcRangeUtils.getListValues(jdbcDataStore, cx, featureType, rs, groupByExpressions, converter, query.getHints());
                }
                if (results.size() == 1 && !(results.get(0) instanceof List)) {
                    result = results.get(0);
                }
            }
            catch (Throwable throwable) {
                jdbcDataStore.closeSafe(rs);
                jdbcDataStore.closeSafe(st);
                throw throwable;
            }
            jdbcDataStore.closeSafe(rs);
            jdbcDataStore.closeSafe(st);
            if (groupByExpressions != null && !groupByExpressions.isEmpty()) {
                jdbcDataStore.setResult(visitor, results);
                return results;
            }
            if (jdbcDataStore.setResult(visitor, result == null ? results : result)) {
                return result == null ? results : result;
            }
            return null;
        }
        catch (SQLException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

