/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.geoway.atlas.common.config.AtlasSystemProperties;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.datasource.DBCPDataSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.jdbc.CompositePrimaryKeyFinder;
import org.geotools.jdbc.GeoToolsJdbcProxyUtils;
import org.geotools.jdbc.HeuristicPrimaryKeyFinder;
import org.geotools.jdbc.JDBCCallbackFactory;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.MetadataTablePrimaryKeyFinder;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.SessionCommandsListener;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.type.FeatureTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalaGeoToolsJdbcProxyUtils$ {
    public static ScalaGeoToolsJdbcProxyUtils$ MODULE$;
    private final Logger logger;
    private final String JDBC_EXTRA_PARAMS;
    private final String JDBC_CONNECTION_TIMEOUT;
    private final int INITIALIZATION_FAIL_TIMEOUT;

    static {
        new ScalaGeoToolsJdbcProxyUtils$();
    }

    public Logger logger() {
        return this.logger;
    }

    public String JDBC_EXTRA_PARAMS() {
        return this.JDBC_EXTRA_PARAMS;
    }

    public String JDBC_CONNECTION_TIMEOUT() {
        return this.JDBC_CONNECTION_TIMEOUT;
    }

    public int INITIALIZATION_FAIL_TIMEOUT() {
        return this.INITIALIZATION_FAIL_TIMEOUT;
    }

    public SQLDialect createSQLDialect(JDBCDataStoreFactory jdbcDataStoreFactory, JDBCDataStore jdbcDataStore, Map<String, Object> params) {
        return jdbcDataStoreFactory.createSQLDialect(jdbcDataStore, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava());
    }

    public JDBCDataStore createDataStore(JDBCDataStoreFactory jdbcDataStoreFactory, java.util.Map<String, Object> params, GeometryFactory gf) {
        Object object;
        boolean exposePk;
        String metadataTable;
        String schema;
        String namespace;
        JDBCDataStore dataStore = new JDBCDataStore();
        SQLDialect dialect = this.createSQLDialect(jdbcDataStoreFactory, dataStore, (Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params).asScala()).toMap(Predef$.MODULE$.$conforms()));
        dataStore.setSQLDialect(dialect);
        DataSource ds = (DataSource)JDBCDataStoreFactory.DATASOURCE.lookUp(params);
        if (ds != null) {
            dataStore.setDataSource(ds);
        } else {
            dataStore.setDataSource(this.createHikariCPDataSource(jdbcDataStoreFactory, dialect, (Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params).asScala()).toMap(Predef$.MODULE$.$conforms())));
        }
        Integer fetchSize = (Integer)JDBCDataStoreFactory.FETCHSIZE.lookUp(params);
        if (fetchSize != null && Predef$.MODULE$.Integer2int(fetchSize) > 0) {
            dataStore.setFetchSize(Predef$.MODULE$.Integer2int(fetchSize));
        } else {
            dataStore.setFetchSize(Predef$.MODULE$.Integer2int((Integer)JDBCDataStoreFactory.FETCHSIZE.sample));
        }
        Integer batchInsertSize = (Integer)JDBCDataStoreFactory.BATCH_INSERT_SIZE.lookUp(params);
        if (batchInsertSize != null && Predef$.MODULE$.Integer2int(batchInsertSize) > 0) {
            dataStore.setBatchInsertSize(Predef$.MODULE$.Integer2int(batchInsertSize));
        }
        if ((namespace = (String)JDBCDataStoreFactory.NAMESPACE.lookUp(params)) != null) {
            dataStore.setNamespaceURI(namespace);
        }
        if ((schema = (String)JDBCDataStoreFactory.SCHEMA.lookUp(params)) != null) {
            dataStore.setDatabaseSchema(schema);
        }
        if ((metadataTable = (String)JDBCDataStoreFactory.PK_METADATA_TABLE.lookUp(params)) != null) {
            MetadataTablePrimaryKeyFinder tableFinder = new MetadataTablePrimaryKeyFinder();
            if (metadataTable.contains(".")) {
                String[] parts = metadataTable.split("\\.");
                if (parts.length > 2) {
                    throw new IllegalArgumentException("The primary key metadata table format is either 'name' or 'schema.name'");
                }
                tableFinder.setTableSchema(parts[0]);
                tableFinder.setTableName(parts[1]);
            } else {
                tableFinder.setTableName(metadataTable);
            }
            dataStore.setPrimaryKeyFinder((PrimaryKeyFinder)new CompositePrimaryKeyFinder(new PrimaryKeyFinder[]{tableFinder, new HeuristicPrimaryKeyFinder()}));
        }
        if (BoxesRunTime.boxToBoolean((boolean)(exposePk = BoxesRunTime.unboxToBoolean((Object)JDBCDataStoreFactory.EXPOSE_PK.lookUp(params)))) != null) {
            dataStore.setExposePrimaryKeyColumns(exposePk);
        }
        String sqlOnBorrow = (String)JDBCDataStoreFactory.SQL_ON_BORROW.lookUp(params);
        String sqlOnRelease = (String)JDBCDataStoreFactory.SQL_ON_RELEASE.lookUp(params);
        if (sqlOnBorrow != null || sqlOnRelease != null) {
            SessionCommandsListener listener = new SessionCommandsListener(sqlOnBorrow, sqlOnRelease);
            object = BoxesRunTime.boxToBoolean((boolean)dataStore.getConnectionLifecycleListeners().add(listener));
        } else {
            object = BoxedUnit.UNIT;
        }
        String callbackFactory = (String)JDBCDataStoreFactory.CALLBACK_FACTORY.lookUp(params);
        if (callbackFactory == null) {
            callbackFactory = System.getProperty("gt2.jdbc.callback");
        }
        dataStore.setCallbackFactory(callbackFactory != null ? JDBCDataStoreFactory.findCallbackFactory((String)callbackFactory) : JDBCCallbackFactory.NULL);
        dataStore.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        dataStore.setGeometryFactory(gf);
        dataStore.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        dataStore.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
        dataStore.setDataStoreFactory((DataStoreFactorySpi)jdbcDataStoreFactory);
        JDBCDataStore result = jdbcDataStoreFactory.createDataStoreInternal(dataStore, params);
        if (result.getDataSource() == null) {
            throw new IOException("JDBC Connection not available with provided parameters");
        }
        return result;
    }

    public GeometryFactory createDataStore$default$3() {
        return new GeometryFactory();
    }

    public DataSource createDataSource(JDBCDataStoreFactory jdbcDataStoreFactory, SQLDialect dialect, Map<String, Object> params) {
        java.util.Map paramMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava();
        BasicDataSource dataSource = this._createDataSource(jdbcDataStoreFactory, dialect, paramMap);
        if (dialect instanceof PreparedStatementSQLDialect) {
            dataSource.setPoolPreparedStatements(true);
            HashMap testMap = new HashMap();
            jdbcDataStoreFactory.setupParameters(testMap);
            if (testMap.containsKey(JDBCDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key)) {
                Integer maxPreparedStatements = (Integer)JDBCDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.lookUp(paramMap);
                if (maxPreparedStatements != null && Predef$.MODULE$.Integer2int(maxPreparedStatements) > 0) {
                    dataSource.setMaxOpenPreparedStatements(Predef$.MODULE$.Integer2int(maxPreparedStatements));
                }
                if (maxPreparedStatements != null && Predef$.MODULE$.Integer2int(maxPreparedStatements) < 0) {
                    dataSource.setPoolPreparedStatements(false);
                }
            }
        }
        return new DBCPDataSource(dataSource);
    }

    public String _getJDBCUrl(JDBCDataStoreFactory jdbcDataStoreFactory, java.util.Map<String, Object> paramMap) {
        return jdbcDataStoreFactory.getJDBCUrl(paramMap);
    }

    public DataSource createHikariCPDataSource(JDBCDataStoreFactory jdbcDataStoreFactory, SQLDialect dialect, Map<String, Object> params) {
        java.util.Map paramMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava();
        return this._createHikariCPDataSource(jdbcDataStoreFactory, dialect, paramMap);
    }

    public DataSource _createHikariCPDataSource(JDBCDataStoreFactory jdbcDataStoreFactory, SQLDialect dialect, java.util.Map<String, Object> paramMap) {
        Integer minEvictableTime;
        Integer maxConn;
        Integer minConn;
        String passwd;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(jdbcDataStoreFactory.getDriverClassName());
        hikariConfig.setAutoCommit(true);
        String extraParams = "";
        if (paramMap.containsKey(this.JDBC_EXTRA_PARAMS())) {
            extraParams = (String)paramMap.get(this.JDBC_EXTRA_PARAMS());
        }
        String jdbcUrl = new StringBuilder(0).append(GeoToolsJdbcProxyUtils.getJdbcOp(dialect).getJDBCUrl(jdbcDataStoreFactory, paramMap)).append(extraParams).toString();
        this.logger().info(new StringBuilder(7).append("\u6570\u636e\u8def\u5f84\u4e3a: ").append(jdbcUrl).toString());
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setInitializationFailTimeout((long)this.INITIALIZATION_FAIL_TIMEOUT());
        String user = paramMap.getOrDefault(JDBCDataStoreFactory.USER.key, "").toString();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            hikariConfig.setUsername(user);
        }
        if ((passwd = (String)JDBCDataStoreFactory.PASSWD.lookUp(paramMap)) != null) {
            hikariConfig.setPassword(passwd);
        }
        hikariConfig.setConnectionTestQuery("SELECT 1");
        Integer maxWait = (Integer)JDBCDataStoreFactory.MAXWAIT.lookUp(paramMap);
        if (maxWait != null && !BoxesRunTime.equalsNumObject((Number)maxWait, (Object)BoxesRunTime.boxToInteger((int)-1))) {
            hikariConfig.setMaxLifetime((long)(Predef$.MODULE$.Integer2int(maxWait) * 1000));
        }
        if ((minConn = (Integer)JDBCDataStoreFactory.MINCONN.lookUp(paramMap)) != null) {
            hikariConfig.setMinimumIdle(Predef$.MODULE$.Integer2int(minConn));
        }
        if ((maxConn = (Integer)JDBCDataStoreFactory.MAXCONN.lookUp(paramMap)) != null) {
            hikariConfig.setMaximumPoolSize(Predef$.MODULE$.Integer2int(maxConn));
        }
        if ((minEvictableTime = (Integer)JDBCDataStoreFactory.MIN_EVICTABLE_TIME.lookUp(paramMap)) != null) {
            hikariConfig.setIdleTimeout((long)Predef$.MODULE$.Integer2int(minEvictableTime) * 1000L);
        }
        if (paramMap.containsKey(this.JDBC_CONNECTION_TIMEOUT())) {
            hikariConfig.setConnectionTimeout((long)new StringOps(Predef$.MODULE$.augmentString(paramMap.get(this.JDBC_CONNECTION_TIMEOUT()).toString())).toInt() * 1000L);
        }
        return new HikariDataSource(hikariConfig);
    }

    public BasicDataSource _createDataSource(JDBCDataStoreFactory jdbcDataStoreFactory, SQLDialect dialect, java.util.Map<String, Object> paramMap) {
        Integer evictorTestsPerRun;
        Integer minEvictableTime;
        Integer timeBetweenEvictorRuns;
        boolean testWhileIdle;
        boolean validate;
        Integer maxConn;
        Integer minConn;
        Integer maxWait;
        String passwd;
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(jdbcDataStoreFactory.getDriverClassName());
        String extraParams = "";
        if (paramMap.containsKey(this.JDBC_EXTRA_PARAMS())) {
            extraParams = (String)paramMap.get(this.JDBC_EXTRA_PARAMS());
        }
        String jdbcUrl = new StringBuilder(0).append(GeoToolsJdbcProxyUtils.getJdbcOp(dialect).getJDBCUrl(jdbcDataStoreFactory, paramMap)).append(extraParams).toString();
        this.logger().info(new StringBuilder(7).append("\u6570\u636e\u8def\u5f84\u4e3a: ").append(jdbcUrl).toString());
        dataSource.setUrl(jdbcUrl);
        String user = paramMap.getOrDefault(JDBCDataStoreFactory.USER.key, "").toString();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            dataSource.setUsername(user);
        }
        if ((passwd = (String)JDBCDataStoreFactory.PASSWD.lookUp(paramMap)) != null) {
            dataSource.setPassword(passwd);
        }
        if ((maxWait = (Integer)JDBCDataStoreFactory.MAXWAIT.lookUp(paramMap)) != null && !BoxesRunTime.equalsNumObject((Number)maxWait, (Object)BoxesRunTime.boxToInteger((int)-1))) {
            dataSource.setMaxWait((long)(Predef$.MODULE$.Integer2int(maxWait) * 1000));
        }
        if ((minConn = (Integer)JDBCDataStoreFactory.MINCONN.lookUp(paramMap)) != null) {
            dataSource.setMinIdle(Predef$.MODULE$.Integer2int(minConn));
        }
        if ((maxConn = (Integer)JDBCDataStoreFactory.MAXCONN.lookUp(paramMap)) != null) {
            dataSource.setMaxActive(Predef$.MODULE$.Integer2int(maxConn));
        }
        if (BoxesRunTime.boxToBoolean((boolean)(validate = BoxesRunTime.unboxToBoolean((Object)JDBCDataStoreFactory.VALIDATECONN.lookUp(paramMap)))) != null && validate && jdbcDataStoreFactory.getValidationQuery() != null) {
            dataSource.setTestOnBorrow(true);
            dataSource.setValidationQuery(jdbcDataStoreFactory.getValidationQuery());
        }
        if (BoxesRunTime.boxToBoolean((boolean)(testWhileIdle = BoxesRunTime.unboxToBoolean((Object)JDBCDataStoreFactory.TEST_WHILE_IDLE.lookUp(paramMap)))) != null) {
            dataSource.setTestWhileIdle(testWhileIdle);
        }
        if ((timeBetweenEvictorRuns = (Integer)JDBCDataStoreFactory.TIME_BETWEEN_EVICTOR_RUNS.lookUp(paramMap)) != null && Predef$.MODULE$.Integer2int(timeBetweenEvictorRuns) > 0) {
            dataSource.setTimeBetweenEvictionRunsMillis((long)Predef$.MODULE$.Integer2int(timeBetweenEvictorRuns) * 1000L);
        }
        if ((minEvictableTime = (Integer)JDBCDataStoreFactory.MIN_EVICTABLE_TIME.lookUp(paramMap)) != null) {
            dataSource.setMinEvictableIdleTimeMillis((long)Predef$.MODULE$.Integer2int(minEvictableTime) * 1000L);
        }
        if ((evictorTestsPerRun = (Integer)JDBCDataStoreFactory.EVICTOR_TESTS_PER_RUN.lookUp(paramMap)) != null) {
            dataSource.setNumTestsPerEvictionRun(Predef$.MODULE$.Integer2int(evictorTestsPerRun));
        }
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        return dataSource;
    }

    public void setNullDataSource(JDBCDataStore ds) {
        ds.dataSource = null;
    }

    private ScalaGeoToolsJdbcProxyUtils$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.JDBC_EXTRA_PARAMS = "atlas.data.jdbc.extra.params";
        this.JDBC_CONNECTION_TIMEOUT = "atlas.data.jdbc.pool.connection.timeout";
        this.INITIALIZATION_FAIL_TIMEOUT = new StringOps(Predef$.MODULE$.augmentString(new AtlasSystemProperties.SystemProperty("atlas.data.jdbc.pool.initialization.timeout", "-1").get())).toInt() * 1000;
    }
}

