/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.storage.nosql.hbase;

import com.geoway.atlas.common.config.AtlasSystemProperties;
import com.geoway.atlas.common.error.ParamException;
import com.geoway.atlas.common.error.ParamException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.storage.nosql.hbase.HbaseConnectionStub;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;

public final class HbaseConnectionStub$
implements LazyLogging,
Serializable {
    public static HbaseConnectionStub$ MODULE$;
    private final Map<String, Tuple2<AtomicInteger, Connection>> connectionPool;
    private final HbaseConnectionStub.HbaseMonitor HBASE_MONITOR;
    private final Thread MONITOR_THREAD;
    private boolean MONITOR_IS_START;
    private final ReentrantLock CLEAR_LOCK;
    private Condition CLEAR_CONDITION;
    private boolean CLEAR_RUNNING;
    private final long HBASE_MONITOR_INTERVAL;
    private final String HBASE_IDE_MS;
    private final long DEFAULT_IDE_MS;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HbaseConnectionStub$();
    }

    private Logger logger$lzycompute() {
        HbaseConnectionStub$ hbaseConnectionStub$ = this;
        synchronized (hbaseConnectionStub$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Map<String, Tuple2<AtomicInteger, Connection>> connectionPool() {
        return this.connectionPool;
    }

    public HbaseConnectionStub.HbaseMonitor HBASE_MONITOR() {
        return this.HBASE_MONITOR;
    }

    public Thread MONITOR_THREAD() {
        return this.MONITOR_THREAD;
    }

    public boolean MONITOR_IS_START() {
        return this.MONITOR_IS_START;
    }

    public void MONITOR_IS_START_$eq(boolean x$1) {
        this.MONITOR_IS_START = x$1;
    }

    public ReentrantLock CLEAR_LOCK() {
        return this.CLEAR_LOCK;
    }

    public Condition CLEAR_CONDITION() {
        return this.CLEAR_CONDITION;
    }

    public void CLEAR_CONDITION_$eq(Condition x$1) {
        this.CLEAR_CONDITION = x$1;
    }

    public boolean CLEAR_RUNNING() {
        return this.CLEAR_RUNNING;
    }

    public void CLEAR_RUNNING_$eq(boolean x$1) {
        this.CLEAR_RUNNING = x$1;
    }

    public long HBASE_MONITOR_INTERVAL() {
        return this.HBASE_MONITOR_INTERVAL;
    }

    public String HBASE_IDE_MS() {
        return this.HBASE_IDE_MS;
    }

    public long DEFAULT_IDE_MS() {
        return this.DEFAULT_IDE_MS;
    }

    public Connection getConnection(String dataSourceId, Function0<Connection> createConnection) {
        this.checkHbaseMonitor();
        if (!this.connectionPool().containsKey(dataSourceId)) {
            HbaseConnectionStub$ hbaseConnectionStub$ = this;
            synchronized (hbaseConnectionStub$) {
                if (!this.connectionPool().containsKey(dataSourceId)) {
                    this.connectionPool().put(dataSourceId, (Tuple2<AtomicInteger, Connection>)new Tuple2((Object)new AtomicInteger(0), createConnection.apply()));
                    this.logger().info(new StringBuilder(13).append("\u521b\u5efaHbase\u6570\u636e\u8fde\u63a5\u6c60 ").append(dataSourceId).toString());
                }
            }
        }
        int currentValue = ((AtomicInteger)this.connectionPool().get(dataSourceId)._1()).incrementAndGet();
        this.logger().info(new StringBuilder(20).append("Hbase\u6570\u636e\u8fde\u63a5\u6c60 ").append(dataSourceId).append(" \u652f\u6301\u7684\u7ebf\u7a0b\u6570\u91cf ").append(currentValue).toString());
        return (Connection)this.connectionPool().get(dataSourceId)._2();
    }

    public void checkHbaseMonitor() {
        if (!this.MONITOR_IS_START()) {
            HbaseConnectionStub$ hbaseConnectionStub$ = this;
            synchronized (hbaseConnectionStub$) {
                if (!this.MONITOR_IS_START()) {
                    this.logger().info("\u542f\u52a8hbase\u8fde\u63a5\u6c60\u76d1\u63a7\u4efb\u52a1");
                    this.MONITOR_THREAD().setDaemon(true);
                    this.MONITOR_THREAD().start();
                    this.MONITOR_IS_START_$eq(true);
                }
            }
        }
        if (this.CLEAR_RUNNING()) {
            this.CLEAR_LOCK().lock();
            this.logger().info("\u7b49\u5f85Hbase\u8fde\u63a5\u6c60\u6e05\u7406\u8fdb\u7a0b!");
            try {
                try {
                    while (this.CLEAR_RUNNING()) {
                        this.CLEAR_CONDITION().await();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.logger().info("\u5524\u9192Hbase\u7b49\u5f85\u8fdb\u7a0b!");
                this.CLEAR_LOCK().unlock();
            }
        }
    }

    public void removeConnection(String dataSourceId) {
        block0: {
            if (!this.connectionPool().containsKey(dataSourceId)) break block0;
            int currentValue = ((AtomicInteger)this.connectionPool().get(dataSourceId)._1()).decrementAndGet();
            this.logger().info(new StringBuilder(18).append("hbase\u8fde\u63a5\u6c60 ").append(dataSourceId).append(" \u652f\u6301\u7684\u7ebf\u7a0b\u6570\u91cf ").append(currentValue).toString());
        }
    }

    public HbaseConnectionStub apply(Connection conn, Admin admin, Table metaTable) {
        return new HbaseConnectionStub(conn, admin, metaTable);
    }

    public Option<Tuple3<Connection, Admin, Table>> unapply(HbaseConnectionStub x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.conn(), (Object)x$0.admin(), (Object)x$0.metaTable()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HbaseConnectionStub$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.connectionPool = new HashMap<String, Tuple2<AtomicInteger, Connection>>();
        this.HBASE_MONITOR = new HbaseConnectionStub.HbaseMonitor();
        this.MONITOR_THREAD = new Thread((Runnable)this.HBASE_MONITOR(), "hbaseMonitor");
        this.MONITOR_IS_START = false;
        this.CLEAR_LOCK = new ReentrantLock();
        this.CLEAR_CONDITION = this.CLEAR_LOCK().newCondition();
        this.CLEAR_RUNNING = false;
        this.HBASE_MONITOR_INTERVAL = 1000L;
        this.HBASE_IDE_MS = "atlas.data.vector.hbase.monitor.idle.ms";
        this.DEFAULT_IDE_MS = BoxesRunTime.unboxToLong((Object)new AtlasSystemProperties.SystemProperty(this.HBASE_IDE_MS(), "1800000").toLong().get());
        if (this.DEFAULT_IDE_MS() < 1000L) {
            String x$1 = "\u8bbe\u7f6e\u7684hbase\u8fde\u63a5\u7a7a\u95f4\u8d85\u65f6\u65f6\u95f4\u914d\u7f6e\u9879atlas.data.vector.hbase.monitor.idle.ms\u5fc5\u987b\u5927\u4e8e1000";
            Thread x$2 = ParamException$.MODULE$.apply$default$2(x$1);
            int x$3 = ParamException$.MODULE$.apply$default$3(x$1);
            throw new ParamException(x$1, x$2, x$3);
        }
    }
}

