/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.common.crs;

import com.geoway.atlas.common.cache.AtlasCache;
import com.geoway.atlas.common.cache.AtlasCache$;
import com.geoway.atlas.common.cache.AtlasThreadSafeCache;
import com.geoway.atlas.common.cache.AtlasThreadSafeCache$;
import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.error.NotEqualException;
import com.geoway.atlas.common.error.NotEqualException$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.common.utils.CollectionUtils$;
import com.geoway.atlas.common.utils.UnitsUtils;
import com.geoway.atlas.data.vector.common.crs.package$;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.collections4.IterableUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.operation.projection.MapProjection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class CrsUtils$
implements LazyLogging {
    public static CrsUtils$ MODULE$;
    private AtlasThreadSafeCache<CoordinateReferenceSystem, GeodeticCalculator> geodeticCalculatorCache;
    private final String RESULT_PRECISION_METER;
    private final String DENSIFICATION_DISTANCE_METER;
    private final double EARTH_CIRCUMFERENCE;
    private final Envelope STANDARD_ENCODE_BOUNDARY;
    private final AtlasCache<CoordinateReferenceSystem, Envelope> ENCODE_BOUNDARY_CACHE;
    private final double DEGREE_METER;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new CrsUtils$();
    }

    private Logger logger$lzycompute() {
        CrsUtils$ crsUtils$ = this;
        synchronized (crsUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private AtlasThreadSafeCache<CoordinateReferenceSystem, GeodeticCalculator> geodeticCalculatorCache() {
        return this.geodeticCalculatorCache;
    }

    private void geodeticCalculatorCache_$eq(AtlasThreadSafeCache<CoordinateReferenceSystem, GeodeticCalculator> x$1) {
        this.geodeticCalculatorCache = x$1;
    }

    public String RESULT_PRECISION_METER() {
        return this.RESULT_PRECISION_METER;
    }

    public String DENSIFICATION_DISTANCE_METER() {
        return this.DENSIFICATION_DISTANCE_METER;
    }

    public double EARTH_CIRCUMFERENCE() {
        return this.EARTH_CIRCUMFERENCE;
    }

    public Envelope STANDARD_ENCODE_BOUNDARY() {
        return this.STANDARD_ENCODE_BOUNDARY;
    }

    private AtlasCache<CoordinateReferenceSystem, Envelope> ENCODE_BOUNDARY_CACHE() {
        return this.ENCODE_BOUNDARY_CACHE;
    }

    public double DEGREE_METER() {
        return this.DEGREE_METER;
    }

    public boolean compareCrs(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        boolean bl;
        if (CRS.equalsIgnoreMetadata((Object)crs1, (Object)crs2)) {
            bl = true;
        } else {
            int srid1 = package$.MODULE$.FIND_SRID(crs1);
            int srid2 = package$.MODULE$.FIND_SRID(crs2);
            if (srid1 != -1 && srid2 != -1) {
                return srid1 == srid2;
            }
            bl = crs1.getName().getCode().replaceAll("_", "").equalsIgnoreCase(crs2.getName().getCode().replaceAll("_", ""));
        }
        return bl;
    }

    public void verifyCRS(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        if (!this.compareCrs(crs1, crs2)) {
            String x$1 = "\u5750\u6807\u7cfb\u4e0d\u76f8\u7b49!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
    }

    public Class<?> getCrsTypeClass(String units) {
        Class clazz;
        if (units == null) {
            clazz = null;
        } else {
            Class clazz2;
            boolean bl;
            String string = units.trim().toLowerCase(Locale.US);
            String string2 = UnitsUtils.Cql_Units$.MODULE$.M();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = UnitsUtils.Cql_Units$.MODULE$.KM();
                String string5 = string;
                bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
            }
            if (bl) {
                clazz2 = ProjectedCRS.class;
            } else {
                boolean bl2;
                String string6 = UnitsUtils.Cql_Units$.MODULE$.DEGREE();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    bl2 = true;
                } else {
                    String string8 = UnitsUtils.Cql_Units$.MODULE$.MINUTE();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        bl2 = true;
                    } else {
                        String string10 = UnitsUtils.Cql_Units$.MODULE$.SECOND();
                        String string11 = string;
                        bl2 = !(string10 != null ? !string10.equals(string11) : string11 != null);
                    }
                }
                clazz2 = bl2 ? GeographicCRS.class : null;
            }
            clazz = clazz2;
        }
        return clazz;
    }

    public double getDensificationDistanceMeter() {
        return new StringOps(Predef$.MODULE$.augmentString(AtlasSystemProperties$.MODULE$.getProperty(this.DENSIFICATION_DISTANCE_METER()))).toDouble();
    }

    public double getCRSRoughDistancebyMeter(double meter, CoordinateReferenceSystem crs) {
        double d;
        CoordinateReferenceSystem coordinateReferenceSystem = crs;
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            d = meter;
        } else if (coordinateReferenceSystem instanceof GeographicCRS) {
            d = meter * 9.0E-6;
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u5750\u6807\u7cfb:").append(coordinateReferenceSystem.getClass().getSimpleName()).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return d;
    }

    public double getCRSRoughDistanceBySqMeter(double sqMeter, CoordinateReferenceSystem crs) {
        double d;
        CoordinateReferenceSystem coordinateReferenceSystem = crs;
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            d = sqMeter;
        } else if (coordinateReferenceSystem instanceof GeographicCRS) {
            d = sqMeter * 8.1E-11;
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u5750\u6807\u7cfb:").append(coordinateReferenceSystem.getClass().getSimpleName()).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return d;
    }

    public double getCRSRoughDistanceByDegree(double degree, CoordinateReferenceSystem crs) {
        double d;
        CoordinateReferenceSystem coordinateReferenceSystem = crs;
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            d = degree * this.DEGREE_METER();
        } else if (coordinateReferenceSystem instanceof GeographicCRS) {
            d = degree;
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u5750\u6807\u7cfb:").append(coordinateReferenceSystem.getClass().getSimpleName()).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return d;
    }

    public GeodeticCalculator getGeodeticCalculator(CoordinateReferenceSystem crs) {
        return (GeodeticCalculator)this.geodeticCalculatorCache().apply((Object)crs, (Function1 & Serializable & scala.Serializable)key -> {
            GeographicCRS geographicCRS;
            CoordinateReferenceSystem coordinateReferenceSystem = crs;
            if (coordinateReferenceSystem instanceof ProjectedCRS) {
                ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem;
                geographicCRS = projectedCRS.getBaseCRS();
            } else if (coordinateReferenceSystem instanceof GeographicCRS) {
                GeographicCRS geographicCRS2;
                geographicCRS = geographicCRS2 = (GeographicCRS)coordinateReferenceSystem;
            } else {
                String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u5750\u6807\u7cfb:").append(coordinateReferenceSystem.getClass().getSimpleName()).toString();
                Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                throw new NotSupportException(x$1, x$2, x$3);
            }
            GeographicCRS findKey = geographicCRS;
            return new GeodeticCalculator((CoordinateReferenceSystem)findKey);
        });
    }

    public Option<CoordinateReferenceSystem> getUnifiedCRS(Seq<CoordinateReferenceSystem> crsSeq) {
        Object object;
        if (CollectionUtils$.MODULE$.nonEmpty(crsSeq)) {
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)crsSeq.head();
            if (crsSeq.size() > 1) {
                boolean flag = true;
                for (int index$macro$1 = 1; index$macro$1 < crsSeq.size() && flag; ++index$macro$1) {
                    if (this.compareCrs(crs, (CoordinateReferenceSystem)crsSeq.apply(index$macro$1))) continue;
                    flag = false;
                }
                object = flag ? new Some((Object)crs) : None$.MODULE$;
            } else {
                object = new Some((Object)crs);
            }
        } else {
            object = None$.MODULE$;
        }
        return object;
    }

    public PrecisionModel getPrecisionModel(CoordinateReferenceSystem crs) {
        PrecisionModel precisionModel;
        CoordinateReferenceSystem coordinateReferenceSystem = crs;
        if (coordinateReferenceSystem instanceof GeographicCRS) {
            precisionModel = new PrecisionModel(Math.pow(10.0, 12.0));
        } else if (coordinateReferenceSystem instanceof ProjectedCRS) {
            precisionModel = new PrecisionModel(Math.pow(10.0, 6.0));
        } else {
            throw new MatchError((Object)coordinateReferenceSystem);
        }
        return precisionModel;
    }

    public double getUnionRate() {
        return 0.9;
    }

    public PrecisionModel getResultPrecisionModel(CoordinateReferenceSystem crs) {
        double d;
        double meters = new StringOps(Predef$.MODULE$.augmentString(AtlasSystemProperties$.MODULE$.getProperty(this.RESULT_PRECISION_METER()))).toDouble();
        CoordinateReferenceSystem coordinateReferenceSystem = crs;
        if (coordinateReferenceSystem instanceof GeographicCRS) {
            d = meters * 9.0E-6;
        } else if (coordinateReferenceSystem instanceof ProjectedCRS) {
            d = meters;
        } else {
            throw new MatchError((Object)coordinateReferenceSystem);
        }
        double tolerance = d;
        return new PrecisionModel(1.0 / tolerance);
    }

    public double getDistanceFromMeters(CoordinateReferenceSystem sourceCRS, double x, double y, double meters) {
        double d;
        CoordinateReferenceSystem coordinateReferenceSystem = sourceCRS;
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            d = meters;
        } else if (coordinateReferenceSystem instanceof GeographicCRS) {
            GeographicCRS geographicCRS = (GeographicCRS)coordinateReferenceSystem;
            GeodeticCalculator geoCalc = this.getGeodeticCalculator((CoordinateReferenceSystem)geographicCRS);
            geoCalc.setStartingGeographicPoint(x, y);
            geoCalc.setDirection(90.0, meters);
            Point2D destPoint2D = geoCalc.getDestinationGeographicPoint();
            d = destPoint2D.distance(x, y);
        } else {
            throw new MatchError((Object)coordinateReferenceSystem);
        }
        return d;
    }

    public Envelope getEncodeBoundary(CoordinateReferenceSystem crs) {
        return (Envelope)this.ENCODE_BOUNDARY_CACHE().apply((Object)crs, (Function1 & Serializable & scala.Serializable)x$2 -> {
            Envelope envelope;
            CoordinateReferenceSystem coordinateReferenceSystem;
            CoordinateReferenceSystem handleCRS = crs;
            int srid = package$.MODULE$.FIND_SRID(crs);
            if (package$.MODULE$.FIND_SRID(crs) > 0) {
                handleCRS = package$.MODULE$.GET_CRS_EPSG(srid);
            }
            if ((coordinateReferenceSystem = handleCRS) instanceof GeographicCRS) {
                GeographicCRS geographicCRS = (GeographicCRS)coordinateReferenceSystem;
                GeographicExtent geographicExtent = geographicCRS.getDomainOfValidity() == null || geographicCRS.getDomainOfValidity().getGeographicElements() == null ? null : (GeographicExtent)IterableUtils.get((Iterable)geographicCRS.getDomainOfValidity().getGeographicElements(), (int)0);
                Envelope e3 = null;
                GeographicExtent geographicExtent2 = geographicExtent;
                if (geographicExtent2 instanceof GeographicBoundingBox) {
                    GeographicBoundingBox geographicBoundingBox = (GeographicBoundingBox)geographicExtent2;
                    double xMin = geographicBoundingBox.getWestBoundLongitude();
                    double xMax = geographicBoundingBox.getEastBoundLongitude();
                    double yMin = geographicBoundingBox.getSouthBoundLatitude();
                    double yMax = geographicBoundingBox.getNorthBoundLatitude();
                    e3 = new Envelope(xMin, xMax, yMin, yMax);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (geographicExtent2 instanceof BoundingPolygon) {
                    BoundingPolygon boundingPolygon = (BoundingPolygon)geographicExtent2;
                    e3 = (Envelope)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(boundingPolygon.getPolygons()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getEnvelope(), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> {
                        DirectPosition lowerPosition = e.getLowerCorner();
                        double xMin = lowerPosition.getOrdinate(0);
                        double yMin = lowerPosition.getOrdinate(1);
                        DirectPosition upperPosition = e.getUpperCorner();
                        double xMax = upperPosition.getOrdinate(0);
                        double yMax = upperPosition.getOrdinate(1);
                        return new Envelope(xMin, xMax, yMin, yMax);
                    }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(e1, e2) -> {
                        e1.expandToInclude(e2);
                        return e1;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                envelope = e3 == null || MODULE$.STANDARD_ENCODE_BOUNDARY().contains(e3) ? MODULE$.STANDARD_ENCODE_BOUNDARY() : new Envelope(e3.centre().x - 180.0, e3.centre().x + 180.0, e3.centre().y - 180.0, e3.centre().y + 180.0);
            } else if (coordinateReferenceSystem instanceof ProjectedCRS) {
                ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem;
                MathTransform projection = projectedCRS.getConversionFromBase().getMathTransform();
                MathTransform mathTransform = projection;
                if (!(mathTransform instanceof MapProjection)) {
                    String x$1 = "\u4e0d\u652f\u6301\u5f53\u524d\u5750\u6807\u8f6c\u6362\u7c7b\u578b!";
                    Thread x$22 = NotSupportException$.MODULE$.apply$default$2(x$1);
                    int x$32 = NotSupportException$.MODULE$.apply$default$3(x$1);
                    throw new NotSupportException(x$1, x$22, x$32);
                }
                MapProjection mapProjection = (MapProjection)mathTransform;
                Envelope envelope2 = MODULE$.getProjectionEnvelope(mapProjection);
                envelope = envelope2;
            } else {
                throw new MatchError((Object)coordinateReferenceSystem);
            }
            return envelope;
        });
    }

    public Envelope getProjectionEnvelope(MapProjection mapProjection) {
        Double semiMajor = (Double)this.getParameterValue(mapProjection, MapProjection.AbstractProvider.SEMI_MAJOR).get();
        Double longCenter = (Double)this.getParameterValue(mapProjection, MapProjection.AbstractProvider.CENTRAL_MERIDIAN).get();
        Double latCenter = (Double)this.getParameterValue(mapProjection, MapProjection.AbstractProvider.LATITUDE_OF_CENTRE).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Double)MODULE$.getParameterValue(mapProjection, MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN).get());
        Double scale = (Double)this.getParameterValue(mapProjection, MapProjection.AbstractProvider.SCALE_FACTOR).get();
        Coordinate projectCoordinate = JTS.transform((Coordinate)new Coordinate(Predef$.MODULE$.Double2double(longCenter), Predef$.MODULE$.Double2double(latCenter)), null, (MathTransform)mapProjection);
        double halfL = Math.ceil(Math.PI * 2 * Predef$.MODULE$.Double2double(semiMajor) * Predef$.MODULE$.Double2double(scale) / (double)2);
        return new Envelope(projectCoordinate.x - halfL, projectCoordinate.x + halfL, projectCoordinate.y - halfL, projectCoordinate.y + halfL);
    }

    private <T> Option<T> getParameterValue(MapProjection mapProjection, ParameterDescriptor<T> parameterDescriptor) {
        ParameterValue parameterValue = mapProjection.getParameterValues().parameter(parameterDescriptor.getName().getCode());
        return parameterValue == null || parameterValue.getValue() == null ? None$.MODULE$ : new Some(parameterValue.getValue());
    }

    private CrsUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.geodeticCalculatorCache = AtlasThreadSafeCache$.MODULE$.apply();
        this.RESULT_PRECISION_METER = "atlas.data.vector.precision.meter";
        this.DENSIFICATION_DISTANCE_METER = "atlas.data.vector.common.crs.densification.distance.meter";
        this.EARTH_CIRCUMFERENCE = 4.0E7;
        this.STANDARD_ENCODE_BOUNDARY = new Envelope(-180.0, 180.0, -180.0, 180.0);
        this.ENCODE_BOUNDARY_CACHE = AtlasCache$.MODULE$.apply();
        this.DEGREE_METER = 111111.11111111111;
    }
}

