/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.common.wkb;

import com.geoway.atlas.common.cache.AtlasThreadSafeObj;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.serialization.JMapSerialization$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class WkbUtils$ {
    public static WkbUtils$ MODULE$;
    private final AtlasThreadSafeObj<WKBWriter> wkbWriterCache;
    private final AtlasThreadSafeObj<WKBReader> wkbReaderCache;

    static {
        new WkbUtils$();
    }

    private AtlasThreadSafeObj<WKBWriter> wkbWriterCache() {
        return this.wkbWriterCache;
    }

    private AtlasThreadSafeObj<WKBReader> wkbReaderCache() {
        return this.wkbReaderCache;
    }

    public WKBWriter getWkbWriter() {
        return (WKBWriter)this.wkbWriterCache().getOrElseUpdate((Function0 & Serializable & scala.Serializable)() -> new WKBWriter());
    }

    public WKBReader getWkbReader() {
        return (WKBReader)this.wkbReaderCache().getOrElseUpdate((Function0 & Serializable & scala.Serializable)() -> new WKBReader());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void write(Geometry geometry, OutputStream outputStream, boolean withUserData) {
        BoxedUnit boxedUnit;
        this.getWkbWriter().write(geometry, (OutStream)new OutputStreamOutStream(outputStream));
        if (!withUserData) return;
        DataOutputStream dos = new DataOutputStream(outputStream);
        if (geometry.getUserData() == null) {
            dos.writeBoolean(false);
            return;
        }
        Object object = geometry.getUserData();
        if (!(object instanceof Map)) {
            String x$1 = new StringBuilder(15).append("\u4e0d\u652f\u6301\u7684userdata\u7c7b\u578b:").append(geometry.getUserData().getClass().getSimpleName()).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        Map map = (Map)object;
        if (!map.isEmpty()) {
            dos.writeBoolean(true);
            JMapSerialization$.MODULE$.serialize(new DataOutputStream(outputStream), map);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            dos.writeBoolean(false);
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] write(Geometry geometry, boolean withUserData) {
        byte[] byArray;
        byte[] geometryBytes = this.getWkbWriter().write(geometry);
        if (!withUserData) {
            byArray = geometryBytes;
            return byArray;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream daos = new DataOutputStream(baos);
        if (geometry.getUserData() != null) {
            BoxedUnit boxedUnit;
            Object object = geometry.getUserData();
            if (!(object instanceof Map)) {
                String x$1 = new StringBuilder(15).append("\u4e0d\u652f\u6301\u7684userdata\u7c7b\u578b:").append(geometry.getUserData().getClass().getSimpleName()).toString();
                Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                throw new NotSupportException(x$1, x$2, x$3);
            }
            Map map = (Map)object;
            if (!map.isEmpty()) {
                daos.writeBoolean(true);
                JMapSerialization$.MODULE$.serialize(daos, map);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                daos.writeBoolean(false);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            daos.writeBoolean(false);
        }
        byArray = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(geometryBytes)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(baos.toByteArray())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public Geometry read(InputStream inputStream, boolean withUserData) {
        void var3_3;
        block0: {
            DataInputStream dis;
            Geometry geometry = this.getWkbReader().read((InStream)new InputStreamInStream(inputStream));
            if (!withUserData || !(dis = new DataInputStream(inputStream)).readBoolean()) break block0;
            Map userMap = JMapSerialization$.MODULE$.deserialize(dis);
            geometry.setUserData((Object)userMap);
        }
        return var3_3;
    }

    public Geometry read(byte[] bytes, boolean withUserData) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        return this.read(dis, withUserData);
    }

    private WkbUtils$() {
        MODULE$ = this;
        this.wkbWriterCache = new AtlasThreadSafeObj();
        this.wkbReaderCache = new AtlasThreadSafeObj();
    }
}

