/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Arrays;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CircularUtils;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class LinearizedCSUtils {
    public static CoordinateSequence getCircularRingLinearizedCS(double tolerance, double threshold, CircularRing circularRing) {
        CircularString circularString = CircularUtils.delegateCircularRing(circularRing);
        return LinearizedCSUtils.getCircularStringLinearizedCS(circularString.tolerance, threshold, circularString);
    }

    public static CoordinateSequence getCircularStringLinearizedCS(double tolerance, double threshold, CircularString circularString) {
        boolean isDefaultTolerance = CircularArc.equals((double)tolerance, (double)circularString.tolerance);
        if (circularString.linearized != null && isDefaultTolerance) {
            return circularString.linearized.getCoordinateSequence();
        }
        GrowableOrdinateArray gar = new GrowableOrdinateArray();
        LinearizedCSUtils.scanCircular(gar, circularString, tolerance, threshold);
        return gar.toCoordinateSequence(circularString.getFactory());
    }

    private static void scanCircular(GrowableOrdinateArray gar, CircularString circularString, double tolerance, double threshold) {
        if (circularString.controlPoints.length == 6) {
            CircularArc arc = new CircularArc(circularString.controlPoints);
            LinearizedCSUtils.visitArc(gar, arc, tolerance, threshold);
        } else {
            double[] arcControlPoints = new double[6];
            CircularArc arc = new CircularArc(arcControlPoints);
            for (int i = 0; i <= circularString.controlPoints.length - 6; i += 4) {
                System.arraycopy(circularString.controlPoints, i, arcControlPoints, 0, 6);
                arc.reset();
                LinearizedCSUtils.visitArc(gar, arc, tolerance, threshold);
            }
        }
    }

    private static void visitArc(GrowableOrdinateArray gar, CircularArc arc, double tolerance, double threshold) {
        if (gar.size() > 0) {
            gar.setSize(gar.size() - 2);
        }
        double[] pointCoordinate = arc.controlPoints;
        double[] xs = new double[]{pointCoordinate[0], pointCoordinate[2], pointCoordinate[4]};
        double[] ys = new double[]{pointCoordinate[1], pointCoordinate[3], pointCoordinate[5]};
        double xMin = Arrays.stream(xs).min().getAsDouble();
        double xMax = Arrays.stream(xs).max().getAsDouble();
        double yMin = Arrays.stream(ys).min().getAsDouble();
        double yMax = Arrays.stream(ys).max().getAsDouble();
        double max = Math.max(xMax - xMin, yMax - yMin);
        if (max <= threshold) {
            gar.addAll(pointCoordinate);
        } else {
            arc.linearize(tolerance, gar);
        }
    }

    public static CoordinateSequence visitArc(CircularArc arc, GeometryFactory gf, double tolerance, double threshold) {
        GrowableOrdinateArray gar = new GrowableOrdinateArray();
        if (gar.size() > 0) {
            gar.setSize(gar.size() - 2);
        }
        double[] pointCoordinate = arc.controlPoints;
        double[] xs = new double[]{pointCoordinate[0], pointCoordinate[2], pointCoordinate[4]};
        double[] ys = new double[]{pointCoordinate[1], pointCoordinate[3], pointCoordinate[5]};
        double xMin = Arrays.stream(xs).min().getAsDouble();
        double xMax = Arrays.stream(xs).max().getAsDouble();
        double yMin = Arrays.stream(ys).min().getAsDouble();
        double yMax = Arrays.stream(ys).max().getAsDouble();
        double max = Math.max(xMax - xMin, yMax - yMin);
        double startEndMax = Math.max(Math.abs(pointCoordinate[0] - pointCoordinate[4]), Math.abs(pointCoordinate[1] - pointCoordinate[5]));
        if (startEndMax <= threshold || max <= threshold) {
            gar.addAll(new double[]{pointCoordinate[0], pointCoordinate[1], (pointCoordinate[0] + pointCoordinate[4]) / 2.0, (pointCoordinate[1] + pointCoordinate[5]) / 2.0, pointCoordinate[4], pointCoordinate[5]});
        } else {
            arc.linearize(tolerance, gar);
        }
        return gar.toCoordinateSequence(gf);
    }

    public static CoordinateSequence getCompoundRingLinearizedCS(double tolerance, double threshold, CompoundRing compoundRing) {
        CompoundCurve compoundCurve = CircularUtils.delegateCompoundRing(compoundRing);
        GrowableOrdinateArray gar = new GrowableOrdinateArray();
        for (LineString component : compoundCurve.components) {
            CoordinateSequence cs;
            if (gar.size() > 0) {
                gar.setSize(gar.size() - 2);
            }
            if (component instanceof CircularRing) {
                cs = LinearizedCSUtils.getCircularRingLinearizedCS(tolerance, threshold, (CircularRing)component);
                gar.addAll(cs);
                continue;
            }
            if (component instanceof CircularString) {
                cs = LinearizedCSUtils.getCircularStringLinearizedCS(tolerance, threshold, (CircularString)component);
                gar.addAll(cs);
                continue;
            }
            if (component instanceof SingleCurvedGeometry) {
                SingleCurvedGeometry curved = (SingleCurvedGeometry)component;
                CoordinateSequence cs2 = curved.getLinearizedCoordinateSequence(tolerance);
                gar.addAll(cs2);
                continue;
            }
            cs = component.getCoordinateSequence();
            for (int i = 0; i < cs.size(); ++i) {
                gar.add(cs.getX(i), cs.getY(i));
            }
        }
        return gar.toCoordinateSequence(compoundRing.getFactory());
    }
}

