/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.LinearizedCSUtils;
import org.geotools.geometry.jts.MultiSurface;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class CurvedGeometryUtils {
    public static MultiPolygon linearizeMultiSurface(MultiSurface multiSurface, double tolerance, double threshold) {
        int numGeometries = multiSurface.getNumGeometries();
        Polygon[] linearized = new Polygon[numGeometries];
        for (int k = 0; k < numGeometries; ++k) {
            Polygon component = (Polygon)multiSurface.getGeometryN(k);
            linearized[k] = component instanceof CurvePolygon ? CurvedGeometryUtils.linearizeCurvePolygon((CurvePolygon)component, tolerance, threshold) : (component instanceof CurvedGeometry ? (Polygon)((CurvedGeometry)component).linearize(tolerance) : component);
        }
        return multiSurface.getFactory().createMultiPolygon(linearized);
    }

    public static Polygon linearizeCurvePolygon(CurvePolygon curvePolygon, double tolerance, double threshold) {
        int numHoles = curvePolygon.getNumInteriorRing();
        LinearRing shell = CurvedGeometryUtils.linearizeLinearRing(tolerance, threshold, curvePolygon.getExteriorRing());
        LinearRing[] holes = new LinearRing[numHoles];
        for (int k = 0; k < numHoles; ++k) {
            LinearRing hole = curvePolygon.getInteriorRingN(k);
            holes[k] = hole = CurvedGeometryUtils.linearizeLinearRing(tolerance, threshold, hole);
        }
        return curvePolygon.getFactory().createPolygon(shell, holes);
    }

    public static LinearRing linearizeLinearRing(double tolerance, double threshold, LinearRing linearRing) {
        if (linearRing instanceof CircularRing) {
            linearRing = CurvedGeometryUtils.linearizeCircularRing(tolerance, threshold, (CircularRing)linearRing);
        } else if (linearRing instanceof CompoundRing) {
            linearRing = CurvedGeometryUtils.linearizeCompoundRing(tolerance, threshold, (CompoundRing)linearRing);
        } else if (linearRing instanceof CurvedGeometry) {
            CurvedGeometry curved = (CurvedGeometry)linearRing;
            linearRing = (LinearRing)curved.linearize(tolerance);
        }
        return linearRing;
    }

    public static LinearRing linearizeCircularRing(double tolerance, double threshold, CircularRing circularRing) {
        CoordinateSequence cs = LinearizedCSUtils.getCircularRingLinearizedCS(tolerance, threshold, circularRing);
        return circularRing.getFactory().createLinearRing(cs);
    }

    public static LinearRing linearizeCompoundRing(double tolerance, double threshold, CompoundRing compoundRing) {
        CoordinateSequence cs = LinearizedCSUtils.getCompoundRingLinearizedCS(tolerance, threshold, compoundRing);
        return compoundRing.getFactory().createLinearRing(cs);
    }
}

