/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import com.geoway.atlas.common.config.AtlasSystemProperties;
import com.geoway.atlas.data.vector.common.crs.CrsUtils$;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CurvedGeometryUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryUtils;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class GeometryUtils$
implements scala.Serializable {
    public static GeometryUtils$ MODULE$;
    private final String CURVED_TOLERANCE;
    private final String CURVED_THRESHOLD;
    private final double CURVED_TOLERANCE_DEFAULT;

    static {
        new GeometryUtils$();
    }

    public String CURVED_TOLERANCE() {
        return this.CURVED_TOLERANCE;
    }

    public String CURVED_THRESHOLD() {
        return this.CURVED_THRESHOLD;
    }

    public double CURVED_TOLERANCE_DEFAULT() {
        return this.CURVED_TOLERANCE_DEFAULT;
    }

    public GeometryUtils.RichGeometry RichGeometry(Geometry geometry) {
        return new GeometryUtils.RichGeometry(geometry);
    }

    public boolean isEmpty(Geometry geometry) {
        return geometry == null || geometry.isEmpty();
    }

    public boolean nonEmpty(Geometry geometry) {
        return !this.isEmpty(geometry);
    }

    public Tuple2<Object, Object> distanceUnit(Geometry geometry, CoordinateReferenceSystem tCrs, double distance, Class<?> dCrsType) {
        Tuple2<Object, Object> tuple2;
        if (dCrsType == null || dCrsType.isAssignableFrom(tCrs.getClass())) {
            tuple2 = new Tuple2<Object, Object>(distance, distance);
        } else {
            Class<?> clazz = dCrsType;
            Class<GeographicCRS> clazz2 = GeographicCRS.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                MathTransform mathTransform = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_THRANSFORM(tCrs, (CoordinateReferenceSystem)((ProjectedCRS)tCrs).getBaseCRS());
                tuple2 = this.distanceUnit(geometry, distance, tCrs, mathTransform);
            } else {
                tuple2 = this.distanceUnit(geometry, distance, tCrs, null);
            }
        }
        return tuple2;
    }

    public Tuple2<Object, Object> distanceUnit(Geometry geom, double value, CoordinateReferenceSystem crs, MathTransform mathTransform) {
        Tuple2<Object, Object> tuple2;
        Geometry geometry = geom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            tuple2 = this.distanceUnit(point, value, CrsUtils$.MODULE$.getGeodeticCalculator(crs), mathTransform);
        } else {
            tuple2 = this.distanceUnit(geom.getEnvelopeInternal(), value, crs, geom.getFactory(), mathTransform);
        }
        return tuple2;
    }

    private Tuple2<Object, Object> distanceUnit(Envelope env, double value, CoordinateReferenceSystem crs, GeometryFactory gf, MathTransform mathTransform) {
        Seq distances = (Seq)new .colon.colon(this.distanceUnit((Geometry)gf.createPoint(new Coordinate(env.getMaxX(), env.getMaxY())), value, crs, mathTransform), (List)new .colon.colon(this.distanceUnit((Geometry)gf.createPoint(new Coordinate(env.getMaxX(), env.getMinY())), value, crs, mathTransform), (List)new .colon.colon(this.distanceUnit((Geometry)gf.createPoint(new Coordinate(env.getMinX(), env.getMinY())), value, crs, mathTransform), (List)new .colon.colon(this.distanceUnit((Geometry)gf.createPoint(new Coordinate(env.getMinX(), env.getMaxY())), value, crs, mathTransform), (List)Nil$.MODULE$))));
        return new Tuple2.mcDD.sp(((Tuple2)distances.minBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$))._1$mcD$sp(), ((Tuple2)distances.maxBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$))._2$mcD$sp());
    }

    private Tuple2<Object, Object> distanceUnit(Point point, double values, GeodeticCalculator calc, MathTransform mathTransform) {
        Tuple2<Object, Object> tuple2;
        Tuple2<Object, Object> tuple22 = tuple2 = mathTransform == null ? this.directionalDegrees(point, values, calc) : this.directionalMeters(point, values, calc, mathTransform);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double east = tuple2._1$mcD$sp();
        double north = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(east, north);
        Tuple2.mcDD.sp sp3 = sp2;
        double east2 = sp3._1$mcD$sp();
        double north2 = sp3._2$mcD$sp();
        return east2 > north2 ? new Tuple2.mcDD.sp(north2, east2) : new Tuple2.mcDD.sp(east2, north2);
    }

    private Tuple2<Object, Object> directionalDegrees(Point point, double meters, GeodeticCalculator calc) {
        calc.setStartingGeographicPoint(point.getX(), point.getY());
        return new Tuple2.mcDD.sp(package$.MODULE$.min(GeometryUtils$.degrees$1(90.0, calc, meters, point), GeometryUtils$.degrees$1(-90.0, calc, meters, point)), package$.MODULE$.min(GeometryUtils$.degrees$1(0.0, calc, meters, point), GeometryUtils$.degrees$1(180.0, calc, meters, point)));
    }

    private Tuple2<Object, Object> directionalMeters(Point point, double degress, GeodeticCalculator calc, MathTransform mathTransform) {
        Point sourcePoint = (Point)JTS.transform((Geometry)point, (MathTransform)mathTransform);
        calc.setStartingGeographicPoint(sourcePoint.getX(), sourcePoint.getY());
        return new Tuple2.mcDD.sp(package$.MODULE$.min(GeometryUtils$.distMeter$1(sourcePoint.getX() - degress, sourcePoint.getY(), calc), GeometryUtils$.distMeter$1(sourcePoint.getX() + degress, sourcePoint.getY(), calc)), package$.MODULE$.max(GeometryUtils$.distMeter$1(sourcePoint.getX(), sourcePoint.getY() - degress, calc), GeometryUtils$.distMeter$1(sourcePoint.getX(), sourcePoint.getY() + degress, calc)));
    }

    public <T extends Geometry> Geometry getLinearizeIfHasCurved(Geometry geometry, CoordinateReferenceSystem crs) {
        Geometry geometry2;
        double tolerance2 = BoxesRunTime.unboxToDouble((Object)new AtlasSystemProperties.SystemProperty(this.CURVED_TOLERANCE(), AtlasSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GeometryUtils$.$anonfun$getLinearizeIfHasCurved$1(x$4))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)tolerance -> CrsUtils$.MODULE$.getCRSRoughDistancebyMeter(tolerance, crs)).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> MODULE$.CURVED_TOLERANCE_DEFAULT()));
        double threshold = CrsUtils$.MODULE$.getCRSRoughDistancebyMeter(BoxesRunTime.unboxToDouble((Object)new AtlasSystemProperties.SystemProperty(this.CURVED_THRESHOLD(), AtlasSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)GeometryUtils$.$anonfun$getLinearizeIfHasCurved$4(x$5))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0)), crs);
        Geometry geometry3 = geometry;
        if (geometry3 instanceof CurvedGeometry) {
            MultiPolygon multiPolygon;
            Geometry geometry4 = geometry3;
            Geometry geometry5 = geometry4;
            if (geometry5 instanceof MultiSurface) {
                MultiSurface multiSurface = (MultiSurface)geometry5;
                multiPolygon = CurvedGeometryUtils.linearizeMultiSurface(multiSurface, tolerance2, threshold);
            } else if (geometry5 instanceof CurvePolygon) {
                CurvePolygon curvePolygon = (CurvePolygon)geometry5;
                multiPolygon = CurvedGeometryUtils.linearizeCurvePolygon(curvePolygon, tolerance2, threshold);
            } else {
                multiPolygon = ((CurvedGeometry)geometry4).linearize(tolerance2);
            }
            geometry2 = multiPolygon;
        } else {
            geometry2 = geometry;
        }
        return geometry2;
    }

    public boolean isEmptyEnvelope(Geometry geometry) {
        boolean bl;
        if (!geometry.isEmpty()) {
            Polygon polygon;
            Geometry geometry2 = geometry;
            boolean bl2 = geometry2 instanceof Polygon ? ((polygon = (Polygon)geometry2).getNumPoints() == 5 ? BoxesRunTime.unboxToBoolean((Object)new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps((boolean[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])polygon.getCoordinates())).map((Function1 & Serializable & scala.Serializable)coordinate -> BoxesRunTime.boxToBoolean((boolean)GeometryUtils$.$anonfun$isEmptyEnvelope$1(coordinate)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())))).reduce((Function2 & Serializable & scala.Serializable)(pre, beh) -> BoxesRunTime.boxToBoolean((boolean)GeometryUtils$.$anonfun$isEmptyEnvelope$2(BoxesRunTime.unboxToBoolean((Object)pre), BoxesRunTime.unboxToBoolean((Object)beh))))) : false) : false;
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final double degrees$1(double azimuth, GeodeticCalculator calc$1, double meters$1, Point point$1) {
        calc$1.setDirection(azimuth, meters$1);
        Point2D dest = calc$1.getDestinationGeographicPoint();
        return point$1.distance((Geometry)point$1.getFactory().createPoint(new Coordinate(dest.getX(), dest.getY())));
    }

    private static final double distMeter$1(double x, double y, GeodeticCalculator calc$2) {
        calc$2.setDestinationGeographicPoint(x, y);
        return calc$2.getOrthodromicDistance();
    }

    public static final /* synthetic */ double $anonfun$getLinearizeIfHasCurved$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toDouble();
    }

    public static final /* synthetic */ double $anonfun$getLinearizeIfHasCurved$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toDouble();
    }

    public static final /* synthetic */ boolean $anonfun$isEmptyEnvelope$1(Coordinate coordinate) {
        return !(coordinate.x != -1.0 && coordinate.x != 0.0 || coordinate.y != -1.0 && coordinate.y != 0.0);
    }

    public static final /* synthetic */ boolean $anonfun$isEmptyEnvelope$2(boolean pre, boolean beh) {
        return pre && beh;
    }

    private GeometryUtils$() {
        MODULE$ = this;
        this.CURVED_TOLERANCE = "atlas.data.vector.geometry.curved.linearize.tolerance";
        this.CURVED_THRESHOLD = "atlas.data.vector.geometry.curved.linearize.threshold";
        this.CURVED_TOLERANCE_DEFAULT = Double.MAX_VALUE;
    }
}

