/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field;

import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.common.error.IoException$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.common.io.package$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.vector.common.feature.sft.SimpleFeatureTypeUtils$;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.HeaderFieldParser$FieldOpt$;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.HeaderFieldParser$GDBType$;
import com.geoway.atlas.data.vector.serialization.esri.filegdb.FileGdbGeometryDeserializer;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import org.json4s.jackson.Serialization$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import scala.Double$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HeaderFieldParser$
implements LazyLogging {
    public static HeaderFieldParser$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HeaderFieldParser$();
    }

    private Logger logger$lzycompute() {
        HeaderFieldParser$ headerFieldParser$ = this;
        synchronized (headerFieldParser$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Tuple2<AttributeDescriptor, Object> readField(StandardInput standardInput, int geomType, int geomProp) {
        Tuple2 tuple2;
        byte fieldType;
        int nameLen = package$.MODULE$.RichStandardInput(standardInput).readUnsignedByte(ByteOrder.LITTLE_ENDIAN);
        String name = package$.MODULE$.RichStandardInput(standardInput).readUTF16String(nameLen, ByteOrder.LITTLE_ENDIAN);
        int aliasLen = package$.MODULE$.RichStandardInput(standardInput).readUnsignedByte(ByteOrder.LITTLE_ENDIAN);
        String alias = aliasLen > 0 ? package$.MODULE$.RichStandardInput(standardInput).readUTF16String(aliasLen, ByteOrder.LITTLE_ENDIAN) : name;
        byte by = fieldType = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        if (HeaderFieldParser$GDBType$.MODULE$.INT16() == by) {
            tuple2 = new Tuple2((Object)this.toFieldInt16(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else if (HeaderFieldParser$GDBType$.MODULE$.INT32() == by) {
            tuple2 = new Tuple2((Object)this.toFieldInt32(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else if (HeaderFieldParser$GDBType$.MODULE$.FLOAT32() == by) {
            tuple2 = new Tuple2((Object)this.toFieldFloat32(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else if (HeaderFieldParser$GDBType$.MODULE$.FLOAT64() == by) {
            tuple2 = new Tuple2((Object)this.toFieldFloat64(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else if (HeaderFieldParser$GDBType$.MODULE$.DATE() == by) {
            tuple2 = new Tuple2((Object)this.toFieldTimestamp(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else if (HeaderFieldParser$GDBType$.MODULE$.STRING() == by) {
            tuple2 = new Tuple2((Object)this.toFieldString(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else if (HeaderFieldParser$GDBType$.MODULE$.OID() == by) {
            tuple2 = new Tuple2((Object)this.toFieldOID(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else if (HeaderFieldParser$GDBType$.MODULE$.SHAPE() == by) {
            tuple2 = new Tuple2((Object)this.toFieldGeom(standardInput, name, alias, geomType, geomProp), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else if (HeaderFieldParser$GDBType$.MODULE$.BINARY() == by) {
            tuple2 = new Tuple2((Object)this.toFieldBinary(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
        } else {
            boolean bl = HeaderFieldParser$GDBType$.MODULE$.UUID() == by ? true : HeaderFieldParser$GDBType$.MODULE$.GUID() == by;
            if (bl) {
                tuple2 = new Tuple2((Object)this.toFieldUUID(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
            } else if (HeaderFieldParser$GDBType$.MODULE$.XML() == by) {
                tuple2 = new Tuple2((Object)this.toFieldXML(standardInput, name, alias), (Object)BoxesRunTime.boxToByte((byte)fieldType));
            } else {
                JsonAST.JObject jObject = JsonListAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.pair2Assoc(new Tuple2((Object)"name", (Object)name), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), new Tuple2((Object)"nameLen", (Object)BoxesRunTime.boxToInteger((int)nameLen)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))), new Tuple2((Object)"alias", (Object)JsonDSL$.MODULE$.string2jvalue(alias)))), new Tuple2((Object)"aliasLen", (Object)JsonDSL$.MODULE$.int2jvalue(aliasLen)))), new Tuple2((Object)"fieldType", (Object)JsonDSL$.MODULE$.byte2jvalue(fieldType)));
                DefaultFormats$ formats = DefaultFormats$.MODULE$;
                String x$25 = new StringBuilder(25).append("Not support this field : ").append(Serialization$.MODULE$.write((Object)jObject, (Formats)formats)).toString();
                Thread x$26 = NotSupportException$.MODULE$.apply$default$2(x$25);
                int x$27 = NotSupportException$.MODULE$.apply$default$3(x$25);
                throw new NotSupportException(x$25, x$26, x$27);
            }
        }
        return tuple2;
    }

    private AttributeDescriptor toFieldFloat32(StandardInput standardInput, String name, String alias) {
        Object object;
        boolean nullable;
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte defaultValueLength = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Float f = null;
        boolean bl = nullable = (flags & 1) == 1;
        if ((flags & 4) != 0) {
            if (defaultValueLength > 0) {
                if (defaultValueLength == 4) {
                    f = BoxesRunTime.boxToFloat((float)package$.MODULE$.RichStandardInput(standardInput).readFloat(ByteOrder.LITTLE_ENDIAN));
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxesRunTime.boxToLong((long)standardInput.skip((long)defaultValueLength));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<Float> x$2 = Float.class;
        HashMap<String, String> x$3 = userMap;
        Float x$4 = f;
        int x$5 = 0;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, (Object)x$4, x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldFloat64(StandardInput standardInput, String name, String alias) {
        Object object;
        boolean nullable;
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte defaultValueLength = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Double d = null;
        boolean bl = nullable = (flags & 1) == 1;
        if ((flags & 4) != 0) {
            if (defaultValueLength > 0) {
                if (defaultValueLength == 8) {
                    d = BoxesRunTime.boxToDouble((double)package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN));
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxesRunTime.boxToLong((long)standardInput.skip((long)defaultValueLength));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<Double> x$2 = Double.class;
        HashMap<String, String> x$3 = userMap;
        Double x$4 = d;
        int x$5 = 0;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, (Object)x$4, x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldInt16(StandardInput standardInput, String name, String alias) {
        Object object;
        boolean nullable;
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte defaultValueLength = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Short s = null;
        boolean bl = nullable = (flags & 1) == 1;
        if ((flags & 4) != 0) {
            if (defaultValueLength > 0) {
                if (defaultValueLength == 2) {
                    s = BoxesRunTime.boxToShort((short)package$.MODULE$.RichStandardInput(standardInput).readShort(ByteOrder.LITTLE_ENDIAN));
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxesRunTime.boxToLong((long)standardInput.skip((long)defaultValueLength));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<Short> x$2 = Short.class;
        HashMap<String, String> x$3 = userMap;
        Short x$4 = s;
        byte x$5 = len;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, (Object)x$4, (int)x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldInt32(StandardInput standardInput, String name, String alias) {
        Object object;
        boolean nullable;
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte defaultValueLength = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Integer n = null;
        boolean bl = nullable = (flags & 1) == 1;
        if ((flags & 4) != 0) {
            if (defaultValueLength > 0) {
                if (defaultValueLength == 4) {
                    n = BoxesRunTime.boxToInteger((int)package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN));
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxesRunTime.boxToLong((long)standardInput.skip((long)defaultValueLength));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<Integer> x$2 = Integer.class;
        HashMap<String, String> x$3 = userMap;
        Integer x$4 = n;
        byte x$5 = len;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, (Object)x$4, (int)x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldBinary(StandardInput standardInput, String name, String alias) {
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Object default_ = null;
        boolean nullable = (flags & 1) == 1;
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<byte[]> x$2 = byte[].class;
        HashMap<String, String> x$3 = userMap;
        Object x$4 = default_;
        byte x$5 = len;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, x$4, (int)x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldUUID(StandardInput standardInput, String name, String alias) {
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Object default_ = null;
        boolean nullable = (flags & 1) == 1;
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<String> x$2 = String.class;
        HashMap<String, String> x$3 = userMap;
        Object x$4 = default_;
        byte x$5 = len;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, x$4, (int)x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldXML(StandardInput standardInput, String name, String alias) {
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Object default_ = null;
        boolean nullable = (flags & 1) == 1;
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<String> x$2 = String.class;
        HashMap<String, String> x$3 = userMap;
        Object x$4 = default_;
        byte x$5 = len;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, x$4, (int)x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldString(StandardInput standardInput, String name, String alias) {
        boolean nullable;
        int len = package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN);
        len = len >= 999999 ? -1 : len;
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        long defaultValueLength = package$.MODULE$.RichStandardInput(standardInput).readVarUInt(ByteOrder.LITTLE_ENDIAN);
        String string = null;
        boolean bl = nullable = (flags & 1) == 1;
        if ((flags & 4) != 0 && defaultValueLength > 0L) {
            byte[] stringBytes = new byte[(int)defaultValueLength + 1];
            standardInput.read(stringBytes, 0, (int)defaultValueLength);
            stringBytes[(int)defaultValueLength] = 0;
            string = new String(stringBytes, StandardCharsets.UTF_8);
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<String> x$2 = String.class;
        HashMap<String, String> x$3 = userMap;
        String x$4 = string;
        int x$5 = len;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, (Object)x$4, x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldTimestamp(StandardInput standardInput, String name, String alias) {
        Object object;
        boolean nullable;
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte defaultValueLength = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Date date = null;
        boolean bl = nullable = (flags & 1) == 1;
        if ((flags & 4) != 0) {
            if (defaultValueLength > 0) {
                if (defaultValueLength == 8) {
                    double dfVal = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
                    double dfSeconds = (dfVal - 25569.0) * 3600.0 * 24.0;
                    if (Double.isNaN(dfSeconds) || dfSeconds < Double$.MODULE$.MinValue() + (double)1000 || dfSeconds > Double.MAX_VALUE) {
                        String x$1 = "\u8bfb\u53d6\u5230\u7684\u9ed8\u8ba4\u65f6\u95f4\u7684\u503c\u65e0\u6cd5\u8f6c\u5316\u4e3a\u65f6\u95f4\u7c7b\u578b";
                        Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
                        int x$3 = IoException$.MODULE$.apply$default$3(x$1);
                        throw new IoException(x$1, x$2, x$3);
                    }
                    date = new Date((long)dfSeconds);
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxesRunTime.boxToLong((long)standardInput.skip((long)defaultValueLength));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$4 = name;
        Class<Date> x$5 = Date.class;
        HashMap<String, String> x$6 = userMap;
        Date x$7 = date;
        byte x$8 = len;
        boolean x$9 = nullable;
        Integer x$10 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$11 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$4, x$5, x$6, x$7, (int)x$8, x$10, x$11, x$9);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldOID(StandardInput standardInput, String name, String alias) {
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        byte flags = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        Object default_ = null;
        boolean nullable = (flags & 1) == 1;
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        String x$1 = name;
        Class<Integer> x$2 = Integer.class;
        HashMap<String, String> x$3 = userMap;
        Object x$4 = default_;
        byte x$5 = len;
        boolean x$6 = nullable;
        Integer x$7 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6();
        Integer x$8 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7();
        AttributeDescriptor attributeDescriptor = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(x$1, x$2, x$3, x$4, (int)x$5, x$7, x$8, x$6);
        return attributeDescriptor;
    }

    private AttributeDescriptor toFieldGeom(StandardInput standardInput, String name, String alias, int geometryType, int geometryProp) {
        Object object;
        Object object2;
        this.logger().info(new StringBuilder(14).append("\u8bfb\u53d6gdb\u7684\u56fe\u5f62\u5b57\u6bb5\u540d\u79f0\u4e3a:").append(name).toString());
        byte len = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        boolean nullable = (package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN) & 1) == 1;
        short srLen = package$.MODULE$.RichStandardInput(standardInput).readShort(ByteOrder.LITTLE_ENDIAN);
        int srChars = srLen / 2;
        String sr = package$.MODULE$.RichStandardInput(standardInput).readUTF16String(srChars, ByteOrder.LITTLE_ENDIAN);
        CoordinateReferenceSystem crs = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_WKT(sr);
        byte zAndM = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        boolean hasZ = false;
        boolean hasM = false;
        byte by = zAndM;
        switch (by) {
            case 7: {
                hasZ = true;
                hasM = true;
                break;
            }
            case 5: {
                hasZ = true;
                hasM = false;
                break;
            }
            default: {
                hasZ = false;
                hasM = false;
                break;
            }
        }
        double xOrig = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        double yOrig = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        double xyScale = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        double mOrig = hasM ? package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN) : 0.0;
        double mScale = hasM ? package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN) : 0.0;
        double zOrig = hasZ ? package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN) : 0.0;
        double zScale = hasZ ? package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN) : 0.0;
        double xyTolerance = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        double mTolerance = hasM ? package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN) : 0.0;
        double zTolerance = hasZ ? package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN) : 0.0;
        double xmin = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        double ymin = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        double xmax = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        double ymax = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        Envelope bbox = new Envelope(xmin, xmax, ymin, ymax);
        if (((Object)BoxesRunTime.boxToDouble((double)Double.NaN)).equals(BoxesRunTime.boxToDouble((double)xmin)) || ((Object)BoxesRunTime.boxToDouble((double)Double.NaN)).equals(BoxesRunTime.boxToDouble((double)xmax)) || ((Object)BoxesRunTime.boxToDouble((double)Double.NaN)).equals(BoxesRunTime.boxToDouble((double)ymin)) || ((Object)BoxesRunTime.boxToDouble((double)Double.NaN)).equals(BoxesRunTime.boxToDouble((double)ymax))) {
            bbox = new Envelope();
        }
        if ((geometryProp & 0x40) != 0) {
            double zMin = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
            double zMax = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        } else {
            hasZ = false;
        }
        if ((geometryProp & 0x80) != 0) {
            double mMin = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
            double mMax = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
        } else {
            hasM = false;
        }
        byte n = package$.MODULE$.RichStandardInput(standardInput).readByte(ByteOrder.LITTLE_ENDIAN);
        long nGridSizeCount = package$.MODULE$.RichStandardInput(standardInput).readUnsignedInt(ByteOrder.LITTLE_ENDIAN);
        ArrayBuffer m_adfSpatialIndexGridResolution = new ArrayBuffer((int)nGridSizeCount);
        for (long i = 0L; i < nGridSizeCount; ++i) {
            double dfGridResolution = package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN);
            m_adfSpatialIndexGridResolution.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{dfGridResolution}));
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put(HeaderFieldParser$FieldOpt$.MODULE$.FIELD_ALIAS(), alias);
        userMap.put(FileGdbGeometryDeserializer.GDBGeometryMeta$.MODULE$.X_ORIG(), Double.toString(xOrig));
        userMap.put(FileGdbGeometryDeserializer.GDBGeometryMeta$.MODULE$.XY_SCALE(), Double.toString(xyScale));
        userMap.put(FileGdbGeometryDeserializer.GDBGeometryMeta$.MODULE$.Y_ORIG(), Double.toString(yOrig));
        if (hasZ) {
            userMap.put(FileGdbGeometryDeserializer.GDBGeometryMeta$.MODULE$.Z_ORIG(), Double.toString(zOrig));
            object2 = userMap.put(FileGdbGeometryDeserializer.GDBGeometryMeta$.MODULE$.Z_SCALE(), Double.toString(zScale));
        } else {
            object2 = BoxedUnit.UNIT;
        }
        if (hasM) {
            userMap.put(FileGdbGeometryDeserializer.GDBGeometryMeta$.MODULE$.M_ORIG(), Double.toString(mOrig));
            object = userMap.put(FileGdbGeometryDeserializer.GDBGeometryMeta$.MODULE$.M_SCALE(), Double.toString(mScale));
        } else {
            object = BoxedUnit.UNIT;
        }
        userMap.put(FileGdbGeometryDeserializer.GDBGeometryMeta$.MODULE$.GEOMETRY_TYPE(), Integer.toString(geometryType));
        return SimpleFeatureTypeUtils$.MODULE$.createGeometryDescriptor(name, userMap, crs, bbox, Geometry.class, nullable);
    }

    private HeaderFieldParser$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

