/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field;

import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.data.vector.common.crs.package$;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.BinaryReader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.FieldReader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.Float32Reader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.Float64Reader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.GeometryReader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.HeaderFieldParser$GDBType$;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.Int16Reader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.Int32Reader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.OIDReader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.StringReader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.TimestampReader;
import com.geoway.atlas.data.vector.filegdb.common.ParseGDB.field.UUIDReader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import scala.Function1;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001]4A\u0001C\u0005\u00019!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0005A1A\u0005\u0002!Ca\u0001\u0016\u0001!\u0002\u0013I\u0005\"\u0002/\u0001\t\u0003i\u0006\"\u00023\u0001\t\u0003)'!\u0003*poJ+\u0017\rZ3s\u0015\tQ1\"A\u0003gS\u0016dGM\u0003\u0002\r\u001b\u0005A\u0001+\u0019:tK\u001e#%I\u0003\u0002\u000f\u001f\u000511m\\7n_:T!\u0001E\t\u0002\u000f\u0019LG.Z4eE*\u0011!cE\u0001\u0007m\u0016\u001cGo\u001c:\u000b\u0005Q)\u0012\u0001\u00023bi\u0006T!AF\f\u0002\u000b\u0005$H.Y:\u000b\u0005aI\u0012AB4f_^\f\u0017PC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0015CR$(/\u001b2vi\u0016$Um]2sSB$xN]:\u0011\u0007\u0015j\u0003G\u0004\u0002'W9\u0011qEK\u0007\u0002Q)\u0011\u0011fG\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!\u0001L\u0010\u0002\u000fA\f7m[1hK&\u0011af\f\u0002\u0004'\u0016\f(B\u0001\u0017 !\t\t$(D\u00013\u0015\t\u0019D'\u0001\u0003usB,'BA\u001b7\u0003\u001d1W-\u0019;ve\u0016T!a\u000e\u001d\u0002\u000f=\u0004XM\\4jg*\t\u0011(A\u0002pe\u001eL!a\u000f\u001a\u0003'\u0005#HO]5ckR,G)Z:de&\u0004Ho\u001c:\u0002\u0015\u0019LW\r\u001c3UsB,7\u000fE\u0002&[y\u0002\"AH \n\u0005\u0001{\"\u0001\u0002\"zi\u0016\fa\u0001P5oSRtDcA\"F\rB\u0011A\tA\u0007\u0002\u0013!)1e\u0001a\u0001I!)Ah\u0001a\u0001{\u0005aa-[3mIJ+\u0017\rZ3sgV\t\u0011\nE\u0002\u001f\u00152K!aS\u0010\u0003\u000b\u0005\u0013(/Y=1\u00055\u0013\u0006c\u0001#O!&\u0011q*\u0003\u0002\f\r&,G\u000e\u001a*fC\u0012,'\u000f\u0005\u0002R%2\u0001A!C*\u0006\u0003\u0003\u0005\tQ!\u0001V\u0005\ryF%M\u0001\u000eM&,G\u000e\u001a*fC\u0012,'o\u001d\u0011\u0012\u0005YK\u0006C\u0001\u0010X\u0013\tAvDA\u0004O_RD\u0017N\\4\u0011\u0005yQ\u0016BA. \u0005\r\te._\u0001\u0005S:LG\u000fF\u0001_!\rq\"j\u0018\u0019\u0003A\n\u00042\u0001\u0012(b!\t\t&\rB\u0005d\r\u0005\u0005\t\u0011!B\u0001+\n\u0019q\f\n\u001a\u0002\u0011\u001d,GOV1mk\u0016$B!\b4qk\")qm\u0002a\u0001Q\u0006Q!-\u001f;f\u0005V4g-\u001a:\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017a\u00018j_*\tQ.\u0001\u0003kCZ\f\u0017BA8k\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006c\u001e\u0001\rA]\u0001\u000bM&,G\u000eZ%oI\u0016D\bC\u0001\u0010t\u0013\t!xDA\u0002J]RDQA^\u0004A\u0002I\f1a\\5e\u0001")
public class RowReader {
    private final Seq<AttributeDescriptor> attributeDescriptors;
    private final Seq<Object> fieldTypes;
    private final FieldReader<?>[] fieldReaders;

    public FieldReader<?>[] fieldReaders() {
        return this.fieldReaders;
    }

    /*
     * WARNING - void declaration
     */
    public FieldReader<?>[] init() {
        void var1_1;
        FieldReader[] tmpReaders = new FieldReader[this.fieldTypes.length()];
        this.fieldTypes.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            FieldReader<Object> fieldReader;
            byte by = BoxesRunTime.unboxToByte((Object)$this.fieldTypes.apply(i));
            if (HeaderFieldParser$GDBType$.MODULE$.INT16() == by) {
                fieldReader = new Int16Reader();
            } else if (HeaderFieldParser$GDBType$.MODULE$.INT32() == by) {
                fieldReader = new Int32Reader();
            } else if (HeaderFieldParser$GDBType$.MODULE$.FLOAT32() == by) {
                fieldReader = new Float32Reader();
            } else if (HeaderFieldParser$GDBType$.MODULE$.FLOAT64() == by) {
                fieldReader = new Float64Reader();
            } else if (HeaderFieldParser$GDBType$.MODULE$.DATE() == by) {
                fieldReader = new TimestampReader();
            } else if (HeaderFieldParser$GDBType$.MODULE$.STRING() == by) {
                fieldReader = new StringReader();
            } else if (HeaderFieldParser$GDBType$.MODULE$.OID() == by) {
                fieldReader = new OIDReader();
            } else if (HeaderFieldParser$GDBType$.MODULE$.SHAPE() == by) {
                fieldReader = new GeometryReader(((PropertyDescriptor)$this.attributeDescriptors.apply(i)).getUserData(), package$.MODULE$.FIND_SRID(((GeometryDescriptor)$this.attributeDescriptors.apply(i)).getCoordinateReferenceSystem()));
            } else if (HeaderFieldParser$GDBType$.MODULE$.BINARY() == by) {
                fieldReader = new BinaryReader();
            } else {
                boolean bl = HeaderFieldParser$GDBType$.MODULE$.UUID() == by ? true : HeaderFieldParser$GDBType$.MODULE$.GUID() == by;
                if (bl) {
                    fieldReader = new UUIDReader();
                } else if (HeaderFieldParser$GDBType$.MODULE$.XML() == by) {
                    fieldReader = new StringReader();
                } else {
                    String x$1 = new StringBuilder(15).append("\u4e0d\u652f\u6301\u5f53\u524d\u7c7b\u578b\u7684\u6570\u636e\u683c\u5f0f\u89e3\u6790:").append($this.fieldTypes.apply(i)).toString();
                    Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                    int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                    throw new NotSupportException(x$1, x$2, x$3);
                }
            }
            tmpReaders$1[i] = fieldReader;
        });
        return var1_1;
    }

    public Object getValue(ByteBuffer byteBuffer, int fieldIndex, int oid) {
        return this.fieldReaders()[fieldIndex].readValue(byteBuffer, oid);
    }

    public RowReader(Seq<AttributeDescriptor> attributeDescriptors, Seq<Object> fieldTypes) {
        this.attributeDescriptors = attributeDescriptors;
        this.fieldTypes = fieldTypes;
        this.fieldReaders = this.init();
    }
}

