/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.gdal.common;

import com.geoway.atlas.common.error.NotMatchException;
import com.geoway.atlas.common.error.NotMatchException$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.data.vector.common.feature.sf.Transform;
import com.geoway.atlas.data.vector.common.wkb.WkbUtils$;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.ogr;
import org.opengis.feature.simple.SimpleFeature;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GDAL_Feature_Helper$ {
    public static GDAL_Feature_Helper$ MODULE$;

    static {
        new GDAL_Feature_Helper$();
    }

    public boolean createGFeature(Feature poDstFeature, SimpleFeature sf, int[] panMap, Class<?>[] classes, Transform transform, int geomIndex, boolean bForceToPolygon, boolean bForceToMultiPolygon, boolean bForceToMultiLineString) {
        boolean bl;
        try {
            Object[] attributes = transform.eval((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(sf.getAttributes()).asScala());
            for (int index$macro$1 = 0; index$macro$1 < panMap.length; ++index$macro$1) {
                int panValue = panMap[index$macro$1];
                if (panValue == -1) continue;
                this.setValue(poDstFeature, panValue, attributes[index$macro$1], classes[index$macro$1]);
            }
            Geometry geometry = ogr.CreateGeometryFromWkb((byte[])WkbUtils$.MODULE$.write((org.locationtech.jts.geom.Geometry)attributes[geomIndex], false));
            poDstFeature.SetGeometryDirectly(this.forceTo(geometry, bForceToPolygon, bForceToMultiPolygon, bForceToMultiLineString));
            bl = true;
        }
        catch (Throwable t) {
            String x$1 = new StringBuilder(8).append("\u8bbe\u7f6e\u5b57\u6bb5\u503c\u9519\u8bef:").append(ExceptionUtils.getRootCauseMessage((Throwable)t)).toString();
            Thread x$2 = NotMatchException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotMatchException$.MODULE$.apply$default$3(x$1);
            throw new NotMatchException(x$1, x$2, x$3);
        }
        return bl;
    }

    public Geometry forceTo(Geometry poDstGeometry, boolean bForceToPolygon, boolean bForceToMultiPolygon, boolean bForceToMultiLineString) {
        Object object = bForceToPolygon ? ogr.ForceToPolygon((Geometry)poDstGeometry) : (bForceToMultiPolygon ? ogr.ForceToMultiPolygon((Geometry)poDstGeometry) : (bForceToMultiLineString ? ogr.ForceToMultiLineString((Geometry)poDstGeometry) : BoxedUnit.UNIT));
        return poDstGeometry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Feature poDstFeature, int fadIndex, Object value, Class<?> clz) {
        String typeName = clz.getTypeName();
        if (typeName.equals(Integer.TYPE.getTypeName()) || typeName.equals(Integer.class.getTypeName())) {
            poDstFeature.SetField(fadIndex, BoxesRunTime.unboxToInt((Object)value));
            return;
        } else if (typeName.equals(Short.TYPE.getTypeName()) || typeName.equals(Short.class.getTypeName())) {
            poDstFeature.SetField(fadIndex, (int)BoxesRunTime.unboxToShort((Object)value));
            return;
        } else if (typeName.equals(int[].class.getTypeName()) || typeName.equals(Integer[].class.getTypeName())) {
            poDstFeature.SetFieldIntegerList(fadIndex, (int[])value);
            return;
        } else if (typeName.equals(scala.math.BigDecimal.class.getTypeName()) || typeName.equals(BigDecimal.class.getTypeName())) {
            Class<?> clazz = clz;
            if (value instanceof scala.math.BigDecimal) {
                ((scala.math.BigDecimal)value).toDouble();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!(value instanceof BigDecimal)) throw new MatchError(clazz);
                ((BigDecimal)value).doubleValue();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else if (typeName.equals(Double.TYPE.getTypeName()) || typeName.equals(Double.class.getTypeName()) || typeName.equals(Float.TYPE.getTypeName()) || typeName.equals(Float.class.getTypeName())) {
            poDstFeature.SetField(fadIndex, BoxesRunTime.unboxToDouble((Object)value));
            return;
        } else if (typeName.equals(double[].class.getTypeName()) || typeName.equals(Double[].class.getTypeName()) || typeName.equals(float[].class.getTypeName()) || typeName.equals(Float[].class.getTypeName())) {
            poDstFeature.SetFieldDoubleList(fadIndex, (double[])value);
            return;
        } else if (typeName.equals(String.class.getTypeName()) || typeName.equals(String.class.getTypeName())) {
            poDstFeature.SetField(fadIndex, (String)value);
            return;
        } else if (typeName.equals(String[].class.getTypeName()) || typeName.equals(String[].class.getTypeName())) {
            poDstFeature.SetFieldStringList(fadIndex, new Vector((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])value))).toBuffer()).asJava()));
            return;
        } else if (typeName.equals(byte[].class.getTypeName()) || typeName.equals(Byte[].class.getTypeName())) {
            poDstFeature.SetFieldBinaryFromHexString(fadIndex, Hex.encodeHexString((byte[])((byte[])value)));
            return;
        } else if (typeName.equals(Date.class.getTypeName())) {
            Date date = (Date)value;
            Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
            calendar.setTime(date);
            poDstFeature.SetField(fadIndex, calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), (float)calendar.get(13), 1);
            return;
        } else if (typeName.equals(Long.TYPE.getTypeName()) || typeName.equals(Long.class.getTypeName())) {
            poDstFeature.SetFieldInteger64(fadIndex, BoxesRunTime.unboxToLong((Object)value));
            return;
        } else {
            String x$1 = new StringBuilder(10).append("\u4e0d\u652f\u6301\u5f53\u524d\u5b57\u6bb5\u7c7b\u578b:").append(typeName).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
    }

    public int toFieldType(Class<?> clz) {
        int n;
        String typeName = clz.getTypeName();
        if (typeName.equals(Integer.TYPE.getTypeName()) || typeName.equals(Integer.class.getTypeName()) || typeName.equals(Short.TYPE.getTypeName()) || typeName.equals(Short.class.getTypeName())) {
            n = 0;
        } else if (typeName.equals(int[].class.getTypeName()) || typeName.equals(Integer[].class.getTypeName())) {
            n = 1;
        } else if (typeName.equals(Double.TYPE.getTypeName()) || typeName.equals(scala.math.BigDecimal.class.getTypeName()) || typeName.equals(BigDecimal.class.getTypeName()) || typeName.equals(Double.class.getTypeName()) || typeName.equals(Float.TYPE.getTypeName()) || typeName.equals(Float.class.getTypeName())) {
            n = 2;
        } else if (typeName.equals(double[].class.getTypeName()) || typeName.equals(Double[].class.getTypeName()) || typeName.equals(float[].class.getTypeName()) || typeName.equals(Float[].class.getTypeName())) {
            n = 3;
        } else if (typeName.equals(String.class.getTypeName()) || typeName.equals(String.class.getTypeName())) {
            n = 4;
        } else if (typeName.equals(String[].class.getTypeName()) || typeName.equals(String[].class.getTypeName())) {
            n = 5;
        } else if (typeName.equals(byte[].class.getTypeName()) || typeName.equals(Byte[].class.getTypeName())) {
            n = 8;
        } else if (typeName.equals(Date.class.getTypeName())) {
            n = 11;
        } else if (typeName.equals(Long.TYPE.getTypeName()) || typeName.equals(Long.class.getTypeName())) {
            n = 12;
        } else {
            String x$1 = new StringBuilder(10).append("\u4e0d\u652f\u6301\u5f53\u524d\u5b57\u6bb5\u7c7b\u578b:").append(typeName).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return n;
    }

    private GDAL_Feature_Helper$() {
        MODULE$ = this;
    }
}

