/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.gdal.common;

import com.geoway.atlas.common.error.ExistException;
import com.geoway.atlas.common.error.ExistException$;
import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.common.error.IoException$;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.error.NullException;
import com.geoway.atlas.common.error.NullException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.vector.common.feature.sf.Transform;
import com.geoway.atlas.data.vector.common.feature.sft.SimpleFeatureTypeUtils$;
import com.geoway.atlas.data.vector.common.feature.sft.package$;
import com.geoway.atlas.data.vector.gdal.common.GDAL_Feature_Helper$;
import com.geoway.atlas.data.vector.gdal.common.bean.WriteParams;
import com.geoway.atlas.data.vector.gdal.common.bean.WriteParams$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorResultMetadata;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorResultMetadata$;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.gdal.gdal.gdal;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Layer;
import org.gdal.osr.SpatialReference;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.slf4j.Logger;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GDAL_Layer_Helper$
implements LazyLogging {
    public static GDAL_Layer_Helper$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GDAL_Layer_Helper$();
    }

    private Logger logger$lzycompute() {
        GDAL_Layer_Helper$ gDAL_Layer_Helper$ = this;
        synchronized (gDAL_Layer_Helper$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void testCreateLayer(DataSource ds) {
        if (!ds.TestCapability("CreateLayer")) {
            String x$1 = "GDAL\u65e0\u6cd5\u521b\u5efa\u56fe\u5c42!";
            Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
            int x$3 = IoException$.MODULE$.apply$default$3(x$1);
            throw new IoException(x$1, x$2, x$3);
        }
    }

    public Layer getLayer(DataSource ds, String layerName) {
        return ds.GetLayerByName(layerName);
    }

    public Layer getLayerByIndex(DataSource ds, int layerIndex) {
        return ds.GetLayerByIndex(layerIndex);
    }

    /*
     * WARNING - void declaration
     */
    public int getLayerIndex(DataSource ds, Layer layer) {
        void var3_3;
        int iLayer = -1;
        if (layer != null) {
            int nLayerCount = ds.GetLayerCount();
            boolean flag = true;
            for (int index$macro$1 = 0; index$macro$1 < nLayerCount && flag; ++index$macro$1) {
                Layer poLayer = ds.GetLayer(index$macro$1);
                if (poLayer == null || !poLayer.GetName().equals(layer.GetName())) continue;
                iLayer = index$macro$1;
                flag = false;
            }
        }
        return (int)var3_3;
    }

    public void deleteLayerIfExist(DataSource ds, String layerName, boolean isForce) {
        Layer layer = ds.GetLayerByName(layerName);
        int layerIndex = this.getLayerIndex(ds, layer);
        if (layerIndex != -1) {
            if (isForce) {
                int code = -1;
                try {
                    gdal.ErrorReset();
                    code = ds.DeleteLayer(layerIndex);
                }
                catch (Throwable throwable) {
                    String x$1 = new StringBuilder(15).append("\u5220\u9664\u56fe\u5c42 ").append(layerName).append(" \u5931\u8d25, \u9519\u8bef\u4fe1\u606f:").append(ExceptionUtils.getRootCauseMessage((Throwable)throwable)).toString();
                    Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
                    int x$3 = IoException$.MODULE$.apply$default$3(x$1);
                    throw new IoException(x$1, x$2, x$3);
                }
                if (code != 0) {
                    String x$4 = new StringBuilder(9).append("\u5220\u9664\u56fe\u5c42 ").append(layerName).append(" \u5931\u8d25!").toString();
                    Thread x$5 = IoException$.MODULE$.apply$default$2(x$4);
                    int x$6 = IoException$.MODULE$.apply$default$3(x$4);
                    throw new IoException(x$4, x$5, x$6);
                }
            } else {
                String x$7 = new StringBuilder(8).append("\u56fe\u5c42 ").append(layerName).append(" \u5df2\u5b58\u5728!").toString();
                Thread x$8 = IoException$.MODULE$.apply$default$2(x$7);
                int x$9 = IoException$.MODULE$.apply$default$3(x$7);
                throw new IoException(x$7, x$8, x$9);
            }
        }
    }

    public boolean deleteLayerIfExist$default$3() {
        return true;
    }

    public Tuple2<Layer, int[]> createLayer(AtlasVectorSchema schema, DataSource poDstDS, String pszNewLayerName, boolean overwrite, boolean append, Class<?> geometryClz, Vector<String> papszLCO, Vector<String> papszSelFields, Vector<String> papszFieldTypesToString) {
        int eGType = this.getEGType(geometryClz);
        Tuple2<Layer, Object> layerTuple = this.preparedLayer(schema, poDstDS, eGType, pszNewLayerName, overwrite, append, papszLCO);
        Layer poDstLayer = (Layer)layerTuple._1();
        boolean bAppend = layerTuple._2$mcZ$sp();
        int[] panMap = this.addFields(schema, poDstLayer, bAppend, papszSelFields, papszFieldTypesToString);
        return new Tuple2((Object)poDstLayer, (Object)panMap);
    }

    public boolean createLayer$default$4() {
        return true;
    }

    public boolean createLayer$default$5() {
        return false;
    }

    public Class<?> createLayer$default$6() {
        return MultiPolygon.class;
    }

    public Vector<String> createLayer$default$7() {
        return new Vector<String>();
    }

    public Vector<String> createLayer$default$8() {
        return new Vector<String>();
    }

    public Vector<String> createLayer$default$9() {
        return new Vector<String>();
    }

    public AtlasVectorResultMetadata saveLayer(Layer poDstLayer, AtlasVectorSchema createVectorSchema, AtlasVectorSchema saveVectorSchema, int[] panMap, Iterator<SimpleFeature> iterator, int commitLimit, Class<?> geometryClz) {
        WriteParams writeParams = WriteParams$.MODULE$.apply(geometryClz, createVectorSchema, saveVectorSchema);
        return this.write(poDstLayer, iterator, commitLimit, panMap, writeParams);
    }

    public int saveLayer$default$6() {
        return 200;
    }

    public Class<?> saveLayer$default$7() {
        return MultiPolygon.class;
    }

    public void startTransaction(Layer layer) {
        layer.StartTransaction();
    }

    public void commitTransaction(Layer layer) {
        layer.CommitTransaction();
    }

    public void rollbackTransaction(Layer layer) {
        layer.RollbackTransaction();
    }

    private AtlasVectorResultMetadata write(Layer poDstLayer, Iterator<SimpleFeature> iterator, int commitLimit, int[] panMap, WriteParams writeParams) {
        int count;
        Object poFeature = null;
        int indexInCommit = 0;
        WriteParams writeParams2 = writeParams;
        if (writeParams2 != null) {
            Transform transform = writeParams2.transform();
            int geomIndex = writeParams2.geomIndex();
            Class<?>[] classes = writeParams2.clz();
            boolean bForceToPolygon = writeParams2.bForceToPolygon();
            boolean bForceToMultiPolygon = writeParams2.bForceToMultiPolygon();
            boolean bForceToMultiLineString = writeParams2.bForceToMultiLineString();
            Object object = commitLimit > 0 ? BoxesRunTime.boxToInteger((int)poDstLayer.StartTransaction()) : BoxedUnit.UNIT;
            count = 0;
            while (iterator.hasNext()) {
                ++count;
                SimpleFeature sf = (SimpleFeature)iterator.next();
                if (commitLimit > 0 && indexInCommit == commitLimit) {
                    poDstLayer.CommitTransaction();
                    poDstLayer.StartTransaction();
                    indexInCommit = 0;
                }
                gdal.ErrorReset();
                Feature poFeature2 = new Feature(poDstLayer.GetLayerDefn());
                if (!GDAL_Feature_Helper$.MODULE$.createGFeature(poFeature2, sf, panMap, classes, transform, geomIndex, bForceToPolygon, bForceToMultiPolygon, bForceToMultiLineString)) {
                    Object object2 = commitLimit > 0 ? BoxesRunTime.boxToInteger((int)poDstLayer.CommitTransaction()) : BoxedUnit.UNIT;
                    String errorString = new StringBuilder(11).append("\u65e0\u6cd5\u5199\u5165\u8981\u7d20").append(sf.getID()).append("\u5230\u8f93\u51fa\u56fe\u5c42").append(poDstLayer.GetName()).toString();
                    if (poFeature2 != null) {
                        poFeature2.delete();
                        poFeature2 = null;
                    }
                    String x$1 = errorString;
                    Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
                    int x$3 = IoException$.MODULE$.apply$default$3(x$1);
                    throw new IoException(x$1, x$2, x$3);
                }
                gdal.ErrorReset();
                if (poDstLayer.CreateFeature(poFeature2) != 0) {
                    Object object3 = commitLimit > 0 ? BoxesRunTime.boxToInteger((int)poDstLayer.RollbackTransaction()) : BoxedUnit.UNIT;
                    String errorString = new StringBuilder(7).append("\u65e0\u6cd5\u5199\u5165\u8981\u7d20:").append(poFeature2.GetFID()).toString();
                    poFeature2.delete();
                    poFeature2 = null;
                    String x$4 = errorString;
                    Thread x$5 = IoException$.MODULE$.apply$default$2(x$4);
                    int x$6 = IoException$.MODULE$.apply$default$3(x$4);
                    throw new IoException(x$4, x$5, x$6);
                }
                poFeature2.delete();
                poFeature2 = null;
                ++indexInCommit;
            }
            if (poFeature != null) {
                poFeature.delete();
                poFeature = null;
            }
        } else {
            throw new MatchError((Object)writeParams2);
        }
        Object object = commitLimit > 0 ? BoxesRunTime.boxToInteger((int)poDstLayer.CommitTransaction()) : BoxedUnit.UNIT;
        AtlasVectorResultMetadata atlasVectorResultMetadata = AtlasVectorResultMetadata$.MODULE$.apply(true, new Envelope(), (long)count, -1, (byte)0);
        return atlasVectorResultMetadata;
    }

    private Tuple2<Layer, Object> preparedLayer(AtlasVectorSchema atlasVectorSchema, DataSource poDstDS, int eGType, String pszNewLayerName, boolean overWrite, boolean append, Vector<String> papszLCO) {
        boolean bAppend = append;
        SpatialReference poOutputSRS = new SpatialReference(com.geoway.atlas.data.vector.common.crs.package$.MODULE$.RichCRS(package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).getCRS()).toLineWKT());
        gdal.PushErrorHandler((String)"CPLQuietErrorHandler");
        Layer poDstLayer = poDstDS.GetLayerByName(pszNewLayerName);
        gdal.PopErrorHandler();
        gdal.ErrorReset();
        int iLayer = -1;
        if (poDstLayer != null) {
            int nLayerCount = poDstDS.GetLayerCount();
            boolean flag = true;
            for (int i = 0; i < nLayerCount && flag; ++i) {
                Layer poLayer = poDstDS.GetLayer(i);
                if (poLayer == null || !poLayer.GetName().equals(poDstLayer.GetName())) continue;
                flag = false;
                iLayer = i;
            }
            if (iLayer == -1) {
                poDstLayer = null;
            } else {
                this.logger().info(new StringBuilder(6).append("\u56fe\u5c42\u5df2\u5b58\u5728:").append(pszNewLayerName).toString());
            }
        }
        if (poDstLayer != null && overWrite) {
            if (poDstDS.DeleteLayer(iLayer) != 0) {
                String x$1 = "GDAL\u5220\u9664\u56fe\u5c42\u65b9\u6cd5\u6267\u884c\u5931\u8d25!";
                Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
                int x$3 = IoException$.MODULE$.apply$default$3(x$1);
                throw new IoException(x$1, x$2, x$3);
            }
            poDstLayer = null;
        }
        if (poDstLayer == null) {
            if (!poDstDS.TestCapability("CreateLayer")) {
                String x$4 = new StringBuilder(27).append("GDAL\u6ca1\u6709\u53d1\u73b0\u56fe\u5c42").append(pszNewLayerName).append("\uff0c\u5e76\u4e14\u521b\u5efa\u56fe\u5c42\u65b9\u6cd5\u4e0d\u652f\u6301\u5f53\u524d\u7684\u9a71\u52a8").toString();
                Thread x$5 = IoException$.MODULE$.apply$default$2(x$4);
                int x$6 = IoException$.MODULE$.apply$default$3(x$4);
                throw new IoException(x$4, x$5, x$6);
            }
            gdal.ErrorReset();
            this.logger().info(new StringBuilder(5).append("\u521b\u5efa\u56fe\u5c42:").append(pszNewLayerName).toString());
            poDstLayer = poDstDS.CreateLayer(pszNewLayerName, poOutputSRS, eGType, papszLCO);
            if (poDstLayer == null) {
                String x$7 = new StringBuilder(7).append("\u65e0\u6cd5\u521b\u5efa\u56fe\u5c42:").append(pszNewLayerName).toString();
                Thread x$8 = IoException$.MODULE$.apply$default$2(x$7);
                int x$9 = IoException$.MODULE$.apply$default$3(x$7);
                throw new IoException(x$7, x$8, x$9);
            }
            if (bAppend) {
                this.logger().warn("\u56fe\u5c42\u4e0d\u5b58\u5728\uff0c\u81ea\u52a8\u8f6c\u6362\u4e3a\u8986\u5199\u6a21\u5f0f!");
                bAppend = false;
            }
        } else {
            if (!bAppend) {
                String x$10 = new StringBuilder(18).append("\u56fe\u5c42 ").append(pszNewLayerName).append(" \u5df2\u5b58\u5728\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u8ffd\u52a0\u5199\u5165\u6a21\u5f0f").toString();
                Thread x$11 = ExistException$.MODULE$.apply$default$2(x$10);
                int x$12 = ExistException$.MODULE$.apply$default$3(x$10);
                throw new ExistException(x$10, x$11, x$12);
            }
            if (papszLCO.size() > 0) {
                this.logger().warn("\u56fe\u5c42\u5df2\u5b58\u5728\uff0c\u521b\u5efa\u53c2\u6570\u5c06\u88ab\u5ffd\u7565");
            }
        }
        return new Tuple2((Object)poDstLayer, (Object)BoxesRunTime.boxToBoolean((boolean)bAppend));
    }

    private int[] addFields(AtlasVectorSchema atlasVectorSchema, Layer poDstLayer, boolean bAppend, Vector<String> papszSelFields, Vector<String> papszFieldTypesToString) {
        int iField = -1;
        int nSrcFieldCount = atlasVectorSchema.getAttributeCount();
        int[] panMap = new int[nSrcFieldCount];
        for (iField = 0; iField < nSrcFieldCount; ++iField) {
            panMap[iField] = -1;
        }
        FeatureDefn poDstFDefn = poDstLayer.GetLayerDefn();
        if (papszSelFields != null && !papszSelFields.isEmpty() && !bAppend) {
            int nDstFieldCount = 0;
            if (poDstFDefn != null) {
                nDstFieldCount = poDstFDefn.GetFieldCount();
            }
            for (iField = 0; iField < papszSelFields.size(); ++iField) {
                int iSrcField = atlasVectorSchema.indexOf(papszSelFields.get(iField));
                if (iSrcField >= 0) {
                    AttributeDescriptor attributeDescriptor = atlasVectorSchema.getDescriptor(iSrcField);
                    FieldDefn oFieldDefn = new FieldDefn(attributeDescriptor.getLocalName(), GDAL_Feature_Helper$.MODULE$.toFieldType(attributeDescriptor.getType().getBinding()));
                    Tuple2 lengthTuple = SimpleFeatureTypeUtils$.MODULE$.getStandardFieldLength(attributeDescriptor);
                    if (lengthTuple == null) {
                        String x$1 = new StringBuilder(17).append("\u4e0d\u652f\u6301\u83b7\u53d6\u5f53\u524d\u6570\u636e\u7c7b\u578b\u7684\u5b57\u6bb5\u957f\u5ea6:").append(attributeDescriptor.getType().getBinding().getSimpleName()).toString();
                        Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                        int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                        throw new NotSupportException(x$1, x$2, x$3);
                    }
                    if (lengthTuple._1$mcI$sp() > 0) {
                        oFieldDefn.SetWidth(lengthTuple._1$mcI$sp());
                    }
                    if (lengthTuple._2$mcI$sp() >= 0) {
                        oFieldDefn.SetPrecision(lengthTuple._2$mcI$sp());
                    }
                    if (papszFieldTypesToString != null && this.CSLFindString(papszFieldTypesToString, "All") != -1) {
                        oFieldDefn.SetType(4);
                    }
                    int iDstField = -1;
                    if (poDstFDefn != null) {
                        iDstField = poDstFDefn.GetFieldIndex(oFieldDefn.GetNameRef());
                    }
                    if (iDstField >= 0) {
                        panMap[iSrcField] = iDstField;
                        continue;
                    }
                    if (poDstLayer.CreateField(oFieldDefn) != 0) continue;
                    if (poDstFDefn == null) {
                        poDstFDefn = poDstLayer.GetLayerDefn();
                    }
                    if (poDstFDefn != null && poDstFDefn.GetFieldCount() != nDstFieldCount + 1) {
                        String x$4 = new StringBuilder(22).append("\u5df2\u901a\u77e5\u8f93\u51fa\u9a71\u52a8\u6dfb\u52a0\u5b57\u6bb5:").append(oFieldDefn.GetNameRef()).append(",\u4f46\u662f\u5b9e\u9645\u4e0a\u6ca1\u6709\u6dfb\u52a0").toString();
                        Thread x$5 = IoException$.MODULE$.apply$default$2(x$4);
                        int x$6 = IoException$.MODULE$.apply$default$3(x$4);
                        throw new IoException(x$4, x$5, x$6);
                    }
                    panMap[iSrcField] = nDstFieldCount++;
                    continue;
                }
                String x$7 = new StringBuilder(19).append("\u6307\u5b9a\u8f93\u51fa\u5b57\u6bb5 ").append((Object)papszSelFields.get(iField)).append(" \u672a\u80fd\u5728\u8f93\u51fa\u56fe\u5c42\u4e2d\u627e\u5230!").toString();
                Thread x$8 = NotFoundException$.MODULE$.apply$default$2(x$7);
                int x$9 = NotFoundException$.MODULE$.apply$default$3(x$7);
                throw new NotFoundException(x$7, x$8, x$9);
            }
        } else if (!bAppend) {
            int nDstFieldCount = 0;
            if (poDstFDefn != null) {
                nDstFieldCount = poDstFDefn.GetFieldCount();
            }
            int geoIndex = atlasVectorSchema.indexOf(package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).getGeomField());
            for (iField = 0; iField < atlasVectorSchema.getAttributeCount(); ++iField) {
                if (iField == geoIndex) continue;
                AttributeDescriptor attributeDescriptor = atlasVectorSchema.getDescriptor(iField);
                FieldDefn oFieldDefn = new FieldDefn(attributeDescriptor.getLocalName(), GDAL_Feature_Helper$.MODULE$.toFieldType(attributeDescriptor.getType().getBinding()));
                Tuple2 lengthTuple = SimpleFeatureTypeUtils$.MODULE$.getStandardFieldLength(attributeDescriptor);
                if (lengthTuple == null) {
                    String x$10 = new StringBuilder(17).append("\u4e0d\u652f\u6301\u83b7\u53d6\u5f53\u524d\u6570\u636e\u7c7b\u578b\u7684\u5b57\u6bb5\u957f\u5ea6:").append(attributeDescriptor.getType().getBinding().getSimpleName()).toString();
                    Thread x$11 = NotSupportException$.MODULE$.apply$default$2(x$10);
                    int x$12 = NotSupportException$.MODULE$.apply$default$3(x$10);
                    throw new NotSupportException(x$10, x$11, x$12);
                }
                if (lengthTuple._1$mcI$sp() > 0) {
                    oFieldDefn.SetWidth(lengthTuple._1$mcI$sp());
                }
                if (lengthTuple._2$mcI$sp() >= 0) {
                    oFieldDefn.SetPrecision(lengthTuple._2$mcI$sp());
                }
                if (papszFieldTypesToString != null && this.CSLFindString(papszFieldTypesToString, "All") != -1) {
                    oFieldDefn.SetType(4);
                }
                int iDstField = -1;
                if (poDstFDefn != null) {
                    iDstField = poDstFDefn.GetFieldIndex(oFieldDefn.GetNameRef());
                }
                if (iDstField >= 0) {
                    panMap[iField] = iDstField;
                    continue;
                }
                if (poDstLayer.CreateField(oFieldDefn) != 0) continue;
                if (poDstFDefn == null) {
                    poDstFDefn = poDstLayer.GetLayerDefn();
                }
                if (poDstFDefn != null && poDstFDefn.GetFieldCount() != nDstFieldCount + 1) {
                    String x$13 = new StringBuilder(22).append("\u5df2\u901a\u77e5\u8f93\u51fa\u9a71\u52a8\u6dfb\u52a0\u5b57\u6bb5:").append(oFieldDefn.GetNameRef()).append(",\u4f46\u662f\u5b9e\u9645\u4e0a\u6ca1\u6709\u6dfb\u52a0").toString();
                    Thread x$14 = IoException$.MODULE$.apply$default$2(x$13);
                    int x$15 = IoException$.MODULE$.apply$default$3(x$13);
                    throw new IoException(x$13, x$14, x$15);
                }
                panMap[iField] = nDstFieldCount++;
            }
        } else {
            if (poDstFDefn == null) {
                String x$16 = "\u65e0\u6cd5\u83b7\u53d6\u5230\u8f93\u51fa\u56fe\u5c42\u7684\u5b57\u6bb5\u4fe1\u606f!";
                Thread x$17 = NullException$.MODULE$.apply$default$2(x$16);
                int x$18 = NullException$.MODULE$.apply$default$3(x$16);
                throw new NullException(x$16, x$17, x$18);
            }
            for (iField = 0; iField < nSrcFieldCount; ++iField) {
                AttributeDescriptor ad = atlasVectorSchema.getDescriptor(iField);
                int iDstField = poDstFDefn.GetFieldIndex(ad.getLocalName());
                if (iDstField < 0) continue;
                panMap[iField] = iDstField;
            }
        }
        return panMap;
    }

    private int CSLFindString(Vector<String> v, String str) {
        int i = 0;
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            String strIter = e.nextElement();
            if (strIter.equalsIgnoreCase(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int wkbFlatten(int eType) {
        return eType & ~Integer.MIN_VALUE;
    }

    public int getEGType(Class<?> geometryClz) {
        int n;
        if (Point.class.getSimpleName().equals(geometryClz.getSimpleName())) {
            n = 1;
        } else if (MultiPoint.class.getSimpleName().equals(geometryClz.getSimpleName())) {
            n = 4;
        } else if (LineString.class.getSimpleName().equals(geometryClz.getSimpleName())) {
            n = 2;
        } else if (MultiLineString.class.getSimpleName().equals(geometryClz.getSimpleName())) {
            n = 5;
        } else if (Polygon.class.getSimpleName().equals(geometryClz.getSimpleName())) {
            n = 3;
        } else if (MultiPolygon.class.getSimpleName().equals(geometryClz.getSimpleName())) {
            n = 6;
        } else {
            String x$1 = new StringBuilder(10).append("\u4e0d\u652f\u6301\u5f53\u524d\u56fe\u6591\u7c7b\u578b:").append(geometryClz.getSimpleName()).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return n;
    }

    private GDAL_Layer_Helper$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

