/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.common.geom.visitor;

import com.geoway.atlas.data.vector.common.geom.GeometryVisitor;
import com.geoway.atlas.data.vector.common.geom.visitor.PolygonAddVisitor$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000154Aa\u0004\t\u0001C!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dQ\u0005A1A\u0005\n-CaA\u0015\u0001!\u0002\u0013a\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u00071\u0002\u0001\u000b\u0011B+\t\u000fe\u0003!\u0019!C\u00055\"1a\f\u0001Q\u0001\nmCQ!\u0005\u0001\u0005B};Q!\u001a\t\t\u0002\u00194Qa\u0004\t\t\u0002\u001dDQ\u0001\u0012\u0007\u0005\u0002!DQ!\u001b\u0007\u0005\u0002)\u0014\u0011\u0003U8ms\u001e|g.\u00113e-&\u001c\u0018\u000e^8s\u0015\t\t\"#A\u0004wSNLGo\u001c:\u000b\u0005M!\u0012\u0001B4f_6T!!\u0006\f\u0002\r\r|W.\\8o\u0015\t9\u0002$\u0001\u0004wK\u000e$xN\u001d\u0006\u00033i\tA\u0001Z1uC*\u00111\u0004H\u0001\u0006CRd\u0017m\u001d\u0006\u0003;y\taaZ3po\u0006L(\"A\u0010\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S)j\u0011AE\u0005\u0003WI\u0011qbR3p[\u0016$(/\u001f,jg&$xN]\u0001\ta>d\u0017pZ8ogB\u0019afM\u001b\u000e\u0003=R!\u0001M\u0019\u0002\u000f5,H/\u00192mK*\u0011!\u0007J\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001b0\u0005\u0019\u0011UO\u001a4feB\u0011aGP\u0007\u0002o)\u00111\u0003\u000f\u0006\u0003si\n1A\u001b;t\u0015\tYD(\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001>\u0003\ry'oZ\u0005\u0003\u007f]\u0012\u0001bR3p[\u0016$(/_\u0001\u0003a6\u0004\"A\u000e\"\n\u0005\r;$A\u0004)sK\u000eL7/[8o\u001b>$W\r\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019C\u0015\n\u0005\u0002H\u00015\t\u0001\u0003C\u0003-\u0007\u0001\u0007Q\u0006C\u0003A\u0007\u0001\u0007\u0011)\u0001\u0004m_\u001e<WM]\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nP\u0001\u0006g24GG[\u0005\u0003#:\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0003O\u001a,\u0012!\u0016\t\u0003mYK!aV\u001c\u0003\u001f\u001d+w.\\3uef4\u0015m\u0019;pef\f1a\u001a4!\u0003\u0015a\u0017.\\5u+\u0005Y\u0006CA\u0012]\u0013\tiFE\u0001\u0004E_V\u0014G.Z\u0001\u0007Y&l\u0017\u000e\u001e\u0011\u0015\u0005\u0001\u001c\u0007CA\u0012b\u0013\t\u0011GE\u0001\u0003V]&$\b\"\u00023\u000b\u0001\u0004)\u0014\u0001C4f_6,GO]=\u0002#A{G._4p]\u0006#GMV5tSR|'\u000f\u0005\u0002H\u0019M\u0011AB\t\u000b\u0002M\u0006)\u0011\r\u001d9msR\u0019ai\u001b7\t\u000b1r\u0001\u0019A\u0017\t\u000b\u0001s\u0001\u0019A!")
public class PolygonAddVisitor
implements GeometryVisitor {
    private final Buffer<Geometry> polygons;
    private final Logger logger;
    private final GeometryFactory gf;
    private final double limit;

    public static PolygonAddVisitor apply(Buffer<Geometry> buffer, PrecisionModel precisionModel) {
        return PolygonAddVisitor$.MODULE$.apply(buffer, precisionModel);
    }

    private Logger logger() {
        return this.logger;
    }

    private GeometryFactory gf() {
        return this.gf;
    }

    private double limit() {
        return this.limit;
    }

    @Override
    public void visitor(Geometry geometry) {
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Polygon) {
            BoxedUnit boxedUnit;
            Polygon polygon = (Polygon)geometry2;
            if (!polygon.isEmpty()) {
                if (polygon.getNumPoints() > 3) {
                    ArrayBuffer interiorRings = new ArrayBuffer();
                    boolean isRebuild = false;
                    if (polygon.getNumInteriorRing() > 0) {
                        int limit$macro$4 = polygon.getNumInteriorRing();
                        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                            LinearRing interiorRing = polygon.getInteriorRingN(index$macro$2);
                            int numPoints = interiorRing.getNumPoints();
                            if (numPoints <= 3) {
                                isRebuild = true;
                                continue;
                            }
                            if (numPoints <= 20) {
                                if (this.gf().createPolygon(interiorRing).getArea() <= this.limit()) {
                                    isRebuild = true;
                                    continue;
                                }
                                interiorRings.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{interiorRing}));
                                continue;
                            }
                            interiorRings.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{interiorRing}));
                        }
                    }
                    if (isRebuild) {
                        this.polygons.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{this.gf().createPolygon(polygon.getExteriorRing(), (LinearRing[])interiorRings.toArray(ClassTag$.MODULE$.apply(LinearRing.class)))}));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.polygons.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{polygon}));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.logger().warn("\u65e0\u6cd5\u6dfb\u52a0\u5f53\u524d\u56fe\u6591\u5230\u7ed3\u679c\u4e2d!");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public PolygonAddVisitor(Buffer<Geometry> polygons, PrecisionModel pm) {
        this.polygons = polygons;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.gf = new GeometryFactory();
        this.limit = !pm.isFloating() ? Math.pow(1.0 / pm.getScale(), 2.0) : 0.0;
    }
}

