/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts.ogc;

import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryEngine;
import com.geoway.atlas.jts.MultiPoint;
import com.geoway.atlas.jts.Operator;
import com.geoway.atlas.jts.OperatorExportToWkb;
import com.geoway.atlas.jts.OperatorFactoryLocal;
import com.geoway.atlas.jts.Point;
import com.geoway.atlas.jts.SpatialReference;
import com.geoway.atlas.jts.ogc.OGCGeometry;
import com.geoway.atlas.jts.ogc.OGCGeometryCollection;
import com.geoway.atlas.jts.ogc.OGCPoint;
import java.nio.ByteBuffer;

public class OGCMultiPoint
extends OGCGeometryCollection {
    public static String TYPE = "MultiPoint";
    private MultiPoint multiPoint;

    @Override
    public int numGeometries() {
        return this.multiPoint.getPointCount();
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 2);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(2, this.getEsriGeometry(), null);
    }

    @Override
    public OGCGeometry geometryN(int n) {
        return OGCMultiPoint.createFromEsriGeometry(this.multiPoint.getPoint(n), this.esriSR);
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + (this.multiPoint != null ? this.multiPoint.estimateMemorySize() : 0L);
    }

    public OGCMultiPoint(MultiPoint mp, SpatialReference sr) {
        this.multiPoint = mp;
        this.esriSR = sr;
    }

    public OGCMultiPoint(Point startPoint, SpatialReference sr) {
        this.multiPoint = new MultiPoint();
        this.multiPoint.add(startPoint);
        this.esriSR = sr;
    }

    public OGCMultiPoint(OGCPoint startPoint, OGCPoint endPoint) {
        this.multiPoint = new MultiPoint();
        this.multiPoint.add((Point)startPoint.getEsriGeometry());
        this.multiPoint.add((Point)endPoint.getEsriGeometry());
        this.esriSR = startPoint.esriSR;
    }

    public OGCMultiPoint(SpatialReference sr) {
        this.esriSR = sr;
        this.multiPoint = new MultiPoint();
    }

    @Override
    public OGCGeometry boundary() {
        return new OGCMultiPoint((MultiPoint)this.multiPoint.createInstance(), this.esriSR);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.multiPoint;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        int n = this.numGeometries();
        if (n == 0) {
            return new OGCPoint(new Point(this.multiPoint.getDescription()), this.esriSR);
        }
        if (n == 1) {
            return this.geometryN(0);
        }
        return this;
    }
}

