/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts.ogc;

import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryEngine;
import com.geoway.atlas.jts.MultiPath;
import com.geoway.atlas.jts.Operator;
import com.geoway.atlas.jts.OperatorExportToWkb;
import com.geoway.atlas.jts.OperatorFactoryLocal;
import com.geoway.atlas.jts.Polyline;
import com.geoway.atlas.jts.SpatialReference;
import com.geoway.atlas.jts.ogc.OGCCurve;
import com.geoway.atlas.jts.ogc.OGCGeometry;
import com.geoway.atlas.jts.ogc.OGCMultiLineString;
import com.geoway.atlas.jts.ogc.OGCPoint;
import java.nio.ByteBuffer;

public class OGCLineString
extends OGCCurve {
    public static String TYPE = "LineString";
    MultiPath multiPath = new Polyline();

    public int numPoints() {
        if (this.multiPath.isEmpty()) {
            return 0;
        }
        int d = this.multiPath.isClosedPath(0) ? 1 : 0;
        return this.multiPath.getPointCount() + d;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 4);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(4, this.getEsriGeometry(), null);
    }

    public OGCPoint pointN(int n) {
        int nn = this.multiPath.isClosedPath(0) && n == this.multiPath.getPathSize(0) ? this.multiPath.getPathStart(0) : n + this.multiPath.getPathStart(0);
        return (OGCPoint)OGCGeometry.createFromEsriGeometry(this.multiPath.getPoint(nn), this.esriSR);
    }

    @Override
    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.multiPath.isClosedPathInXYPlane(0);
    }

    public OGCLineString(MultiPath mp, int pathIndex, SpatialReference sr) {
        if (!mp.isEmpty()) {
            this.multiPath.addPath(mp, pathIndex, true);
        }
        this.esriSR = sr;
    }

    public OGCLineString(MultiPath mp, int pathIndex, SpatialReference sr, boolean reversed) {
        if (!mp.isEmpty()) {
            this.multiPath.addPath(mp, pathIndex, !reversed);
        }
        this.esriSR = sr;
    }

    @Override
    public double length() {
        return this.multiPath.calculateLength2D();
    }

    @Override
    public OGCPoint startPoint() {
        return this.pointN(0);
    }

    @Override
    public OGCPoint endPoint() {
        return this.pointN(this.numPoints() - 1);
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + (this.multiPath != null ? this.multiPath.estimateMemorySize() : 0L);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.multiPath;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return new OGCMultiLineString((Polyline)this.multiPath, this.esriSR);
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        return this;
    }
}

