/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts.ogc;

import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryEngine;
import com.geoway.atlas.jts.Operator;
import com.geoway.atlas.jts.OperatorBoundary;
import com.geoway.atlas.jts.OperatorExportToGeoJson;
import com.geoway.atlas.jts.OperatorExportToWkb;
import com.geoway.atlas.jts.OperatorFactoryLocal;
import com.geoway.atlas.jts.Polyline;
import com.geoway.atlas.jts.SpatialReference;
import com.geoway.atlas.jts.ogc.OGCGeometry;
import com.geoway.atlas.jts.ogc.OGCLineString;
import com.geoway.atlas.jts.ogc.OGCMultiCurve;
import java.nio.ByteBuffer;

public class OGCMultiLineString
extends OGCMultiCurve {
    public static String TYPE = "MultiLineString";
    Polyline polyline;

    public OGCMultiLineString(Polyline poly, SpatialReference sr) {
        this.polyline = poly;
        this.esriSR = sr;
    }

    public OGCMultiLineString(SpatialReference sr) {
        this.polyline = new Polyline();
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 8);
    }

    @Override
    public String asGeoJson() {
        OperatorExportToGeoJson op = (OperatorExportToGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToGeoJson);
        return op.execute(1, null, this.getEsriGeometry());
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(8, this.getEsriGeometry(), null);
    }

    @Override
    public OGCGeometry geometryN(int n) {
        OGCLineString ls = new OGCLineString(this.polyline, n, this.esriSR);
        return ls;
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + (this.polyline != null ? this.polyline.estimateMemorySize() : 0L);
    }

    @Override
    public OGCGeometry boundary() {
        OperatorBoundary op = (OperatorBoundary)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Boundary);
        Geometry g = op.execute(this.polyline, null);
        return OGCMultiLineString.createFromEsriGeometry(g, this.esriSR, true);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polyline;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        int n = this.numGeometries();
        if (n == 0) {
            return new OGCLineString(new Polyline(this.polyline.getDescription()), 0, this.esriSR);
        }
        if (n == 1) {
            return this.geometryN(0);
        }
        return this;
    }
}

