/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.algorithm.vector.overlay.geom;

import com.geoway.atlas.common.cache.AtlasThreadSafeCache;
import com.geoway.atlas.common.cache.AtlasThreadSafeCache$;
import com.geoway.atlas.common.cache.AtlasThreadSafeObj;
import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryCursor;
import com.geoway.atlas.jts.Line;
import com.geoway.atlas.jts.Operator;
import com.geoway.atlas.jts.OperatorDifference;
import com.geoway.atlas.jts.OperatorExportToWkb;
import com.geoway.atlas.jts.OperatorFactoryLocal;
import com.geoway.atlas.jts.OperatorImportFromWkb;
import com.geoway.atlas.jts.OperatorIntersection;
import com.geoway.atlas.jts.OperatorUnion;
import com.geoway.atlas.jts.Polyline;
import com.geoway.atlas.jts.SimpleGeometryCursor;
import com.geoway.atlas.jts.SpatialReference;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.PrecisionUtil;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ArcOverlayOp$ {
    public static ArcOverlayOp$ MODULE$;
    private final AtlasThreadSafeCache<Object, SpatialReference> SR_CACHE;
    private final OperatorFactoryLocal PROJ_Env;
    private final AtlasThreadSafeObj<WKBWriter> wkbWriterCache;
    private final AtlasThreadSafeObj<WKBReader> wkbReaderCache;
    private final GeometryFactory gf;

    static {
        new ArcOverlayOp$();
    }

    public AtlasThreadSafeCache<Object, SpatialReference> SR_CACHE() {
        return this.SR_CACHE;
    }

    public OperatorFactoryLocal PROJ_Env() {
        return this.PROJ_Env;
    }

    private AtlasThreadSafeObj<WKBWriter> wkbWriterCache() {
        return this.wkbWriterCache;
    }

    private AtlasThreadSafeObj<WKBReader> wkbReaderCache() {
        return this.wkbReaderCache;
    }

    public GeometryFactory gf() {
        return this.gf;
    }

    public com.geoway.atlas.jts.Polygon transformtoArc(org.locationtech.jts.geom.Geometry geometry) {
        OperatorImportFromWkb operatorImport = (OperatorImportFromWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ImportFromWkb);
        return (com.geoway.atlas.jts.Polygon)operatorImport.execute(0, Geometry.Type.Polygon, ByteBuffer.wrap(((WKBWriter)this.wkbWriterCache().getOrElseUpdate((Function0 & Serializable & scala.Serializable)() -> new WKBWriter())).write(geometry)), null);
    }

    public Polygonal transformFromArc(com.geoway.atlas.jts.Polygon arcPolygon) {
        OperatorExportToWkb operatorExport = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        ByteBuffer byteBuffer = operatorExport.execute(0, arcPolygon, null);
        byte[] wkb = byteBuffer.array();
        return (Polygonal)((Object)((WKBReader)this.wkbReaderCache().getOrElseUpdate((Function0 & Serializable & scala.Serializable)() -> new WKBReader())).read(wkb));
    }

    public Geometry overlay(Geometry p1, Geometry p2, int opCode, PrecisionModel pm) {
        SpatialReference spatialReference = pm.getScale() < Math.pow(10.0, 6.0) ? (SpatialReference)this.SR_CACHE().apply((Object)BoxesRunTime.boxToInteger((int)4496), (Function1 & Serializable & scala.Serializable)x$1 -> ArcOverlayOp$.$anonfun$overlay$1(BoxesRunTime.unboxToInt((Object)x$1))) : (SpatialReference)this.SR_CACHE().apply((Object)BoxesRunTime.boxToInteger((int)4490), (Function1 & Serializable & scala.Serializable)x$2 -> ArcOverlayOp$.$anonfun$overlay$2(BoxesRunTime.unboxToInt((Object)x$2)));
        SimpleGeometryCursor cursor1 = new SimpleGeometryCursor(p1);
        SimpleGeometryCursor cursor2 = new SimpleGeometryCursor(p2);
        Geometry result = this.overlayByArcOp(cursor1, cursor2, spatialReference, opCode);
        return result;
    }

    public org.locationtech.jts.geom.Geometry overlay(Polygonal p1, Polygonal p2, int opCode, PrecisionModel pm) {
        PrecisionModel nPm = pm.isFloating() ? this.getRobustPrecisionModel((Seq<org.locationtech.jts.geom.Geometry>)Predef$.MODULE$.wrapRefArray((Object[])new org.locationtech.jts.geom.Geometry[]{(org.locationtech.jts.geom.Geometry)((Object)p1), (org.locationtech.jts.geom.Geometry)((Object)p2)})) : pm;
        SpatialReference spatialReference = nPm.getScale() < Math.pow(10.0, 6.0) ? (SpatialReference)this.SR_CACHE().apply((Object)BoxesRunTime.boxToInteger((int)4496), (Function1 & Serializable & scala.Serializable)x$3 -> ArcOverlayOp$.$anonfun$overlay$3(BoxesRunTime.unboxToInt((Object)x$3))) : (SpatialReference)this.SR_CACHE().apply((Object)BoxesRunTime.boxToInteger((int)4490), (Function1 & Serializable & scala.Serializable)x$4 -> ArcOverlayOp$.$anonfun$overlay$4(BoxesRunTime.unboxToInt((Object)x$4)));
        com.geoway.atlas.jts.Polygon arcP1 = this.toArcGeometry(p1);
        com.geoway.atlas.jts.Polygon arcP2 = this.toArcGeometry(p2);
        SimpleGeometryCursor cursor1 = new SimpleGeometryCursor(arcP1);
        SimpleGeometryCursor cursor2 = new SimpleGeometryCursor(arcP2);
        Geometry result = this.overlayByArcOp(cursor1, cursor2, spatialReference, opCode);
        return this.toJTSGeometry(result);
    }

    public PrecisionModel getRobustPrecisionModel(Seq<org.locationtech.jts.geom.Geometry> geometries) {
        PrecisionModel precisionModel;
        if (geometries.length() == 1) {
            org.locationtech.jts.geom.Geometry geometry = (org.locationtech.jts.geom.Geometry)geometries.apply(0);
            precisionModel = PrecisionUtil.robustPM(geometry);
        } else {
            precisionModel = new PrecisionModel(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)geometries.map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToDouble((double)ArcOverlayOp$.$anonfun$getRobustPrecisionModel$1(a)), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Double$.MODULE$)));
        }
        return precisionModel;
    }

    /*
     * WARNING - void declaration
     */
    public org.locationtech.jts.geom.Geometry toJTSGeometry(Geometry arcGeometry) {
        void var3_2;
        org.locationtech.jts.geom.Geometry geometry;
        org.locationtech.jts.geom.Geometry jtsGeom = null;
        if (arcGeometry != null) {
            org.locationtech.jts.geom.Geometry geometry2;
            if (arcGeometry.isEmpty()) {
                return null;
            }
            Geometry.Type type = arcGeometry.getType();
            if (((Object)((Object)Geometry.Type.Polygon)).equals((Object)type)) {
                com.geoway.atlas.jts.Polygon arcPolygon = (com.geoway.atlas.jts.Polygon)arcGeometry;
                geometry2 = this.toPolygon(arcPolygon);
            } else if (((Object)((Object)Geometry.Type.Polyline)).equals((Object)type)) {
                geometry2 = this.toPolyline((Polyline)arcGeometry);
            } else if (((Object)((Object)Geometry.Type.Line)).equals((Object)type)) {
                geometry2 = this.toLine((Line)arcGeometry);
            } else if (((Object)((Object)Geometry.Type.Point)).equals((Object)type)) {
                geometry2 = this.toPoint((com.geoway.atlas.jts.Point)arcGeometry);
            } else if (((Object)((Object)Geometry.Type.MultiPoint)).equals((Object)type)) {
                geometry2 = this.toMultiPoint((com.geoway.atlas.jts.MultiPoint)arcGeometry);
            } else if (((Object)((Object)Geometry.Type.Unknown)).equals((Object)type)) {
                geometry2 = null;
            } else {
                throw new MatchError((Object)type);
            }
            geometry = geometry2;
        } else {
            geometry = null;
        }
        jtsGeom = geometry;
        return jtsGeom == null ? this.gf().createEmpty(2) : var3_2;
    }

    public org.locationtech.jts.geom.Geometry toPolygon(com.geoway.atlas.jts.Polygon arcPolygon) {
        org.locationtech.jts.geom.Geometry geometry;
        int lineCount = arcPolygon.getPathCount();
        Object object = lineCount == 0 ? this.gf().createEmpty(2) : BoxedUnit.UNIT;
        Tuple2[] linearRings = new Tuple2[arcPolygon.getExteriorRingCount()];
        int currentPolygonIndex = -1;
        int limit$macro$9 = lineCount;
        for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
            int start = arcPolygon.getPathStart(index$macro$7);
            int end = arcPolygon.getPathEnd(index$macro$7);
            Coordinate[] coordinates = new Coordinate[end - start + 1];
            int limit$macro$4 = end;
            for (int index$macro$2 = start; index$macro$2 < limit$macro$4; ++index$macro$2) {
                com.geoway.atlas.jts.Point arcPoint = arcPolygon.getPoint(index$macro$2);
                coordinates[index$macro$2 - start] = new Coordinate(arcPoint.getX(), arcPoint.getY());
            }
            coordinates[coordinates.length - 1] = new Coordinate(((Coordinate)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coordinates)).head()).getX(), ((Coordinate)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coordinates)).head()).getY());
            LinearRing linearRing = this.gf().createLinearRing(coordinates);
            if (arcPolygon.isExteriorRing(index$macro$7)) {
                linearRings[++currentPolygonIndex] = new Tuple2((Object)linearRing, new ArrayList());
                continue;
            }
            ((List)linearRings[currentPolygonIndex]._2()).add(linearRing);
        }
        if (linearRings.length == 1) {
            geometry = this.gf().createPolygon((LinearRing)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearRings)).head())._1(), (LinearRing[])((List)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearRings)).head())._2()).toArray((Object[])new LinearRing[((List)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearRings)).head())._2()).size()]));
        } else {
            Polygon[] polygons = new Polygon[linearRings.length];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearRings)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                polygons$1[i] = MODULE$.gf().createPolygon((LinearRing)linearRings[i]._1(), (LinearRing[])((List)linearRings[i]._2()).toArray((Object[])new LinearRing[((List)linearRings[i]._2()).size()]));
            });
            geometry = this.gf().createMultiPolygon(polygons);
        }
        return geometry;
    }

    public org.locationtech.jts.geom.Geometry toPolyline(Polyline arcPolyline) {
        int pathCount = arcPolyline.getPathCount();
        Object object = pathCount == 0 ? this.gf().createEmpty(1) : BoxedUnit.UNIT;
        LineString[] lineStrings = new LineString[pathCount];
        int limit$macro$9 = pathCount;
        for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
            int start = arcPolyline.getPathStart(index$macro$7);
            int end = arcPolyline.getPathEnd(index$macro$7);
            Coordinate[] coordinates = new Coordinate[end - start];
            int limit$macro$4 = end;
            for (int index$macro$2 = start; index$macro$2 < limit$macro$4; ++index$macro$2) {
                com.geoway.atlas.jts.Point arcPoint = arcPolyline.getPoint(index$macro$2);
                coordinates[index$macro$2 - start] = new Coordinate(arcPoint.getX(), arcPoint.getY());
            }
            lineStrings[index$macro$7] = this.gf().createLineString(coordinates);
        }
        return this.gf().createMultiLineString(lineStrings);
    }

    public LineString toLine(Line arcLine) {
        Coordinate startPoint = new Coordinate(arcLine.getStartX(), arcLine.getStartY());
        Coordinate endPoint = new Coordinate(arcLine.getEndX(), arcLine.getEndY());
        return this.gf().createLineString((Coordinate[])((Object[])new Coordinate[]{startPoint, endPoint}));
    }

    public Point toPoint(com.geoway.atlas.jts.Point arcPoint) {
        return this.gf().createPoint(new Coordinate(arcPoint.getX(), arcPoint.getY()));
    }

    public MultiPoint toMultiPoint(com.geoway.atlas.jts.MultiPoint arcMultiPoint) {
        int pointCount = arcMultiPoint.getPointCount();
        ArrayBuffer points = new ArrayBuffer();
        int limit$macro$4 = pointCount;
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            com.geoway.atlas.jts.Point arcPoint = arcMultiPoint.getPoint(index$macro$2);
            Point point = this.gf().createPoint(new Coordinate(arcPoint.getX(), arcPoint.getY()));
            points.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Point[]{point}));
        }
        return this.gf().createMultiPoint((Point[])points.toArray(ClassTag$.MODULE$.apply(Point.class)));
    }

    public Geometry overlayByArcOp(GeometryCursor cursor1, GeometryCursor cursor2, SpatialReference sr, int opCode) {
        Geometry geometry;
        int n = opCode;
        if (OverlayNG.INTERSECTION == n) {
            Geometry geomr;
            OperatorIntersection operatorIntersection = (OperatorIntersection)this.PROJ_Env().getOperator(Operator.Type.Intersection);
            GeometryCursor outputGeoms = operatorIntersection.execute(cursor1, cursor2, sr, null);
            geometry = geomr = outputGeoms.next();
        } else if (OverlayNG.DIFFERENCE == n) {
            Geometry geomr;
            OperatorDifference operatorDifference = (OperatorDifference)this.PROJ_Env().getOperator(Operator.Type.Difference);
            GeometryCursor outputGeoms = operatorDifference.execute(cursor1, cursor2, sr, null);
            geometry = geomr = outputGeoms.next();
        } else if (OverlayNG.UNION == n) {
            Geometry geomr;
            OperatorUnion operatorUnion = (OperatorUnion)this.PROJ_Env().getOperator(Operator.Type.Union);
            SimpleGeometryCursor cursors = new SimpleGeometryCursor((Geometry[])((Object[])new Geometry[]{cursor1.next(), cursor2.next()}));
            GeometryCursor outputGeoms = operatorUnion.execute(cursors, sr, null);
            geometry = geomr = outputGeoms.next();
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return geometry;
    }

    /*
     * WARNING - void declaration
     */
    public com.geoway.atlas.jts.Polygon toArcGeometry(Polygonal polygonal) {
        void var3_2;
        com.geoway.atlas.jts.Polygon arcPolygon = null;
        if (((org.locationtech.jts.geom.Geometry)((Object)polygonal)).isEmpty()) {
            arcPolygon = new com.geoway.atlas.jts.Polygon();
        } else {
            ArrayBuffer polygons = new ArrayBuffer();
            Polygonal polygonal2 = polygonal;
            if (polygonal2 instanceof Polygon) {
                Polygon polygon = (Polygon)polygonal2;
                polygons.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{polygon}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (polygonal2 instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)polygonal2;
                int limit$macro$4 = multiPolygon.getNumGeometries();
                for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                    polygons.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{(Polygon)multiPolygon.getGeometryN(index$macro$2)}));
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)polygonal2);
            }
            arcPolygon = this.toArcGeometry((Seq<Polygon>)polygons);
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public com.geoway.atlas.jts.Polygon toArcGeometry(Seq<Polygon> polygons) {
        void var2_2;
        com.geoway.atlas.jts.Polygon arcPolygon = new com.geoway.atlas.jts.Polygon();
        polygons.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)polygonIndex -> {
            Polygon polygon = (Polygon)polygons.apply(polygonIndex);
            LinearRing exteriorRing = polygon.getExteriorRing();
            MODULE$.addCoordinateSequence(exteriorRing.getCoordinateSequence(), arcPolygon);
            int numInteriorRing = polygon.getNumInteriorRing();
            int limit$macro$4 = numInteriorRing;
            for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                LinearRing linearRing = polygon.getInteriorRingN(index$macro$2);
                MODULE$.addCoordinateSequence(linearRing.getCoordinateSequence(), arcPolygon);
            }
        });
        return var2_2;
    }

    public void addCoordinateSequence(CoordinateSequence cs, com.geoway.atlas.jts.Polygon arcPolygon) {
        arcPolygon.startPath(cs.getX(0), cs.getY(0));
        int limit$macro$4 = cs.size() - 1;
        for (int index$macro$2 = 1; index$macro$2 < limit$macro$4; ++index$macro$2) {
            Coordinate coordinate = cs.getCoordinate(index$macro$2);
            arcPolygon.lineTo(coordinate.x, coordinate.y);
        }
        arcPolygon.closePathWithLine();
    }

    public static final /* synthetic */ SpatialReference $anonfun$overlay$1(int x$1) {
        return SpatialReference.create(4496);
    }

    public static final /* synthetic */ SpatialReference $anonfun$overlay$2(int x$2) {
        return SpatialReference.create(4490);
    }

    public static final /* synthetic */ SpatialReference $anonfun$overlay$3(int x$3) {
        return SpatialReference.create(4496);
    }

    public static final /* synthetic */ SpatialReference $anonfun$overlay$4(int x$4) {
        return SpatialReference.create(4490);
    }

    public static final /* synthetic */ double $anonfun$getRobustPrecisionModel$1(org.locationtech.jts.geom.Geometry a) {
        return PrecisionUtil.robustScale(a);
    }

    private ArcOverlayOp$() {
        MODULE$ = this;
        this.SR_CACHE = AtlasThreadSafeCache$.MODULE$.apply();
        this.PROJ_Env = OperatorFactoryLocal.getInstance();
        this.wkbWriterCache = new AtlasThreadSafeObj();
        this.wkbReaderCache = new AtlasThreadSafeObj();
        this.gf = new GeometryFactory();
    }
}

