/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;

public class BoundaryChainNoder
implements Noder {
    private List<SegmentString> chainList;

    @Override
    public void computeNodes(Collection segStrings) {
        HashSet<Segment> segSet = new HashSet<Segment>();
        BoundarySegmentMap[] bdySections = new BoundarySegmentMap[segStrings.size()];
        BoundaryChainNoder.addSegments(segStrings, segSet, bdySections);
        BoundaryChainNoder.markBoundarySegments(segSet);
        this.chainList = BoundaryChainNoder.extractChains(bdySections);
    }

    private static void addSegments(Collection<SegmentString> segStrings, HashSet<Segment> segSet, BoundarySegmentMap[] includedSegs) {
        int i = 0;
        for (SegmentString ss : segStrings) {
            BoundarySegmentMap segInclude = new BoundarySegmentMap(ss);
            includedSegs[i++] = segInclude;
            BoundaryChainNoder.addSegments(ss, segInclude, segSet);
        }
    }

    private static void addSegments(SegmentString segString, BoundarySegmentMap segInclude, HashSet<Segment> segSet) {
        for (int i = 0; i < segString.size() - 1; ++i) {
            Coordinate p1;
            Coordinate p0 = segString.getCoordinate(i);
            Segment seg = new Segment(p0, p1 = segString.getCoordinate(i + 1), segInclude, i);
            if (segSet.contains(seg)) {
                segSet.remove(seg);
                continue;
            }
            segSet.add(seg);
        }
    }

    private static void markBoundarySegments(HashSet<Segment> segSet) {
        for (Segment seg : segSet) {
            seg.markInBoundary();
        }
    }

    private static List<SegmentString> extractChains(BoundarySegmentMap[] sections) {
        ArrayList<SegmentString> sectionList = new ArrayList<SegmentString>();
        for (BoundarySegmentMap sect : sections) {
            sect.createChains(sectionList);
        }
        return sectionList;
    }

    @Override
    public Collection getNodedSubstrings() {
        return this.chainList;
    }

    private static class Segment
    extends LineSegment {
        private BoundarySegmentMap segMap;
        private int index;

        public Segment(Coordinate p0, Coordinate p1, BoundarySegmentMap segMap, int index) {
            super(p0, p1);
            this.segMap = segMap;
            this.index = index;
            this.normalize();
        }

        public void markInBoundary() {
            this.segMap.setBoundarySegment(this.index);
        }
    }

    private static class BoundarySegmentMap {
        private SegmentString segString;
        private boolean[] isBoundary;

        public BoundarySegmentMap(SegmentString ss) {
            this.segString = ss;
            this.isBoundary = new boolean[ss.size() - 1];
        }

        public void setBoundarySegment(int index) {
            this.isBoundary[index] = true;
        }

        public void createChains(List<SegmentString> chainList) {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = this.findChainStart(endIndex)) < this.segString.size() - 1) {
                endIndex = this.findChainEnd(startIndex);
                SegmentString ss = BoundarySegmentMap.createChain(this.segString, startIndex, endIndex);
                chainList.add(ss);
            }
        }

        private static SegmentString createChain(SegmentString segString, int startIndex, int endIndex) {
            Coordinate[] pts = new Coordinate[endIndex - startIndex + 1];
            int ipts = 0;
            for (int i = startIndex; i < endIndex + 1; ++i) {
                pts[ipts++] = segString.getCoordinate(i).copy();
            }
            return new BasicSegmentString(pts, segString.getData());
        }

        private int findChainStart(int index) {
            while (index < this.isBoundary.length && !this.isBoundary[index]) {
                ++index;
            }
            return index;
        }

        private int findChainEnd(int index) {
            ++index;
            while (index < this.isBoundary.length && this.isBoundary[index]) {
                ++index;
            }
            return index;
        }
    }
}

