/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.Collection;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.noding.snap.SnappingNoder;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.OverlayUtil;
import org.locationtech.jts.operation.overlayng.PrecisionUtil;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.locationtech.jts.operation.union.UnionStrategy;

public class OverlayNGRobust {
    private static UnionStrategy OVERLAY_UNION = new UnionStrategy(){

        @Override
        public Geometry union(Geometry g0, Geometry g1) {
            Geometry result = OverlayNGRobust.overlay(g0, g1, 2);
            if (result == null) {
                if (g0 != null) {
                    return g0.getFactory().createEmpty(g0.getDimension());
                }
                return g1.getFactory().createEmpty(g1.getDimension());
            }
            return result;
        }

        @Override
        public boolean isFloatingPrecision() {
            return true;
        }
    };
    private static UnionStrategy OVERLAY_UNION_RAW_CCW = new UnionStrategy(){

        @Override
        public Geometry union(Geometry g0, Geometry g1) {
            Geometry result = OverlayNGRobust.overlayRawCCW(g0, g1, 2);
            if (result == null) {
                if (g0 != null) {
                    return g0.getFactory().createEmpty(g0.getDimension());
                }
                return g1.getFactory().createEmpty(g1.getDimension());
            }
            return result;
        }

        @Override
        public boolean isFloatingPrecision() {
            return true;
        }
    };
    private static final int NUM_SNAP_TRIES = 5;
    private static final double SNAP_TOL_FACTOR = 1.0E12;

    public static Geometry union(Geometry geom) {
        UnaryUnionOp op = new UnaryUnionOp(geom);
        op.setUnionFunction(OVERLAY_UNION);
        return op.union();
    }

    public static Geometry union(Collection<Geometry> geoms) {
        UnaryUnionOp op = new UnaryUnionOp(geoms);
        op.setUnionFunction(OVERLAY_UNION);
        return op.union();
    }

    public static Geometry union(Collection<Geometry> geoms, GeometryFactory geomFact) {
        UnaryUnionOp op = new UnaryUnionOp(geoms, geomFact);
        op.setUnionFunction(OVERLAY_UNION);
        return op.union();
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode) {
        return OverlayNGRobust.overlay(geom0, geom1, opCode, false);
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode, boolean isStrictMode) {
        return OverlayNGRobust.overlay(geom0, geom1, opCode, isStrictMode, null);
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode, boolean isStrictMode, PrecisionModel pm) {
        return OverlayNGRobust.overlay(geom0, geom1, opCode, isStrictMode, pm, false);
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode, boolean isStrictMode, PrecisionModel pm, boolean isUseArc) {
        return OverlayNGRobust.overlay(geom0, geom1, opCode, isStrictMode, pm, isUseArc, false);
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode, boolean isStrictMode, PrecisionModel pm, boolean isUseArc, boolean isRawCCW) {
        try {
            OverlayNG ov = new OverlayNG(geom0, geom1, pm, opCode);
            ov.setStrictMode(isStrictMode);
            ov.setUseArc(isUseArc);
            ov.setIgnoreCCWThrowable(isRawCCW);
            return ov.getResult();
        }
        catch (RuntimeException ex) {
            RuntimeException exOriginal = ex;
            Geometry result = OverlayNGRobust.overlaySnapTries(geom0, geom1, pm, opCode, isStrictMode, isUseArc, isRawCCW);
            if (result != null) {
                return result;
            }
            result = OverlayNGRobust.overlaySR(geom0, geom1, opCode, isStrictMode, isUseArc, isRawCCW);
            if (result != null) {
                return result;
            }
            throw exOriginal;
        }
    }

    private static Geometry overlaySnapTries(Geometry geom0, Geometry geom1, PrecisionModel pm, int opCode, boolean isStrictMode, boolean isUseArc, boolean isRawCCW) {
        double snapTol = OverlayNGRobust.snapTolerance(geom0, geom1);
        for (int i = 0; i < 5; ++i) {
            Geometry result = OverlayNGRobust.overlaySnapping(geom0, geom1, opCode, snapTol, pm, isStrictMode, isUseArc, isRawCCW);
            if (result != null) {
                return result;
            }
            result = OverlayNGRobust.overlaySnapBoth(geom0, geom1, opCode, snapTol, pm, isStrictMode, isUseArc, isRawCCW);
            if (result != null) {
                return result;
            }
            snapTol *= 10.0;
        }
        return null;
    }

    private static Geometry overlaySnapping(Geometry geom0, Geometry geom1, int opCode, double snapTol, PrecisionModel pm, boolean isStrictMode, boolean isUseArc, boolean isRawCCW) {
        try {
            return OverlayNGRobust.overlaySnapTol(geom0, geom1, opCode, snapTol, pm, isStrictMode, isUseArc, isRawCCW);
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }

    private static Geometry overlaySnapBoth(Geometry geom0, Geometry geom1, int opCode, double snapTol, PrecisionModel pm, boolean isStrictMode, boolean isUseArc, boolean isRawCCW) {
        try {
            Geometry snap0 = OverlayNGRobust.snapSelf(geom0, snapTol);
            Geometry snap1 = OverlayNGRobust.snapSelf(geom1, snapTol);
            return OverlayNGRobust.overlaySnapTol(snap0, snap1, opCode, snapTol, pm, isStrictMode, isUseArc, isRawCCW);
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }

    private static Geometry snapSelf(Geometry geom, double snapTol) {
        OverlayNG ov = new OverlayNG(geom, null);
        SnappingNoder snapNoder = new SnappingNoder(snapTol);
        ov.setNoder(snapNoder);
        ov.setStrictMode(true);
        return ov.getResult();
    }

    private static Geometry overlaySnapTol(Geometry geom0, Geometry geom1, int opCode, double snapTol, PrecisionModel pm, boolean isStrictMode, boolean isUseArc, boolean isRawCCW) {
        SnappingNoder snapNoder = new SnappingNoder(snapTol);
        OverlayNG overlayNG = new OverlayNG(geom0, geom1, pm, opCode);
        overlayNG.setUseArc(isUseArc);
        overlayNG.setStrictMode(isStrictMode);
        overlayNG.setNoder(snapNoder);
        overlayNG.setIgnoreCCWThrowable(isRawCCW);
        return overlayNG.getResult();
    }

    private static double snapTolerance(Geometry geom0, Geometry geom1) {
        double tol0 = OverlayNGRobust.snapTolerance(geom0);
        double tol1 = OverlayNGRobust.snapTolerance(geom1);
        double snapTol = Math.max(tol0, tol1);
        return snapTol;
    }

    private static double snapTolerance(Geometry geom) {
        double magnitude = OverlayNGRobust.ordinateMagnitude(geom);
        return magnitude / 1.0E12;
    }

    private static double ordinateMagnitude(Geometry geom) {
        if (geom == null || geom.isEmpty()) {
            return 0.0;
        }
        Envelope env = geom.getEnvelopeInternal();
        double magMax = Math.max(Math.abs(env.getMaxX()), Math.abs(env.getMaxY()));
        double magMin = Math.max(Math.abs(env.getMinX()), Math.abs(env.getMinY()));
        return Math.max(magMax, magMin);
    }

    private static Geometry overlaySR(Geometry geom0, Geometry geom1, int opCode, boolean isStrictMode, boolean isUseArc, boolean isRawCCW) {
        try {
            double scaleSafe = PrecisionUtil.safeScale(geom0, geom1);
            PrecisionModel pmSafe = new PrecisionModel(scaleSafe);
            OverlayNG overlayNG = new OverlayNG(geom0, geom1, pmSafe, opCode);
            overlayNG.setStrictMode(isStrictMode);
            overlayNG.setUseArc(isUseArc);
            overlayNG.setIgnoreCCWThrowable(isRawCCW);
            Geometry result = overlayNG.getResult();
            return result;
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }

    public static Geometry unionNG(Collection<Geometry> geoms, PrecisionModel pm, boolean isStrictMode, boolean isUseArc) {
        UnaryUnionOp op = new UnaryUnionOp(geoms);
        op.setUnionFunction(OverlayNGRobust.createUnionStrategy(pm, isStrictMode, isUseArc));
        return op.union();
    }

    public static Geometry unionNG(Collection<Geometry> geoms, PrecisionModel pm, boolean isStrictMode) {
        return OverlayNGRobust.unionNG(geoms, pm, isStrictMode, false);
    }

    private static UnionStrategy createUnionStrategy(final PrecisionModel pm, final boolean isStrictMode, final boolean isUseArc) {
        return new UnionStrategy(){

            @Override
            public Geometry union(Geometry g0, Geometry g1) {
                Geometry result;
                try {
                    result = OverlayNGRobust.overlay(g0, g1, 2, isStrictMode, pm, isUseArc);
                }
                catch (Throwable throwable) {
                    Geometry gg0 = this.fix(g0);
                    Geometry gg1 = this.fix(g1);
                    result = OverlayNGRobust.overlay(gg0, gg1, 2, isStrictMode, pm, isUseArc);
                }
                if (result == null) {
                    result = g0.getFactory().createEmpty(g0.getDimension());
                }
                return result;
            }

            private Geometry fix(Geometry g) {
                Geometry result = g;
                if (!g.isValid()) {
                    try {
                        result = GeometryFixer.fix(g);
                        if (!result.isValid()) {
                            result = result.buffer(0.0);
                        }
                    }
                    catch (Throwable throwable) {
                        result = g.buffer(0.0);
                    }
                }
                return result;
            }

            @Override
            public boolean isFloatingPrecision() {
                return OverlayUtil.isFloating(pm);
            }
        };
    }

    public static Geometry overlayRawCCW(Geometry geom0, Geometry geom1, int opCode) {
        return OverlayNGRobust.overlay(geom0, geom1, opCode, false, null, false, true);
    }

    public static Geometry unionRawCCW(Collection<Geometry> geoms) {
        UnaryUnionOp op = new UnaryUnionOp(geoms);
        op.setUnionFunction(OVERLAY_UNION_RAW_CCW);
        return op.union();
    }
}

