/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.data.vector.parquet.common;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.data.vector.parquet.common.SimpleFeatureParquetWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class SimpleFeatureParquetWriter$
implements LazyLogging {
    public static SimpleFeatureParquetWriter$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SimpleFeatureParquetWriter$();
    }

    private Logger logger$lzycompute() {
        SimpleFeatureParquetWriter$ simpleFeatureParquetWriter$ = this;
        synchronized (simpleFeatureParquetWriter$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public SimpleFeatureParquetWriter.Builder builder(AtlasVectorSchema avs, Path file, Configuration conf) {
        CompressionCodecName codec = CompressionCodecName.fromConf((String)conf.get("parquet.compression", this.getCompressionName()));
        this.logger().debug(new StringBuilder(32).append("Using Parquet Compression codec ").append(codec.name()).toString());
        return (SimpleFeatureParquetWriter.Builder)new SimpleFeatureParquetWriter.Builder(avs, file).withConf(conf).withCompressionCodec(codec).withDictionaryEncoding(true).withDictionaryPageSize(this.getDictionaryPageSize()).withMaxPaddingSize(this.getMaxPaddingSize()).withPageSize(this.getPageSize()).withValidation(false).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0).withRowGroupSize(this.getRowGroupSize());
    }

    private String getCompressionName() {
        return AtlasSystemProperties$.MODULE$.getProperty("atlas.storage.parquet.compression", "SNAPPY");
    }

    private int getDictionaryPageSize() {
        return new StringOps(Predef$.MODULE$.augmentString(AtlasSystemProperties$.MODULE$.getProperty("atlas.storage.parquet.dictionary.page.size", Integer.toString(0x100000)))).toInt();
    }

    private int getMaxPaddingSize() {
        return new StringOps(Predef$.MODULE$.augmentString(AtlasSystemProperties$.MODULE$.getProperty("atlas.storage.parquet.max.padding.size", Integer.toString(0x800000)))).toInt();
    }

    private int getPageSize() {
        return new StringOps(Predef$.MODULE$.augmentString(AtlasSystemProperties$.MODULE$.getProperty("atlas.storage.parquet.page.size", Integer.toString(0x100000)))).toInt();
    }

    private long getRowGroupSize() {
        return new StringOps(Predef$.MODULE$.augmentString(AtlasSystemProperties$.MODULE$.getProperty("atlas.storage.parquet.row.group.size", Integer.toString(0x800000)))).toLong();
    }

    private SimpleFeatureParquetWriter$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

