/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.serialization.kryo.json;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.vector.serialization.kryo.json.KryoJsonSerialization;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.control.NonFatal$;

public final class KryoJsonSerialization$
implements LazyLogging {
    public static KryoJsonSerialization$ MODULE$;
    private final byte com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$TerminalByte;
    private final byte DoubleByte;
    private final byte StringByte;
    private final byte DocByte;
    private final byte ArrayByte;
    private final byte BooleanByte;
    private final byte NullByte;
    private final byte IntByte;
    private final byte LongByte;
    private final byte BooleanFalse;
    private final byte BooleanTrue;
    private final ThreadLocal<byte[]> com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$nameBuffers;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new KryoJsonSerialization$();
    }

    private Logger logger$lzycompute() {
        KryoJsonSerialization$ kryoJsonSerialization$ = this;
        synchronized (kryoJsonSerialization$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public byte com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$TerminalByte() {
        return this.com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$TerminalByte;
    }

    private byte DoubleByte() {
        return this.DoubleByte;
    }

    private byte StringByte() {
        return this.StringByte;
    }

    private byte DocByte() {
        return this.DocByte;
    }

    private byte ArrayByte() {
        return this.ArrayByte;
    }

    private byte BooleanByte() {
        return this.BooleanByte;
    }

    private byte NullByte() {
        return this.NullByte;
    }

    private byte IntByte() {
        return this.IntByte;
    }

    private byte LongByte() {
        return this.LongByte;
    }

    private byte BooleanFalse() {
        return this.BooleanFalse;
    }

    private byte BooleanTrue() {
        return this.BooleanTrue;
    }

    public ThreadLocal<byte[]> com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$nameBuffers() {
        return this.com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$nameBuffers;
    }

    public void serialize(Output out, String json) {
        JsonAST.JObject jObject;
        if (json == null) {
            jObject = null;
        } else {
            try {
                jObject = (JsonAST.JObject)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logger().warn(new StringBuilder(20).append("Error parsing json:\n").append(json).toString(), e);
                Object var3_7 = null;
                jObject = var3_7;
            }
        }
        JsonAST.JObject obj = jObject;
        this.serialize(out, obj);
    }

    public void serialize(Output out, JsonAST.JObject json) {
        if (json == null) {
            out.write((int)this.BooleanFalse());
        } else {
            out.write((int)this.BooleanTrue());
            this.writeDocument(out, json);
        }
    }

    public String deserializeAndRender(Input in) {
        String string;
        JsonAST.JObject json = this.deserialize(in);
        if (json == null) {
            string = null;
        } else {
            JsonAST.JObject x$1 = json;
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        }
        return string;
    }

    public JsonAST.JObject deserialize(Input in) {
        JsonAST.JObject jObject;
        block4: {
            try {
                if (in.readByte() == this.BooleanFalse()) {
                    jObject = null;
                    break block4;
                }
                jObject = this.readDocument(in);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logger().error("Error reading serialized kryo json", e);
                Object var2_6 = null;
                jObject = var2_6;
            }
        }
        return jObject;
    }

    private void writeDocument(Output out, String name, JsonAST.JObject value) {
        out.writeByte(this.DocByte());
        this.RichOutput(out).writeName(name);
        this.writeDocument(out, value);
    }

    private void writeDocument(Output out, JsonAST.JObject value) {
        int start = out.position();
        out.writeInt(0);
        value.obj().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KryoJsonSerialization$.$anonfun$writeDocument$1(out, x0$1);
            return BoxedUnit.UNIT;
        });
        out.writeByte(this.com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$TerminalByte());
        int end = out.position();
        out.setPosition(start);
        out.writeInt(end - start);
        out.setPosition(end);
    }

    private void writeArray(Output out, String name, JsonAST.JArray value) {
        out.writeByte(this.ArrayByte());
        this.RichOutput(out).writeName(name);
        IntRef i = IntRef.create((int)-1);
        List withKeys = (List)value.arr().map((Function1 & Serializable & scala.Serializable)element -> {
            ++i$1.elem;
            return new Tuple2((Object)Integer.toString(i$1.elem), element);
        }, List$.MODULE$.canBuildFrom());
        this.writeDocument(out, new JsonAST.JObject(withKeys));
    }

    private void writeString(Output out, String name, JsonAST.JString value) {
        out.writeByte(this.StringByte());
        this.RichOutput(out).writeName(name);
        byte[] bytes = value.values().getBytes(StandardCharsets.UTF_8);
        out.writeInt(bytes.length);
        out.write(bytes);
        out.writeByte(this.com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$TerminalByte());
    }

    private void writeDecimal(Output out, String name, JsonAST.JDecimal value) {
        out.writeByte(this.DoubleByte());
        this.RichOutput(out).writeName(name);
        out.writeDouble(value.values().toDouble());
    }

    private void writeDouble(Output out, String name, JsonAST.JDouble value) {
        out.writeByte(this.DoubleByte());
        this.RichOutput(out).writeName(name);
        out.writeDouble(value.values());
    }

    private void writeInt(Output out, String name, JsonAST.JInt value) {
        if (value.values().isValidInt()) {
            out.writeByte(this.IntByte());
            this.RichOutput(out).writeName(name);
            out.writeInt(value.values().intValue());
        } else if (value.values().isValidLong()) {
            out.writeByte(this.LongByte());
            this.RichOutput(out).writeName(name);
            out.writeLong(value.values().longValue());
        } else {
            this.logger().warn(new StringBuilder(48).append("Skipping int value that does not fit in a long: ").append(value).toString());
        }
    }

    private void writeBoolean(Output out, String name, JsonAST.JBool v) {
        out.writeByte(this.BooleanByte());
        this.RichOutput(out).writeName(name);
        out.writeByte(v.values() ? this.BooleanTrue() : this.BooleanFalse());
    }

    private void writeNull(Output out, String name) {
        out.writeByte(this.NullByte());
        this.RichOutput(out).writeName(name);
    }

    private JsonAST.JObject readDocument(Input in) {
        int end = in.position() + in.readInt() - 1;
        ArrayBuffer elements = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (in.position() < end) {
            JsonAST.JString jString;
            byte by = in.readByte();
            String name = this.RichInput(in).readName();
            byte by2 = by;
            if (this.StringByte() == by2) {
                jString = new JsonAST.JString(this.readString(in));
            } else if (this.DocByte() == by2) {
                jString = this.readDocument(in);
            } else if (this.ArrayByte() == by2) {
                jString = this.readArray(in);
            } else if (this.DoubleByte() == by2) {
                jString = new JsonAST.JDouble(in.readDouble());
            } else if (this.IntByte() == by2) {
                jString = new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(in.readInt()));
            } else if (this.LongByte() == by2) {
                jString = new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(in.readLong()));
            } else if (this.NullByte() == by2) {
                jString = JsonAST.JNull$.MODULE$;
            } else if (this.BooleanByte() == by2) {
                jString = JsonAST.JBool$.MODULE$.apply(this.readBoolean(in));
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
            }
            JsonAST.JString value = jString;
            elements.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{JsonAST.JField$.MODULE$.apply(name, (JsonAST.JValue)value)}));
        }
        in.skip(1);
        return new JsonAST.JObject(elements.toList());
    }

    private JsonAST.JArray readArray(Input in) {
        return new JsonAST.JArray((List)this.readDocument(in).obj().map((Function1 & Serializable & scala.Serializable)x$1 -> (JsonAST.JValue)x$1._2(), List$.MODULE$.canBuildFrom()));
    }

    private void skipDocument(Input in) {
        in.skip(in.readInt() - 4);
    }

    private String readString(Input in) {
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(in.readInt(), ClassTag$.MODULE$.Byte());
        in.read(bytes);
        in.skip(1);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private boolean readBoolean(Input in) {
        return in.readByte() == this.BooleanTrue();
    }

    private KryoJsonSerialization.RichOutput RichOutput(Output out) {
        return new KryoJsonSerialization.RichOutput(out);
    }

    private KryoJsonSerialization.RichInput RichInput(Input in) {
        return new KryoJsonSerialization.RichInput(in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$writeDocument$1(Output out$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String name = (String)tuple2._1();
        JsonAST.JValue elem = (JsonAST.JValue)tuple2._2();
        JsonAST.JValue jValue = elem;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            MODULE$.writeString(out$1, name, jString);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            MODULE$.writeDocument(out$1, name, jObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue;
            MODULE$.writeArray(out$1, name, jArray);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JDouble) {
            JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
            MODULE$.writeDouble(out$1, name, jDouble);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue;
            MODULE$.writeInt(out$1, name, jInt);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonAST.JNull$.MODULE$.equals(jValue)) {
            MODULE$.writeNull(out$1, name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JBool) {
            JsonAST.JBool jBool = (JsonAST.JBool)jValue;
            MODULE$.writeBoolean(out$1, name, jBool);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(jValue instanceof JsonAST.JDecimal)) throw new MatchError((Object)jValue);
            JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
            MODULE$.writeDecimal(out$1, name, jDecimal);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private KryoJsonSerialization$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$TerminalByte = 0;
        this.DoubleByte = 1;
        this.StringByte = (byte)2;
        this.DocByte = (byte)3;
        this.ArrayByte = (byte)4;
        this.BooleanByte = (byte)8;
        this.NullByte = (byte)10;
        this.IntByte = (byte)16;
        this.LongByte = (byte)18;
        this.BooleanFalse = 0;
        this.BooleanTrue = 1;
        this.com$geoway$atlas$data$vector$serialization$kryo$json$KryoJsonSerialization$$nameBuffers = new ThreadLocal<byte[]>(){

            public byte[] initialValue() {
                return (byte[])Array$.MODULE$.ofDim(32, ClassTag$.MODULE$.Byte());
            }
        };
    }
}

