/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.serialization.kryo.partition;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.geoway.atlas.data.vector.serialization.kryo.partition.KryoEnvelopeSerializer$;
import com.geoway.atlas.index.vector.common.partitionIndex.quadtree.QuadtreePartitionVectorIndex;
import com.geoway.atlas.index.vector.common.partitionIndex.quadtree.QuadtreePartitionVectorIndex$;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.Node;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;

public final class KryoQuadIndexSerializer$ {
    public static KryoQuadIndexSerializer$ MODULE$;

    static {
        new KryoQuadIndexSerializer$();
    }

    public void serializableQuadTree(Output out, QuadtreePartitionVectorIndex<String> t) {
        if (t.isEmpty()) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            List items = t.quadtree().getRoot().getItems();
            out.writeInt(items.size());
            int limit$macro$4 = items.size();
            for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                out.writeString((String)items.get(index$macro$2));
            }
            Node[] subNodes = t.quadtree().getRoot().getSubnode();
            int limit$macro$9 = 4;
            for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
                this.writeQuadTreeNode(out, subNodes[index$macro$7]);
            }
        }
    }

    public void writeQuadTreeNode(Output out, Node node) {
        if (node == null || node.isEmpty()) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            KryoEnvelopeSerializer$.MODULE$.writeEnvelope(out, node.getEnvelope());
            out.writeInt(node.getLevel());
            List items = node.getItems();
            out.writeInt(items.size());
            int limit$macro$4 = items.size();
            for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                out.writeString((String)items.get(index$macro$2));
            }
            Node[] subNodes = node.getSubnode();
            int limit$macro$9 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subNodes)).size();
            for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
                this.writeQuadTreeNode(out, node);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public QuadtreePartitionVectorIndex<String> deSerializableQuadTree(Input input) {
        void var2_2;
        boolean notEmpty;
        QuadtreePartitionVectorIndex index = QuadtreePartitionVectorIndex$.MODULE$.apply();
        boolean bl = notEmpty = (input.readByte() & 1) == 1;
        if (!notEmpty) {
            return index;
        }
        int itemSize = input.readInt();
        ArrayList<String> items = new ArrayList<String>();
        int limit$macro$4 = itemSize;
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            items.add(input.readString());
        }
        index.quadtree().getRoot().setItems(items);
        int limit$macro$9 = 4;
        for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
            index.quadtree().getRoot().getSubnode()[index$macro$7] = this.readQuadTreeNode(input);
        }
        return var2_2;
    }

    public Node readQuadTreeNode(Input input) {
        boolean notEmpty;
        boolean bl = notEmpty = (input.readByte() & 1) == 1;
        if (!notEmpty) {
            return null;
        }
        Envelope envelope = KryoEnvelopeSerializer$.MODULE$.readEnvelope(input);
        int level = input.readInt();
        Node node = new Node(envelope, level);
        int itemSize = input.readInt();
        ArrayList<String> items = new ArrayList<String>();
        int limit$macro$4 = itemSize;
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            items.add(input.readString());
        }
        node.setItems(items);
        int limit$macro$9 = 4;
        for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
            node.getSubnode()[index$macro$7] = this.readQuadTreeNode(input);
        }
        return node;
    }

    private KryoQuadIndexSerializer$() {
        MODULE$ = this;
    }
}

