/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.spark.common.api;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.error.NotEqualException;
import com.geoway.atlas.common.error.NotEqualException$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.time.AtlasTimer$;
import com.geoway.atlas.data.common.data.AtlasDataHub$;
import com.geoway.atlas.data.common.data.AtlasDataModelRDao;
import com.geoway.atlas.data.common.data.AtlasDataModelWDao;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.common.data.AtlasDataStore;
import com.geoway.atlas.data.common.data.AtlasDataStore$;
import com.geoway.atlas.data.common.dataset.AtlasDataSet;
import com.geoway.atlas.data.common.dataset.AtlasResultMetadata;
import com.geoway.atlas.data.common.schema.AtlasSchema;
import com.geoway.atlas.data.common.storage.AtlasDataParams;
import com.geoway.atlas.data.common.storage.AtlasDataParams$;
import com.geoway.atlas.data.vector.common.feature.sft.package;
import com.geoway.atlas.data.vector.common.wkt.WktUtils$;
import com.geoway.atlas.data.vector.geojson.datastore.GeoJsonAtlasDataStore$;
import com.geoway.atlas.dataset.common.manager.AtlasDataTag;
import com.geoway.atlas.dataset.common.manager.DataManager;
import com.geoway.atlas.dataset.common.manager.DataManager$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.spark.VectorSparkProvider;
import com.geoway.atlas.dataset.vector.spark.VectorSparkProvider$;
import com.geoway.atlas.dataset.vector.spark.VectorSparkSqlDataSet;
import com.geoway.atlas.dataset.vector.spark.manager.VectorSparkDataManager$;
import com.geoway.atlas.dataset.vector.spark.utils.VectorSparkSqlDataSetUtils$;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorStatistic;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorStatistic$;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructField;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class VectorSparkDataApi$ {
    public static VectorSparkDataApi$ MODULE$;

    static {
        new VectorSparkDataApi$();
    }

    public void loadVectorData(AtlasDataName dataName, Option<Map<String, String>> dataLabel, String dataStoreFormat, Map<String, String> loadParams) {
        StructField geoField;
        String viewName = DataManager$.MODULE$.getViewName(new AtlasDataTag(dataName, dataLabel), DataManager$.MODULE$.getViewName$default$2());
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        SparkRuntime$.MODULE$.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(215).append("\n         |create temporary view ").append(viewName).append(" using atlas\n         |OPTIONS (\n         |atlas.sql.view.data.name '").append(dataName).append("',\n         |atlas.sql.view.data.label '").append((Object)(dataLabel.isDefined() ? StringUtils.replace((String)Serialization$.MODULE$.write(dataLabel.get(), (Formats)formats), (String)"'", (String)"''") : "")).append("',\n         |atlas.dataStore.format '").append(dataStoreFormat).append("',\n         |").append(((TraversableOnce)loadParams.map((Function1 & Serializable & scala.Serializable)tuple -> new StringBuilder(3).append(tuple._1()).append(" '").append(StringUtils.replaceEach((String)((String)tuple._2()), (String[])((String[])((Object[])new String[]{"\\", "'"})), (String[])((String[])((Object[])new String[]{"\\\\", "\\'"})))).append("'").toString(), Iterable$.MODULE$.canBuildFrom())).mkString(",")).append("\n         |)\n         |").toString())).stripMargin());
        ObjectRef totalDataLabel = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.DATA_TYPE()), (Object)DataManager.DataType$.MODULE$.TABLE())}))));
        dataLabel.foreach((Function1 & Serializable & scala.Serializable)m -> {
            totalDataLabel.elem = ((Map)totalDataLabel.elem).$plus$plus((GenTraversableOnce)m);
            return BoxedUnit.UNIT;
        });
        Dataset df = SparkRuntime$.MODULE$.getSparkSession().table(viewName);
        VectorSparkSqlDataSet sqlDataSet = new VectorSparkSqlDataSet(null, dataName, SparkRuntime$.MODULE$.getSparkSession().table(viewName));
        Option geoFieldOpt = VectorSparkSqlDataSetUtils$.MODULE$.RichStructType(df.schema()).getGeomField();
        Geometry geoRange = null;
        if (geoFieldOpt.isDefined() && (geoField = df.schema().apply((String)geoFieldOpt.get())).metadata().contains(package.spatialOpt$.MODULE$.SELECT_RANGE())) {
            geoRange = WktUtils$.MODULE$.read(geoField.metadata().getString(package.spatialOpt$.MODULE$.SELECT_RANGE()));
        }
        if (geoRange != null) {
            AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic((AtlasVectorStatistic)sqlDataSet).setRangeStat((String)geoFieldOpt.get(), geoRange);
        }
        DataManager$.MODULE$.register((AtlasDataSet)sqlDataSet, (Option)new Some((Object)((Map)totalDataLabel.elem)));
    }

    public void saveVectorData(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOpts, String dataStoreFormat, Map<String, String> saveParams) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Tuple2 tuple2 = atlasParams.extractUrlParams(saveParams);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataName storageName = (AtlasDataName)tuple2._1();
        Map nSaveParams = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storageName, (Object)nSaveParams);
        Tuple2 tuple23 = tuple22;
        AtlasDataName storageName2 = (AtlasDataName)tuple23._1();
        Map nSaveParams2 = (Map)tuple23._2();
        String rddName = !StringUtils.equalsIgnoreCase((CharSequence)dataStoreFormat, (CharSequence)GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT()) ? AtlasDataParams$.MODULE$.RichDataParams(saveParams).getDataUrl() : GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT();
        this.saveVectorData(atlasDataName, matchLabelOpts, storageName2, dataStoreFormat, (Map<String, String>)nSaveParams2, rddName);
    }

    public void loadVectorData(AtlasDataName dataName, Option<Map<String, String>> dataLabel, AtlasDataName storageDataName, String dataStoreFormat, Map<String, String> loadParams) {
        this.loadVectorData(dataName, dataLabel, storageDataName, dataStoreFormat, loadParams, null);
    }

    public void loadVectorData(AtlasDataName dataName, Option<Map<String, String>> dataLabel, AtlasDataName storageDataName, String dataStoreFormat, Map<String, String> loadParams, String rddName) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        ObjectRef atlasDataStore = ObjectRef.create(null);
        atlasDataStore.elem = AtlasDataHub$.MODULE$.getAtlasDataStore(dataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.SPARK_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Map connectParams = atlasParams.extractConnectParams(loadParams);
        Map schemaParams = atlasParams.extractGetSchemaParams(loadParams);
        Map partitionParams = atlasParams.extractReadParams(loadParams);
        ((AtlasDataStore)atlasDataStore.elem).connection(connectParams);
        Map storageParams = ((AtlasDataStore)atlasDataStore.elem).getStorageInfo().getStorageParams();
        Map daoFactoryParams = ((AtlasDataStore)atlasDataStore.elem).getStorageInfo().getDaoFactoryParams();
        ObjectRef atlasSchema = ObjectRef.create(null);
        AtlasDataModelRDao dao = null;
        try {
            AtlasTimer$.MODULE$.costTime("\u751f\u6210schema\u8017\u65f6", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                atlasSchema$1.elem = ((AtlasDataStore)atlasDataStore$1.elem).getSchema(storageDataName, dataName, schemaParams);
            });
            dao = ((AtlasDataStore)atlasDataStore.elem).getAtlasDataModelReadDao((AtlasSchema)atlasSchema.elem, partitionParams);
        }
        finally {
            ((AtlasDataStore)atlasDataStore.elem).close();
        }
        VectorSparkProvider sparkProvider = VectorSparkProvider$.MODULE$.apply(SparkRuntime$.MODULE$.getSparkContext(), (AtlasVectorSchema)((AtlasSchema)atlasSchema.elem), rddName);
        String string = ((AtlasSchema)atlasSchema.elem).getDataType();
        String string2 = DataManager.DataType$.MODULE$.VECTOR();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            AtlasDataSet dataSet = sparkProvider.provideData(null, dao, partitionParams.$plus$plus((GenTraversableOnce)storageParams).$plus$plus((GenTraversableOnce)daoFactoryParams), ClassTag$.MODULE$.apply(SimpleFeature.class));
            ObjectRef totalDataLabel = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.DATA_TYPE()), (Object)DataManager.DataType$.MODULE$.VECTOR())}))));
            dataLabel.foreach((Function1 & Serializable & scala.Serializable)m -> {
                totalDataLabel.elem = ((Map)totalDataLabel.elem).$plus$plus((GenTraversableOnce)m);
                return BoxedUnit.UNIT;
            });
            DataManager$.MODULE$.register(dataSet, (Option)new Some((Object)((Map)totalDataLabel.elem)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = DataManager.DataType$.MODULE$.NORMAL();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                AtlasDataSet dataSet = sparkProvider.provideData(null, dao, partitionParams.$plus$plus((GenTraversableOnce)storageParams).$plus$plus((GenTraversableOnce)daoFactoryParams), ClassTag$.MODULE$.apply(SimpleFeature.class));
                ObjectRef totalDataLabel = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.DATA_TYPE()), (Object)DataManager.DataType$.MODULE$.NORMAL())}))));
                dataLabel.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    totalDataLabel.elem = ((Map)totalDataLabel.elem).$plus$plus((GenTraversableOnce)m);
                    return BoxedUnit.UNIT;
                });
                DataManager$.MODULE$.register(dataSet, (Option)new Some((Object)((Map)totalDataLabel.elem)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = DataManager.DataType$.MODULE$.RASTER();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    String x$4 = "\u6682\u672a\u5b9e\u73b0\u5f53\u524d\u65b9\u6cd5!";
                    Thread x$5 = NotSupportException$.MODULE$.apply$default$2(x$4);
                    int x$6 = NotSupportException$.MODULE$.apply$default$3(x$4);
                    throw new NotSupportException(x$4, x$5, x$6);
                }
                throw new MatchError((Object)string);
            }
        }
        sparkProvider.afterRead(dao);
    }

    public void saveVectorData(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOpts, AtlasDataName storageName, String dataStoreFormat, Map<String, String> saveParams) {
        this.saveVectorData(atlasDataName, matchLabelOpts, storageName, dataStoreFormat, saveParams, null);
    }

    public void saveVectorData(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOpts, AtlasDataName storageName, String dataStoreFormat, Map<String, String> saveParams, String rddName) {
        Tuple2 tuple2 = VectorSparkDataManager$.MODULE$.getOrCreateVectorOrNormal(atlasDataName, matchLabelOpts);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataSet atlasDataSet = (AtlasDataSet)tuple2._1();
        Option dataLabel = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)atlasDataSet, (Object)dataLabel);
        Tuple2 tuple23 = tuple22;
        AtlasDataSet atlasDataSet2 = (AtlasDataSet)tuple23._1();
        Option dataLabel2 = (Option)tuple23._2();
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataStore atlasDataStore = AtlasDataHub$.MODULE$.getAtlasDataStore(dataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.SPARK_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasSystemProperties$.MODULE$.ATLAS_FRAMEWORK()), (Object)AtlasSystemProperties$.MODULE$.SPARK_FRAMEWORK())}))));
        Map connectParams = atlasParams.extractConnectParams(saveParams);
        Map createSchemaParams = atlasParams.extractCreateSchemaParams(saveParams);
        Map writeParams = atlasParams.extractWriteParams(saveParams);
        boolean isAppend = atlasParams.isAppend(saveParams);
        atlasDataStore.connection(connectParams);
        Map storageParams = atlasDataStore.getStorageInfo().getStorageParams();
        Map daoFactoryParams = atlasDataStore.getStorageInfo().getDaoFactoryParams();
        AtlasDataModelWDao dao = null;
        try {
            AtlasSchema createSchema = null;
            VectorSparkDataApi$ vectorSparkDataApi$ = this;
            synchronized (vectorSparkDataApi$) {
                AtlasSchema atlasSchema;
                if (isAppend && atlasDataStore.getStorageInfo().existSchema(storageName)) {
                    Map readSchemaParams = atlasParams.extractReadParams(saveParams);
                    atlasSchema = atlasDataStore.getSchema(storageName, atlasDataSet2.getAtlasSchema().getDataName(), readSchemaParams);
                } else {
                    atlasSchema = atlasDataSet2.getAtlasSchema();
                }
                createSchema = atlasSchema;
                atlasDataStore.createSchema(createSchema, storageName, createSchemaParams);
            }
            dao = atlasDataStore.getAtlasDataModelWriteDao(storageName, atlasDataSet2.getAtlasSchema(), createSchema);
        }
        finally {
            atlasDataStore.close();
        }
        VectorSparkProvider sparkProvider = VectorSparkProvider$.MODULE$.apply(SparkRuntime$.MODULE$.getSparkContext(), (AtlasVectorSchema)atlasDataSet2.getAtlasSchema(), rddName);
        AtlasResultMetadata resultMetadata = null;
        try {
            resultMetadata = sparkProvider.saveData(atlasDataSet2, dao, storageParams.$plus$plus((GenTraversableOnce)daoFactoryParams).$plus$plus((GenTraversableOnce)writeParams), ClassTag$.MODULE$.apply(SimpleFeature.class));
        }
        catch (Throwable throwable) {
            try {
                sparkProvider.afterSave(dao, atlasDataSet2, resultMetadata, ClassTag$.MODULE$.apply(SimpleFeature.class));
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            sparkProvider.afterSave(dao, atlasDataSet2, resultMetadata, ClassTag$.MODULE$.apply(SimpleFeature.class));
        }
        catch (Throwable throwable) {}
    }

    private VectorSparkDataApi$() {
        MODULE$ = this;
    }
}

