/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.standalone.common.api;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.error.CancelOpException;
import com.geoway.atlas.common.error.CancelOpException$;
import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.common.error.IoException$;
import com.geoway.atlas.common.error.NotEqualException;
import com.geoway.atlas.common.error.NotEqualException$;
import com.geoway.atlas.common.utils.UUIDUtils$;
import com.geoway.atlas.data.common.data.AtlasDataHub$;
import com.geoway.atlas.data.common.data.AtlasDataModelDao$;
import com.geoway.atlas.data.common.data.AtlasDataModelRDao;
import com.geoway.atlas.data.common.data.AtlasDataModelWDao;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.common.data.AtlasDataName$;
import com.geoway.atlas.data.common.data.AtlasDataStore;
import com.geoway.atlas.data.common.data.AtlasDataStore$;
import com.geoway.atlas.data.common.dataset.AtlasDataSet;
import com.geoway.atlas.data.common.dataset.AtlasResultMetadata;
import com.geoway.atlas.data.common.schema.AtlasSchema;
import com.geoway.atlas.data.common.storage.AtlasDataParams;
import com.geoway.atlas.data.common.storage.AtlasDataParams$;
import com.geoway.atlas.data.vector.geojson.datastore.GeoJsonAtlasDataStore$;
import com.geoway.atlas.dataset.common.manager.DataManager$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.standalone.VectorStandaloneDataSet;
import com.geoway.atlas.dataset.vector.standalone.VectorStandaloneProvider;
import com.geoway.atlas.dataset.vector.standalone.VectorStandaloneProvider$;
import com.geoway.atlas.dataset.vector.standalone.runnable.RunningTaskInfo;
import com.geoway.atlas.dataset.vector.standalone.runnable.RunningTaskInfo$;
import com.geoway.atlas.dataset.vector.standalone.runnable.TransRunnable;
import com.geoway.atlas.dataset.vector.standalone.runnable.TransRunnable$;
import com.geoway.atlas.dataset.vector.standalone.runnable.WriteRunningTaskInfo;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class VectorStandaloneDataApi$ {
    public static VectorStandaloneDataApi$ MODULE$;

    static {
        new VectorStandaloneDataApi$();
    }

    public void loadVectorData(AtlasDataName dataName, Option<Map<String, String>> dataLabel, String dataStoreFormat, Map<String, String> loadParams) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Tuple2 tuple2 = atlasParams.extractUrlParams(loadParams);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataName storageName = (AtlasDataName)tuple2._1();
        Map nLoadParams = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storageName, (Object)nLoadParams);
        Tuple2 tuple23 = tuple22;
        AtlasDataName storageName2 = (AtlasDataName)tuple23._1();
        Map nLoadParams2 = (Map)tuple23._2();
        String dataLogName = !StringUtils.equalsIgnoreCase((CharSequence)dataStoreFormat, (CharSequence)GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT()) ? AtlasDataParams$.MODULE$.RichDataParams(loadParams).getDataUrl() : GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT();
        this.loadVectorData(dataName, dataLabel, storageName2, dataStoreFormat, (Map<String, String>)nLoadParams2, dataLogName);
    }

    public void loadVectorData(AtlasDataName dataName, Option<Map<String, String>> dataLabel, AtlasDataName storageDataName, String dataStoreFormat, Map<String, String> loadParams) {
        this.loadVectorData(dataName, dataLabel, storageDataName, dataStoreFormat, loadParams, null);
    }

    private void loadVectorData(AtlasDataName dataName, Option<Map<String, String>> dataLabel, AtlasDataName storageDataName, String dataStoreFormat, Map<String, String> loadParams, String dataLogName) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataStore atlasDataStore = AtlasDataHub$.MODULE$.getAtlasDataStore(dataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.STANDALONE_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Map connectParams = atlasParams.extractConnectParams(loadParams);
        Map schemaParams = atlasParams.extractGetSchemaParams(loadParams);
        Map partitionParams = atlasParams.extractReadParams(loadParams);
        atlasDataStore.connection(connectParams);
        Map storageParams = atlasDataStore.getStorageInfo().getStorageParams();
        Map daoFactoryParams = atlasDataStore.getStorageInfo().getDaoFactoryParams();
        AtlasSchema atlasSchema = atlasDataStore.getSchema(storageDataName, dataName, schemaParams);
        AtlasDataModelRDao dao = atlasDataStore.getAtlasDataModelReadDao(atlasSchema, partitionParams);
        atlasDataStore.close();
        VectorStandaloneProvider standaloneProvider = VectorStandaloneProvider$.MODULE$.apply((AtlasVectorSchema)atlasSchema);
        VectorStandaloneDataSet dataSet = standaloneProvider.provideData(null, dao, partitionParams, ClassTag$.MODULE$.apply(SimpleFeature.class));
        DataManager$.MODULE$.register((AtlasDataSet)dataSet, dataLabel);
        standaloneProvider.afterRead(dao);
    }

    private Tuple2<AtlasDataModelRDao, VectorStandaloneDataSet<Envelope, String, SimpleFeature>> loadVectorData(String dataStoreFormat, Map<String, String> loadParams, AtlasDataStore loadAtlasDataStore) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Tuple2 tuple2 = atlasParams.extractUrlParams(loadParams);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataName storageName = (AtlasDataName)tuple2._1();
        Map nLoadParams = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storageName, (Object)nLoadParams);
        Tuple2 tuple23 = tuple22;
        AtlasDataName storageName2 = (AtlasDataName)tuple23._1();
        Map nLoadParams2 = (Map)tuple23._2();
        String dataLogName = !StringUtils.equalsIgnoreCase((CharSequence)dataStoreFormat, (CharSequence)GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT()) ? AtlasDataParams$.MODULE$.RichDataParams(loadParams).getDataUrl() : GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT();
        return this.loadVectorData(storageName2, dataStoreFormat, (Map<String, String>)nLoadParams2, dataLogName, loadAtlasDataStore);
    }

    private Tuple2<AtlasDataModelRDao, VectorStandaloneDataSet<Envelope, String, SimpleFeature>> loadVectorData(AtlasDataName storageDataName, String dataStoreFormat, Map<String, String> loadParams, String dataLogName, AtlasDataStore loadAtlasDataStore) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataStore atlasDataStore = loadAtlasDataStore != null ? loadAtlasDataStore : AtlasDataHub$.MODULE$.getAtlasDataStore(dataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.STANDALONE_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Map connectParams = atlasParams.extractConnectParams(loadParams);
        Map schemaParams = atlasParams.extractGetSchemaParams(loadParams);
        Map partitionParams = atlasParams.extractReadParams(loadParams);
        if (loadAtlasDataStore == null) {
            atlasDataStore.connection(connectParams);
        }
        Map storageParams = atlasDataStore.getStorageInfo().getStorageParams();
        Map daoFactoryParams = atlasDataStore.getStorageInfo().getDaoFactoryParams();
        AtlasSchema atlasSchema = atlasDataStore.getSchema(storageDataName, AtlasDataName$.MODULE$.getTempDataName(), schemaParams);
        AtlasDataModelRDao dao = atlasDataStore.getAtlasDataModelReadDao(atlasSchema, partitionParams);
        if (loadAtlasDataStore == null) {
            atlasDataStore.close();
        }
        VectorStandaloneProvider standaloneProvider = VectorStandaloneProvider$.MODULE$.apply((AtlasVectorSchema)atlasSchema);
        VectorStandaloneDataSet dataSet = standaloneProvider.provideData(null, dao, partitionParams, ClassTag$.MODULE$.apply(SimpleFeature.class));
        return new Tuple2((Object)dao, (Object)dataSet);
    }

    public void saveVectorData(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOpts, String dataStoreFormat, Map<String, String> saveParams) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Tuple2 tuple2 = atlasParams.extractUrlParams(saveParams);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataName storageName = (AtlasDataName)tuple2._1();
        Map nSaveParams = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storageName, (Object)nSaveParams);
        Tuple2 tuple23 = tuple22;
        AtlasDataName storageName2 = (AtlasDataName)tuple23._1();
        Map nSaveParams2 = (Map)tuple23._2();
        String dataLogName = !StringUtils.equalsIgnoreCase((CharSequence)dataStoreFormat, (CharSequence)GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT()) ? AtlasDataParams$.MODULE$.RichDataParams(saveParams).getDataUrl() : GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT();
        this.saveVectorData(atlasDataName, matchLabelOpts, storageName2, dataStoreFormat, (Map<String, String>)nSaveParams2, dataLogName);
    }

    public void saveVectorData(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOpts, AtlasDataName storageName, String dataStoreFormat, Map<String, String> saveParams) {
        this.saveVectorData(atlasDataName, matchLabelOpts, storageName, dataStoreFormat, saveParams, null);
    }

    private void saveVectorData(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOpts, AtlasDataName storageName, String dataStoreFormat, Map<String, String> saveParams, String dataLogName) {
        AtlasSchema atlasSchema;
        Tuple2 tuple2 = DataManager$.MODULE$.get(atlasDataName, matchLabelOpts);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataSet atlasDataSet = (AtlasDataSet)tuple2._1();
        Option dataLabel = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)atlasDataSet, (Object)dataLabel);
        Tuple2 tuple23 = tuple22;
        AtlasDataSet atlasDataSet2 = (AtlasDataSet)tuple23._1();
        Option dataLabel2 = (Option)tuple23._2();
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataStore atlasDataStore = AtlasDataHub$.MODULE$.getAtlasDataStore(dataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.STANDALONE_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Map connectParams = atlasParams.extractConnectParams(saveParams);
        Map createSchemaParams = atlasParams.extractCreateSchemaParams(saveParams);
        Map writeParams = atlasParams.extractWriteParams(saveParams);
        boolean isAppend = atlasParams.isAppend(saveParams);
        atlasDataStore.connection(connectParams);
        if (isAppend) {
            Map readSchemaParams = atlasParams.extractReadParams(saveParams);
            atlasSchema = atlasDataStore.getSchema(storageName, atlasDataSet2.getAtlasSchema().getDataName(), readSchemaParams);
        } else {
            atlasSchema = atlasDataSet2.getAtlasSchema();
        }
        AtlasSchema createSchema = atlasSchema;
        atlasDataStore.createSchema(createSchema, storageName, createSchemaParams);
        AtlasDataModelWDao dao = atlasDataStore.getAtlasDataModelWriteDao(storageName, atlasDataSet2.getAtlasSchema(), createSchema);
        Map storageParams = atlasDataStore.getStorageInfo().getStorageParams();
        Map daoFactoryParams = atlasDataStore.getStorageInfo().getDaoFactoryParams();
        atlasDataStore.close();
        VectorStandaloneProvider standaloneProvider = VectorStandaloneProvider$.MODULE$.apply((AtlasVectorSchema)atlasDataSet2.getAtlasSchema());
        AtlasResultMetadata resultMetadata = standaloneProvider.saveData(atlasDataSet2, dao, storageParams.$plus$plus((GenTraversableOnce)daoFactoryParams).$plus$plus((GenTraversableOnce)writeParams), ClassTag$.MODULE$.apply(SimpleFeature.class));
        standaloneProvider.afterSave(dao, atlasDataSet2, resultMetadata, ClassTag$.MODULE$.apply(SimpleFeature.class));
    }

    private void saveVectorData(VectorStandaloneDataSet<Envelope, String, SimpleFeature> atlasDataSet, String dataStoreFormat, Map<String, String> saveParams, AtlasDataStore saveAtlasDataStore, ExecutorService executorService, WriteRunningTaskInfo runningTaskInfo) {
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Tuple2 tuple2 = atlasParams.extractUrlParams(saveParams);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataName storageName = (AtlasDataName)tuple2._1();
        Map nSaveParams = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storageName, (Object)nSaveParams);
        Tuple2 tuple23 = tuple22;
        AtlasDataName storageName2 = (AtlasDataName)tuple23._1();
        Map nSaveParams2 = (Map)tuple23._2();
        String dataLogName = !StringUtils.equalsIgnoreCase((CharSequence)dataStoreFormat, (CharSequence)GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT()) ? AtlasDataParams$.MODULE$.RichDataParams(saveParams).getDataUrl() : GeoJsonAtlasDataStore$.MODULE$.GEOJSON_STORAGE_FORMAT();
        this.saveVectorData(atlasDataSet, storageName2, dataStoreFormat, (Map<String, String>)nSaveParams2, dataLogName, saveAtlasDataStore, executorService, runningTaskInfo);
    }

    private void saveVectorData(VectorStandaloneDataSet<Envelope, String, SimpleFeature> atlasDataSet, AtlasDataName storageName, String dataStoreFormat, Map<String, String> saveParams, String dataLogName, AtlasDataStore saveAtlasDataStore, ExecutorService executorService, WriteRunningTaskInfo runningTaskInfo) {
        AtlasSchema atlasSchema;
        Map dataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)dataStoreFormat)}));
        AtlasDataStore atlasDataStore = saveAtlasDataStore != null ? saveAtlasDataStore : AtlasDataHub$.MODULE$.getAtlasDataStore(dataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.STANDALONE_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        AtlasDataParams atlasParams = AtlasDataParams$.MODULE$.apply(dataStoreParams);
        Map connectParams = atlasParams.extractConnectParams(saveParams);
        Map createSchemaParams = atlasParams.extractCreateSchemaParams(saveParams);
        Map writeParams = atlasParams.extractWriteParams(saveParams);
        boolean isAppend = atlasParams.isAppend(saveParams);
        if (saveAtlasDataStore == null) {
            atlasDataStore.connection(connectParams);
        }
        if (isAppend) {
            Map readSchemaParams = atlasParams.extractReadParams(saveParams);
            atlasSchema = atlasDataStore.getSchema(storageName, atlasDataSet.getAtlasSchema().getDataName(), readSchemaParams);
        } else {
            atlasSchema = atlasDataSet.getAtlasSchema();
        }
        AtlasSchema createSchema = atlasSchema;
        atlasDataStore.createSchema(createSchema, storageName, createSchemaParams);
        AtlasDataModelWDao dao = atlasDataStore.getAtlasDataModelWriteDao(storageName, atlasDataSet.getAtlasSchema(), createSchema);
        Map storageParams = atlasDataStore.getStorageInfo().getStorageParams();
        Map daoFactoryParams = atlasDataStore.getStorageInfo().getDaoFactoryParams();
        if (saveAtlasDataStore == null) {
            atlasDataStore.close();
        }
        VectorStandaloneProvider standaloneProvider = VectorStandaloneProvider$.MODULE$.apply((AtlasVectorSchema)atlasDataSet.getAtlasSchema(), executorService, runningTaskInfo);
        AtlasResultMetadata resultMetadata = null;
        try {
            try {
                resultMetadata = standaloneProvider.saveData(atlasDataSet, dao, storageParams.$plus$plus((GenTraversableOnce)daoFactoryParams).$plus$plus((GenTraversableOnce)writeParams), ClassTag$.MODULE$.apply(SimpleFeature.class));
            }
            catch (Throwable throwable) {
                Object object;
                if (!isAppend) {
                    if (saveAtlasDataStore == null) {
                        atlasDataStore.connection(connectParams);
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)atlasDataStore.getStorageInfo().deleteSchema(storageName));
                } else {
                    object = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            try {
                standaloneProvider.afterSave(dao, atlasDataSet, resultMetadata, ClassTag$.MODULE$.apply(SimpleFeature.class));
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            standaloneProvider.afterSave(dao, atlasDataSet, resultMetadata, ClassTag$.MODULE$.apply(SimpleFeature.class));
        }
        catch (Throwable throwable) {}
    }

    public void transformData(String loadDataStoreFormat, Map<String, String> loadParams, AtlasDataStore loadAtlasDataStore, String saveDataStoreFormat, Map<String, String> saveParams, AtlasDataStore saveAtlasDataStore, ExecutorService executorService, RunningTaskInfo runningTaskInfo) {
        Map loadDataStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)loadDataStoreFormat)}));
        AtlasDataParams loadAtlasParams = AtlasDataParams$.MODULE$.apply(loadDataStoreParams);
        Tuple2 tuple2 = loadAtlasParams.extractUrlParams(loadParams);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AtlasDataName loadStorageName = (AtlasDataName)tuple2._1();
        Map nLoadParams = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)loadStorageName, (Object)nLoadParams);
        Tuple2 tuple23 = tuple22;
        AtlasDataName loadStorageName2 = (AtlasDataName)tuple23._1();
        Map nLoadParams2 = (Map)tuple23._2();
        AtlasDataStore lAtlasDataStore = loadAtlasDataStore != null ? loadAtlasDataStore : AtlasDataHub$.MODULE$.getAtlasDataStore(loadDataStoreParams);
        String atlasFramework = AtlasSystemProperties$.MODULE$.getFramework();
        if (!AtlasSystemProperties$.MODULE$.STANDALONE_FRAMEWORK().equals(atlasFramework)) {
            String x$1 = "\u8bbe\u7f6e\u7684\u8ba1\u7b97\u6846\u67b6\u4e0e\u5f53\u524d\u7684\u8ba1\u7b97\u6846\u67b6\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!";
            Thread x$2 = NotEqualException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotEqualException$.MODULE$.apply$default$3(x$1);
            throw new NotEqualException(x$1, x$2, x$3);
        }
        Map loadConnParams = loadAtlasParams.extractConnectParams(nLoadParams2);
        Map loadSchemaParams = loadAtlasParams.extractGetSchemaParams(nLoadParams2);
        Map loadPartParams = loadAtlasParams.extractReadParams(nLoadParams2);
        if (loadAtlasDataStore == null) {
            lAtlasDataStore.connection(loadConnParams);
        }
        AtlasSchema loadAtlasSchema = lAtlasDataStore.getSchema(loadStorageName2, AtlasDataName$.MODULE$.getTempDataName(), loadSchemaParams);
        AtlasDataModelRDao loadDao = lAtlasDataStore.getAtlasDataModelReadDao(loadAtlasSchema, loadPartParams);
        if (loadAtlasDataStore == null) {
            lAtlasDataStore.close();
        }
        ObjectRef loadQueryParams = ObjectRef.create((Object)loadDao.partition(null, loadPartParams));
        Map taskInfoMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataModelDao$.MODULE$.DATA_TASK_ID()), (Object)UUIDUtils$.MODULE$.getUUID())}));
        loadQueryParams.elem = (Map[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Map[])loadQueryParams.elem))).map((Function1 & Serializable & scala.Serializable)x$7 -> taskInfoMap.$plus$plus((GenTraversableOnce)x$7), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)));
        Map saveStoreParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataStore$.MODULE$.DATA_STORE_FORMAT()), (Object)saveDataStoreFormat)}));
        AtlasDataParams saveAtlasParams = AtlasDataParams$.MODULE$.apply(saveStoreParams);
        Tuple2 tuple24 = saveAtlasParams.extractUrlParams(saveParams);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        AtlasDataName saveStorageName = (AtlasDataName)tuple24._1();
        Map nSaveParams = (Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)saveStorageName, (Object)nSaveParams);
        Tuple2 tuple26 = tuple25;
        AtlasDataName saveStorageName2 = (AtlasDataName)tuple26._1();
        Map nSaveParams2 = (Map)tuple26._2();
        AtlasDataStore sAtlasDataStore = saveAtlasDataStore != null ? saveAtlasDataStore : AtlasDataHub$.MODULE$.getAtlasDataStore(saveStoreParams);
        Map saveConnParams = saveAtlasParams.extractConnectParams(nSaveParams2);
        Map createSchemaParams = saveAtlasParams.extractCreateSchemaParams(nSaveParams2);
        Map writeParams = saveAtlasParams.extractWriteParams(nSaveParams2);
        boolean isAppend = saveAtlasParams.isAppend(nSaveParams2);
        if (saveAtlasDataStore == null) {
            sAtlasDataStore.connection(saveConnParams);
        }
        VectorStandaloneDataSet loadDataset = new VectorStandaloneDataSet(null, (AtlasVectorSchema)loadAtlasSchema, (Iterator[])Array$.MODULE$.fill(((Map[])loadQueryParams.elem).length, (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().empty(), ClassTag$.MODULE$.apply(Iterator.class)), ClassTag$.MODULE$.apply(SimpleFeature.class));
        ObjectRef saveDao = ObjectRef.create(null);
        AtlasResultMetadata resultMetadata = null;
        try {
            try {
                AtlasSchema atlasSchema;
                if (isAppend) {
                    Map readSchemaParams = saveAtlasParams.extractReadParams(nSaveParams2);
                    atlasSchema = sAtlasDataStore.getSchema(saveStorageName2, loadAtlasSchema.getDataName(), readSchemaParams);
                } else {
                    atlasSchema = loadAtlasSchema;
                }
                AtlasSchema createSchema = atlasSchema;
                sAtlasDataStore.createSchema(createSchema, saveStorageName2, createSchemaParams);
                saveDao.elem = sAtlasDataStore.getAtlasDataModelWriteDao(saveStorageName2, loadAtlasSchema, createSchema);
                Map storageParams = sAtlasDataStore.getStorageInfo().getStorageParams();
                Map daoFactoryParams = sAtlasDataStore.getStorageInfo().getDaoFactoryParams();
                ObjectRef errorCount = ObjectRef.create((Object)new AtomicInteger(0));
                ObjectRef saveDataParams = ObjectRef.create((Object)((AtlasDataModelWDao)saveDao.elem).partition((AtlasDataSet)loadDataset, storageParams.$plus$plus((GenTraversableOnce)daoFactoryParams).$plus$plus((GenTraversableOnce)writeParams)));
                saveDataParams.elem = (Seq)((Seq)saveDataParams.elem).map((Function1 & Serializable & scala.Serializable)x$9 -> taskInfoMap.$plus$plus((GenTraversableOnce)x$9), Seq$.MODULE$.canBuildFrom());
                AtlasResultMetadata[] resultMetadatas = new AtlasResultMetadata[((Seq)saveDataParams.elem).length()];
                TransRunnable[] runnables = new TransRunnable[((Seq)saveDataParams.elem).length()];
                Future[] futures = new Future[((Seq)saveDataParams.elem).length()];
                saveDataParams.elem = (Seq)((Seq)saveDataParams.elem).map((Function1 & Serializable & scala.Serializable)x$10 -> taskInfoMap.$plus$plus((GenTraversableOnce)x$10), Seq$.MODULE$.canBuildFrom());
                CountDownLatch countDownLatch = new CountDownLatch(((Seq)saveDataParams.elem).length());
                BooleanRef isSaveToOne = BooleanRef.create((boolean)false);
                if (((Seq)saveDataParams.elem).length() != ((Map[])loadQueryParams.elem).length) {
                    if (((Seq)saveDataParams.elem).length() != 1) {
                        String x$4 = "\u4fdd\u5b58\u7ebf\u7a0b\u4e0e\u8bfb\u53d6\u7ebf\u7a0b\u4e0d\u7b49\uff0c\u4e14\u4fdd\u5b58\u7ebf\u7a0b\u4e0d\u7b49\u4e8e1!";
                        Thread x$5 = NotEqualException$.MODULE$.apply$default$2(x$4);
                        int x$6 = NotEqualException$.MODULE$.apply$default$3(x$4);
                        throw new NotEqualException(x$4, x$5, x$6);
                    }
                    isSaveToOne.elem = true;
                }
                ((Seq)saveDataParams.elem).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionIndex -> {
                    Map[] loadPartitionParam = isSaveToOne$1.elem ? (Map[])loadQueryParams$1.elem : (Map[])((Object[])new Map[]{((Map[])loadQueryParams$1.elem)[partitionIndex]});
                    Map savePartitionParam = (Map)((Seq)saveDataParams$1.elem).apply(partitionIndex);
                    TransRunnable transRunnable = TransRunnable$.MODULE$.apply(loadDao, loadPartitionParam, !isAppend, partitionIndex, resultMetadatas, (AtlasDataModelWDao)saveDao$1.elem, savePartitionParam, countDownLatch, (AtomicInteger)errorCount$1.elem);
                    Future<?> future = executorService.submit((Runnable)transRunnable);
                    runnables$1[partitionIndex] = transRunnable;
                    futures$1[partitionIndex] = future;
                });
                Object object = runningTaskInfo != null ? RunningTaskInfo$.MODULE$.setTaskInfo(runningTaskInfo, futures, runnables, (AtomicInteger)errorCount.elem, countDownLatch) : BoxedUnit.UNIT;
                countDownLatch.await();
                if (((AtomicInteger)errorCount.elem).get() > 0) {
                    String x$72 = "\u5199\u5165\u6570\u636e\u65f6\u53d1\u751f\u4e00\u4e2a\u6216\u591a\u4e2a\u9519\u8bef!";
                    Thread x$8 = IoException$.MODULE$.apply$default$2(x$72);
                    int x$92 = IoException$.MODULE$.apply$default$3(x$72);
                    throw new IoException(x$72, x$8, x$92);
                }
                if (runningTaskInfo != null && runningTaskInfo.getProcessInfo().waitTask() != 0) {
                    String x$102 = "\u4efb\u52a1\u88ab\u624b\u52a8\u505c\u6b62!";
                    Thread x$11 = CancelOpException$.MODULE$.apply$default$2(x$102);
                    int x$12 = CancelOpException$.MODULE$.apply$default$3(x$102);
                    throw new CancelOpException(x$102, x$11, x$12);
                }
                resultMetadata = (AtlasResultMetadata)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resultMetadatas)).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> a.merge(b));
            }
            catch (Throwable throwable) {
                if (!isAppend) {
                    sAtlasDataStore.getStorageInfo().deleteSchema(saveStorageName2);
                    if (saveAtlasDataStore == null) {
                        sAtlasDataStore.close();
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (runningTaskInfo != null) {
                runningTaskInfo.setFinish(true);
            }
            try {
                if ((AtlasDataModelWDao)saveDao.elem != null && resultMetadata != null) {
                    ((AtlasDataModelWDao)saveDao.elem).afterWrite((AtlasDataSet)loadDataset, resultMetadata);
                }
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        if (runningTaskInfo != null) {
            runningTaskInfo.setFinish(true);
        }
        try {
            if ((AtlasDataModelWDao)saveDao.elem != null && resultMetadata != null) {
                ((AtlasDataModelWDao)saveDao.elem).afterWrite((AtlasDataSet)loadDataset, resultMetadata);
            }
        }
        catch (Throwable throwable) {}
    }

    public void transformData(String loadDataStoreFormat, Map<String, String> loadParams, String saveDataStoreFormat, Map<String, String> saveParams) {
        this.transformData(loadDataStoreFormat, loadParams, null, saveDataStoreFormat, saveParams, null, null, null);
    }

    private VectorStandaloneDataApi$() {
        MODULE$ = this;
    }
}

