/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.dataset.vector.common;

import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.common.utils.CollectionUtils$;
import com.geoway.atlas.common.utils.StringUtils$;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.vector.common.feature.sft.SimpleFeatureTypeUtils$;
import com.geoway.atlas.data.vector.common.feature.sft.package$;
import com.geoway.atlas.data.vector.common.jts.JTSUtils$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorAttribute;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchemas$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.FeatureTypes;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class AtlasVectorSchemaUtils$ {
    public static AtlasVectorSchemaUtils$ MODULE$;
    private final String AVS_IDENTITY;

    static {
        new AtlasVectorSchemaUtils$();
    }

    public String AVS_IDENTITY() {
        return this.AVS_IDENTITY;
    }

    public AtlasVectorSchema addIdentity(AtlasVectorSchema avs) {
        return avs;
    }

    public int getIdentity(AtlasVectorSchema avs) {
        if (!avs.getUserData().containsKey(this.AVS_IDENTITY())) {
            String x$1 = "\u672a\u53d1\u73b0\u6570\u636e\u96c6\u7ed3\u6784\u7684\u552f\u4e00\u6807\u8bc6";
            Thread x$2 = NotFoundException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotFoundException$.MODULE$.apply$default$3(x$1);
            throw new NotFoundException(x$1, x$2, x$3);
        }
        return new StringOps(Predef$.MODULE$.augmentString(avs.getUserData().get(this.AVS_IDENTITY()).toString())).toInt();
    }

    public Seq<AttributeDescriptor> distinctAttrDescriptor(Seq<SimpleFeatureType> sfts) {
        Seq allAttributes = (Seq)sfts.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getAttributeDescriptors()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AtlasVectorSchemaUtils$.$anonfun$distinctAttrDescriptor$2(x$2))), Seq$.MODULE$.canBuildFrom());
        Seq attrOrder = (Seq)((SeqLike)allAttributes.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getLocalName().toLowerCase(), Seq$.MODULE$.canBuildFrom())).distinct();
        Map sftMap = allAttributes.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getLocalName().toLowerCase());
        return (Seq)attrOrder.map((Function1 & Serializable & scala.Serializable)descriptorName -> {
            Seq attributeDescriptors = (Seq)sftMap.apply(descriptorName);
            AtlasVectorAttribute atlasVectorAttribute = new AtlasVectorAttribute(null, null, -1, -1, -1, false, new HashMap<Object, Object>(), null);
            attributeDescriptors.aggregate((Function0 & Serializable & scala.Serializable)() -> atlasVectorAttribute, (Function2 & Serializable & scala.Serializable)(mid, attribute) -> {
                mid.mergeDescriptor((AttributeDescriptor)attribute);
                return mid;
            }, (Function2 & Serializable & scala.Serializable)(pre, beh) -> {
                pre.mergeVectorAttribute((AtlasVectorAttribute)beh);
                return pre;
            });
            return SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(descriptorName, atlasVectorAttribute.bind(), atlasVectorAttribute.userdata(), atlasVectorAttribute.defaultValue(), atlasVectorAttribute.fieldLength(), Predef$.MODULE$.int2Integer(atlasVectorAttribute.minOccurs()), Predef$.MODULE$.int2Integer(atlasVectorAttribute.maxOccurs()), atlasVectorAttribute.isNillable());
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void combineMultiSft(AtlasVectorSchema atlasVectorSchema, Option<String> selectColumnsOpt, Option<String> epsgOpt, Option<Geometry> selectRangeOpt, String defaultGeomField) {
        block10: {
            Seq attributeMerges = this.distinctAttrDescriptor(atlasVectorSchema.getSimpleFeatureTypes());
            Seq geoAttributes = (Seq)((SeqLike)((TraversableLike)((TraversableLike)atlasVectorSchema.getSimpleFeatureTypes().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getGeometryDescriptor(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)gd -> BoxesRunTime.boxToBoolean((boolean)AtlasVectorSchemaUtils$.$anonfun$combineMultiSft$2(gd)))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getLocalName().toLowerCase(), Seq$.MODULE$.canBuildFrom())).distinct();
            Seq fieldNames = (Seq)attributeMerges.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getLocalName(), Seq$.MODULE$.canBuildFrom());
            String[] geomFields = StringUtils.isNotEmpty((CharSequence)defaultGeomField) ? (String[])((Object[])new String[]{defaultGeomField}) : new String[1];
            boolean hasShape = true;
            if (selectColumnsOpt.isDefined()) {
                String[] unCheckFieldContainShapes = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)selectColumnsOpt.get()).split(","))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                String[] selectFields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unCheckFieldContainShapes)).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AtlasVectorSchemaUtils$.$anonfun$combineMultiSft$6(s)));
                String[] diffFields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unCheckFieldContainShapes)).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AtlasVectorSchemaUtils$.$anonfun$combineMultiSft$7(s))))).map((Function1 & Serializable & scala.Serializable)s -> StringUtils.substring((String)s, (int)1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectFields)).nonEmpty()) {
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectFields)).intersect((GenSeq)geoAttributes))).isEmpty()) {
                        hasShape = false;
                    }
                } else {
                    selectFields = (String[])fieldNames.toArray(ClassTag$.MODULE$.apply(String.class));
                }
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])diffFields)).nonEmpty()) {
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])diffFields)).intersect((GenSeq)geoAttributes))).nonEmpty()) {
                        hasShape = false;
                    }
                    selectFields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectFields)).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])diffFields));
                }
                String[] unCheckFields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unCheckFieldContainShapes)).diff((GenSeq)geoAttributes);
                attributeMerges = SimpleFeatureTypeUtils$.MODULE$.selectFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])unCheckFields), attributeMerges);
                fieldNames = Predef$.MODULE$.wrapRefArray((Object[])selectFields);
            }
            Seq geometryDescriptors = (Seq)Nil$.MODULE$;
            Geometry range = null;
            if (((FeatureType)atlasVectorSchema.getSimpleFeatureTypes().head()).getGeometryDescriptor() != null) {
                Tuple2 tuple = SimpleFeatureTypeUtils$.MODULE$.distinctGeoDescriptor(StringUtils$.MODULE$.getUniqueStringFromSeq(SimpleFeatureTypeUtils$.MODULE$.SHP_FIELD(), fieldNames), atlasVectorSchema.getSimpleFeatureTypes(), epsgOpt, geomFields, selectRangeOpt);
                geometryDescriptors = (Seq)tuple._1();
                range = (Geometry)tuple._2();
            }
            SimpleFeatureType sft = SimpleFeatureTypeUtils$.MODULE$.createSimpleFeatureType(atlasVectorSchema.getOriginDataName(), hasShape ? (Seq)geometryDescriptors.$plus$plus(attributeMerges, Seq$.MODULE$.canBuildFrom()) : attributeMerges, hasShape ? (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geomFields)).head() : null);
            atlasVectorSchema.setSimpleFeatureType(sft);
            if (!atlasVectorSchema.getSimpleFeatureTypes().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AtlasVectorSchemaUtils$.$anonfun$combineMultiSft$9(x$9)))) {
                long count = BoxesRunTime.unboxToLong((Object)((TraversableOnce)atlasVectorSchema.getSimpleFeatureTypes().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)AtlasVectorSchemaUtils$.$anonfun$combineMultiSft$10(x$10)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).setCount(count);
            }
            if (atlasVectorSchema.getGeometryDescriptor() != null) {
                package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).setGeometryDimension(BoxesRunTime.unboxToInt((Object)((TraversableOnce)atlasVectorSchema.getSimpleFeatureTypes().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)AtlasVectorSchemaUtils$.$anonfun$combineMultiSft$11(x$11)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$)));
            }
            if (selectRangeOpt.isDefined()) {
                package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).setQueryRange((Geometry)selectRangeOpt.get());
            }
            if (range == null) break block10;
            package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).setRange(range);
        }
    }

    public Option<String> combineMultiSft$default$2() {
        return None$.MODULE$;
    }

    public Option<String> combineMultiSft$default$3() {
        return None$.MODULE$;
    }

    public Option<Geometry> combineMultiSft$default$4() {
        return None$.MODULE$;
    }

    public String combineMultiSft$default$5() {
        return null;
    }

    public void setSelectInfo(AtlasVectorSchema atlasVectorSchema, Option<String> selectColumnsOpt, Option<Geometry> selectRangeOpt) {
        block5: {
            SimpleFeatureType oAvs = (SimpleFeatureType)atlasVectorSchema.getSimpleFeatureTypes().head();
            Seq selectAttributeDes = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(oAvs.getAttributeDescriptors()).asScala();
            if (selectColumnsOpt.isDefined()) {
                String[] unCheckFields = ((String)selectColumnsOpt.get()).split(",");
                selectAttributeDes = SimpleFeatureTypeUtils$.MODULE$.selectFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])unCheckFields), selectAttributeDes);
            }
            String geomField = package$.MODULE$.RichSimpleFeatureType(oAvs).getGeomField();
            SimpleFeatureType nSft = SimpleFeatureTypeUtils$.MODULE$.createSimpleFeatureType(atlasVectorSchema.getOriginDataName(), selectAttributeDes, geomField);
            atlasVectorSchema.setSimpleFeatureType(nSft);
            if (package$.MODULE$.RichSimpleFeatureType(oAvs).getCount().nonEmpty()) {
                package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).setCount(BoxesRunTime.unboxToLong((Object)package$.MODULE$.RichSimpleFeatureType(oAvs).getCount().get()));
            }
            if (package$.MODULE$.RichSimpleFeatureType(oAvs).getRange().isDefined()) {
                package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).setRange((Geometry)package$.MODULE$.RichSimpleFeatureType(oAvs).getRange().get());
            } else if (package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).getBBox().isDefined()) {
                package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).setRange(JTSUtils$.MODULE$.toGeometry((Envelope)package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).getBBox().get()));
            }
            if (!selectRangeOpt.isDefined()) break block5;
            package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).setQueryRange((Geometry)selectRangeOpt.get());
        }
    }

    public Option<String> setSelectInfo$default$2() {
        return None$.MODULE$;
    }

    public Option<Geometry> setSelectInfo$default$3() {
        return None$.MODULE$;
    }

    public SimpleFeatureType lowerAttributeName(SimpleFeatureType sft) {
        Buffer ads = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)descriptor -> {
            GeometryDescriptor geometryDescriptor;
            if (descriptor != null) {
                if (StringUtils.isNotEmpty((CharSequence)descriptor.getLocalName())) {
                    GeometryDescriptor geometryDescriptor2;
                    AttributeDescriptor attributeDescriptor = descriptor;
                    if (attributeDescriptor instanceof GeometryDescriptor) {
                        GeometryDescriptor geometryDescriptor3 = (GeometryDescriptor)attributeDescriptor;
                        geometryDescriptor2 = SimpleFeatureTypeUtils$.MODULE$.createGeometryDescriptor(geometryDescriptor3.getLocalName().toLowerCase(), geometryDescriptor3.getUserData(), geometryDescriptor3.getCoordinateReferenceSystem(), null, geometryDescriptor3.getType().getBinding(), false);
                    } else if (attributeDescriptor != null) {
                        AttributeDescriptor attributeDescriptor2 = attributeDescriptor;
                        geometryDescriptor2 = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(attributeDescriptor2.getLocalName().toLowerCase(), attributeDescriptor2.getType().getBinding(), attributeDescriptor2.getUserData(), attributeDescriptor2.getDefaultValue(), FeatureTypes.getFieldLength((PropertyDescriptor)attributeDescriptor2), Predef$.MODULE$.int2Integer(attributeDescriptor2.getMinOccurs()), Predef$.MODULE$.int2Integer(attributeDescriptor2.getMaxOccurs()), attributeDescriptor2.isNillable());
                    } else {
                        throw new MatchError((Object)attributeDescriptor);
                    }
                    geometryDescriptor = geometryDescriptor2;
                } else {
                    geometryDescriptor = null;
                }
            } else {
                geometryDescriptor = null;
            }
            return geometryDescriptor;
        }, Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AtlasVectorSchemaUtils$.$anonfun$lowerAttributeName$2(x$12)));
        SimpleFeatureType newSft = SimpleFeatureTypeUtils$.MODULE$.createSimpleFeatureType(new AtlasDataName(sft.getName().getNamespaceURI(), sft.getName().getLocalPart().toLowerCase()), (Seq)ads, package$.MODULE$.RichSimpleFeatureType(sft).getGeomField().toLowerCase());
        return AtlasVectorSchemas$.MODULE$.decodeSft(AtlasVectorSchemas$.MODULE$.encodeSft(newSft));
    }

    public AtlasVectorSchema addField(AtlasVectorSchema rawAtlasSchema, AtlasDataName newName, Seq<Tuple2<String, Class<?>>> fields) {
        return this.insertFields(rawAtlasSchema, newName, rawAtlasSchema.getAttributeCount(), fields);
    }

    public AtlasVectorSchema insertFields(AtlasVectorSchema rawAtlasSchema, AtlasDataName newName, int position, Seq<Tuple2<String, Class<?>>> fields) {
        AtlasVectorSchema atlasVectorSchema;
        if (CollectionUtils$.MODULE$.nonEmpty(fields)) {
            ArrayBuffer addAttributeDescriptors = new ArrayBuffer();
            fields.indices().foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> AtlasVectorSchemaUtils$.$anonfun$insertFields$1(fields, (Buffer)addAttributeDescriptors, arg_0)));
            ArrayList<AttributeDescriptor> rawDescriptors = new ArrayList<AttributeDescriptor>(rawAtlasSchema.getAttributeDescriptors());
            rawDescriptors.addAll(position, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)addAttributeDescriptors).asJava());
            Buffer attributeDescriptor = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rawDescriptors).asScala();
            SimpleFeatureType innerSft = SimpleFeatureTypeUtils$.MODULE$.createSimpleFeatureType(new AtlasDataName(rawAtlasSchema.getName().getNamespaceURI(), rawAtlasSchema.getName().getLocalPart()), (Seq)attributeDescriptor, package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)rawAtlasSchema).getGeomField());
            AtlasVectorSchema resultSchema = AtlasVectorSchema$.MODULE$.apply(newName);
            resultSchema.setOriginDataName(rawAtlasSchema.dataName());
            resultSchema.setSimpleFeatureType(innerSft);
            atlasVectorSchema = AtlasVectorSchemas$.MODULE$.decode(AtlasVectorSchemas$.MODULE$.encode(resultSchema));
        } else {
            atlasVectorSchema = this.getDuplicate(rawAtlasSchema, newName);
        }
        return atlasVectorSchema;
    }

    public AtlasVectorSchema getDuplicate(AtlasVectorSchema rawAtlasSchema, AtlasDataName newName) {
        AtlasVectorSchema resultSchema = AtlasVectorSchema$.MODULE$.apply(newName);
        resultSchema.setOriginDataName(rawAtlasSchema.dataName());
        resultSchema.setSimpleFeatureType(rawAtlasSchema.getSimpleFeatureType());
        return AtlasVectorSchemas$.MODULE$.decode(AtlasVectorSchemas$.MODULE$.encode(resultSchema));
    }

    public static final /* synthetic */ boolean $anonfun$distinctAttrDescriptor$2(AttributeDescriptor x$2) {
        return x$2 instanceof GeometryDescriptor;
    }

    public static final /* synthetic */ boolean $anonfun$combineMultiSft$2(GeometryDescriptor gd) {
        return gd != null;
    }

    public static final /* synthetic */ boolean $anonfun$combineMultiSft$6(String s) {
        return !StringUtils.startsWith((CharSequence)s, (CharSequence)"!");
    }

    public static final /* synthetic */ boolean $anonfun$combineMultiSft$7(String s) {
        return StringUtils.startsWith((CharSequence)s, (CharSequence)"!");
    }

    public static final /* synthetic */ boolean $anonfun$combineMultiSft$9(SimpleFeatureType x$9) {
        return package$.MODULE$.RichSimpleFeatureType(x$9).getCount().isEmpty();
    }

    public static final /* synthetic */ long $anonfun$combineMultiSft$10(SimpleFeatureType x$10) {
        return BoxesRunTime.unboxToLong((Object)package$.MODULE$.RichSimpleFeatureType(x$10).getCount().get());
    }

    public static final /* synthetic */ int $anonfun$combineMultiSft$11(SimpleFeatureType x$11) {
        return BoxesRunTime.unboxToInt((Object)package$.MODULE$.RichSimpleFeatureType(x$11).getGeometryDimension().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
    }

    public static final /* synthetic */ boolean $anonfun$lowerAttributeName$2(AttributeDescriptor x$12) {
        return x$12 != null;
    }

    public static final /* synthetic */ void $anonfun$insertFields$1(Seq fields$1, Buffer addAttributeDescriptors$1, int i) {
        String fieldName = (String)((Tuple2)fields$1.apply(i))._1();
        Class fieldClz = (Class)((Tuple2)fields$1.apply(i))._2();
        addAttributeDescriptors$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeDescriptor[]{SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(fieldName, fieldClz, new HashMap(), SimpleFeatureTypeUtils$.MODULE$.getDefaultValue(fieldClz), -1, SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6(), SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7(), SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$8())}));
    }

    private AtlasVectorSchemaUtils$() {
        MODULE$ = this;
        this.AVS_IDENTITY = "avs_identity";
    }
}

