/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.dataset.vector.spark;

import com.geoway.atlas.common.config.AtlasSystemProperties;
import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.error.NotEqualException;
import com.geoway.atlas.common.error.NotEqualException$;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.common.utils.UUIDUtils$;
import com.geoway.atlas.common.with.WithTargetClass$;
import com.geoway.atlas.data.common.data.AtlasDataModelDao$;
import com.geoway.atlas.data.common.data.AtlasDataModelDaoFactory;
import com.geoway.atlas.data.common.data.AtlasDataModelDaoFactory$;
import com.geoway.atlas.data.common.data.AtlasDataModelRDao;
import com.geoway.atlas.data.common.data.AtlasDataModelWDao;
import com.geoway.atlas.data.common.data.AtlasDataName$;
import com.geoway.atlas.data.common.dataset.AtlasDataSet;
import com.geoway.atlas.data.common.dataset.AtlasDataSetProvider;
import com.geoway.atlas.data.common.dataset.AtlasDataSetProvider$;
import com.geoway.atlas.data.common.dataset.AtlasResultMetadata;
import com.geoway.atlas.data.common.dataset.AtlasStatistic$;
import com.geoway.atlas.data.common.schema.AtlasSchema;
import com.geoway.atlas.data.common.storage.AtlasStorageInfo$;
import com.geoway.atlas.data.vector.common.jts.JTSUtils$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorDataSet$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchemas$;
import com.geoway.atlas.dataset.vector.spark.VectorRDD;
import com.geoway.atlas.dataset.vector.spark.VectorRDD$;
import com.geoway.atlas.dataset.vector.spark.VectorSparkDataSet;
import com.geoway.atlas.dataset.vector.spark.VectorSparkProvider$;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorResultMetadata;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorStatistic;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorStatistic$;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import com.geoway.atlas.index.common.AtlasIndex;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.spatial.ContainsImpl;
import org.locationtech.geomesa.filter.expression.FastComparisonOperator$;
import org.locationtech.geomesa.filter.expression.FastPropertyName;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\b\u0011\u0001uA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\to\u0001\u0011\t\u0019!C\u0001q!Aa\b\u0001BA\u0002\u0013\u0005q\b\u0003\u0005F\u0001\t\u0005\t\u0015)\u0003:\u0011!1\u0005A!A!\u0002\u00139\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"B-\u0001\t\u0003R\u0006bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\t)\u0006\u0001C!\u0003/:q!!\u001f\u0011\u0011\u0003\tYH\u0002\u0004\u0010!!\u0005\u0011Q\u0010\u0005\u0007%2!\t!a \t\u000f\u0005\u0005E\u0002\"\u0001\u0002\u0004\n\u0019b+Z2u_J\u001c\u0006/\u0019:l!J|g/\u001b3fe*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\taA^3di>\u0014(BA\u000b\u0017\u0003\u001d!\u0017\r^1tKRT!a\u0006\r\u0002\u000b\u0005$H.Y:\u000b\u0005eQ\u0012AB4f_^\f\u0017PC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015ZS\"\u0001\u0014\u000b\u0005U9#B\u0001\u0015*\u0003\u0019\u0019w.\\7p]*\u0011!FF\u0001\u0005I\u0006$\u0018-\u0003\u0002-M\t!\u0012\t\u001e7bg\u0012\u000bG/Y*fiB\u0013xN^5eKJ\f!a]2\u0011\u0005=*T\"\u0001\u0019\u000b\u0005E\t$B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001eL!A\u000e\u0019\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\rM\u001c\u0007.Z7b+\u0005I\u0004C\u0001\u001e=\u001b\u0005Y$B\u0001\u0015\u0013\u0013\ti4HA\tBi2\f7OV3di>\u00148k\u00195f[\u0006\f!b]2iK6\fw\fJ3r)\t\u00015\t\u0005\u0002 \u0003&\u0011!\t\t\u0002\u0005+:LG\u000fC\u0004E\u0007\u0005\u0005\t\u0019A\u001d\u0002\u0007a$\u0013'A\u0004tG\",W.\u0019\u0011\u0002\u000fI$GMT1nKB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\u0011\u000e\u0003-S!\u0001\u0014\u000f\u0002\rq\u0012xn\u001c;?\u0013\tq\u0005%\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(!\u0003\u0019a\u0014N\\5u}Q!AKV,Y!\t)\u0006!D\u0001\u0011\u0011\u0015ic\u00011\u0001/\u0011\u00159d\u00011\u0001:\u0011\u00151e\u00011\u0001H\u0003-\u0001(o\u001c<jI\u0016$\u0015\r^1\u0016\tm\u0013Gn\u001c\u000b\u00079f\f)!a\u0005\u0015\u0005u\u000b\b#B\u0013_A.t\u0017BA0'\u00051\tE\u000f\\1t\t\u0006$\u0018mU3u!\t\t'\r\u0004\u0001\u0005\u000b\r<!\u0019\u00013\u0003\u0003E\u000b\"!\u001a5\u0011\u0005}1\u0017BA4!\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aH5\n\u0005)\u0004#aA!osB\u0011\u0011\r\u001c\u0003\u0006[\u001e\u0011\r\u0001\u001a\u0002\u0002%B\u0011\u0011m\u001c\u0003\u0006a\u001e\u0011\r\u0001\u001a\u0002\u0002)\"9!oBA\u0001\u0002\b\u0019\u0018AC3wS\u0012,gnY3%cA\u0019Ao\u001e8\u000e\u0003UT!A\u001e\u0011\u0002\u000fI,g\r\\3di&\u0011\u00010\u001e\u0002\t\u00072\f7o\u001d+bO\")!p\u0002a\u0001w\u0006Q\u0011\r\u001e7bg&sG-\u001a=\u0011\u000bq\f\t\u0001Y6\u000e\u0003uT!\u0001\u000b@\u000b\u0005}4\u0012!B5oI\u0016D\u0018bAA\u0002{\nQ\u0011\t\u001e7bg&sG-\u001a=\t\u000f\u0005\u001dq\u00011\u0001\u0002\n\u0005\u0011\u0012\r\u001e7bg\u0012\u000bG/Y'pI\u0016d'\u000bR1p!\u0011\tY!a\u0004\u000e\u0005\u00055!B\u0001\u0016(\u0013\u0011\t\t\"!\u0004\u0003%\u0005#H.Y:ECR\fWj\u001c3fYJ#\u0015m\u001c\u0005\b\u0003+9\u0001\u0019AA\f\u0003\u0019\u0001\u0018M]1ngB)\u0001*!\u0007H\u000f&\u0019\u00111D)\u0003\u00075\u000b\u0007/\u0001\u0005tCZ,G)\u0019;b+!\t\t#!\u0010\u0002B\u0005MB\u0003CA\u0012\u0003k\t\u0019%!\u0014\u0015\t\u0005\u0015\u00121\u0006\t\u0004K\u0005\u001d\u0012bAA\u0015M\t\u0019\u0012\t\u001e7bgJ+7/\u001e7u\u001b\u0016$\u0018\rZ1uC\"I\u0011Q\u0006\u0005\u0002\u0002\u0003\u000f\u0011qF\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004\u0003\u0002;x\u0003c\u00012!YA\u001a\t\u0015\u0001\bB1\u0001e\u0011\u001d\t9\u0004\u0003a\u0001\u0003s\tA\"\u0019;mCN$\u0015\r^1TKR\u0004\u0002\"\n0\u0002<\u0005}\u0012\u0011\u0007\t\u0004C\u0006uB!B2\t\u0005\u0004!\u0007cA1\u0002B\u0011)Q\u000e\u0003b\u0001I\"9\u0011Q\t\u0005A\u0002\u0005\u001d\u0013AE1uY\u0006\u001cH)\u0019;b\u001b>$W\r\\,EC>\u0004B!a\u0003\u0002J%!\u00111JA\u0007\u0005I\tE\u000f\\1t\t\u0006$\u0018-T8eK2<F)Y8\t\u000f\u0005U\u0001\u00021\u0001\u0002\u0018\u0005I\u0011M\u001a;feJ+\u0017\r\u001a\u000b\u0004\u0001\u0006M\u0003bBA\u0004\u0013\u0001\u0007\u0011\u0011B\u0001\nC\u001a$XM]*bm\u0016,\u0002\"!\u0017\u0002p\u0005M\u0014Q\r\u000b\t\u00037\n9'!\u001b\u0002vQ\u0019\u0001)!\u0018\t\u0013\u0005}#\"!AA\u0004\u0005\u0005\u0014AC3wS\u0012,gnY3%gA!Ao^A2!\r\t\u0017Q\r\u0003\u0006a*\u0011\r\u0001\u001a\u0005\b\u0003\u000bR\u0001\u0019AA$\u0011\u001d\t9D\u0003a\u0001\u0003W\u0002\u0002\"\n0\u0002n\u0005E\u00141\r\t\u0004C\u0006=D!B2\u000b\u0005\u0004!\u0007cA1\u0002t\u0011)QN\u0003b\u0001I\"9\u0011q\u000f\u0006A\u0002\u0005\u0015\u0012aA1s[\u0006\u0019b+Z2u_J\u001c\u0006/\u0019:l!J|g/\u001b3feB\u0011Q\u000bD\n\u0003\u0019y!\"!a\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fQ\u000b))a\"\u0002\n\")QF\u0004a\u0001]!)qG\u0004a\u0001s!)aI\u0004a\u0001\u000f\u0002")
public class VectorSparkProvider
implements AtlasDataSetProvider {
    private final SparkContext sc;
    private AtlasVectorSchema schema;
    private final String rddName;

    public static VectorSparkProvider apply(SparkContext sparkContext, AtlasVectorSchema atlasVectorSchema, String string) {
        return VectorSparkProvider$.MODULE$.apply(sparkContext, atlasVectorSchema, string);
    }

    public AtlasVectorSchema schema() {
        return this.schema;
    }

    public void schema_$eq(AtlasVectorSchema x$1) {
        this.schema = x$1;
    }

    public <Q, R, T> AtlasDataSet<Q, R, T> provideData(AtlasIndex<Q, R> atlasIndex, AtlasDataModelRDao atlasDataModelRDao, Map<String, String> params, ClassTag<T> evidence$1) {
        BoxedUnit boxedUnit;
        Map nParams = params.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataSetProvider$.MODULE$.PREFER_PARTITION_NUM()), (Object)Integer.toString((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)new AtlasSystemProperties.SystemProperty(AtlasDataSetProvider$.MODULE$.PREFER_PARTITION_RATE(), AtlasSystemProperties.SystemProperty$.MODULE$.apply$default$2()).toDouble().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 5.0)) * (double)SparkRuntime$.MODULE$.getTotalExecutorNums()))))})));
        Map[] queryParams = atlasDataModelRDao.partition(atlasIndex, nParams);
        Map taskInfoMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataModelDao$.MODULE$.DATA_TASK_ID()), (Object)UUIDUtils$.MODULE$.getUUID())}));
        VectorRDD<T> vectorRDD = VectorRDD$.MODULE$.apply(this.sc, this.schema(), params, params, (Map[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).map((Function1 & Serializable & scala.Serializable)x$1 -> taskInfoMap.$plus$plus((GenTraversableOnce)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class))), evidence$1);
        Object object = StringUtils.isNotBlank((CharSequence)this.rddName) ? vectorRDD.setName(this.rddName) : BoxedUnit.UNIT;
        VectorSparkDataSet<Q, R, T> sparkDataSet = new VectorSparkDataSet<Q, R, T>(atlasIndex, this.schema(), vectorRDD);
        String isPersist = AtlasSystemProperties$.MODULE$.getProperty(AtlasDataSetProvider$.MODULE$.IS_PERSIST_LOAD());
        Object object2 = isPersist != null && new StringOps(Predef$.MODULE$.augmentString(isPersist)).toBoolean() ? SparkRuntime$.MODULE$.persist(sparkDataSet.rdd(), new StringBuilder(7).append("input_").append(sparkDataSet.getAtlasSchema().getDataName().localName()).append("_").append(UUIDUtils$.MODULE$.getUUID()).toString(), false) : BoxedUnit.UNIT;
        Object object3 = com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)this.schema()).getCount().isDefined() ? sparkDataSet.putStatistic(AtlasStatistic$.MODULE$.COUNT(), (Filter)FastComparisonOperator$.MODULE$.lessThanOrEqual((Expression)new FastPropertyName.FastPropertyNameAttribute(AtlasStatistic$.MODULE$.COUNT_KEY(), -1), (Literal)new LiteralExpressionImpl(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)this.schema()).getCount().get()))) : BoxedUnit.UNIT;
        if (com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)this.schema()).getRange().isDefined() && !((Geometry)com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)this.schema()).getRange().get()).isEmpty()) {
            String geomField = com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)this.schema()).getGeomField();
            int geomIndex = this.schema().indexOf(geomField);
            boxedUnit = sparkDataSet.putStatistic(AtlasVectorStatistic$.MODULE$.RANGE(), (Filter)new ContainsImpl((Expression)new LiteralExpressionImpl(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)this.schema()).getRange().get()), (Expression)new FastPropertyName.FastPropertyNameAttribute(geomField, geomIndex)));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sparkDataSet;
    }

    public <Q, R, T> AtlasResultMetadata saveData(AtlasDataSet<Q, R, T> atlasDataSet, AtlasDataModelWDao atlasDataModelWDao, Map<String, String> params, ClassTag<T> evidence$2) {
        return (AtlasResultMetadata)WithTargetClass$.MODULE$.apply().apply(atlasDataSet, (Function1 & Serializable & scala.Serializable)vectorSparkDataSet -> {
            Object object;
            LazyRef logger$lzy = new LazyRef();
            ObjectRef partitionParamSeq = ObjectRef.create((Object)atlasDataModelWDao.partition((AtlasDataSet)vectorSparkDataSet, params));
            boolean isOverwrite = !new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)AtlasStorageInfo$.MODULE$.STORAGE_IS_APPEND(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
            Map taskInfoMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasDataModelDao$.MODULE$.DATA_TASK_ID()), (Object)UUIDUtils$.MODULE$.getUUID())}));
            partitionParamSeq.elem = (Seq)((Seq)partitionParamSeq.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> taskInfoMap.$plus$plus((GenTraversableOnce)x$2), Seq$.MODULE$.canBuildFrom());
            String resultName = atlasDataSet.getAtlasSchema().getDataName().localName();
            String serializableStorageDN = atlasDataModelWDao.storageDataName().toString();
            String serializableSStorageSS = AtlasVectorSchemas$.MODULE$.encode((AtlasVectorSchema)atlasDataModelWDao.storageSchema());
            String serializableSStorageCS = AtlasVectorSchemas$.MODULE$.encode((AtlasVectorSchema)atlasDataModelWDao.createSchema());
            RDD qual$1 = (RDD)vectorSparkDataSet.getTempData();
            int x$1 = SparkRuntime$.MODULE$.getTotalExecutorNums();
            boolean x$22 = false;
            Option x$3 = qual$1.coalesce$default$3();
            int x$4 = x$1;
            boolean x$5 = x$22;
            Option x$6 = x$3;
            Ordering x$7 = qual$1.coalesce$default$4(x$4, x$5, x$6);
            RDD qual$2 = qual$1.coalesce(x$4, x$5, x$6, x$7);
            Function1 & Serializable & scala.Serializable x$14 = (Function1 & Serializable & scala.Serializable)iterator -> {
                int taskPartitionId = TaskContext$.MODULE$.get().partitionId();
                Map partitionParams = (Map)((Seq)partitionParamSeq$1.elem).apply(taskPartitionId);
                int partitionId = new StringOps(Predef$.MODULE$.augmentString((String)AtlasVectorDataSet$.MODULE$.RichAtlasVectorDataSetParams(partitionParams).getPartitionId().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    String x$8 = new StringBuilder(5).append("\u672a\u627e\u5230").append(AtlasVectorDataSet$.MODULE$.DATASET_PARTITION_ID()).append("\u53d8\u91cf").toString();
                    Thread x$9 = NotFoundException$.MODULE$.apply$default$2(x$8);
                    int x$10 = NotFoundException$.MODULE$.apply$default$3(x$8);
                    throw new NotFoundException(x$8, x$9, x$10);
                }))).toInt();
                if (partitionId != taskPartitionId) {
                    String x$11 = "\u5f53\u524d\u6570\u636e\u5206\u533aid\u4e0e\u8bbe\u7f6e\u7684\u6570\u636e\u5206\u533aid\u4e0d\u7b26!";
                    Thread x$12 = NotEqualException$.MODULE$.apply$default$2(x$11);
                    int x$13 = NotEqualException$.MODULE$.apply$default$3(x$11);
                    throw new NotEqualException(x$11, x$12, x$13);
                }
                AtlasDataModelDaoFactory daoFactory = AtlasDataModelDaoFactory$.MODULE$.getDao(params);
                AtlasDataModelWDao wDao = daoFactory.createDMWDao(AtlasDataName$.MODULE$.deserializable(serializableStorageDN), (AtlasSchema)AtlasVectorSchemas$.MODULE$.decode(serializableSStorageSS), (AtlasSchema)AtlasVectorSchemas$.MODULE$.decode(serializableSStorageCS), params);
                long startTime = System.currentTimeMillis();
                AtlasResultMetadata arm = isOverwrite ? wDao.writeCreate(iterator, partitionParams) : wDao.writeAppend(iterator, partitionParams);
                long count = 0L;
                if (arm != null) {
                    AtlasResultMetadata atlasResultMetadata = arm;
                    if (atlasResultMetadata instanceof AtlasVectorResultMetadata) {
                        AtlasVectorResultMetadata atlasVectorResultMetadata = (AtlasVectorResultMetadata)atlasResultMetadata;
                        count = atlasVectorResultMetadata.count();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                VectorSparkProvider.logger$1(logger$lzy).info(new StringBuilder(15).append("\u6570\u636e").append(resultName).append(" \u5199\u5165\u884c\u6570\uff1a").append(count).append(", \u8017\u65f6\u4e3a\uff1a").append((System.currentTimeMillis() - startTime) / 1000L).append("s").toString());
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtlasResultMetadata[]{arm}));
            };
            boolean x$15 = qual$2.mapPartitions$default$2();
            RDD partitionWriteRDD = qual$2.mapPartitions((Function1)x$14, x$15, ClassTag$.MODULE$.apply(AtlasResultMetadata.class));
            Object object2 = StringUtils.isNotBlank((CharSequence)$this.rddName) ? partitionWriteRDD.setName($this.rddName) : BoxedUnit.UNIT;
            try {
                AtlasResultMetadata avrm = (AtlasResultMetadata)partitionWriteRDD.treeReduce((Function2 & Serializable & scala.Serializable)(a, b) -> a == null ? b : (b == null ? a : a.merge(b)), partitionWriteRDD.treeReduce$default$2());
                object = avrm == null ? new AtlasVectorResultMetadata(false, new Envelope(), 0L, 2, 3) : avrm;
            }
            catch (UnsupportedOperationException exception) {
                if ("empty collection".equals(exception.getMessage())) {
                    object = new AtlasVectorResultMetadata(false, new Envelope(), 0L, 2, 3);
                }
                throw exception;
            }
            return object;
        });
    }

    public void afterRead(AtlasDataModelRDao atlasDataModelRDao) {
        block0: {
            if (atlasDataModelRDao == null) break block0;
            atlasDataModelRDao.afterRead();
        }
    }

    public <Q, R, T> void afterSave(AtlasDataModelWDao atlasDataModelWDao, AtlasDataSet<Q, R, T> atlasDataSet, AtlasResultMetadata arm, ClassTag<T> evidence$3) {
        AtlasDataSet<Q, R, T> atlasDataSet2;
        if (atlasDataModelWDao != null) {
            atlasDataModelWDao.afterWrite(atlasDataSet, arm);
        }
        if ((atlasDataSet2 = atlasDataSet) instanceof AtlasVectorStatistic) {
            AtlasVectorStatistic atlasVectorStatistic = (AtlasVectorStatistic)atlasDataSet2;
            Envelope envelope = ((AtlasVectorResultMetadata)arm).envelope();
            if (envelope != null && !envelope.isNull()) {
                Geometry geometry = JTSUtils$.MODULE$.toGeometry(envelope);
                AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic(atlasVectorStatistic).setRangeStat("shape", geometry);
            }
            AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic(atlasVectorStatistic).setCountStat(((AtlasVectorResultMetadata)arm).count());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final /* synthetic */ Logger logger$lzycompute$1(LazyRef logger$lzy$1) {
        Logger logger;
        LazyRef lazyRef = logger$lzy$1;
        synchronized (lazyRef) {
            logger = logger$lzy$1.initialized() ? (Logger)logger$lzy$1.value() : (Logger)logger$lzy$1.initialize((Object)LoggerFactory.getLogger(VectorSparkProvider.class));
        }
        return logger;
    }

    private static final Logger logger$1(LazyRef logger$lzy$1) {
        return logger$lzy$1.initialized() ? (Logger)logger$lzy$1.value() : VectorSparkProvider.logger$lzycompute$1(logger$lzy$1);
    }

    public VectorSparkProvider(SparkContext sc, AtlasVectorSchema schema, String rddName) {
        this.sc = sc;
        this.schema = schema;
        this.rddName = rddName;
    }
}

