/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.process.vector.common.area;

import com.geoway.atlas.common.cache.AtlasThreadSafeCache;
import com.geoway.atlas.data.vector.common.crs.package$;
import com.geoway.atlas.process.vector.common.area.GeodesicAreaCalculator;
import org.geotools.referencing.operation.projection.MapProjection;
import org.locationtech.jts.geom.Geometry;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.datum.Ellipsoid;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public final class GeodesicAreaCalculator$
implements Serializable {
    public static GeodesicAreaCalculator$ MODULE$;
    private final double com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD;
    private final double com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$DEGREE_TO_ARC;
    private final AtlasThreadSafeCache<CoordinateReferenceSystem, GeodesicAreaCalculator> calculatorCache;

    static {
        new GeodesicAreaCalculator$();
    }

    public double com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD() {
        return this.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD;
    }

    public double com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$DEGREE_TO_ARC() {
        return this.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$DEGREE_TO_ARC;
    }

    public AtlasThreadSafeCache<CoordinateReferenceSystem, GeodesicAreaCalculator> calculatorCache() {
        return this.calculatorCache;
    }

    public GeodesicAreaCalculator getCalculator(CoordinateReferenceSystem crs) {
        return (GeodesicAreaCalculator)this.calculatorCache().apply((Object)crs, (Function1 & java.io.Serializable & Serializable)x$3 -> {
            GeographicCRS gCRS = null;
            double projectZone = -1.0;
            double central = 0.0;
            CoordinateReferenceSystem coordinateReferenceSystem = crs;
            if (coordinateReferenceSystem instanceof ProjectedCRS) {
                ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem;
                gCRS = projectedCRS.getBaseCRS();
                int epsgCode = package$.MODULE$.FIND_SRID((CoordinateReferenceSystem)gCRS);
                if (epsgCode != 4490) {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u975ecgcs2000\u7684\u6295\u5f71\u5750\u6807\u7cfb\u8fdb\u884c\u5750\u6807\u53cd\u7b97");
                }
                ParameterValueGroup parameterValue = ((MapProjection)projectedCRS.getConversionFromBase().getMathTransform()).getParameterValues();
                projectZone = parameterValue.parameter("false_easting").doubleValue();
                central = parameterValue.parameter("central_meridian").doubleValue() * MODULE$.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$DEGREE_TO_ARC();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (coordinateReferenceSystem instanceof GeographicCRS) {
                GeographicCRS geographicCRS;
                gCRS = geographicCRS = (GeographicCRS)coordinateReferenceSystem;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)coordinateReferenceSystem);
            }
            Ellipsoid ellipsoid = gCRS.getDatum().getEllipsoid();
            double aRadius = ellipsoid.getSemiMajorAxis();
            Predef$.MODULE$.require(!Double.isNaN(aRadius), (Function0 & java.io.Serializable & Serializable)() -> "\u65e0\u6cd5\u83b7\u53d6\u692d\u7403\u957f\u8f74\u534a\u5f84");
            double bRadius = ellipsoid.getSemiMinorAxis();
            Predef$.MODULE$.require(!Double.isNaN(bRadius), (Function0 & java.io.Serializable & Serializable)() -> "\u65e0\u6cd5\u83b7\u53d6\u692d\u7403\u77ed\u8f74\u534a\u5f84");
            double paraC = Math.pow(aRadius, 2.0) / bRadius;
            return new GeodesicAreaCalculator(aRadius, bRadius, paraC, true, true, central, projectZone);
        });
    }

    public double calculate(Geometry geometry, CoordinateReferenceSystem crs) {
        GeodesicAreaCalculator geodesicArea = this.getCalculator(crs);
        return geodesicArea.calcGeom(geometry);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeodesicAreaCalculator$() {
        MODULE$ = this;
        this.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD = 206264.8062471;
        this.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$DEGREE_TO_ARC = Math.PI / 180;
        this.calculatorCache = new AtlasThreadSafeCache();
    }
}

