/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.process.vector.common.buffer;

import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.common.utils.UnitsUtils;
import com.geoway.atlas.common.utils.UnitsUtils$;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.common.dataset.AtlasDataSet;
import com.geoway.atlas.data.common.schema.AtlasSchema;
import com.geoway.atlas.data.vector.common.crs.CrsUtils$;
import com.geoway.atlas.data.vector.common.feature.sft.package$;
import com.geoway.atlas.dataset.common.manager.DataManager;
import com.geoway.atlas.dataset.common.manager.DataManager$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorDataSet;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchemas$;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorStatistic;
import com.geoway.atlas.dataset.vector.statistic.AtlasVectorStatistic$;
import com.geoway.atlas.index.vector.common.AtlasVectorIndex;
import com.geoway.atlas.index.vector.common.AtlasVectorIndex$;
import com.geoway.atlas.index.vector.common.AtlasVectorIndexMetadata;
import com.geoway.atlas.index.vector.common.AtlasVectorIndexMetadata$;
import com.geoway.atlas.process.common.unitary.AbstractAtlasUnitaryProcess;
import com.geoway.atlas.process.vector.common.AtlasVectorProcess;
import com.geoway.atlas.process.vector.common.AtlasVectorStatisticProcess;
import com.geoway.atlas.process.vector.common.buffer.AtlasProcessBufferParams$;
import com.geoway.atlas.process.vector.common.buffer.BufferProcess$;
import java.io.Serializable;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-g!\u0002\u0015*\u0003\u0003A\u0004\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u00111\u0004!\u0011!Q\u0001\n5D\u0001B \u0001\u0003\u0004\u0003\u0006Ya \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011%\tY\u0002\u0001a\u0001\n\u0003\ti\u0002C\u0005\u0002&\u0001\u0001\r\u0011\"\u0001\u0002(!A\u00111\u0007\u0001!B\u0013\ty\u0002C\u0005\u00026\u0001\u0001\r\u0011\"\u0001\u0002\u001e!I\u0011q\u0007\u0001A\u0002\u0013\u0005\u0011\u0011\b\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002 !I\u0011q\b\u0001A\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0001\u0003\u000bBq!!\u0013\u0001A\u0003&1\u0010C\u0005\u0002L\u0001\u0001\r\u0011\"\u0001\u0002N!I\u0011Q\u000b\u0001A\u0002\u0013\u0005\u0011q\u000b\u0005\t\u00037\u0002\u0001\u0015)\u0003\u0002P!I\u0011Q\f\u0001A\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003?\u0002\u0001\u0019!C\u0001\u0003CB\u0001\"!\u001a\u0001A\u0003&\u0011q\n\u0005\n\u0003O\u0002\u0001\u0019!C\u0001\u0003SB\u0011\"!\"\u0001\u0001\u0004%\t!a\"\t\u0011\u0005-\u0005\u0001)Q\u0005\u0003WBq!!$\u0001\t\u0003\ny\tC\u0004\u0002H\u0002!\t%!3\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002d\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0011\u001d\u0011Y\u0002\u0001C!\u0005;AaA\u000b\u0001\u0007\u0012\t-\u0003b\u0002B=\u0001\u0019E!1\u0010\u0005\b\u0005\u001f\u0003A\u0011\tBI\u0011\u001d\u0011\u0019\n\u0001C!\u0005+;qA!(*\u0011\u0003\u0011yJ\u0002\u0004)S!\u0005!\u0011\u0015\u0005\b\u0003\u0017\u0019C\u0011\u0001BX\u0011%\u0011\tl\tb\u0001\n\u0003\u0011\u0019\f\u0003\u0005\u0003@\u000e\u0002\u000b\u0011\u0002B[\u0011%\u0011\tmIA\u0001\n\u0013\u0011\u0019MA\u0007Ck\u001a4WM\u001d)s_\u000e,7o\u001d\u0006\u0003U-\naAY;gM\u0016\u0014(B\u0001\u0017.\u0003\u0019\u0019w.\\7p]*\u0011afL\u0001\u0007m\u0016\u001cGo\u001c:\u000b\u0005A\n\u0014a\u00029s_\u000e,7o\u001d\u0006\u0003eM\nQ!\u0019;mCNT!\u0001N\u001b\u0002\r\u001d,wn^1z\u0015\u00051\u0014aA2p[\u000e\u0001Q\u0003B\u001dD!N\u001bR\u0001\u0001\u001eV3\u0002\u0004RaO B\u001fJk\u0011\u0001\u0010\u0006\u0003{y\nq!\u001e8ji\u0006\u0014\u0018P\u0003\u0002-_%\u0011\u0001\t\u0010\u0002\u001c\u0003\n\u001cHO]1di\u0006#H.Y:V]&$\u0018M]=Qe>\u001cWm]:\u0011\u0005\t\u001bE\u0002\u0001\u0003\u0006\t\u0002\u0011\r!\u0012\u0002\u0002#F\u0011a\t\u0014\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\b\u001d>$\b.\u001b8h!\t9U*\u0003\u0002O\u0011\n\u0019\u0011I\\=\u0011\u0005\t\u0003F!B)\u0001\u0005\u0004)%!\u0001*\u0011\u0005\t\u001bF!\u0002+\u0001\u0005\u0004)%!\u0001+\u0011\u0005Y;V\"A\u0016\n\u0005a[#aG!uY\u0006\u001ch+Z2u_J\u001cF/\u0019;jgRL7\r\u0015:pG\u0016\u001c8\u000f\u0005\u0002[=6\t1L\u0003\u0002];\u0006\u0019An\\4\u000b\u00051\n\u0014BA0\\\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0011\u0005Y\u000b\u0017B\u00012,\u0005I\tE\u000f\\1t-\u0016\u001cGo\u001c:Qe>\u001cWm]:\u0002%\u0005$H.Y:WK\u000e$xN\u001d#bi\u0006\u001cV\r\u001e\t\u0006K*\fuJU\u0007\u0002M*\u0011Af\u001a\u0006\u0003]!T!![\u0019\u0002\u000f\u0011\fG/Y:fi&\u00111N\u001a\u0002\u0013\u0003Rd\u0017m\u001d,fGR|'\u000fR1uCN+G/A\u0005eCR\fG*\u00192fYB\u0019qI\u001c9\n\u0005=D%AB(qi&|g\u000e\u0005\u0003rqn\\hB\u0001:w!\t\u0019\b*D\u0001u\u0015\t)x'\u0001\u0004=e>|GOP\u0005\u0003o\"\u000ba\u0001\u0015:fI\u00164\u0017BA={\u0005\ri\u0015\r\u001d\u0006\u0003o\"\u0003\"!\u001d?\n\u0005uT(AB*ue&tw-\u0001\u0006fm&$WM\\2fIE\u0002R!!\u0001\u0002\bIk!!a\u0001\u000b\u0007\u0005\u0015\u0001*A\u0004sK\u001adWm\u0019;\n\t\u0005%\u00111\u0001\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"b!a\u0004\u0002\u0018\u0005eA\u0003BA\t\u0003+\u0001b!a\u0005\u0001\u0003>\u0013V\"A\u0015\t\u000by$\u00019A@\t\u000b\r$\u0001\u0019\u00013\t\u000b1$\u0001\u0019A7\u0002\u0017\t,hMZ3s?NL'0Z\u000b\u0003\u0003?\u00012aRA\u0011\u0013\r\t\u0019\u0003\u0013\u0002\u0007\t>,(\r\\3\u0002\u001f\t,hMZ3s?NL'0Z0%KF$B!!\u000b\u00020A\u0019q)a\u000b\n\u0007\u00055\u0002J\u0001\u0003V]&$\b\"CA\u0019\r\u0005\u0005\t\u0019AA\u0010\u0003\rAH%M\u0001\rEV4g-\u001a:`g&TX\rI\u0001\rEV4g-\u001a:`e\u0006$\u0018n\\\u0001\u0011EV4g-\u001a:`e\u0006$\u0018n\\0%KF$B!!\u000b\u0002<!I\u0011\u0011G\u0005\u0002\u0002\u0003\u0007\u0011qD\u0001\u000eEV4g-\u001a:`e\u0006$\u0018n\u001c\u0011\u0002\u0019\t,hMZ3s?\u001aLW\r\u001c3\u0016\u0003m\f\u0001CY;gM\u0016\u0014xLZ5fY\u0012|F%Z9\u0015\t\u0005%\u0012q\t\u0005\t\u0003ca\u0011\u0011!a\u0001w\u0006i!-\u001e4gKJ|f-[3mI\u0002\n\u0011b]5eK~#\u0018\u0010]3\u0016\u0005\u0005=\u0003cA$\u0002R%\u0019\u00111\u000b%\u0003\u0007%sG/A\u0007tS\u0012,w\f^=qK~#S-\u001d\u000b\u0005\u0003S\tI\u0006C\u0005\u00022=\t\t\u00111\u0001\u0002P\u0005Q1/\u001b3f?RL\b/\u001a\u0011\u0002\u0011\u0015tGm\u0018;za\u0016\fA\"\u001a8e?RL\b/Z0%KF$B!!\u000b\u0002d!I\u0011\u0011\u0007\n\u0002\u0002\u0003\u0007\u0011qJ\u0001\nK:$w\f^=qK\u0002\nAB]1x?\n|WO\u001c3bef,\"!a\u001b\u0011\t\u001ds\u0017Q\u000e\t\u0005\u0003_\n\t)\u0004\u0002\u0002r)!\u00111OA;\u0003\u00119Wm\\7\u000b\t\u0005]\u0014\u0011P\u0001\u0004UR\u001c(\u0002BA>\u0003{\nA\u0002\\8dCRLwN\u001c;fG\"T!!a \u0002\u0007=\u0014x-\u0003\u0003\u0002\u0004\u0006E$\u0001C$f_6,GO]=\u0002!I\fwo\u00182pk:$\u0017M]=`I\u0015\fH\u0003BA\u0015\u0003\u0013C\u0011\"!\r\u0016\u0003\u0003\u0005\r!a\u001b\u0002\u001bI\fwo\u00182pk:$\u0017M]=!\u0003Y9W\r\u001e*fgVdGo\u0015;bi&\u001cH/[2NKR\fGCBAI\u0003_\u000b\u0019\fE\u0004\u0002\u0014\u0006u50a(\u000e\u0005\u0005U%\u0002BAL\u00033\u000bA!\u001e;jY*\u0011\u00111T\u0001\u0005U\u00064\u0018-C\u0002z\u0003+\u0003B!!)\u0002,6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0004gS2$XM\u001d\u0006\u0005\u0003S\u000bi(A\u0004pa\u0016tw-[:\n\t\u00055\u00161\u0015\u0002\u0007\r&dG/\u001a:\t\r\u0005Ev\u00031\u0001q\u0003\u0019\u0001\u0018M]1ng\"9\u0011QW\fA\u0002\u0005]\u0016aA:giB!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016AB:j[BdWM\u0003\u0003\u0002B\u0006\u001d\u0016a\u00024fCR,(/Z\u0005\u0005\u0003\u000b\fYLA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\f1dZ3u\u0003Rd\u0017m\u001d,fGR|'/\u00138eKblU\r^1eCR\fGCBAf\u00037\fi\u000e\u0005\u0003\u0002N\u0006]WBAAh\u0015\ra\u0013\u0011\u001b\u0006\u0004]\u0005M'bAAkc\u0005)\u0011N\u001c3fq&!\u0011\u0011\\Ah\u0005a\tE\u000f\\1t-\u0016\u001cGo\u001c:J]\u0012,\u00070T3uC\u0012\fG/\u0019\u0005\u0007\u0003cC\u0002\u0019\u00019\t\u000f\u0005}\u0007\u00041\u0001\u00028\u0006I!/Z:vYR\u001cf\r^\u0001\fG\",7m\u001b)be\u0006l7\u000f\u0006\u0004\u0002*\u0005\u0015\u0018q\u001d\u0005\u0007\u0003cK\u0002\u0019\u00019\t\u000f\u0005%\u0018\u00041\u0001\u0002l\u0006Q!/Z:vYRt\u0015-\\3\u0011\t\u00055\u0018q_\u0007\u0003\u0003_TA!!=\u0002t\u0006!A-\u0019;b\u0015\ra\u0013Q\u001f\u0006\u0004\u0003c\f\u0014\u0002BA}\u0003_\u0014Q\"\u0011;mCN$\u0015\r^1OC6,\u0017!D4fi\n+hMZ3s\u0013:4w\u000e\u0006\u0003\u0002 \u0005}\bB\u0002B\u00015\u0001\u000710A\u0007j]B,H\u000fR5ti\u0006t7-Z\u0001\u0013O\u0016tWM]1m%\u0006<(i\\;oI\u0006\u0014\u0018\u0010\u0006\u0002\u0002*\u0005!r-\u001a;SKN,H\u000e^!uY\u0006\u001c8k\u00195f[\u0006$bAa\u0003\u0003\u0018\te\u0001\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\t\tE\u00111_\u0001\u0007g\u000eDW-\\1\n\t\tU!q\u0002\u0002\f\u0003Rd\u0017m]*dQ\u0016l\u0017\r\u0003\u0004\u00022r\u0001\r\u0001\u001d\u0005\b\u0003Sd\u0002\u0019AAv\u0003U9W\r\u001e*fgVdG/\u0011;mCN$\u0015\r^1TKR,\u0002Ba\b\u00030\tU\"1\b\u000b\u0007\u0005C\u0011)E!\u0013\u0015\t\t\r\"q\b\t\u000b\u0005K\u0011IC!\f\u00034\teRB\u0001B\u0014\u0015\rI\u00171_\u0005\u0005\u0005W\u00119C\u0001\u0007Bi2\f7\u000fR1uCN+G\u000fE\u0002C\u0005_!aA!\r\u001e\u0005\u0004)%A\u0001*R!\r\u0011%Q\u0007\u0003\u0007\u0005oi\"\u0019A#\u0003\u0005I\u0013\u0006c\u0001\"\u0003<\u00111!QH\u000fC\u0002\u0015\u0013!A\u0015+\t\u0013\t\u0005S$!AA\u0004\t\r\u0013AC3wS\u0012,gnY3%eA1\u0011\u0011AA\u0004\u0005sAqAa\u0012\u001e\u0001\u0004\u0011Y!\u0001\u0007sKN,H\u000e^*dQ\u0016l\u0017\r\u0003\u0004\u00022v\u0001\r\u0001]\u000b\t\u0005\u001b\u0012)F!\u0017\u0003^Q1!q\nB3\u0005_\"BA!\u0015\u0003`AAQM\u001bB*\u0005/\u0012Y\u0006E\u0002C\u0005+\"aA!\r\u001f\u0005\u0004)\u0005c\u0001\"\u0003Z\u00111!q\u0007\u0010C\u0002\u0015\u00032A\u0011B/\t\u0019\u0011iD\bb\u0001\u000b\"I!\u0011\r\u0010\u0002\u0002\u0003\u000f!1M\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004CBA\u0001\u0003\u000f\u0011Y\u0006C\u0004\u0003hy\u0001\rA!\u001b\u0002!\u0005$H.Y:WK\u000e$xN]%oI\u0016D\b\u0003CAg\u0005W\u0012\u0019Fa\u0016\n\t\t5\u0014q\u001a\u0002\u0011\u0003Rd\u0017m\u001d,fGR|'/\u00138eKbDqA!\u001d\u001f\u0001\u0004\u0011\u0019(A\tbi2\f7OV3di>\u00148k\u00195f[\u0006\u00042!\u001aB;\u0013\r\u00119H\u001a\u0002\u0012\u0003Rd\u0017m\u001d,fGR|'oU2iK6\f\u0017aF4fiJ+7/\u001e7u\u0003Rd\u0017m\u001d#bi\u0006Le\u000eZ3y+\u0019\u0011iHa!\u0003\bR1!q\u0010BE\u0005\u0017\u0003\u0002\"!4\u0003l\t\u0005%Q\u0011\t\u0004\u0005\n\rEA\u0002B\u0019?\t\u0007Q\tE\u0002C\u0005\u000f#aAa\u000e \u0005\u0004)\u0005BBAY?\u0001\u0007\u0001\u000fC\u0004\u0003\u000e~\u0001\r!a3\u0002\u001b%tG-\u001a=NKR\fG-\u0019;b\u000359WM\\3sC2d\u0015MY3mgV\tQ.\u0001\njg\u000e\u0013X-\u0019;f\u001d\u0016<H)\u0019;b'\u0016$XC\u0001BL!\r9%\u0011T\u0005\u0004\u00057C%a\u0002\"p_2,\u0017M\\\u0001\u000e\u0005V4g-\u001a:Qe>\u001cWm]:\u0011\u0007\u0005M1eE\u0003$\u0005G\u0013I\u000bE\u0002H\u0005KK1Aa*I\u0005\u0019\te.\u001f*fMB\u0019qIa+\n\u0007\t5\u0006J\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003 \u0006!a*Q'F+\t\u0011)\f\u0005\u0003\u00038\nuVB\u0001B]\u0015\u0011\u0011Y,!'\u0002\t1\fgnZ\u0005\u0004{\ne\u0016!\u0002(B\u001b\u0016\u0003\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!2\u0011\t\t]&qY\u0005\u0005\u0005\u0013\u0014IL\u0001\u0004PE*,7\r\u001e")
public abstract class BufferProcess<Q, R, T>
extends AbstractAtlasUnitaryProcess<Q, R, T>
implements AtlasVectorStatisticProcess,
LazyLogging,
AtlasVectorProcess {
    private final AtlasVectorDataSet<Q, R, T> atlasVectorDataSet;
    private final Option<scala.collection.immutable.Map<String, String>> dataLabel;
    private double buffer_size;
    private double buffer_ratio;
    private String buffer_field;
    private int side_type;
    private int end_type;
    private Option<Geometry> raw_boundary;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String NAME() {
        return BufferProcess$.MODULE$.NAME();
    }

    @Override
    public AtlasDataSet<?, ?, ?> runProcess(scala.collection.immutable.Map<String, String> params, AtlasDataName resultName) {
        return AtlasVectorProcess.runProcess$(this, params, resultName);
    }

    @Override
    public AtlasSchema handleSchemaHook(AtlasSchema atlasSchema) {
        return AtlasVectorProcess.handleSchemaHook$(this, atlasSchema);
    }

    private Logger logger$lzycompute() {
        BufferProcess bufferProcess = this;
        synchronized (bufferProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public double buffer_size() {
        return this.buffer_size;
    }

    public void buffer_size_$eq(double x$1) {
        this.buffer_size = x$1;
    }

    public double buffer_ratio() {
        return this.buffer_ratio;
    }

    public void buffer_ratio_$eq(double x$1) {
        this.buffer_ratio = x$1;
    }

    public String buffer_field() {
        return this.buffer_field;
    }

    public void buffer_field_$eq(String x$1) {
        this.buffer_field = x$1;
    }

    public int side_type() {
        return this.side_type;
    }

    public void side_type_$eq(int x$1) {
        this.side_type = x$1;
    }

    public int end_type() {
        return this.end_type;
    }

    public void end_type_$eq(int x$1) {
        this.end_type = x$1;
    }

    public Option<Geometry> raw_boundary() {
        return this.raw_boundary;
    }

    public void raw_boundary_$eq(Option<Geometry> x$1) {
        this.raw_boundary = x$1;
    }

    @Override
    public Map<String, Filter> getResultStatisticMeta(scala.collection.immutable.Map<String, String> params, SimpleFeatureType sft) {
        AtlasVectorStatistic nStatisticMetadata;
        block3: {
            nStatisticMetadata = new AtlasVectorStatistic();
            Option rangeStat = AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic((AtlasVectorStatistic)this.atlasVectorDataSet).getRangeStat();
            Option countStat = AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic((AtlasVectorStatistic)this.atlasVectorDataSet).getCountStat();
            if (countStat.isDefined()) {
                AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic(nStatisticMetadata).setCountStat(BoxesRunTime.unboxToLong((Object)countStat.get()));
            }
            String geomField = package$.MODULE$.RichSimpleFeatureType(sft).getGeomField();
            if (!rangeStat.isDefined()) break block3;
            if (!((Geometry)rangeStat.get()).isEmpty() && !GeometryUtils$.MODULE$.isEmptyEnvelope((Geometry)rangeStat.get())) {
                AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic(nStatisticMetadata).setRangeStat(geomField, ((Geometry)rangeStat.get()).buffer(this.buffer_size()));
            } else {
                AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic(nStatisticMetadata).setRangeStat(geomField, (Geometry)rangeStat.get());
            }
        }
        return nStatisticMetadata.getStatisticMetadata();
    }

    @Override
    public AtlasVectorIndexMetadata getAtlasVectorIndexMetadata(scala.collection.immutable.Map<String, String> params, SimpleFeatureType resultSft) {
        AtlasVectorIndexMetadata rIndexMetadata;
        if (this.atlasVectorDataSet.getAtlasIndex() != null && (rIndexMetadata = ((AtlasVectorIndex)this.atlasVectorDataSet.getAtlasIndex()).getIndexMetadata()) != null) {
            scala.collection.immutable.Map mp = (scala.collection.immutable.Map)rIndexMetadata.oidFieldMap().map((Function1 & Serializable & scala.Serializable)a -> new Tuple2(a._1(), a._2()), Map$.MODULE$.canBuildFrom());
            if (rIndexMetadata.getIndexField().isDefined()) {
                mp = (scala.collection.immutable.Map)mp.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BufferProcess.$anonfun$getAtlasVectorIndexMetadata$2(x$1)));
            }
            return new AtlasVectorIndexMetadata(rIndexMetadata.isSplit(), mp, null, rIndexMetadata.bufferSizeMeter());
        }
        return new AtlasVectorIndexMetadata(false, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), AtlasVectorIndexMetadata$.MODULE$.apply$default$3(), AtlasVectorIndexMetadata$.MODULE$.apply$default$4());
    }

    public void checkParams(scala.collection.immutable.Map<String, String> params, AtlasDataName resultName) {
        if (!this.dataLabel.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BufferProcess.$anonfun$checkParams$1(x$2)))) {
            String x$1 = "\u4e0d\u652f\u6301\u975e\u7a7a\u95f4\u56fe\u5c42\u8fdb\u884c\u7f13\u51b2\u8ba1\u7b97\uff01";
            Thread x$22 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$22, x$3);
        }
        String inputDistance = AtlasProcessBufferParams$.MODULE$.RichBufferParams(params).getDistance();
        if (inputDistance.startsWith("[")) {
            int lastFlag = inputDistance.indexOf("]");
            this.buffer_field_$eq(inputDistance.substring(1, lastFlag).toLowerCase());
            this.buffer_ratio_$eq(this.getBufferInfo(new StringBuilder(1).append("1").append(inputDistance.substring(lastFlag + 1)).toString()));
            this.logger().info(new StringBuilder(10).append("\u6362\u7b97\u540e\u7684\u7f13\u51b2\u6bd4\u4f8b\u4e3a:").append(this.buffer_ratio()).toString());
        } else {
            this.buffer_size_$eq(this.getBufferInfo(inputDistance));
            this.logger().info(new StringBuilder(10).append("\u6362\u7b97\u540e\u7684\u7f13\u51b2\u8ddd\u79bb\u4e3a:").append(this.buffer_size()).toString());
        }
        this.side_type_$eq(AtlasProcessBufferParams$.MODULE$.RichBufferParams(params).getSideType());
        this.end_type_$eq(AtlasProcessBufferParams$.MODULE$.RichBufferParams(params).getEndType());
    }

    public double getBufferInfo(String inputDistance) {
        CoordinateReferenceSystem crs;
        Tuple2 tuple2 = UnitsUtils$.MODULE$.getDistance(inputDistance);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double distance = tuple2._1$mcD$sp();
        int unit = tuple2._2$mcI$sp();
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(distance, unit);
        Tuple2.mcDI.sp sp3 = sp2;
        double distance2 = sp3._1$mcD$sp();
        int unit2 = sp3._2$mcI$sp();
        int distanceCoefficient = distance2 < 0.0 ? -1 : 1;
        double tmp_buffer_size = 0.0;
        CoordinateReferenceSystem coordinateReferenceSystem = crs = package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)((AtlasVectorSchema)this.atlasVectorDataSet.getAtlasSchema())).getCRS();
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            BoxedUnit boxedUnit;
            ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem;
            if (unit2 == UnitsUtils.Units$.MODULE$.M()) {
                tmp_buffer_size = distance2;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.generalRawBoundary();
                if (this.raw_boundary().isDefined()) {
                    Tuple2 tuple22 = GeometryUtils$.MODULE$.distanceUnit((Geometry)((Geometry)this.raw_boundary().get()).getCentroid(), (CoordinateReferenceSystem)projectedCRS, Math.abs(distance2), GeographicCRS.class);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    double min = tuple22._1$mcD$sp();
                    double max = tuple22._2$mcD$sp();
                    Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(min, max);
                    Tuple2.mcDD.sp sp5 = sp4;
                    double min2 = sp5._1$mcD$sp();
                    double max2 = sp5._2$mcD$sp();
                    tmp_buffer_size = (min2 + max2) / 2.0 * (double)distanceCoefficient;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    tmp_buffer_size = CrsUtils$.MODULE$.getCRSRoughDistanceByDegree(Math.abs(distance2), crs) * (double)distanceCoefficient;
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (coordinateReferenceSystem instanceof GeographicCRS) {
            BoxedUnit boxedUnit;
            GeographicCRS geographicCRS = (GeographicCRS)coordinateReferenceSystem;
            if (unit2 == UnitsUtils.Units$.MODULE$.M()) {
                this.generalRawBoundary();
                if (this.raw_boundary().isDefined()) {
                    Tuple2 tuple23 = GeometryUtils$.MODULE$.distanceUnit((Geometry)((Geometry)this.raw_boundary().get()).getCentroid(), (CoordinateReferenceSystem)geographicCRS, Math.abs(distance2), ProjectedCRS.class);
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    double min = tuple23._1$mcD$sp();
                    double max = tuple23._2$mcD$sp();
                    Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(min, max);
                    Tuple2.mcDD.sp sp7 = sp6;
                    double min3 = sp7._1$mcD$sp();
                    double max3 = sp7._2$mcD$sp();
                    tmp_buffer_size = (min3 + max3) / 2.0 * (double)distanceCoefficient;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    tmp_buffer_size = CrsUtils$.MODULE$.getCRSRoughDistancebyMeter(Math.abs(distance2), crs) * (double)distanceCoefficient;
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                tmp_buffer_size = distance2;
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u5750\u6807\u7cfb:").append(com.geoway.atlas.data.vector.common.crs.package$.MODULE$.RichCRS(crs).toLineWKT()).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return tmp_buffer_size;
    }

    public void generalRawBoundary() {
        block0: {
            Option rangeStat = AtlasVectorStatistic$.MODULE$.RichAtlasVectorStatistic((AtlasVectorStatistic)this.atlasVectorDataSet).getRangeStat();
            if (!this.raw_boundary().isEmpty() || !rangeStat.isDefined() || !GeometryUtils$.MODULE$.nonEmpty((Geometry)rangeStat.get())) break block0;
            this.raw_boundary_$eq((Option<Geometry>)new Some(rangeStat.get()));
        }
    }

    public AtlasSchema getResultAtlasSchema(scala.collection.immutable.Map<String, String> params, AtlasDataName resultName) {
        AtlasVectorSchema schema = (AtlasVectorSchema)this.atlasVectorDataSet.getAtlasSchema();
        return AtlasVectorSchemas$.MODULE$.decode(resultName, AtlasVectorSchemas$.MODULE$.encode(schema));
    }

    public <RQ, RR, RT> AtlasDataSet<RQ, RR, RT> getResultAtlasDataSet(AtlasSchema resultSchema, scala.collection.immutable.Map<String, String> params, ClassTag<RT> evidence$2) {
        Map<String, Filter> statisticMetadata = this.getResultStatisticMeta(params, (SimpleFeatureType)((AtlasVectorSchema)resultSchema));
        AtlasVectorIndex<RQ, RR> atlasIndex = null;
        AtlasVectorIndexMetadata indexMetadata = this.getAtlasVectorIndexMetadata(params, (SimpleFeatureType)((AtlasVectorSchema)resultSchema));
        atlasIndex = this.getResultAtlasDataIndex(params, indexMetadata);
        AtlasVectorDataSet<RQ, RR, RT> resultAtlasDataSet = this.buffer(atlasIndex, (AtlasVectorSchema)resultSchema, evidence$2);
        ((AtlasVectorStatistic)resultAtlasDataSet).setStaticMetadata(statisticMetadata);
        return resultAtlasDataSet;
    }

    public abstract <RQ, RR, RT> AtlasVectorDataSet<RQ, RR, RT> buffer(AtlasVectorIndex<RQ, RR> var1, AtlasVectorSchema var2, ClassTag<RT> var3);

    public abstract <RQ, RR> AtlasVectorIndex<RQ, RR> getResultAtlasDataIndex(scala.collection.immutable.Map<String, String> var1, AtlasVectorIndexMetadata var2);

    public Option<scala.collection.immutable.Map<String, String>> generalLabels() {
        return new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.DATA_TYPE()), (Object)DataManager.DataType$.MODULE$.VECTOR())})));
    }

    public boolean isCreateNewDataSet() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getAtlasVectorIndexMetadata$2(Tuple2 x$1) {
        return ((String)x$1._1()).equals(AtlasVectorIndex$.MODULE$.INDEX_FIELD());
    }

    public static final /* synthetic */ boolean $anonfun$checkParams$2(String dt) {
        return DataManager.DataType$.MODULE$.VECTOR().equals(dt) || DataManager.DataType$.MODULE$.TABLE().equals(dt);
    }

    public static final /* synthetic */ boolean $anonfun$checkParams$1(scala.collection.immutable.Map x$2) {
        return x$2.get((Object)DataManager$.MODULE$.DATA_TYPE()).exists((Function1 & Serializable & scala.Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)BufferProcess.$anonfun$checkParams$2(dt)));
    }

    public BufferProcess(AtlasVectorDataSet<Q, R, T> atlasVectorDataSet, Option<scala.collection.immutable.Map<String, String>> dataLabel, ClassTag<T> evidence$1) {
        this.atlasVectorDataSet = atlasVectorDataSet;
        this.dataLabel = dataLabel;
        super(atlasVectorDataSet, dataLabel);
        LazyLogging.$init$((LazyLogging)this);
        AtlasVectorProcess.$init$(this);
        this.buffer_size = -1.0;
        this.buffer_ratio = -1.0;
        this.buffer_field = null;
        this.side_type = -1;
        this.end_type = -1;
        this.raw_boundary = None$.MODULE$;
    }
}

