/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.process.vector.spark.partition;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.utils.UUIDUtils$;
import com.geoway.atlas.data.vector.common.feature.sf.SimpleFeatureBuilderUtils$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchemas$;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import com.geoway.atlas.framework.spark.common.partition.SparkPartitioner;
import com.geoway.atlas.framework.spark.common.utils.RDDUtils$;
import com.geoway.atlas.index.common.geosot.GeoSot;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.CodeFind;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.GridCode;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.GridGeometry;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.GridTree;
import com.geoway.atlas.process.vector.common.partition.VectorDataSetGridSplitProcess;
import com.geoway.atlas.process.vector.common.partition.VectorDataSetPartitionProcess$;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LazyRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

public final class SparkGridSplitUtils$ {
    public static SparkGridSplitUtils$ MODULE$;

    static {
        new SparkGridSplitUtils$();
    }

    public RDD<SimpleFeature> split(RDD<SimpleFeature> rdd, double partitionLimit, int shapeIndex, double scale, GridTree gridTree, Option<Object> codeModeOpt, Option<String> codeParamOpt, Option<String> codeFieldOpt, Option<int[]> reComputeFieldOpt, String serializableSft, String serializableOSft) {
        RDD nRdd;
        boolean isCodeField;
        boolean isReCompute;
        block6: {
            double maxPartition;
            isReCompute = reComputeFieldOpt.nonEmpty() && new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])reComputeFieldOpt.get())).nonEmpty();
            isCodeField = codeFieldOpt.nonEmpty() && StringUtils.isNotBlank((CharSequence)((CharSequence)codeFieldOpt.get()));
            nRdd = rdd;
            if (!(gridTree.getCellHigh() < partitionLimit) || !(gridTree.getCellWeight() < partitionLimit)) break block6;
            int level = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(Math.log10(gridTree.getLongCodeCount()) / Math.log10(4.0)));
            double pow = Math.pow(2.0, (int)RichFloat$.MODULE$.ceil$extension(Predef$.MODULE$.floatWrapper((float)(level / 2))));
            GridTree nGridTree = this.getNewGridTree(gridTree, (int)pow);
            int currentNumPartition = rdd.getNumPartitions();
            if (nGridTree.getCodeCount() > currentNumPartition && (maxPartition = new StringOps(Predef$.MODULE$.augmentString(AtlasSystemProperties$.MODULE$.getProperty(VectorDataSetPartitionProcess$.MODULE$.ATLAS_MAX_PARTITION_RATE()))).toDouble() * (double)SparkRuntime$.MODULE$.getTotalExecutorNums()) > (double)currentNumPartition) {
                if ((double)nGridTree.getCodeCount() > maxPartition) {
                    int nLevel = level - (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(Math.log10(currentNumPartition) / Math.log10(4.0)));
                    pow = Math.pow(2.0, nLevel);
                    nGridTree = this.getNewGridTree(gridTree, (int)pow);
                    if ((double)nGridTree.getCodeCount() > maxPartition) {
                        while ((double)nGridTree.getCodeCount() > maxPartition) {
                            pow = Math.pow(2.0, ++nLevel);
                            nGridTree = this.getNewGridTree(gridTree, (int)pow);
                        }
                    } else {
                        while ((double)nGridTree.getCodeCount() < maxPartition) {
                            pow = Math.pow(2.0, --nLevel);
                            nGridTree = this.getNewGridTree(gridTree, (int)pow);
                        }
                        pow = Math.pow(2.0, ++nLevel);
                        nGridTree = this.getNewGridTree(gridTree, (int)pow);
                    }
                }
                RDD partitionedRDD = RDD$.MODULE$.rddToPairRDDFunctions(this.getPartitionRDD(rdd, serializableOSft, scale, shapeIndex, nGridTree, isReCompute, reComputeFieldOpt), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(SimpleFeature.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)SparkPartitioner.KeyPartitioner$.MODULE$.apply(nGridTree.getCodeCount()));
                nRdd = RDDUtils$.MODULE$.rmKey(partitionedRDD, ClassTag$.MODULE$.apply(SimpleFeature.class));
            }
        }
        return this.getResult(nRdd, scale, shapeIndex, serializableSft, gridTree, codeParamOpt, codeModeOpt, isReCompute, reComputeFieldOpt, isCodeField);
    }

    public GridTree getNewGridTree(GridTree gridTree, int pow) {
        return new GridTree(new GeometryFactory().createPoint(new Coordinate(gridTree.getZeroX(), gridTree.getZeroY())), gridTree.getDirection(), gridTree.getBoundary(), gridTree.getCellHigh() * (double)pow, gridTree.getCellWeight() * (double)pow);
    }

    public RDD<Tuple2<Object, SimpleFeature>> getPartitionRDD(RDD<SimpleFeature> nRdd, String serializableOSft, double scale, int shapeIndex, GridTree nGridTree, boolean isReCompute, Option<int[]> reComputeFieldOpt) {
        LazyRef oSft$lzy = new LazyRef();
        return nRdd.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> {
            Iterator iterator2;
            if (iterator.hasNext()) {
                PrecisionModel pm = new PrecisionModel(scale);
                SimpleFeatureBuilder sftBuilder = SimpleFeatureBuilderUtils$.MODULE$.getSimpleFeatureBuilder(SparkGridSplitUtils$.oSft$1(oSft$lzy, serializableOSft));
                iterator2 = iterator.flatMap((Function1 & Serializable & scala.Serializable)sf -> {
                    Geometry geometry = (Geometry)sf.getDefaultGeometry();
                    DoubleRef baseArea = DoubleRef.create((double)0.0);
                    if (isReCompute) {
                        baseArea.elem = geometry.getArea();
                    }
                    Seq gridGeometries = nGridTree.splitRange(geometry, pm);
                    return (GenTraversableOnce)gridGeometries.map((Function1 & Serializable & scala.Serializable)gridGeometry -> {
                        Object[] nValues = new Object[sf.getAttributeCount()];
                        MODULE$.setNewValue(sf.getAttributeCount(), shapeIndex, isReCompute, baseArea$1.elem, reComputeFieldOpt, (GridGeometry)gridGeometry, nValues, (SimpleFeature)sf);
                        CodeFind codeFind = nGridTree.getCode(gridGeometry.gridCode());
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)codeFind.codeNumber()), (Object)SimpleFeatureBuilderUtils$.MODULE$.createSimpleFeature(sftBuilder, nValues, UUIDUtils$.MODULE$.getUUID()));
                    }, Seq$.MODULE$.canBuildFrom());
                });
            } else {
                iterator2 = package$.MODULE$.Iterator().empty();
            }
            return iterator2;
        }, nRdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<SimpleFeature> getResult(RDD<SimpleFeature> nRdd, double scale, int shapeIndex, String serializableSft, GridTree nGridTree, Option<String> codeParamOpt, Option<Object> codeModeOpt, boolean isReCompute, Option<int[]> reComputeFieldOpt, boolean isCodeField) {
        LazyRef sft$lzy = new LazyRef();
        return nRdd.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> {
            Iterator iterator2;
            if (iterator.hasNext()) {
                PrecisionModel pm = new PrecisionModel(scale);
                SimpleFeatureBuilder sftBuilder = SimpleFeatureBuilderUtils$.MODULE$.getSimpleFeatureBuilder(SparkGridSplitUtils$.sft$1(sft$lzy, serializableSft));
                iterator2 = iterator.flatMap((Function1 & Serializable & scala.Serializable)sf -> {
                    Geometry geometry = (Geometry)sf.getDefaultGeometry();
                    DoubleRef baseArea = DoubleRef.create((double)0.0);
                    if (isReCompute) {
                        baseArea.elem = geometry.getArea();
                    }
                    Seq gridGeometries = nGridTree.splitRange(geometry, pm);
                    return (GenTraversableOnce)gridGeometries.map((Function1 & Serializable & scala.Serializable)gridGeometry -> {
                        Object[] nValues;
                        block0: {
                            nValues = new Object[SparkGridSplitUtils$.sft$1(sft$lzy, serializableSft).getAttributeCount()];
                            MODULE$.setNewValue(sf.getAttributeCount(), shapeIndex, isReCompute, baseArea$2.elem, reComputeFieldOpt, (GridGeometry)gridGeometry, nValues, (SimpleFeature)sf);
                            if (!isCodeField) break block0;
                            nValues[nValues.length - 1] = MODULE$.getCode(nGridTree, gridGeometry.gridCode(), BoxesRunTime.unboxToInt((Object)codeModeOpt.get()), (String)codeParamOpt.get());
                        }
                        return SimpleFeatureBuilderUtils$.MODULE$.createSimpleFeature(sftBuilder, nValues, UUIDUtils$.MODULE$.getUUID());
                    }, Seq$.MODULE$.canBuildFrom());
                });
            } else {
                iterator2 = package$.MODULE$.Iterator().empty();
            }
            return iterator2;
        }, nRdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
    }

    public void setNewValue(int attributeCount, int shapeIndex, boolean isReCompute, double baseArea, Option<int[]> reComputeFieldOpt, GridGeometry gridGeometry, Object[] nValues, SimpleFeature sf) {
        double rate = -1.0;
        int limit$macro$4 = attributeCount;
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            if (shapeIndex != index$macro$2) {
                if (isReCompute && new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])reComputeFieldOpt.get())).contains((Object)BoxesRunTime.boxToInteger((int)index$macro$2))) {
                    Double d;
                    if (rate == -1.0) {
                        rate = gridGeometry.geometry().getArea() / baseArea;
                    }
                    if (sf.getAttribute(index$macro$2) == null) {
                        d = BoxesRunTime.boxToDouble((double)0.0);
                    } else {
                        Double d2;
                        Object object = sf.getAttribute(index$macro$2);
                        if (Double.class.isAssignableFrom(object.getClass()) || Double.TYPE.isAssignableFrom(object.getClass())) {
                            d2 = BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)object) * rate));
                        } else if (Integer.class.isAssignableFrom(object.getClass()) || Integer.TYPE.isAssignableFrom(object.getClass())) {
                            d2 = BoxesRunTime.boxToDouble((double)((double)BoxesRunTime.unboxToInt((Object)object) * rate));
                        } else if (Float.class.isAssignableFrom(object.getClass()) || Float.TYPE.isAssignableFrom(object.getClass())) {
                            d2 = BoxesRunTime.boxToDouble((double)((double)BoxesRunTime.unboxToFloat((Object)object) * rate));
                        } else if (Short.class.isAssignableFrom(object.getClass()) || Short.TYPE.isAssignableFrom(object.getClass())) {
                            d2 = BoxesRunTime.boxToDouble((double)((double)BoxesRunTime.unboxToShort((Object)object) * rate));
                        } else if (Long.class.isAssignableFrom(object.getClass()) || Long.TYPE.isAssignableFrom(object.getClass())) {
                            d2 = BoxesRunTime.boxToDouble((double)((double)BoxesRunTime.unboxToLong((Object)object) * rate));
                        } else {
                            String x$1 = new StringBuilder(13).append("\u4e0d\u652f\u6301\u5f53\u524d\u7c7b\u578b\u7684\u6570\u636e\u8fd0\u7b97\uff1a").append(object.getClass().getSimpleName()).toString();
                            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                            throw new NotSupportException(x$1, x$2, x$3);
                        }
                        d = d2;
                    }
                    nValues[index$macro$2] = d;
                    continue;
                }
                nValues[index$macro$2] = sf.getAttribute(index$macro$2);
                continue;
            }
            nValues[index$macro$2] = gridGeometry.geometry();
        }
    }

    public String getCode(GridTree gridTree, GridCode gridCode, int codeModeOpt, String codeParam) {
        String string;
        int n = codeModeOpt;
        if (VectorDataSetGridSplitProcess.SplitMode$.MODULE$.DISTINCT_GRID() == n) {
            string = new StringBuilder(1).append(gridCode.row()).append("_").append(gridCode.col()).toString();
        } else if (VectorDataSetGridSplitProcess.SplitMode$.MODULE$.GEOSOT() == n) {
            string = this.getGeoSotCode(gridTree.getCenter(gridCode), Integer.parseInt(codeParam));
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u6a21\u5f0f:").append(n).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return string;
    }

    public String getGeoSotCode(Coordinate coordinate, int level) {
        return GeoSot.getCode((double)coordinate.x, (double)coordinate.y, (int)level);
    }

    private static final /* synthetic */ SimpleFeatureType oSft$lzycompute$1(LazyRef oSft$lzy$1, String serializableOSft$1) {
        SimpleFeatureType simpleFeatureType;
        LazyRef lazyRef = oSft$lzy$1;
        synchronized (lazyRef) {
            simpleFeatureType = oSft$lzy$1.initialized() ? (SimpleFeatureType)oSft$lzy$1.value() : (SimpleFeatureType)oSft$lzy$1.initialize((Object)AtlasVectorSchemas$.MODULE$.decodeSft(serializableOSft$1));
        }
        return simpleFeatureType;
    }

    private static final SimpleFeatureType oSft$1(LazyRef oSft$lzy$1, String serializableOSft$1) {
        return oSft$lzy$1.initialized() ? (SimpleFeatureType)oSft$lzy$1.value() : SparkGridSplitUtils$.oSft$lzycompute$1(oSft$lzy$1, serializableOSft$1);
    }

    private static final /* synthetic */ SimpleFeatureType sft$lzycompute$1(LazyRef sft$lzy$1, String serializableSft$1) {
        SimpleFeatureType simpleFeatureType;
        LazyRef lazyRef = sft$lzy$1;
        synchronized (lazyRef) {
            simpleFeatureType = sft$lzy$1.initialized() ? (SimpleFeatureType)sft$lzy$1.value() : (SimpleFeatureType)sft$lzy$1.initialize((Object)AtlasVectorSchemas$.MODULE$.decodeSft(serializableSft$1));
        }
        return simpleFeatureType;
    }

    private static final SimpleFeatureType sft$1(LazyRef sft$lzy$1, String serializableSft$1) {
        return sft$lzy$1.initialized() ? (SimpleFeatureType)sft$lzy$1.value() : SparkGridSplitUtils$.sft$lzycompute$1(sft$lzy$1, serializableSft$1);
    }

    private SparkGridSplitUtils$() {
        MODULE$ = this;
    }
}

