/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.dataset.vector.spark.manager.VectorSparkDataManager$;
import java.io.Serializable;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeRDD;
import org.apache.spark.graphx.EdgeRDD$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.GraphXUtils$;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.VertexRDD$;
import org.apache.spark.graphx.impl.EdgeRDDImpl;
import org.apache.spark.graphx.impl.GraphImpl$;
import org.apache.spark.graphx.util.PeriodicGraphCheckpointer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.util.PeriodicRDDCheckpointer;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction2;

public final class GraphUtils$
implements LazyLogging {
    public static GraphUtils$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GraphUtils$();
    }

    private Logger logger$lzycompute() {
        GraphUtils$ graphUtils$ = this;
        synchronized (graphUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public <VD, ED> Graph<VD, ED> createGraph(RDD<Tuple2<Object, VD>> vertices, RDD<Edge<ED>> edges, Option<Map<String, String>> label, VD defaultVertexAttr, StorageLevel edgeStorageLevel, StorageLevel vertexStorageLevel, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        EdgeRDDImpl edgeRDD = EdgeRDD$.MODULE$.fromEdges(edges, package$.MODULE$.classTag(evidence$2), package$.MODULE$.classTag(evidence$1)).withTargetStorageLevel(edgeStorageLevel);
        VertexRDD vertexRDD = VertexRDD$.MODULE$.apply(vertices, (EdgeRDD)edgeRDD, defaultVertexAttr, evidence$1).withTargetStorageLevel(vertexStorageLevel);
        vertexRDD.cache();
        VectorSparkDataManager$.MODULE$.registerWithLabel(label, (RDD)vertexRDD);
        EdgeRDDImpl newEdges = edgeRDD.mapEdgePartitions((Function2 & Serializable & scala.Serializable)(pid, part) -> part.withoutVertexAttributes(evidence$1), evidence$2, evidence$1).cache();
        VectorSparkDataManager$.MODULE$.registerWithLabel(label, (RDD)newEdges);
        return GraphImpl$.MODULE$.fromExistingRDDs(vertexRDD, (EdgeRDD)newEdges, evidence$1, evidence$2);
    }

    public <VD, ED> VD createGraph$default$4() {
        return null;
    }

    public <VD, ED> StorageLevel createGraph$default$5() {
        return StorageLevel$.MODULE$.MEMORY_ONLY();
    }

    public <VD, ED> StorageLevel createGraph$default$6() {
        return StorageLevel$.MODULE$.MEMORY_ONLY();
    }

    public <VD, ED> Graph<Object, ED> connectedComponents(Graph<VD, ED> graph, Option<Map<String, String>> dataLabel, ClassTag<VD> evidence$3, ClassTag<ED> evidence$4) {
        int maxIterations = Integer.MAX_VALUE;
        Predef$.MODULE$.require(maxIterations > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Maximum of iterations must be greater than 0,").append(" but got ").append(maxIterations).toString());
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)GraphUtils$.$anonfun$connectedComponents$2(BoxesRunTime.unboxToLong((Object)x0$1), x1$1));
        ClassTag x$2 = ClassTag$.MODULE$.apply(Long.TYPE);
        Null$ x$3 = graph.mapVertices$default$3((Function2)x$1);
        Graph ccGraph = graph.mapVertices((Function2)x$1, x$2, null);
        long initialMessage = Long.MAX_VALUE;
        Graph<VD, ED> pregelGraph = null;
        try {
            pregelGraph = this.createPregel((Graph<VD, ED>)ccGraph, (Object)BoxesRunTime.boxToLong((long)initialMessage), maxIterations, EdgeDirection$.MODULE$.Either(), (Function3)(Function3 & Serializable & scala.Serializable)(id, attr, msg) -> BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToLong((Object)attr), BoxesRunTime.unboxToLong((Object)msg))), (Function1)(Function1 & Serializable & scala.Serializable)edge -> GraphUtils$.sendMessage$1(edge), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(a, b) -> scala.math.package$.MODULE$.min(a, b), dataLabel, (ClassTag<VD>)ClassTag$.MODULE$.apply(Long.TYPE), evidence$4, (ClassTag)ClassTag$.MODULE$.Long());
        }
        finally {
            if (ccGraph != null) {
                ccGraph.unpersist(ccGraph.unpersist$default$1());
            }
        }
        return pregelGraph;
    }

    public <VD, ED, A> Graph<VD, ED> createPregel(Graph<VD, ED> graph, A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg, Function2<A, A, A> mergeMsg, Option<Map<String, String>> dataLabel, ClassTag<VD> evidence$5, ClassTag<ED> evidence$6, ClassTag<A> evidence$7) {
        long activeMessages;
        PeriodicRDDCheckpointer messageCheckpointer;
        VertexRDD messages;
        PeriodicGraphCheckpointer graphCheckpointer;
        Graph g;
        block9: {
            Predef$.MODULE$.require(maxIterations > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Maximum number of iterations must be greater than 0,").append(" but got ").append(maxIterations).toString());
            int checkpointInterval = graph.vertices().sparkContext().getConf().getInt("spark.graphx.pregel.checkpointInterval", -1);
            g = graph.mapVertices((Function2 & Serializable & scala.Serializable)(vid, vdata) -> vprog.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)vid)), vdata, initialMsg), evidence$5, Predef.$eq$colon$eq$.MODULE$.tpEquals());
            graphCheckpointer = new PeriodicGraphCheckpointer(checkpointInterval, graph.vertices().sparkContext());
            messages = null;
            messageCheckpointer = null;
            activeMessages = -1L;
            try {
                graphCheckpointer.update((Object)g);
                messages = GraphXUtils$.MODULE$.mapReduceTriplets(g, sendMsg, mergeMsg, GraphXUtils$.MODULE$.mapReduceTriplets$default$4(), evidence$5, evidence$6, evidence$7);
                messageCheckpointer = new PeriodicRDDCheckpointer(checkpointInterval, graph.vertices().sparkContext());
                messageCheckpointer.update((Object)messages);
                activeMessages = messages.count();
            }
            catch (Throwable throwable) {
                graphCheckpointer.deleteAllCheckpoints();
                graphCheckpointer.unpersistDataSet();
                if (messageCheckpointer == null) break block9;
                messageCheckpointer.deleteAllCheckpoints();
                messageCheckpointer.unpersistDataSet();
            }
        }
        Graph prevG = null;
        try {
            int i;
            for (i = 0; activeMessages > 0L && i < maxIterations; ++i) {
                prevG = g;
                g = Graph$.MODULE$.graphToGraphOps(g, evidence$5, evidence$6).joinVertices((RDD)messages, vprog, evidence$7);
                graphCheckpointer.update((Object)g);
                VertexRDD oldMessages = messages;
                try {
                    messages = GraphXUtils$.MODULE$.mapReduceTriplets(g, sendMsg, mergeMsg, (Option)new Some((Object)new Tuple2((Object)oldMessages, (Object)activeDirection)), evidence$5, evidence$6, evidence$7);
                    messageCheckpointer.update((Object)messages);
                    activeMessages = messages.count();
                    this.logger().info(new StringBuilder(26).append("Pregel finished iteration ").append(i).toString());
                    continue;
                }
                finally {
                    oldMessages.unpersist(oldMessages.unpersist$default$1());
                    Graph qual$1 = prevG;
                    boolean x$1 = qual$1.unpersistVertices$default$1();
                    qual$1.unpersistVertices(x$1);
                    EdgeRDD qual$2 = prevG.edges();
                    boolean x$2 = qual$2.unpersist$default$1();
                    qual$2.unpersist(x$2);
                }
            }
            this.logger().info(new StringBuilder(23).append("Pregel total iteration ").append(i).toString());
        }
        finally {
            messageCheckpointer.unpersistDataSet();
            graphCheckpointer.deleteAllCheckpoints();
            messageCheckpointer.deleteAllCheckpoints();
            VectorSparkDataManager$.MODULE$.registerWithLabel(dataLabel, g.vertices().partitionsRDD());
            VectorSparkDataManager$.MODULE$.registerWithLabel(dataLabel, g.edges().partitionsRDD());
        }
        return g;
    }

    public <VD, ED, A> int createPregel$default$3() {
        return Integer.MAX_VALUE;
    }

    public <VD, ED, A> EdgeDirection createPregel$default$4() {
        return EdgeDirection$.MODULE$.Either();
    }

    public static final /* synthetic */ long $anonfun$connectedComponents$2(long x0$1, Object x1$1) {
        long vid;
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = vid = tuple2._1$mcJ$sp();
        return l;
    }

    private static final Iterator sendMessage$1(EdgeTriplet edge) {
        return BoxesRunTime.unboxToLong((Object)edge.srcAttr()) < BoxesRunTime.unboxToLong((Object)edge.dstAttr()) ? Iterator$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(edge.dstId(), BoxesRunTime.unboxToLong((Object)edge.srcAttr()))})) : (BoxesRunTime.unboxToLong((Object)edge.srcAttr()) > BoxesRunTime.unboxToLong((Object)edge.dstAttr()) ? Iterator$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(edge.srcId(), BoxesRunTime.unboxToLong((Object)edge.dstAttr()))})) : Iterator$.MODULE$.empty());
    }

    private GraphUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

