/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.process.vector.spark.area;

import com.geoway.atlas.common.error.NoExpectException;
import com.geoway.atlas.common.error.NoExpectException$;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.data.vector.common.feature.sf.SimpleFeatureBuilderUtils$;
import com.geoway.atlas.dataset.common.manager.AtlasDataTag;
import com.geoway.atlas.dataset.common.manager.DataManager$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchemas$;
import com.geoway.atlas.dataset.vector.spark.utils.VectorSparkSqlDataSetUtils$;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import com.geoway.atlas.process.vector.common.area.AtlasProcessCalculateParams;
import com.geoway.atlas.process.vector.common.area.GeodesicAreaCalculator$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class VectorSparkCalculateUtils$ {
    public static VectorSparkCalculateUtils$ MODULE$;

    static {
        new VectorSparkCalculateUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public int getSridFromString(String str) {
        void var2_2;
        int targetSrid = -1;
        targetSrid = StringUtils.isNumeric((CharSequence)str) ? new StringOps(Predef$.MODULE$.augmentString(str)).toInt() : com.geoway.atlas.data.vector.common.crs.package$.MODULE$.WKT_TO_SRID(str);
        return (int)var2_2;
    }

    public RDD<SimpleFeature> calculate(RDD<SimpleFeature> rdd, AtlasVectorSchema nSft, String calculateField, String calculateType, String calculateParams, int calculateZone, boolean isNewField) {
        LazyRef serializableSchema$lzy = new LazyRef();
        String nSftString = AtlasVectorSchemas$.MODULE$.encode(nSft);
        int calculateFieldIndex = nSft.indexOf(calculateField);
        BooleanRef isTransform = BooleanRef.create((boolean)false);
        IntRef targetSrid = IntRef.create((int)-1);
        IntRef oSrid = IntRef.create((int)-1);
        String string = calculateType.toLowerCase();
        String string2 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.GEODESIC_AREA();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            targetSrid.elem = this.getSridFromString(calculateParams);
            oSrid.elem = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)nSft).getCRS());
            CoordinateReferenceSystem coordinateReferenceSystem = com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)nSft).getCRS();
            if (coordinateReferenceSystem instanceof ProjectedCRS) {
                ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem;
                if (targetSrid.elem != 4490 || com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID((CoordinateReferenceSystem)projectedCRS.getBaseCRS()) != 4490) {
                    String x$1 = "\u9488\u5bf9\u6295\u5f71\u5750\u6807\u7cfb\u4ec5\u652f\u6301CGCS2000\u8ba1\u7b97\u692d\u7403\u4e0b\u7684\u6295\u5f71\u5750\u6807\u7cfb!";
                    Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                    int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                    throw new NotSupportException(x$1, x$2, x$3);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (coordinateReferenceSystem instanceof GeographicCRS) {
                isTransform.elem = oSrid.elem != targetSrid.elem;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)coordinateReferenceSystem);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.PROJECT_AREA();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                CoordinateReferenceSystem coordinateReferenceSystem;
                oSrid.elem = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)nSft).getCRS());
                targetSrid.elem = -1;
                if (StringUtils.isNotEmpty((CharSequence)calculateParams)) {
                    targetSrid.elem = this.getSridFromString(calculateParams);
                    if (!(com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_EPSG(targetSrid.elem) instanceof ProjectedCRS)) {
                        String x$4 = "\u8ba1\u7b97\u6295\u5f71\u9762\u79ef\u6307\u5b9a\u5750\u6807\u7cfb\u5fc5\u987b\u4e3a\u6295\u5f71\u5750\u6807\u7cfb,\u5982\u679c\u8ba1\u7b97\u5206\u5e26\u6295\u5f71\u9762\u79ef\u5219\u4e0d\u9700\u8981\u8bbe\u7f6e\u5750\u6807\u7cfb\u53c2\u6570!";
                        Thread x$5 = NotSupportException$.MODULE$.apply$default$2(x$4);
                        int x$6 = NotSupportException$.MODULE$.apply$default$3(x$4);
                        throw new NotSupportException(x$4, x$5, x$6);
                    }
                }
                if ((coordinateReferenceSystem = com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)nSft).getCRS()) instanceof ProjectedCRS) {
                    BoxedUnit boxedUnit;
                    if (targetSrid.elem != -1) {
                        isTransform.elem = oSrid.elem != targetSrid.elem;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (coordinateReferenceSystem instanceof GeographicCRS) {
                    if (oSrid.elem != 4490) {
                        String x$7 = "\u4e0d\u652f\u6301\u975eCGCS2000\u5750\u6807\u7cfb\u8fdb\u884c\u6295\u5f71\u9762\u79ef\u53cd\u7b97!";
                        Thread x$8 = NotFoundException$.MODULE$.apply$default$2(x$7);
                        int x$9 = NotFoundException$.MODULE$.apply$default$3(x$7);
                        throw new NotFoundException(x$7, x$8, x$9);
                    }
                    isTransform.elem = false;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)coordinateReferenceSystem);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return rdd.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> {
            Iterator iterator2;
            if (iterator.nonEmpty()) {
                SimpleFeatureBuilder sfb = SimpleFeatureBuilderUtils$.MODULE$.getSimpleFeatureBuilder((SimpleFeatureType)VectorSparkCalculateUtils$.com$geoway$atlas$process$vector$spark$area$VectorSparkCalculateUtils$$serializableSchema$1(serializableSchema$lzy, nSftString));
                ObjectRef transform = ObjectRef.create(null);
                if (isTransform$1.elem) {
                    transform.elem = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_THRANSFORM(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)VectorSparkCalculateUtils$.com$geoway$atlas$process$vector$spark$area$VectorSparkCalculateUtils$$serializableSchema$1(serializableSchema$lzy, nSftString)).getCRS(), com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_EPSG(targetSrid$1.elem));
                }
                HashMap transformMap = new HashMap();
                iterator2 = new Iterator<SimpleFeature>(iterator, oSrid, calculateType, calculateZone, transform, transformMap, isNewField, calculateFieldIndex, sfb, serializableSchema$lzy, nSftString){
                    private final Iterator iterator$1;
                    private final IntRef oSrid$1;
                    private final String calculateType$1;
                    private final int calculateZone$1;
                    private final ObjectRef transform$1;
                    private final Map transformMap$1;
                    private final boolean isNewField$1;
                    private final int calculateFieldIndex$1;
                    private final SimpleFeatureBuilder sfb$1;
                    private final LazyRef serializableSchema$lzy$1;
                    private final String nSftString$1;

                    public Iterator<SimpleFeature> seq() {
                        return Iterator.seq$((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.isEmpty$((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.isTraversableAgain$((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.hasDefiniteSize$((Iterator)this);
                    }

                    public Iterator<SimpleFeature> take(int n) {
                        return Iterator.take$((Iterator)this, (int)n);
                    }

                    public Iterator<SimpleFeature> drop(int n) {
                        return Iterator.drop$((Iterator)this, (int)n);
                    }

                    public Iterator<SimpleFeature> slice(int from, int until) {
                        return Iterator.slice$((Iterator)this, (int)from, (int)until);
                    }

                    public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<SimpleFeature, B> f) {
                        return Iterator.map$((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.$plus$plus$((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
                        return Iterator.flatMap$((Iterator)this, f);
                    }

                    public Iterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                        return Iterator.filter$((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                        return Iterator.corresponds$((Iterator)this, that, p);
                    }

                    public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                        return Iterator.withFilter$((Iterator)this, p);
                    }

                    public Iterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                        return Iterator.filterNot$((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                        return Iterator.collect$((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                        return Iterator.scanLeft$((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                        return Iterator.scanRight$((Iterator)this, z, op);
                    }

                    public Iterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                        return Iterator.takeWhile$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                        return Iterator.partition$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                        return Iterator.span$((Iterator)this, p);
                    }

                    public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                        return Iterator.dropWhile$((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
                        return Iterator.zip$((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.padTo$((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                        return Iterator.zipWithIndex$((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<SimpleFeature, U> f) {
                        Iterator.foreach$((Iterator)this, f);
                    }

                    public boolean forall(Function1<SimpleFeature, Object> p) {
                        return Iterator.forall$((Iterator)this, p);
                    }

                    public boolean exists(Function1<SimpleFeature, Object> p) {
                        return Iterator.exists$((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.contains$((Iterator)this, (Object)elem);
                    }

                    public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                        return Iterator.find$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<SimpleFeature, Object> p) {
                        return Iterator.indexWhere$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                        return Iterator.indexWhere$((Iterator)this, p, (int)from);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.indexOf$((Iterator)this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return Iterator.indexOf$((Iterator)this, elem, (int)from);
                    }

                    public BufferedIterator<SimpleFeature> buffered() {
                        return Iterator.buffered$((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.grouped$((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.sliding$default$2$((Iterator)this);
                    }

                    public int length() {
                        return Iterator.length$((Iterator)this);
                    }

                    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                        return Iterator.duplicate$((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.sameElements$((Iterator)this, that);
                    }

                    public Traversable<SimpleFeature> toTraversable() {
                        return Iterator.toTraversable$((Iterator)this);
                    }

                    public Iterator<SimpleFeature> toIterator() {
                        return Iterator.toIterator$((Iterator)this);
                    }

                    public Stream<SimpleFeature> toStream() {
                        return Iterator.toStream$((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.toString$((Iterator)this);
                    }

                    public List<SimpleFeature> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.size$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<SimpleFeature, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<SimpleFeature> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Iterable<SimpleFeature> toIterable() {
                        return TraversableOnce.toIterable$((TraversableOnce)this);
                    }

                    public Seq<SimpleFeature> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<SimpleFeature> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<SimpleFeature> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
                        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<SimpleFeature, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public boolean hasNext() {
                        return this.iterator$1.hasNext();
                    }

                    public SimpleFeature next() {
                        Double d;
                        SimpleFeature sf = (SimpleFeature)this.iterator$1.next();
                        ArrayList<Double> list = new ArrayList<Double>(sf.getAttributes());
                        Double nArea = BoxesRunTime.boxToDouble((double)VectorSparkCalculateUtils$.MODULE$.calculateValue(this.oSrid$1.elem, com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)VectorSparkCalculateUtils$.com$geoway$atlas$process$vector$spark$area$VectorSparkCalculateUtils$$serializableSchema$1(this.serializableSchema$lzy$1, this.nSftString$1)).getCRS(), (Geometry)sf.getDefaultGeometry(), this.calculateType$1, this.calculateZone$1, (MathTransform)this.transform$1.elem, this.transformMap$1));
                        if (this.isNewField$1) {
                            list.add(this.calculateFieldIndex$1, nArea);
                            d = BoxedUnit.UNIT;
                        } else {
                            d = list.set(this.calculateFieldIndex$1, nArea);
                        }
                        return SimpleFeatureBuilderUtils$.MODULE$.createSimpleFeature(this.sfb$1, list, sf.getID());
                    }
                    {
                        this.iterator$1 = iterator$1;
                        this.oSrid$1 = oSrid$1;
                        this.calculateType$1 = calculateType$1;
                        this.calculateZone$1 = calculateZone$1;
                        this.transform$1 = transform$1;
                        this.transformMap$1 = transformMap$1;
                        this.isNewField$1 = isNewField$1;
                        this.calculateFieldIndex$1 = calculateFieldIndex$1;
                        this.sfb$1 = sfb$1;
                        this.serializableSchema$lzy$1 = serializableSchema$lzy$1;
                        this.nSftString$1 = nSftString$1;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Iterator.$init$((Iterator)this);
                    }
                };
            } else {
                iterator2 = package$.MODULE$.Iterator().empty();
            }
            return iterator2;
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double calculateValue(int oSrid, CoordinateReferenceSystem originCRS, Geometry geometry, String calculateType, int calculateZone, MathTransform transform, Map<Object, MathTransform> transformMap) {
        String string = calculateType.toLowerCase();
        String string2 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.ST_AREA();
        String string3 = string;
        if (string2 == null) {
            if (string3 == null) return GeometryUtils$.MODULE$.RichGeometry(geometry).fastGetArea();
        } else if (string2.equals(string3)) {
            return GeometryUtils$.MODULE$.RichGeometry(geometry).fastGetArea();
        }
        String string4 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.GEODESIC_AREA();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return transform == null ? GeometryUtils$.MODULE$.RichGeometry(geometry).fastGetGeoArea((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToDouble((double)GeodesicAreaCalculator$.MODULE$.calculate(g, originCRS))) : GeometryUtils$.MODULE$.RichGeometry(geometry).fastGetGeoArea((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToDouble((double)GeodesicAreaCalculator$.MODULE$.calculate(JTS.transform((Geometry)g, (MathTransform)transform), originCRS)));
        }
        String string6 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.PROJECT_AREA();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            double d;
            if (transform == null) {
                double d2;
                CoordinateReferenceSystem coordinateReferenceSystem = originCRS;
                if (coordinateReferenceSystem instanceof ProjectedCRS) {
                    d2 = GeometryUtils$.MODULE$.RichGeometry(geometry).fastGetArea();
                } else {
                    MathTransform mathTransform;
                    if (!(coordinateReferenceSystem instanceof GeographicCRS)) throw new MatchError((Object)coordinateReferenceSystem);
                    int n = oSrid;
                    if (4490 != n) throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    if (calculateZone == 3) {
                        int zoneId = (int)Math.round(geometry.getCentroid().getX() / (double)3) + 4488;
                        if (zoneId < 4513 || zoneId > 4533) {
                            String x$1 = new java.lang.StringBuilder(26).append("\u56fe\u6591\u8f6c\u6362\u540e\u76843\u5ea6\u6295\u5f71\u5e26").append(zoneId).append("\u4e0d\u57284513~4533\u8303\u56f4\u5185!").toString();
                            Thread x$2 = NoExpectException$.MODULE$.apply$default$2(x$1);
                            int x$3 = NoExpectException$.MODULE$.apply$default$3(x$1);
                            throw new NoExpectException(x$1, x$2, x$3);
                        }
                        mathTransform = transformMap.computeIfAbsent(BoxesRunTime.boxToInteger((int)zoneId), i -> com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_THRANSFORM(com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_EPSG(4490), com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_EPSG(zoneId)));
                    } else if (calculateZone == 6) {
                        int zoneId = (int)Math.round((geometry.getCentroid().getX() + (double)3) / (double)6) + 4478;
                        if (zoneId < 4491 || zoneId > 4501) {
                            String x$4 = new java.lang.StringBuilder(26).append("\u56fe\u6591\u8f6c\u6362\u540e\u76843\u5ea6\u6295\u5f71\u5e26").append(zoneId).append("\u4e0d\u57284491~4501\u8303\u56f4\u5185!").toString();
                            Thread x$5 = NoExpectException$.MODULE$.apply$default$2(x$4);
                            int x$6 = NoExpectException$.MODULE$.apply$default$3(x$4);
                            throw new NoExpectException(x$4, x$5, x$6);
                        }
                        mathTransform = transformMap.computeIfAbsent(BoxesRunTime.boxToInteger((int)zoneId), i -> com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_THRANSFORM(com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_EPSG(4490), com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_EPSG(zoneId)));
                    } else {
                        String x$7 = "\u4e0d\u652f\u6301\u9664\u4e863\u5ea6\u5e26\u548c6\u5ea6\u5e26\u7684\u5176\u4ed6\u5206\u5e26\u65b9\u5f0f!";
                        Thread x$8 = NotSupportException$.MODULE$.apply$default$2(x$7);
                        int x$9 = NotSupportException$.MODULE$.apply$default$3(x$7);
                        throw new NotSupportException(x$7, x$8, x$9);
                    }
                    MathTransform mathTransform2 = mathTransform;
                    MathTransform nTransform = mathTransform2;
                    d2 = JTS.transform((Geometry)geometry, (MathTransform)nTransform).getArea();
                }
                d = d2;
                return d;
            } else {
                d = JTS.transform((Geometry)geometry, (MathTransform)transform).getArea();
            }
            return d;
        }
        String x$10 = new java.lang.StringBuilder(10).append("\u4e0d\u652f\u6301\u5f53\u524d\u8ba1\u7b97\u7c7b\u578b").append(calculateType).append("!").toString();
        Thread x$11 = NotSupportException$.MODULE$.apply$default$2(x$10);
        int x$12 = NotSupportException$.MODULE$.apply$default$3(x$10);
        throw new NotSupportException(x$10, x$11, x$12);
    }

    public Dataset<Row> calculate(AtlasDataTag dataTag, Dataset<Row> df, String calculateField, String calculateType, String calculateParams, int calculateZone, boolean isNewField) {
        String tableName = DataManager$.MODULE$.getViewName(dataTag, DataManager$.MODULE$.getViewName$default$2());
        AtlasVectorSchema atlasVectorSchema = VectorSparkSqlDataSetUtils$.MODULE$.getAtlasSchema(dataTag.atlasDataName(), df.schema());
        String geometryField = atlasVectorSchema.getGeometryDescriptor().getLocalName();
        boolean isTransform = false;
        int targetSrid = -1;
        int oSrid = -1;
        String string = calculateType.toLowerCase();
        String string2 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.GEODESIC_AREA();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            targetSrid = this.getSridFromString(calculateParams);
            oSrid = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).getCRS());
            CoordinateReferenceSystem coordinateReferenceSystem = com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).getCRS();
            if (coordinateReferenceSystem instanceof ProjectedCRS) {
                ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem;
                if (targetSrid != 4490 || com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID((CoordinateReferenceSystem)projectedCRS.getBaseCRS()) != 4490) {
                    String x$12 = "\u9488\u5bf9\u6295\u5f71\u5750\u6807\u7cfb\u4ec5\u652f\u6301CGCS2000\u8ba1\u7b97\u692d\u7403\u4e0b\u7684\u6295\u5f71\u5750\u6807\u7cfb!";
                    Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$12);
                    int x$3 = NotSupportException$.MODULE$.apply$default$3(x$12);
                    throw new NotSupportException(x$12, x$2, x$3);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (coordinateReferenceSystem instanceof GeographicCRS) {
                isTransform = oSrid != targetSrid;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)coordinateReferenceSystem);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.PROJECT_AREA();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                oSrid = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).getCRS());
                targetSrid = -1;
                if (StringUtils.isNotEmpty((CharSequence)calculateParams) && !(com.geoway.atlas.data.vector.common.crs.package$.MODULE$.GET_CRS_EPSG(targetSrid = this.getSridFromString(calculateParams)) instanceof ProjectedCRS)) {
                    String x$4 = "\u8ba1\u7b97\u6295\u5f71\u9762\u79ef\u6307\u5b9a\u5750\u6807\u7cfb\u5fc5\u987b\u4e3a\u6295\u5f71\u5750\u6807\u7cfb,\u5982\u679c\u8ba1\u7b97\u5206\u5e26\u6295\u5f71\u9762\u79ef\u5219\u4e0d\u9700\u8981\u8bbe\u7f6e\u5750\u6807\u7cfb\u53c2\u6570!";
                    Thread x$5 = NotSupportException$.MODULE$.apply$default$2(x$4);
                    int x$6 = NotSupportException$.MODULE$.apply$default$3(x$4);
                    throw new NotSupportException(x$4, x$5, x$6);
                }
                CoordinateReferenceSystem coordinateReferenceSystem = com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)atlasVectorSchema).getCRS();
                if (coordinateReferenceSystem instanceof ProjectedCRS) {
                    BoxedUnit boxedUnit;
                    if (targetSrid != -1) {
                        isTransform = oSrid != targetSrid;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (coordinateReferenceSystem instanceof GeographicCRS) {
                    if (oSrid != 4490) {
                        String x$7 = "\u4e0d\u652f\u6301\u975eCGCS2000\u5750\u6807\u7cfb\u8fdb\u884c\u6295\u5f71\u9762\u79ef\u53cd\u7b97!";
                        Thread x$8 = NotFoundException$.MODULE$.apply$default$2(x$7);
                        int x$9 = NotFoundException$.MODULE$.apply$default$3(x$7);
                        throw new NotFoundException(x$7, x$8, x$9);
                    }
                    isTransform = false;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)coordinateReferenceSystem);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (!StringUtils.isNotBlank((CharSequence)geometryField)) {
            String x$10 = "\u672a\u627e\u5230\u56fe\u5f62\u5b57\u6bb5!";
            Thread x$11 = NotFoundException$.MODULE$.apply$default$2(x$10);
            int x$12 = NotFoundException$.MODULE$.apply$default$3(x$10);
            throw new NotFoundException(x$10, x$11, x$12);
        }
        String sqlString = this.getCalculateSql(oSrid, atlasVectorSchema, geometryField, calculateField, calculateType, calculateZone, targetSrid);
        Buffer fieldNames = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(atlasVectorSchema.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLocalName(), Buffer$.MODULE$.canBuildFrom());
        String fieldNameString = isNewField ? ((TraversableOnce)fieldNames.map((Function1 & Serializable & scala.Serializable)nf -> new java.lang.StringBuilder(2).append("`").append((String)nf).append("`").toString(), Buffer$.MODULE$.canBuildFrom())).mkString(",") : ((TraversableOnce)((TraversableLike)fieldNames.diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{calculateField}))).map((Function1 & Serializable & scala.Serializable)nf -> new java.lang.StringBuilder(2).append("`").append((String)nf).append("`").toString(), Buffer$.MODULE$.canBuildFrom())).mkString(",");
        Dataset df2 = SparkRuntime$.MODULE$.sql(new java.lang.StringBuilder(15).append("select ").append(fieldNameString).append(", ").append(sqlString).append(" from ").append(tableName).toString());
        return df2;
    }

    public String getCalculateSql(int oSrid, AtlasVectorSchema schema, String geometryField, String calculateField, String calculateType, int calculateZone, int targetSrid) {
        String string;
        String string2 = calculateType.toLowerCase();
        String string3 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.ST_AREA();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = new java.lang.StringBuilder(17).append("ST_Area(`").append(geometryField).append("`) AS `").append(calculateField).append("`").toString();
        } else {
            String string5 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.GEODESIC_AREA();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                int originSrid = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)schema).getCRS());
                string = new java.lang.StringBuilder(29).append("ST_GeodesicArea(`").append(geometryField).append("`, ").append(originSrid).append(", ").append(targetSrid).append(") AS `").append(calculateField).append("`").toString();
            } else {
                String string7 = AtlasProcessCalculateParams.CalculateTarget$.MODULE$.PROJECT_AREA();
                String string8 = string2;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    string = new java.lang.StringBuilder(30).append("ST_ProjectArea(`").append(geometryField).append("`, ").append(oSrid).append(", ").append(targetSrid).append(", ").append(calculateZone).append(") AS `").append(calculateField).append("`").toString();
                } else {
                    String x$1 = new java.lang.StringBuilder(10).append("\u4e0d\u652f\u6301\u5f53\u524d\u8ba1\u7b97\u7c7b\u578b").append(calculateType).append("!").toString();
                    Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                    int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                    throw new NotSupportException(x$1, x$2, x$3);
                }
            }
        }
        return string;
    }

    private static final /* synthetic */ AtlasVectorSchema serializableSchema$lzycompute$1(LazyRef serializableSchema$lzy$1, String nSftString$1) {
        AtlasVectorSchema atlasVectorSchema;
        LazyRef lazyRef = serializableSchema$lzy$1;
        synchronized (lazyRef) {
            atlasVectorSchema = serializableSchema$lzy$1.initialized() ? (AtlasVectorSchema)serializableSchema$lzy$1.value() : (AtlasVectorSchema)serializableSchema$lzy$1.initialize((Object)AtlasVectorSchemas$.MODULE$.decode(nSftString$1));
        }
        return atlasVectorSchema;
    }

    public static final AtlasVectorSchema com$geoway$atlas$process$vector$spark$area$VectorSparkCalculateUtils$$serializableSchema$1(LazyRef serializableSchema$lzy$1, String nSftString$1) {
        return serializableSchema$lzy$1.initialized() ? (AtlasVectorSchema)serializableSchema$lzy$1.value() : VectorSparkCalculateUtils$.serializableSchema$lzycompute$1(serializableSchema$lzy$1, nSftString$1);
    }

    private VectorSparkCalculateUtils$() {
        MODULE$ = this;
    }
}

