/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.process.vector.spark.area;

import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.common.dataset.AtlasDataSet;
import com.geoway.atlas.dataset.common.manager.AtlasDataTag;
import com.geoway.atlas.dataset.vector.common.AtlasVectorDataSet;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.spark.VectorSparkDataSet;
import com.geoway.atlas.dataset.vector.spark.VectorSparkSqlDataSet;
import com.geoway.atlas.framework.spark.common.utils.RDDUtils$;
import com.geoway.atlas.index.common.AtlasIndex;
import com.geoway.atlas.index.common.partitionIndex.AtlasPartitionIndex;
import com.geoway.atlas.index.vector.common.AtlasVectorIndex;
import com.geoway.atlas.index.vector.common.AtlasVectorIndexMetadata;
import com.geoway.atlas.index.vector.common.AtlasVectorSparkIndex;
import com.geoway.atlas.process.vector.common.area.CalculateProcess;
import com.geoway.atlas.process.vector.spark.area.VectorSparkCalculateUtils$;
import com.geoway.atlas.process.vector.spark.common.VectorSparkProcess;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001\u0002\u0005\n\u0001aA\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"AA\f\u0001B\u0002B\u0003-Q\fC\u0003d\u0001\u0011\u0005A\rC\u0003l\u0001\u0011EC\u000eC\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005u\u0001\u0001\"\u0015\u0002 \tYb+Z2u_J\u001c\u0006/\u0019:l\u0007\u0006d7-\u001e7bi\u0016\u0004&o\\2fgNT!AC\u0006\u0002\t\u0005\u0014X-\u0019\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\rY,7\r^8s\u0015\t\u0001\u0012#A\u0004qe>\u001cWm]:\u000b\u0005I\u0019\u0012!B1uY\u0006\u001c(B\u0001\u000b\u0016\u0003\u00199Wm\\<bs*\ta#A\u0002d_6\u001c\u0001!\u0006\u0003\u001aGA\u001a4\u0003\u0002\u0001\u001bki\u0002RaG\u0010\"_Ij\u0011\u0001\b\u0006\u0003\u0015uQ!AH\u0007\u0002\r\r|W.\\8o\u0013\t\u0001CD\u0001\tDC2\u001cW\u000f\\1uKB\u0013xnY3tgB\u0011!e\t\u0007\u0001\t\u0015!\u0003A1\u0001&\u0005\u0005\t\u0016C\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aJ\u0017\n\u00059B#aA!osB\u0011!\u0005\r\u0003\u0006c\u0001\u0011\r!\n\u0002\u0002%B\u0011!e\r\u0003\u0006i\u0001\u0011\r!\n\u0002\u0002)B\u0011a\u0007O\u0007\u0002o)\u0011adC\u0005\u0003s]\u0012!CV3di>\u00148\u000b]1sWB\u0013xnY3tgB\u00111hP\u0007\u0002y)\u0011QHP\u0001\u0004Y><'B\u0001\u0010\u0012\u0013\t\u0001EHA\u0006MCjLHj\\4hS:<\u0017AE1uY\u0006\u001ch+Z2u_J$\u0015\r^1TKR\u0004Ra\u0011%\"_Ij\u0011\u0001\u0012\u0006\u0003=\u0015S!A\u0004$\u000b\u0005\u001d\u000b\u0012a\u00023bi\u0006\u001cX\r^\u0005\u0003\u0013\u0012\u0013!#\u0011;mCN4Vm\u0019;pe\u0012\u000bG/Y*fi\u0006IA-\u0019;b\u0019\u0006\u0014W\r\u001c\t\u0004O1s\u0015BA')\u0005\u0019y\u0005\u000f^5p]B!qJV-Z\u001d\t\u0001F\u000b\u0005\u0002RQ5\t!K\u0003\u0002T/\u00051AH]8pizJ!!\u0016\u0015\u0002\rA\u0013X\rZ3g\u0013\t9\u0006LA\u0002NCBT!!\u0016\u0015\u0011\u0005=S\u0016BA.Y\u0005\u0019\u0019FO]5oO\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007y\u000b''D\u0001`\u0015\t\u0001\u0007&A\u0004sK\u001adWm\u0019;\n\u0005\t|&\u0001C\"mCN\u001cH+Y4\u0002\rqJg.\u001b;?)\r)\u0017N\u001b\u000b\u0003M\"\u0004Ra\u001a\u0001\"_Ij\u0011!\u0003\u0005\u00069\u0012\u0001\u001d!\u0018\u0005\u0006\u0003\u0012\u0001\rA\u0011\u0005\u0006\u0015\u0012\u0001\raS\u0001\nG\u0006d7-\u001e7bi\u0016,B!\\9uoR!a\u000e`A\u0002)\ty\u0017\u0010E\u0003D\u0011B\u001ch\u000f\u0005\u0002#c\u0012)!/\u0002b\u0001K\t\u0011!+\u0015\t\u0003EQ$Q!^\u0003C\u0002\u0015\u0012!A\u0015*\u0011\u0005\t:H!\u0002=\u0006\u0005\u0004)#A\u0001*U\u0011\u001dQX!!AA\u0004m\f!\"\u001a<jI\u0016t7-\u001a\u00133!\rq\u0016M\u001e\u0005\u0006{\u0016\u0001\rA`\u0001\u0007g\u000eDW-\\1\u0011\u0005\r{\u0018bAA\u0001\t\n\t\u0012\t\u001e7bgZ+7\r^8s'\u000eDW-\\1\t\u000f\u0005\u0015Q\u00011\u0001\u0002\b\u0005)\u0011N\u001c3fqB1\u0011\u0011BA\baNl!!a\u0003\u000b\u0007y\tiAC\u0002\u0002\u0006EIA!!\u0005\u0002\f\tQ\u0011\t\u001e7bg&sG-\u001a=\u0002\u001d};W\r\u001e$jK2$g*Y7fgV\u0011\u0011q\u0003\t\u0005O\u0005e\u0011,C\u0002\u0002\u001c!\u0012Q!\u0011:sCf\fQbZ3u\u0003Rd\u0017m]%oI\u0016DXCBA\u0011\u0003c\t)\u0004\u0006\u0003\u0002$\u0005]\u0002\u0003CA\u0013\u0003W\ty#a\r\u000e\u0005\u0005\u001d\"b\u0001\u0010\u0002*)\u0019a\"!\u0004\n\t\u00055\u0012q\u0005\u0002\u0011\u0003Rd\u0017m\u001d,fGR|'/\u00138eKb\u00042AIA\u0019\t\u0015\u0011xA1\u0001&!\r\u0011\u0013Q\u0007\u0003\u0006k\u001e\u0011\r!\n\u0005\b\u0003s9\u0001\u0019AA\u001e\u0003!iW\r^1eCR\f\u0007\u0003BA\u0013\u0003{IA!a\u0010\u0002(\tA\u0012\t\u001e7bgZ+7\r^8s\u0013:$W\r_'fi\u0006$\u0017\r^1")
public class VectorSparkCalculateProcess<Q, R, T>
extends CalculateProcess<Q, R, T>
implements VectorSparkProcess,
LazyLogging {
    private final AtlasVectorDataSet<Q, R, T> atlasVectorDataSet;
    private final Option<Map<String, String>> dataLabel;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public AtlasDataSet<?, ?, ?> runProcess(Map<String, String> params, AtlasDataName resultName) {
        return VectorSparkProcess.runProcess$(this, params, resultName);
    }

    private Logger logger$lzycompute() {
        VectorSparkCalculateProcess vectorSparkCalculateProcess = this;
        synchronized (vectorSparkCalculateProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public <RQ, RR, RT> AtlasVectorDataSet<RQ, RR, RT> calculate(AtlasVectorSchema schema, AtlasIndex<RQ, RR> index, ClassTag<RT> evidence$2) {
        VectorSparkDataSet vectorSparkDataSet;
        AtlasVectorDataSet<Q, R, T> atlasVectorDataSet = this.atlasVectorDataSet;
        if (atlasVectorDataSet instanceof VectorSparkDataSet) {
            VectorSparkDataSet vectorSparkDataSet2 = (VectorSparkDataSet)atlasVectorDataSet;
            if (StringUtils.isEmpty((CharSequence)this.calculateName())) {
                return new VectorSparkDataSet(index, schema, vectorSparkDataSet2.rdd());
            }
            RDD<SimpleFeature> nRDD = VectorSparkCalculateUtils$.MODULE$.calculate((RDD<SimpleFeature>)vectorSparkDataSet2.rdd(), schema, this.calculateName(), this.calculateType(), this.calculateParams(), this.calculateZone(), this.fieldIsNew());
            vectorSparkDataSet = new VectorSparkDataSet(index, schema, nRDD);
        } else if (atlasVectorDataSet instanceof VectorSparkSqlDataSet) {
            VectorSparkSqlDataSet vectorSparkSqlDataSet = (VectorSparkSqlDataSet)atlasVectorDataSet;
            if (StringUtils.isEmpty((CharSequence)this.calculateName())) {
                return new VectorSparkSqlDataSet(index, schema.getDataName(), vectorSparkSqlDataSet.dataFrame());
            }
            Dataset<Row> df = VectorSparkCalculateUtils$.MODULE$.calculate(new AtlasDataTag(this.atlasVectorDataSet.getAtlasSchema().getDataName(), this.dataLabel), (Dataset<Row>)vectorSparkSqlDataSet.dataFrame(), this.calculateName(), this.calculateType(), this.calculateParams(), this.calculateZone(), this.fieldIsNew());
            vectorSparkDataSet = new VectorSparkSqlDataSet(index, schema.getDataName(), df);
        } else {
            throw new MatchError(atlasVectorDataSet);
        }
        return vectorSparkDataSet;
    }

    public String[] _getFieldNames() {
        String[] stringArray;
        AtlasVectorDataSet<Q, R, T> atlasVectorDataSet = this.atlasVectorDataSet;
        if (atlasVectorDataSet instanceof VectorSparkDataSet) {
            VectorSparkDataSet vectorSparkDataSet = (VectorSparkDataSet)atlasVectorDataSet;
            stringArray = (String[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vectorSparkDataSet.schema().getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLocalName(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (atlasVectorDataSet instanceof VectorSparkSqlDataSet) {
            VectorSparkSqlDataSet vectorSparkSqlDataSet = (VectorSparkSqlDataSet)atlasVectorDataSet;
            stringArray = vectorSparkSqlDataSet.dataFrame().schema().fieldNames();
        } else {
            throw new MatchError(atlasVectorDataSet);
        }
        return stringArray;
    }

    public <RQ, RR> AtlasVectorIndex<RQ, RR> getAtlasIndex(AtlasVectorIndexMetadata metadata) {
        AtlasVectorSparkIndex atlasVectorSparkIndex;
        RDD rdd = null;
        if (this.atlasVectorDataSet.getAtlasIndex() != null && (atlasVectorSparkIndex = (AtlasVectorSparkIndex)this.atlasVectorDataSet.getAtlasIndex()) != null && atlasVectorSparkIndex.getPartitionIndex() != null) {
            rdd = RDDUtils$.MODULE$.getDuplicate(atlasVectorSparkIndex.getPartitionIndex(), ClassTag$.MODULE$.apply(AtlasPartitionIndex.class));
        }
        return new AtlasVectorSparkIndex(metadata, rdd);
    }

    public VectorSparkCalculateProcess(AtlasVectorDataSet<Q, R, T> atlasVectorDataSet, Option<Map<String, String>> dataLabel, ClassTag<T> evidence$1) {
        this.atlasVectorDataSet = atlasVectorDataSet;
        this.dataLabel = dataLabel;
        super(atlasVectorDataSet, dataLabel, evidence$1);
        VectorSparkProcess.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

