/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.process.vector.spark.graphx;

import com.geoway.atlas.algorithm.vector.overlay.layer.index.MapTransToSimpleFeature;
import com.geoway.atlas.algorithm.vector.overlay.layer.index.MapTransToSimpleFeature$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.common.utils.IteratorUtils$;
import com.geoway.atlas.common.utils.UUIDUtils$;
import com.geoway.atlas.data.vector.common.feature.sf.SimpleFeatureBuilderUtils$;
import com.geoway.atlas.data.vector.common.feature.sf.Transform;
import com.geoway.atlas.data.vector.common.feature.sf.Transform$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchemas$;
import com.geoway.atlas.dataset.vector.spark.manager.VectorSparkDataManager$;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import com.geoway.atlas.index.common.partitionIndex.AtlasPartitionIndex;
import java.io.Serializable;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Edge$;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.GraphUtils$;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel$;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble$;

public final class ConnectedComponentsUtils$
implements LazyLogging {
    public static ConnectedComponentsUtils$ MODULE$;
    private final double PARTITION_NUMBER;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConnectedComponentsUtils$();
    }

    private Logger logger$lzycompute() {
        ConnectedComponentsUtils$ connectedComponentsUtils$ = this;
        synchronized (connectedComponentsUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public double PARTITION_NUMBER() {
        return this.PARTITION_NUMBER;
    }

    public RDD<SimpleFeature> process(AtlasVectorSchema avs, RDD<SimpleFeature> oidRDD, RDD<SimpleFeature> featureRDD, RDD<AtlasPartitionIndex<Envelope, String>> indexRDD, String oidField, AtlasVectorSchema resultAvs, String connectedField, double bufferSize, Option<scala.collection.immutable.Map<String, String>> dataLabel) {
        BoxedUnit boxedUnit;
        LazyRef serializableOAvs$lzy = new LazyRef();
        LazyRef serializableRAvs$lzy = new LazyRef();
        int oidFieldIndex = avs.indexOf(oidField);
        int[] oidFieldIndexes = new int[]{oidFieldIndex};
        String oAvsString = AtlasVectorSchemas$.MODULE$.encode(avs);
        String nAvsString = AtlasVectorSchemas$.MODULE$.encode(resultAvs);
        int connectedFieldIndex = resultAvs.indexOf(connectedField);
        RDD edgeRDD = indexRDD.zipPartitions(featureRDD, (Function2 & Serializable & scala.Serializable)(indexIterator, featureIterator) -> {
            ArrayBuffer resultEdge = new ArrayBuffer();
            if (indexIterator != null && indexIterator.nonEmpty() && featureIterator != null && featureIterator.nonEmpty()) {
                Tuple2 tuple2 = MapTransToSimpleFeature$.MODULE$.getArrayAndMap(featureIterator, oidFieldIndexes);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SimpleFeature[] sfArray = (SimpleFeature[])tuple2._1();
                HashMap map = (HashMap)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)sfArray, (Object)map);
                Tuple2 tuple23 = tuple22;
                SimpleFeature[] sfArray2 = (SimpleFeature[])tuple23._1();
                HashMap map2 = (HashMap)tuple23._2();
                MapTransToSimpleFeature mapTransToSimpleFeature = new MapTransToSimpleFeature((Map)map2);
                AtlasPartitionIndex partitionIndex = (AtlasPartitionIndex)indexIterator.next();
                Iterator sfIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sfArray2)).toIterator();
                while (sfIterator.hasNext()) {
                    SimpleFeature sf = (SimpleFeature)sfIterator.next();
                    long oid = BoxesRunTime.unboxToLong((Object)sf.getAttribute(oidFieldIndex));
                    Geometry geometry = (Geometry)sf.getDefaultGeometry();
                    Envelope geometryEnvelope = geometry.getEnvelopeInternal();
                    geometryEnvelope.expandBy(bufferSize);
                    partitionIndex.query((Object)geometryEnvelope, arg_0 -> ConnectedComponentsUtils$.$anonfun$process$2(mapTransToSimpleFeature, geometry, oidFieldIndex, (Buffer)resultEdge, oid, arg_0));
                }
            }
            return resultEdge.iterator();
        }, ClassTag$.MODULE$.apply(SimpleFeature.class), ClassTag$.MODULE$.apply(Edge.class));
        long edgeRDDCount = new StringOps(Predef$.MODULE$.augmentString((String)SparkRuntime$.MODULE$.tryPersist(edgeRDD, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), (Function2 & Serializable & scala.Serializable)(rdd, count) -> ConnectedComponentsUtils$.$anonfun$process$3(rdd, BoxesRunTime.unboxToLong((Object)count))).apply((Object)"count"))).toLong();
        int numPartitions = 0;
        if (edgeRDDCount > 0L) {
            numPartitions = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)edgeRDDCount / this.PARTITION_NUMBER()));
            this.logger().info(new java.lang.StringBuilder(7).append("\u5c06\u8fb9\u91cd\u5206\u533a\u4e3a:").append(numPartitions).toString());
            RDD edgeTempRDD = null;
            try {
                try {
                    RDD qual$1 = edgeRDD;
                    int x$1 = numPartitions;
                    boolean x$2 = numPartitions > edgeRDD.getNumPartitions();
                    Option x$3 = qual$1.coalesce$default$3();
                    int x$4 = x$1;
                    boolean x$5 = x$2;
                    Option x$6 = x$3;
                    Ordering x$7 = qual$1.coalesce$default$4(x$4, x$5, x$6);
                    edgeTempRDD = qual$1.coalesce(x$4, x$5, x$6, x$7);
                    edgeTempRDD.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
                    this.logger().info(new java.lang.StringBuilder(8).append("\u5168\u90e8\u8fb9\u7684\u6570\u91cf\u4e3a:").append(edgeTempRDD.count()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    if (edgeTempRDD != null) {
                        RDD qual$2 = edgeTempRDD;
                        boolean x$8 = qual$2.unpersist$default$1();
                        boxedUnit = qual$2.unpersist(x$8);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                RDD qual$3 = edgeRDD;
                boolean x$9 = qual$3.unpersist$default$1();
                qual$3.unpersist(x$9);
                edgeRDD = edgeTempRDD;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RDD<Tuple2<Object, Object>> verticesRDD = null;
        Graph graph = null;
        VertexRDD connectedVerticesRDD = null;
        RDD kvFeatureRDD = null;
        try {
            try {
                kvFeatureRDD = oidRDD.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> IteratorUtils$.MODULE$.nonEmpty(iterator) ? new Iterator<Tuple2<Object, SimpleFeature>>(iterator, oidFieldIndex){
                    private final Iterator iterator$1;
                    private final int oidFieldIndex$1;

                    public Iterator<Tuple2<Object, SimpleFeature>> seq() {
                        return Iterator.seq$((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.isEmpty$((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.isTraversableAgain$((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.hasDefiniteSize$((Iterator)this);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> take(int n) {
                        return Iterator.take$((Iterator)this, (int)n);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> drop(int n) {
                        return Iterator.drop$((Iterator)this, (int)n);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> slice(int from, int until) {
                        return Iterator.slice$((Iterator)this, (int)from, (int)until);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> sliceIterator(int from, int until) {
                        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<Tuple2<Object, SimpleFeature>, B> f) {
                        return Iterator.map$((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.$plus$plus$((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<Tuple2<Object, SimpleFeature>, GenTraversableOnce<B>> f) {
                        return Iterator.flatMap$((Iterator)this, f);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> filter(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.filter$((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<Object, SimpleFeature>, B, Object> p) {
                        return Iterator.corresponds$((Iterator)this, that, p);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> withFilter(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.withFilter$((Iterator)this, p);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> filterNot(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.filterNot$((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<Tuple2<Object, SimpleFeature>, B> pf) {
                        return Iterator.collect$((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<Object, SimpleFeature>, B> op) {
                        return Iterator.scanLeft$((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<Tuple2<Object, SimpleFeature>, B, B> op) {
                        return Iterator.scanRight$((Iterator)this, z, op);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> takeWhile(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.takeWhile$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<Tuple2<Object, SimpleFeature>>, Iterator<Tuple2<Object, SimpleFeature>>> partition(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.partition$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<Tuple2<Object, SimpleFeature>>, Iterator<Tuple2<Object, SimpleFeature>>> span(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.span$((Iterator)this, p);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> dropWhile(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.dropWhile$((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<Tuple2<Object, SimpleFeature>, B>> zip(Iterator<B> that) {
                        return Iterator.zip$((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.padTo$((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<Tuple2<Object, SimpleFeature>, Object>> zipWithIndex() {
                        return Iterator.zipWithIndex$((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<Tuple2<Object, SimpleFeature>, U> f) {
                        Iterator.foreach$((Iterator)this, f);
                    }

                    public boolean forall(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.forall$((Iterator)this, p);
                    }

                    public boolean exists(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.exists$((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.contains$((Iterator)this, (Object)elem);
                    }

                    public Option<Tuple2<Object, SimpleFeature>> find(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.find$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return Iterator.indexWhere$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<Tuple2<Object, SimpleFeature>, Object> p, int from) {
                        return Iterator.indexWhere$((Iterator)this, p, (int)from);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.indexOf$((Iterator)this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return Iterator.indexOf$((Iterator)this, elem, (int)from);
                    }

                    public BufferedIterator<Tuple2<Object, SimpleFeature>> buffered() {
                        return Iterator.buffered$((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.grouped$((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.sliding$default$2$((Iterator)this);
                    }

                    public int length() {
                        return Iterator.length$((Iterator)this);
                    }

                    public Tuple2<Iterator<Tuple2<Object, SimpleFeature>>, Iterator<Tuple2<Object, SimpleFeature>>> duplicate() {
                        return Iterator.duplicate$((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.sameElements$((Iterator)this, that);
                    }

                    public Traversable<Tuple2<Object, SimpleFeature>> toTraversable() {
                        return Iterator.toTraversable$((Iterator)this);
                    }

                    public Iterator<Tuple2<Object, SimpleFeature>> toIterator() {
                        return Iterator.toIterator$((Iterator)this);
                    }

                    public Stream<Tuple2<Object, SimpleFeature>> toStream() {
                        return Iterator.toStream$((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.toString$((Iterator)this);
                    }

                    public List<Tuple2<Object, SimpleFeature>> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.size$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<Tuple2<Object, SimpleFeature>, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<Tuple2<Object, SimpleFeature>, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, Tuple2<Object, SimpleFeature>, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<Tuple2<Object, SimpleFeature>, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, Tuple2<Object, SimpleFeature>, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<Tuple2<Object, SimpleFeature>, B, B> op) {
                        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, Tuple2<Object, SimpleFeature>, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<Tuple2<Object, SimpleFeature>, B, B> op) {
                        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<Object, SimpleFeature>, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<Tuple2<Object, SimpleFeature>, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<Object, SimpleFeature>, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<Tuple2<Object, SimpleFeature>> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Iterable<Tuple2<Object, SimpleFeature>> toIterable() {
                        return TraversableOnce.toIterable$((TraversableOnce)this);
                    }

                    public Seq<Tuple2<Object, SimpleFeature>> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<Tuple2<Object, SimpleFeature>> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<Tuple2<Object, SimpleFeature>> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<Object, SimpleFeature>, Col> cbf) {
                        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<Tuple2<Object, SimpleFeature>, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public boolean hasNext() {
                        return this.iterator$1.hasNext();
                    }

                    public Tuple2<Object, SimpleFeature> next() {
                        SimpleFeature sf = (SimpleFeature)this.iterator$1.next();
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)sf.getAttribute(this.oidFieldIndex$1))), (Object)sf);
                    }
                    {
                        this.iterator$1 = iterator$1;
                        this.oidFieldIndex$1 = oidFieldIndex$1;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Iterator.$init$((Iterator)this);
                    }
                } : package$.MODULE$.Iterator().empty(), oidRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                verticesRDD = this.getRelateVerticesRDD((RDD<Edge<String>>)edgeRDD);
                verticesRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
                long verticesCount = verticesRDD.count();
                this.logger().info(new java.lang.StringBuilder(11).append("\u4e0e\u8fb9\u76f8\u5173\u7684\u9876\u70b9\u6570\u91cf\u4e3a\uff1a").append(verticesCount).toString());
                graph = GraphUtils$.MODULE$.createGraph(verticesRDD, edgeRDD, dataLabel, GraphUtils$.MODULE$.createGraph$default$4(), GraphUtils$.MODULE$.createGraph$default$5(), GraphUtils$.MODULE$.createGraph$default$6(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(String.class));
                connectedVerticesRDD = GraphUtils$.MODULE$.connectedComponents(graph, dataLabel, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(String.class)).vertices();
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit2;
                BoxedUnit boxedUnit3;
                if (graph != null) {
                    Graph qual$4 = graph;
                    boolean x$10 = qual$4.unpersist$default$1();
                    boxedUnit3 = qual$4.unpersist(x$10);
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                if (connectedVerticesRDD != null) {
                    VertexRDD qual$5 = connectedVerticesRDD;
                    boolean x$11 = qual$5.unpersist$default$1();
                    boxedUnit2 = qual$5.unpersist(x$11);
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
        finally {
            RDD qual$6 = edgeRDD;
            boolean x$12 = qual$6.unpersist$default$1();
            qual$6.unpersist(x$12);
            if (verticesRDD != null) {
                RDD<Tuple2<Object, Object>> qual$7 = verticesRDD;
                boolean x$13 = qual$7.unpersist$default$1();
                qual$7.unpersist(x$13);
            }
        }
        RDD<Tuple2<Object, String>> candidateKOidRDD = this.getRawToStringOidRDD((RDD<Tuple2<Object, SimpleFeature>>)kvFeatureRDD, (VertexRDD<Object>)connectedVerticesRDD, numPartitions);
        SparkRuntime$.MODULE$.tryPersist(candidateKOidRDD, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), (Function2 & Serializable & scala.Serializable)(rdd, count) -> ConnectedComponentsUtils$.$anonfun$process$5(rdd, BoxesRunTime.unboxToLong((Object)count)));
        VectorSparkDataManager$.MODULE$.registerWithLabel(dataLabel, candidateKOidRDD);
        RDD<Tuple2<String, Object>> stringToLongRDD = this.getStringValueToLongValue(candidateKOidRDD);
        RDD<Tuple2<Object, Object>> kvOidRDD = this.getOidKVMap(candidateKOidRDD, stringToLongRDD);
        RDD joinRDD = RDD$.MODULE$.rddToPairRDDFunctions(kvFeatureRDD, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(SimpleFeature.class), (Ordering)Ordering.Long$.MODULE$).leftOuterJoin(kvOidRDD, numPartitions > 0 ? numPartitions : 1);
        return joinRDD.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> {
            Iterator iterator2;
            if (iterator != null && iterator.nonEmpty()) {
                Transform transform = Transform$.MODULE$.getTransform((SimpleFeatureType)ConnectedComponentsUtils$.serializableOAvs$1(serializableOAvs$lzy, oAvsString), (SimpleFeatureType)ConnectedComponentsUtils$.serializableRAvs$1(serializableRAvs$lzy, nAvsString));
                SimpleFeatureBuilder sfb = SimpleFeatureBuilderUtils$.MODULE$.getSimpleFeatureBuilder((SimpleFeatureType)ConnectedComponentsUtils$.serializableRAvs$1(serializableRAvs$lzy, nAvsString));
                iterator2 = new Iterator<SimpleFeature>(iterator, connectedFieldIndex, transform, sfb){
                    private final Iterator iterator$2;
                    private final int connectedFieldIndex$1;
                    private final Transform transform$1;
                    private final SimpleFeatureBuilder sfb$1;

                    public Iterator<SimpleFeature> seq() {
                        return Iterator.seq$((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.isEmpty$((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.isTraversableAgain$((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.hasDefiniteSize$((Iterator)this);
                    }

                    public Iterator<SimpleFeature> take(int n) {
                        return Iterator.take$((Iterator)this, (int)n);
                    }

                    public Iterator<SimpleFeature> drop(int n) {
                        return Iterator.drop$((Iterator)this, (int)n);
                    }

                    public Iterator<SimpleFeature> slice(int from, int until) {
                        return Iterator.slice$((Iterator)this, (int)from, (int)until);
                    }

                    public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<SimpleFeature, B> f) {
                        return Iterator.map$((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.$plus$plus$((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
                        return Iterator.flatMap$((Iterator)this, f);
                    }

                    public Iterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                        return Iterator.filter$((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                        return Iterator.corresponds$((Iterator)this, that, p);
                    }

                    public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                        return Iterator.withFilter$((Iterator)this, p);
                    }

                    public Iterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                        return Iterator.filterNot$((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                        return Iterator.collect$((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                        return Iterator.scanLeft$((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                        return Iterator.scanRight$((Iterator)this, z, op);
                    }

                    public Iterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                        return Iterator.takeWhile$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                        return Iterator.partition$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                        return Iterator.span$((Iterator)this, p);
                    }

                    public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                        return Iterator.dropWhile$((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
                        return Iterator.zip$((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.padTo$((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                        return Iterator.zipWithIndex$((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<SimpleFeature, U> f) {
                        Iterator.foreach$((Iterator)this, f);
                    }

                    public boolean forall(Function1<SimpleFeature, Object> p) {
                        return Iterator.forall$((Iterator)this, p);
                    }

                    public boolean exists(Function1<SimpleFeature, Object> p) {
                        return Iterator.exists$((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.contains$((Iterator)this, (Object)elem);
                    }

                    public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                        return Iterator.find$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<SimpleFeature, Object> p) {
                        return Iterator.indexWhere$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                        return Iterator.indexWhere$((Iterator)this, p, (int)from);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.indexOf$((Iterator)this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return Iterator.indexOf$((Iterator)this, elem, (int)from);
                    }

                    public BufferedIterator<SimpleFeature> buffered() {
                        return Iterator.buffered$((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.grouped$((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.sliding$default$2$((Iterator)this);
                    }

                    public int length() {
                        return Iterator.length$((Iterator)this);
                    }

                    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                        return Iterator.duplicate$((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.sameElements$((Iterator)this, that);
                    }

                    public Traversable<SimpleFeature> toTraversable() {
                        return Iterator.toTraversable$((Iterator)this);
                    }

                    public Iterator<SimpleFeature> toIterator() {
                        return Iterator.toIterator$((Iterator)this);
                    }

                    public Stream<SimpleFeature> toStream() {
                        return Iterator.toStream$((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.toString$((Iterator)this);
                    }

                    public List<SimpleFeature> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.size$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<SimpleFeature, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<SimpleFeature> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Iterable<SimpleFeature> toIterable() {
                        return TraversableOnce.toIterable$((TraversableOnce)this);
                    }

                    public Seq<SimpleFeature> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<SimpleFeature> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<SimpleFeature> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
                        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<SimpleFeature, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public boolean hasNext() {
                        return this.iterator$2.hasNext();
                    }

                    public SimpleFeature next() {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = (Tuple2)this.iterator$2.next();
                        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        SimpleFeature sf = (SimpleFeature)tuple2._1();
                        Option connectedFlagOpt = (Option)tuple2._2();
                        Tuple2 tuple23 = new Tuple2((Object)sf, (Object)connectedFlagOpt);
                        Tuple2 tuple24 = tuple23;
                        SimpleFeature sf2 = (SimpleFeature)tuple24._1();
                        Option connectedFlagOpt2 = (Option)tuple24._2();
                        long connectedFlag = BoxesRunTime.unboxToLong((Object)connectedFlagOpt2.get());
                        scala.collection.immutable.Map appendValues = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.connectedFieldIndex$1)), (Object)BoxesRunTime.boxToLong((long)connectedFlag))}));
                        Object[] nValues = this.transform$1.eval((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(sf2.getAttributes()).asScala(), appendValues);
                        return SimpleFeatureBuilderUtils$.MODULE$.createSimpleFeature(this.sfb$1, nValues, sf2.getID());
                    }
                    {
                        this.iterator$2 = iterator$2;
                        this.connectedFieldIndex$1 = connectedFieldIndex$1;
                        this.transform$1 = transform$1;
                        this.sfb$1 = sfb$1;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Iterator.$init$((Iterator)this);
                    }
                };
            } else {
                iterator2 = package$.MODULE$.Iterator().empty();
            }
            return iterator2;
        }, joinRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
    }

    public RDD<Tuple2<Object, Object>> getRelateVerticesRDD(RDD<Edge<String>> edgeRDD) {
        RDD qual$1 = edgeRDD.mapPartitions((Function1 & Serializable & scala.Serializable)edgeIterator -> IteratorUtils$.MODULE$.nonEmpty(edgeIterator) ? edgeIterator.flatMap((Function1 & Serializable & scala.Serializable)edge -> new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(new long[]{edge.dstId(), edge.srcId()})).iterator()) : package$.MODULE$.Iterator().empty(), edgeRDD.mapPartitions$default$2(), ClassTag$.MODULE$.Long()).distinct();
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iterator -> IteratorUtils$.MODULE$.nonEmpty(iterator) ? new Iterator<Tuple2<Object, Object>>(iterator){
            private final Iterator iterator$3;

            public Iterator<Tuple2<Object, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<Object, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<Object, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<Object, Object>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<Object, Object>> filter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<Object, Object>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<Object, Object>> withFilter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> filterNot(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<Object, Object>> takeWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> partition(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> span(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> dropWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<Object, Object>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<Object, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<Object, Object>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<Object, Object>> find(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<Object, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<Object, Object>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<Object, Object>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<Object, Object>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<Object, Object>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<Object, Object>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<Object, Object>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<Object, Object>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<Object, Object>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<Object, Object>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<Object, Object>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<Object, Object>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<Object, Object>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<Tuple2<Object, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.iterator$3.hasNext();
            }

            public Tuple2<Object, Object> next() {
                long id = BoxesRunTime.unboxToLong((Object)this.iterator$3.next());
                return new Tuple2.mcJJ.sp(id, id);
            }
            {
                this.iterator$3 = iterator$3;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        } : package$.MODULE$.Iterator().empty();
        boolean x$2 = qual$1.mapPartitions$default$2();
        return qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, String>> getRawToStringOidRDD(RDD<Tuple2<Object, SimpleFeature>> kvFeatureRDD, VertexRDD<Object> connectedVerticesRDD, int numPartitions) {
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(kvFeatureRDD.mapPartitions((Function1 & Serializable & scala.Serializable)kvIterator -> IteratorUtils$.MODULE$.nonEmpty(kvIterator) ? new Iterator<Tuple2<Object, Object>>(kvIterator){
            private final Iterator kvIterator$1;

            public Iterator<Tuple2<Object, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<Object, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<Object, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<Object, Object>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<Object, Object>> filter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<Object, Object>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<Object, Object>> withFilter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> filterNot(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<Object, Object>> takeWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> partition(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> span(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> dropWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<Object, Object>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<Object, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<Object, Object>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<Object, Object>> find(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<Object, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<Object, Object>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<Object, Object>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<Object, Object>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<Object, Object>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<Object, Object>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<Object, Object>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<Object, Object>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<Object, Object>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<Object, Object>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<Object, Object>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<Object, Object>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<Object, Object>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<Tuple2<Object, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.kvIterator$1.hasNext();
            }

            public Tuple2<Object, Object> next() {
                Tuple2 tuple2 = (Tuple2)this.kvIterator$1.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long k = tuple2._1$mcJ$sp();
                SimpleFeature v = (SimpleFeature)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)k), (Object)v);
                Tuple2 tuple23 = tuple22;
                long k2 = tuple23._1$mcJ$sp();
                SimpleFeature v2 = (SimpleFeature)tuple23._2();
                return new Tuple2.mcJJ.sp(k2, k2);
            }
            {
                this.kvIterator$1 = kvIterator$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        } : package$.MODULE$.Iterator().empty(), kvFeatureRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Long(), (Ordering)Ordering.Long$.MODULE$).leftOuterJoin(connectedVerticesRDD, numPartitions);
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iterator -> IteratorUtils$.MODULE$.nonEmpty(iterator) ? new Iterator<Tuple2<Object, String>>(iterator){
            private final Iterator iterator$4;

            public Iterator<Tuple2<Object, String>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<Object, String>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, String>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, String>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<Object, String>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<Object, String>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<Object, String>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<Object, String>> filter(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<Object, String>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<Object, String>> withFilter(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, String>> filterNot(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<Object, String>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<Object, String>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<Object, String>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<Object, String>> takeWhile(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, String>>, Iterator<Tuple2<Object, String>>> partition(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, String>>, Iterator<Tuple2<Object, String>>> span(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, String>> dropWhile(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<Object, String>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<Object, String>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<Object, String>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<Object, String>> find(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, String>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, String>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<Object, String>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<Object, String>>, Iterator<Tuple2<Object, String>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<Object, String>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<Object, String>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<Object, String>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<Object, String>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<Object, String>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<Object, String>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<Object, String>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<Object, String>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<Object, String>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<Object, String>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<Object, String>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<Object, String>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<Object, String>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<Object, String>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<Object, String>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<Object, String>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<Object, String>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<Object, String>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<Object, String>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<Object, String>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<Object, String>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<Tuple2<Object, String>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.iterator$4.hasNext();
            }

            public Tuple2<Object, String> next() {
                Tuple2 r = (Tuple2)this.iterator$4.next();
                Option connectIdOpt = (Option)((Tuple2)r._2())._2();
                String connectId = connectIdOpt.isDefined() ? connectIdOpt.get().toString() : UUIDUtils$.MODULE$.getUUID();
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)r._1$mcJ$sp()), (Object)connectId);
            }
            {
                this.iterator$4 = iterator$4;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        } : package$.MODULE$.Iterator().empty();
        boolean x$2 = qual$1.mapPartitions$default$2();
        return qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<String, Object>> getStringValueToLongValue(RDD<Tuple2<Object, String>> candidateKOidRDD) {
        return candidateKOidRDD.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> IteratorUtils$.MODULE$.nonEmpty(iterator) ? new Iterator<String>(iterator){
            private final Iterator iterator$5;

            public Iterator<String> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<String> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<String> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<String> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<String> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<String, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<String> filter(Function1<String, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<String> withFilter(Function1<String, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<String> filterNot(Function1<String, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<String> takeWhile(Function1<String, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<String> dropWhile(Function1<String, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<String, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<String, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<String, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<String, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<String> find(Function1<String, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<String, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<String, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<String> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<String> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<String> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<String> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<String> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<String, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, String, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<String, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<String> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<String> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<String> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<String> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<String> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<String, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.iterator$5.hasNext();
            }

            public String next() {
                return (String)((Tuple2)this.iterator$5.next())._2();
            }
            {
                this.iterator$5 = iterator$5;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        } : package$.MODULE$.Iterator().empty(), candidateKOidRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class)).distinct().zipWithUniqueId();
    }

    public RDD<Tuple2<Object, Object>> getOidKVMap(RDD<Tuple2<Object, String>> candidateKOidRDD, RDD<Tuple2<String, Object>> stringToLongRDD) {
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(candidateKOidRDD.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> IteratorUtils$.MODULE$.nonEmpty(iterator) ? new Iterator<Tuple2<String, Object>>(iterator){
            private final Iterator iterator$6;

            public Iterator<Tuple2<String, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<String, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<String, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<String, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<String, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<String, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<String, Object>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<String, Object>> filter(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<String, Object>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<String, Object>> withFilter(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<String, Object>> filterNot(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<String, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<String, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<String, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<String, Object>> takeWhile(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<String, Object>>, Iterator<Tuple2<String, Object>>> partition(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<String, Object>>, Iterator<Tuple2<String, Object>>> span(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<String, Object>> dropWhile(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<String, Object>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<String, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<String, Object>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<String, Object>> find(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<String, Object>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<String, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<String, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<String, Object>>, Iterator<Tuple2<String, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<String, Object>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<String, Object>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<String, Object>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<String, Object>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<String, Object>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<String, Object>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<String, Object>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<String, Object>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<String, Object>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<String, Object>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<String, Object>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<String, Object>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<String, Object>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<String, Object>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<String, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<String, Object>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<String, Object>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<String, Object>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<String, Object>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<String, Object>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<String, Object>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<Tuple2<String, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.iterator$6.hasNext();
            }

            public Tuple2<String, Object> next() {
                Tuple2 tuple2 = (Tuple2)this.iterator$6.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long id = tuple2._1$mcJ$sp();
                String sid = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), (Object)sid);
                Tuple2 tuple23 = tuple22;
                long id2 = tuple23._1$mcJ$sp();
                String sid2 = (String)tuple23._2();
                return new Tuple2((Object)sid2, (Object)BoxesRunTime.boxToLong((long)id2));
            }
            {
                this.iterator$6 = iterator$6;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        } : package$.MODULE$.Iterator().empty(), candidateKOidRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).leftOuterJoin(stringToLongRDD);
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iterator -> IteratorUtils$.MODULE$.nonEmpty(iterator) ? new Iterator<Tuple2<Object, Object>>(iterator){
            private final Iterator iterator$7;

            public Iterator<Tuple2<Object, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<Object, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<Object, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<Object, Object>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<Object, Object>> filter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<Object, Object>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<Object, Object>> withFilter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> filterNot(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<Object, Object>> takeWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> partition(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> span(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> dropWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<Object, Object>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<Object, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<Object, Object>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<Object, Object>> find(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<Object, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<Object, Object>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<Object, Object>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<Object, Object>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<Object, Object>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<Object, Object>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<Object, Object>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<Object, Object>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<Object, Object>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<Object, Object>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<Object, Object>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<Object, Object>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<Object, Object>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<Tuple2<Object, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.iterator$7.hasNext();
            }

            public Tuple2<Object, Object> next() {
                Tuple2 tuple2 = (Tuple2)((Tuple2)this.iterator$7.next())._2();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long k = tuple2._1$mcJ$sp();
                Option ovalue = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)k), (Object)ovalue);
                Tuple2 tuple23 = tuple22;
                long k2 = tuple23._1$mcJ$sp();
                Option ovalue2 = (Option)tuple23._2();
                return new Tuple2.mcJJ.sp(k2, BoxesRunTime.unboxToLong((Object)ovalue2.get()));
            }
            {
                this.iterator$7 = iterator$7;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        } : package$.MODULE$.Iterator().empty();
        boolean x$2 = qual$1.mapPartitions$default$2();
        return qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private static final /* synthetic */ AtlasVectorSchema serializableOAvs$lzycompute$1(LazyRef serializableOAvs$lzy$1, String oAvsString$1) {
        AtlasVectorSchema atlasVectorSchema;
        LazyRef lazyRef = serializableOAvs$lzy$1;
        synchronized (lazyRef) {
            atlasVectorSchema = serializableOAvs$lzy$1.initialized() ? (AtlasVectorSchema)serializableOAvs$lzy$1.value() : (AtlasVectorSchema)serializableOAvs$lzy$1.initialize((Object)AtlasVectorSchemas$.MODULE$.decode(oAvsString$1));
        }
        return atlasVectorSchema;
    }

    private static final AtlasVectorSchema serializableOAvs$1(LazyRef serializableOAvs$lzy$1, String oAvsString$1) {
        return serializableOAvs$lzy$1.initialized() ? (AtlasVectorSchema)serializableOAvs$lzy$1.value() : ConnectedComponentsUtils$.serializableOAvs$lzycompute$1(serializableOAvs$lzy$1, oAvsString$1);
    }

    private static final /* synthetic */ AtlasVectorSchema serializableRAvs$lzycompute$1(LazyRef serializableRAvs$lzy$1, String nAvsString$1) {
        AtlasVectorSchema atlasVectorSchema;
        LazyRef lazyRef = serializableRAvs$lzy$1;
        synchronized (lazyRef) {
            atlasVectorSchema = serializableRAvs$lzy$1.initialized() ? (AtlasVectorSchema)serializableRAvs$lzy$1.value() : (AtlasVectorSchema)serializableRAvs$lzy$1.initialize((Object)AtlasVectorSchemas$.MODULE$.decode(nAvsString$1));
        }
        return atlasVectorSchema;
    }

    private static final AtlasVectorSchema serializableRAvs$1(LazyRef serializableRAvs$lzy$1, String nAvsString$1) {
        return serializableRAvs$lzy$1.initialized() ? (AtlasVectorSchema)serializableRAvs$lzy$1.value() : ConnectedComponentsUtils$.serializableRAvs$lzycompute$1(serializableRAvs$lzy$1, nAvsString$1);
    }

    public static final /* synthetic */ void $anonfun$process$2(MapTransToSimpleFeature mapTransToSimpleFeature$1, Geometry geometry$1, int oidFieldIndex$1, Buffer resultEdge$1, long oid$1, String obj) {
        block0: {
            Geometry queryGeometry;
            SimpleFeature queryFeature = mapTransToSimpleFeature$1.transFrom(obj);
            if (queryFeature == null || geometry$1.disjoint(queryGeometry = (Geometry)queryFeature.getDefaultGeometry())) break block0;
            long queryOid = BoxesRunTime.unboxToLong((Object)queryFeature.getAttribute(oidFieldIndex$1));
            resultEdge$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge(oid$1, queryOid, Edge$.MODULE$.apply$default$3())}));
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$process$3(RDD rdd, long count) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)Long.toString(count))}));
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$process$5(RDD rdd, long count) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private ConnectedComponentsUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.PARTITION_NUMBER = 671088.64;
    }
}

