/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.process.vector.spark.overlay.union;

import com.geoway.atlas.algorithm.vector.common.feature.OverlayFeatureVisitor;
import com.geoway.atlas.algorithm.vector.common.feature.visitor.CombineWithIdFeatureVisitor;
import com.geoway.atlas.algorithm.vector.overlay.layer.index.MapTransToSimpleFeature;
import com.geoway.atlas.algorithm.vector.overlay.layer.index.MapTransToSimpleFeature$;
import com.geoway.atlas.algorithm.vector.overlay.layer.union.LayerUnion$;
import com.geoway.atlas.common.utils.IteratorUtils$;
import com.geoway.atlas.data.vector.common.feature.sft.BinaryFieldIndex;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchemas$;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import com.geoway.atlas.index.common.partitionIndex.AtlasPartitionIndex;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function4;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public final class VectorSparkUnionUtils$ {
    public static VectorSparkUnionUtils$ MODULE$;

    static {
        new VectorSparkUnionUtils$();
    }

    public <Q1, R1, T1, Q2, R2, T2, RT> RDD<RT> union(RDD<AtlasPartitionIndex<Q1, R1>> leftIndexRDD, RDD<T1> leftRDD, RDD<AtlasPartitionIndex<Q2, R2>> rightIndexRDD, RDD<T2> rightRDD, int lGeomIndex, int rGeomIndex, BinaryFieldIndex binaryFieldIndex, int[] oidIndexes, AtlasVectorSchema resultSft, int[] lOidIndexes, int[] rOidIndexes, double scale, ClassTag<T1> evidence$1, ClassTag<T2> evidence$2, ClassTag<RT> evidence$3) {
        LazyRef sft$lzy = new LazyRef();
        int[] leftFieldIndex = binaryFieldIndex.lFieldIndex();
        int[] rightFieldIndex = binaryFieldIndex.rFieldIndex();
        Broadcast leftFieldIndexBroadcast = SparkRuntime$.MODULE$.broadcast((Object)leftFieldIndex, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        Broadcast rightFieldIndexBroadcast = SparkRuntime$.MODULE$.broadcast((Object)rightFieldIndex, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        String serializableAvs = AtlasVectorSchemas$.MODULE$.encode(resultSft);
        return leftIndexRDD.zipPartitions(leftRDD, rightIndexRDD, rightRDD, (Function4 & Serializable & scala.Serializable)(leftIndexIterator, leftIterator, rightIndexIterator, rightIterator) -> {
            Iterator iterator;
            if (IteratorUtils$.MODULE$.isEmpty(leftIterator) && IteratorUtils$.MODULE$.isEmpty(rightIterator)) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                PrecisionModel pm = new PrecisionModel(scale);
                CombineWithIdFeatureVisitor fiVisitor = new CombineWithIdFeatureVisitor((SimpleFeatureType)VectorSparkUnionUtils$.sft$1(sft$lzy, serializableAvs), (int[])leftFieldIndexBroadcast.value(), (int[])rightFieldIndexBroadcast.value(), oidIndexes);
                MapTransToSimpleFeature leftIndexTransToSF = null;
                AtlasPartitionIndex leftIndex = null;
                Iterator leftNewIterator = package$.MODULE$.Iterator().empty();
                MapTransToSimpleFeature rightIndexTransToSF = null;
                AtlasPartitionIndex rightIndex = null;
                Iterator rightNewIterator = package$.MODULE$.Iterator().empty();
                if (IteratorUtils$.MODULE$.nonEmpty(leftIterator)) {
                    Tuple2 tuple2 = MapTransToSimpleFeature$.MODULE$.getArrayAndMap(leftIterator, lOidIndexes);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SimpleFeature[] leftArray = (SimpleFeature[])tuple2._1();
                    HashMap leftIndexMap = (HashMap)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)leftArray, (Object)leftIndexMap);
                    Tuple2 tuple23 = tuple22;
                    SimpleFeature[] leftArray2 = (SimpleFeature[])tuple23._1();
                    HashMap leftIndexMap2 = (HashMap)tuple23._2();
                    leftIndexTransToSF = MapTransToSimpleFeature$.MODULE$.apply((Map)leftIndexMap2);
                    leftNewIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftArray2)).toIterator();
                    leftIndex = (AtlasPartitionIndex)leftIndexIterator.next();
                }
                if (IteratorUtils$.MODULE$.nonEmpty(rightIterator)) {
                    Tuple2 tuple2 = MapTransToSimpleFeature$.MODULE$.getArrayAndMap(rightIterator, rOidIndexes);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SimpleFeature[] rightArray = (SimpleFeature[])tuple2._1();
                    HashMap rightIndexMap = (HashMap)tuple2._2();
                    Tuple2 tuple24 = new Tuple2((Object)rightArray, (Object)rightIndexMap);
                    Tuple2 tuple25 = tuple24;
                    SimpleFeature[] rightArray2 = (SimpleFeature[])tuple25._1();
                    HashMap rightIndexMap2 = (HashMap)tuple25._2();
                    rightIndexTransToSF = MapTransToSimpleFeature$.MODULE$.apply((Map)rightIndexMap2);
                    rightNewIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightArray2)).toIterator();
                    rightIndex = (AtlasPartitionIndex)rightIndexIterator.next();
                }
                LayerUnion$.MODULE$.union(leftIndex, leftNewIterator, rightIndex, rightNewIterator, pm, (OverlayFeatureVisitor)fiVisitor, leftIndexTransToSF, rightIndexTransToSF);
                iterator = fiVisitor.getIterator();
            }
            return iterator;
        }, evidence$1, ClassTag$.MODULE$.apply(AtlasPartitionIndex.class), evidence$2, evidence$3);
    }

    private static final /* synthetic */ AtlasVectorSchema sft$lzycompute$1(LazyRef sft$lzy$1, String serializableAvs$1) {
        AtlasVectorSchema atlasVectorSchema;
        LazyRef lazyRef = sft$lzy$1;
        synchronized (lazyRef) {
            atlasVectorSchema = sft$lzy$1.initialized() ? (AtlasVectorSchema)sft$lzy$1.value() : (AtlasVectorSchema)sft$lzy$1.initialize((Object)AtlasVectorSchemas$.MODULE$.decode(serializableAvs$1));
        }
        return atlasVectorSchema;
    }

    private static final AtlasVectorSchema sft$1(LazyRef sft$lzy$1, String serializableAvs$1) {
        return sft$lzy$1.initialized() ? (AtlasVectorSchema)sft$lzy$1.value() : VectorSparkUnionUtils$.sft$lzycompute$1(sft$lzy$1, serializableAvs$1);
    }

    private VectorSparkUnionUtils$() {
        MODULE$ = this;
    }
}

