/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.spark.common.rpc.server;

import com.geoway.atlas.data.vector.spark.common.rpc.server.SparkRpcServices;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class SparkRpcServerApi {
    public static final int MAX_INBOUND_METADATA_SIZE = 0xA00000;
    private final Server server;

    public SparkRpcServerApi(int port, ExecutorService rpcServerPool) {
        this((ServerBuilder<?>)NettyServerBuilder.forPort((int)port).maxInboundMetadataSize(0xA00000), rpcServerPool);
    }

    public SparkRpcServerApi(String host, int port, ExecutorService rpcServerPool) {
        this((ServerBuilder<?>)NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(host, port)).maxInboundMetadataSize(0xA00000), rpcServerPool);
    }

    public SparkRpcServerApi(ServerBuilder<?> serverBuilder, ExecutorService rpcServerPool) {
        this.server = serverBuilder.executor((Executor)rpcServerPool).addService((BindableService)new SparkRpcServices.SparkDataManagerService()).addService((BindableService)new SparkRpcServices.SparkVectorProcessService()).addService((BindableService)new SparkRpcServices.AtlasBaseOpService()).build();
    }

    public void start() throws IOException {
        System.out.println("Server init ...");
        this.server.start();
        int port = this.server.getPort();
        System.out.println("Server started, listening on : " + port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server since JVM is shutting down");
            try {
                this.stop();
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
            System.err.println("*** server shut down");
        }));
    }

    public void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(3L, TimeUnit.SECONDS);
        }
    }
}

