/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.spark.common.rpc.task;

import com.geoway.atlas.common.concurrent.AtlasThread$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.common.utils.InheritableThreadLocalUtils$;
import com.geoway.atlas.common.utils.UUIDUtils$;
import com.geoway.atlas.data.vector.spark.common.rpc.task.JobManager$;
import com.geoway.atlas.data.vector.spark.common.rpc.task.TaskManager;
import com.geoway.atlas.dataset.common.manager.DataManager$;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import com.geoway.atlas.framework.spark.common.listener.AtlasSparkListener$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class TaskManager$
implements LazyLogging {
    public static TaskManager$ MODULE$;
    private final Object jobLock;
    private final int MONITOR_INTERVAL;
    private final int ESTABLISH_TIMEOUT;
    private final int SOCKET_TIMEOUT;
    private final int GET_FROM_POOL_TIMEOUT;
    private final int POOL_SIZE;
    private final String ATLAS_URL;
    private final String TASK_TIMEOUT;
    private boolean isMonitor;
    private final ConcurrentMap<String, TaskManager.JobInfo> jobInfos;
    private final ConcurrentMap<String, List<Thread>> jobThreads;
    private final TaskManager.TaskMonitor taskMonitor;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new TaskManager$();
    }

    private Logger logger$lzycompute() {
        TaskManager$ taskManager$ = this;
        synchronized (taskManager$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Object jobLock() {
        return this.jobLock;
    }

    public int MONITOR_INTERVAL() {
        return this.MONITOR_INTERVAL;
    }

    public int ESTABLISH_TIMEOUT() {
        return this.ESTABLISH_TIMEOUT;
    }

    public int SOCKET_TIMEOUT() {
        return this.SOCKET_TIMEOUT;
    }

    public int GET_FROM_POOL_TIMEOUT() {
        return this.GET_FROM_POOL_TIMEOUT;
    }

    public int POOL_SIZE() {
        return this.POOL_SIZE;
    }

    public String ATLAS_URL() {
        return this.ATLAS_URL;
    }

    public String TASK_TIMEOUT() {
        return this.TASK_TIMEOUT;
    }

    public boolean isMonitor() {
        return this.isMonitor;
    }

    public void isMonitor_$eq(boolean x$1) {
        this.isMonitor = x$1;
    }

    public ConcurrentMap<String, TaskManager.JobInfo> jobInfos() {
        return this.jobInfos;
    }

    public ConcurrentMap<String, List<Thread>> jobThreads() {
        return this.jobThreads;
    }

    public TaskManager.TaskMonitor taskMonitor() {
        return this.taskMonitor;
    }

    public void startMonitor(Map<String, String> envParams) {
        if (envParams.contains((Object)this.ATLAS_URL()) && StringUtils.isNotBlank((CharSequence)((CharSequence)envParams.apply((Object)this.ATLAS_URL())))) {
            this.taskMonitor().setAtlasUrl((String)envParams.apply((Object)this.ATLAS_URL()));
        }
        AtlasThread$.MODULE$.start((Runnable)this.taskMonitor(), "TaskMonitor", false);
    }

    public String getRawTask(String taskId) {
        String string;
        if (taskId.length() > 24) {
            StringBuilder sb = new StringBuilder(taskId);
            string = sb.insert(8, "-").insert(13, "-").insert(18, "-").insert(23, "-").toString();
        } else {
            string = taskId;
        }
        return string;
    }

    public String start(String jobId, String taskId, Thread currentThread) {
        String string;
        SparkRuntime$.MODULE$.setLocalProperty(InheritableThreadLocalUtils$.MODULE$.ATLAS_TASK_ID(), taskId);
        Object object = this.jobLock();
        synchronized (object) {
            String string2;
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                Object object2;
                Object object3;
                List<Thread> threadArrays = null;
                if (!this.jobThreads().containsKey(taskId)) {
                    threadArrays = new ArrayList();
                    object3 = this.jobThreads().put(taskId, threadArrays);
                } else {
                    threadArrays = (List)this.jobThreads().get(taskId);
                    object3 = BoxedUnit.UNIT;
                }
                threadArrays.add(currentThread);
                TaskManager.JobInfo jobInfo = null;
                if (!this.jobInfos().containsKey(taskId)) {
                    jobInfo = new TaskManager.JobInfo(-1L, new ArrayList<String>());
                    object2 = this.jobInfos().put(taskId, jobInfo);
                } else {
                    jobInfo = (TaskManager.JobInfo)this.jobInfos().get(taskId);
                    object2 = BoxedUnit.UNIT;
                }
                jobInfo.currentTime_$eq(-1L);
                String nJobId = jobId;
                if (StringUtils.isBlank((CharSequence)jobId)) {
                    nJobId = UUIDUtils$.MODULE$.getUUID();
                }
                jobInfo.jobs().add(nJobId);
                string2 = nJobId;
            } else {
                string2 = jobId;
            }
            string = string2;
        }
        return string;
    }

    public void finished(String jobId, String taskId, Thread thread) {
        Object object = this.jobLock();
        synchronized (object) {
            Object object2;
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                TaskManager.JobInfo jobInfo = (TaskManager.JobInfo)this.jobInfos().get(taskId);
                TaskManager$.liftedTree1$1(jobInfo, jobId);
                List jobThreadList = (List)this.jobThreads().get(taskId);
                if (jobThreadList != null) {
                    Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> jobThreadList.remove(thread));
                    object2 = jobThreadList.isEmpty() ? this.jobThreads().remove(taskId) : BoxedUnit.UNIT;
                } else {
                    object2 = BoxedUnit.UNIT;
                }
            } else {
                object2 = BoxedUnit.UNIT;
            }
        }
    }

    public void success(String jobId, String taskId, Thread thread) {
        this.finished(jobId, taskId, thread);
    }

    public void failed(String jobId, String taskId, Thread thread) {
        this.finished(jobId, taskId, thread);
    }

    public void cancelTask(String taskId) {
        this.logger().info("cancel: 1.\u505c\u6b62\u8fd0\u884c\u4e2d\u7684taskId\u76f8\u5173\u7684\u7ebf\u7a0b");
        Object object = this.jobLock();
        synchronized (object) {
            Object object2;
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                if (this.jobThreads().containsKey(taskId)) {
                    ((Iterable)this.jobThreads().get(taskId)).forEach(thread -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> thread.interrupt()));
                    object2 = this.jobThreads().remove(taskId);
                } else {
                    object2 = BoxedUnit.UNIT;
                }
            } else {
                object2 = BoxedUnit.UNIT;
            }
        }
        this.logger().info("cancel: 2.\u6539\u53d8\u8bb0\u5f55\u7684job\u8fd0\u884c\u72b6\u6001");
        Object object3 = this.jobLock();
        synchronized (object3) {
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                TaskManager.JobInfo jobInfo = (TaskManager.JobInfo)this.jobInfos().get(taskId);
                TaskManager$.liftedTree2$1(jobInfo);
            }
        }
        this.logger().info("cancel: 3.\u505c\u6b62\u8fd0\u884c\u4e2d\u7684sparkjob");
        AtlasSparkListener$.MODULE$.cancelAtlasTask(taskId);
        this.logger().info("cancel: 4.\u5220\u9664\u4efb\u52a1\u76f8\u5173\u6570\u636e");
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataManager$.MODULE$.unregister((Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.IDENTITY_SUFFIX()), (Object)taskId)})))));
    }

    public void putFinishJobIfNotExist(String rawTaskId, String jobId) {
        Object object = this.jobLock();
        synchronized (object) {
            Object object2;
            if (StringUtils.isNotBlank((CharSequence)rawTaskId)) {
                String taskId = rawTaskId.replace("-", "");
                object2 = !this.jobInfos().containsKey(taskId) ? this.jobInfos().put(taskId, new TaskManager.JobInfo(System.currentTimeMillis(), new ArrayList<String>())) : BoxedUnit.UNIT;
            } else {
                object2 = BoxedUnit.UNIT;
            }
        }
    }

    public void remove(String taskId) {
        try {
            DataManager$.MODULE$.unregister((Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.IDENTITY_SUFFIX()), (Object)taskId)}))));
        }
        finally {
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (TaskManager.JobInfo)MODULE$.jobInfos().remove(taskId));
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JobManager$.MODULE$.remove(MODULE$.getRawTask(taskId)));
        }
    }

    private static final /* synthetic */ void liftedTree1$1(TaskManager.JobInfo jobInfo$2, String jobId$1) {
        try {
            jobInfo$2.jobs().remove(jobId$1);
            if (jobInfo$2.jobs().isEmpty()) {
                jobInfo$2.currentTime_$eq(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {}
    }

    private static final /* synthetic */ void liftedTree2$1(TaskManager.JobInfo jobInfo$3) {
        try {
            jobInfo$3.jobs().removeAll(jobInfo$3.jobs());
            jobInfo$3.currentTime_$eq(System.currentTimeMillis());
        }
        catch (Throwable throwable) {}
    }

    private TaskManager$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.jobLock = new Object();
        this.MONITOR_INTERVAL = 2000;
        this.ESTABLISH_TIMEOUT = 20000;
        this.SOCKET_TIMEOUT = 40000;
        this.GET_FROM_POOL_TIMEOUT = 3000;
        this.POOL_SIZE = 100;
        this.ATLAS_URL = "atlas.url";
        this.TASK_TIMEOUT = "atlas.rpc.spark.task.timeout";
        this.isMonitor = true;
        this.jobInfos = new ConcurrentHashMap<String, TaskManager.JobInfo>();
        this.jobThreads = new ConcurrentHashMap<String, List<Thread>>();
        this.taskMonitor = new TaskManager.TaskMonitor();
    }
}

