/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.spark.common.rpc.server;

import com.geoway.atlas.common.api.AtlasCommonDataApi;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NullException;
import com.geoway.atlas.common.utils.InheritableThreadLocalUtils;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasBaseOpGrpc;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasJobInfo;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataName;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataTag;
import com.geoway.atlas.data.vector.spark.common.rpc.EnvInfo;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcAtlasBaseOpRespons;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcBinaryProcessParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDeleteDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDeleteRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcExistDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcExistDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcListProcessParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcLoadDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcNilProcessParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcPersistDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcPersistRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcRenameDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcRenameDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcRespondMessage;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcSaveDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcShowDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcTaskId;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcTaskRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcUnPersistDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcUnPersistRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcUnitaryProcessParams;
import com.geoway.atlas.data.vector.spark.common.rpc.SparkDataManagerGrpc;
import com.geoway.atlas.data.vector.spark.common.rpc.SparkVectorProcessGrpc;
import com.geoway.atlas.data.vector.spark.common.rpc.common.GrpcExceptionUtil;
import com.geoway.atlas.data.vector.spark.common.rpc.task.JobManager;
import com.geoway.atlas.data.vector.spark.common.rpc.task.TaskManager;
import com.geoway.atlas.dataset.common.manager.AtlasDataTag;
import com.geoway.atlas.dataset.common.manager.DataManager;
import com.geoway.atlas.dataset.common.manager.DataManager$;
import com.geoway.atlas.process.spark.common.api.SparkProcessSimpleApi;
import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.HashMap;
import scala.collection.mutable.Builder;

public class SparkRpcServices {
    private static final Logger logger = LoggerFactory.getLogger(SparkRpcServices.class);

    public static <T> Option<scala.collection.immutable.Map<String, String>> addTaskIdLabel(AtlasRpcDataName rpcDataName, String taskId, java.util.Map<String, String> rpcDataLabelMap, StreamObserver<T> streamObserver) {
        java.util.Map<String, String> resultDataLabelMap = rpcDataLabelMap;
        if (StringUtils.isBlank((CharSequence)rpcDataName.getNameSpace())) {
            if (StringUtils.isBlank((CharSequence)taskId)) {
                NullException nullException = new NullException("\u5fc5\u987b\u8bbe\u7f6etaskId\u7528\u4e8e\u5220\u9664\u4e34\u65f6\u6570\u636e!", Thread.currentThread(), 3);
                streamObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)nullException));
                throw nullException;
            }
            resultDataLabelMap = new java.util.HashMap<String, String>(rpcDataLabelMap);
            resultDataLabelMap.put(DataManager.IDENTITY_SUFFIX(), taskId);
        }
        return SparkRpcServices.getOptionMap(resultDataLabelMap);
    }

    public static void initService(String taskId) {
        InheritableThreadLocalUtils.setLocalProperty((String)InheritableThreadLocalUtils.ATLAS_TASK_ID(), (String)taskId);
    }

    private static AtlasDataName getAtlasDataName(AtlasRpcDataName rpcDataName) {
        AtlasDataName atlasDataName = StringUtils.isEmpty((CharSequence)rpcDataName.getNameSpace()) ? new AtlasDataName("", rpcDataName.getLocalName().toLowerCase()) : new AtlasDataName(rpcDataName.getNameSpace().toLowerCase(), rpcDataName.getLocalName().toLowerCase());
        return atlasDataName;
    }

    private static AtlasRpcDataName getRpcDataName(AtlasDataName atlasDataName) {
        AtlasRpcDataName.Builder rpcDataNameBuilder = AtlasRpcDataName.newBuilder();
        if (StringUtils.isNotBlank((CharSequence)atlasDataName.nameSpace())) {
            rpcDataNameBuilder.setNameSpace(atlasDataName.nameSpace().toLowerCase());
        }
        rpcDataNameBuilder.setLocalName(atlasDataName.localName().toLowerCase());
        return rpcDataNameBuilder.build();
    }

    private static AtlasRpcDataTag getAtlasRpcDataTag(AtlasDataTag atlasDataTag) {
        AtlasRpcDataTag.Builder rpcDataTagBuilder = AtlasRpcDataTag.newBuilder();
        AtlasRpcDataName rpcDataName = SparkRpcServices.getRpcDataName(atlasDataTag.atlasDataName());
        rpcDataTagBuilder.setDataName(rpcDataName);
        if (atlasDataTag.labelOptions().isDefined()) {
            java.util.Map labelMap = JavaConverters.mapAsJavaMap((Map)((Map)atlasDataTag.labelOptions().get()));
            rpcDataTagBuilder.putAllDataLabel(labelMap);
        }
        return rpcDataTagBuilder.build();
    }

    public static Option<scala.collection.immutable.Map<String, String>> getOptionMap(java.util.Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return Option.apply(null);
        }
        scala.collection.mutable.Map scalaMap = JavaConverters.mapAsScalaMap(map);
        Growable convert = Map$.MODULE$.newBuilder().$plus$plus$eq((TraversableOnce)scalaMap.toSeq());
        Object convertResult = ((Builder)convert).result();
        scala.collection.immutable.Map scalaImMap = (scala.collection.immutable.Map)convertResult;
        return Some.apply((Object)scalaImMap);
    }

    private static scala.collection.immutable.Map<String, String> getScalaMap(java.util.Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            scala.collection.mutable.Map scalaMap = JavaConverters.mapAsScalaMap(map);
            Growable convert = Map$.MODULE$.newBuilder().$plus$plus$eq((TraversableOnce)scalaMap.toSeq());
            Object convertResult = ((Builder)convert).result();
            scala.collection.immutable.Map scalaImMap = (scala.collection.immutable.Map)convertResult;
            return scalaImMap;
        }
        HashMap scalaImMap = new HashMap();
        return scalaImMap;
    }

    public static class AtlasBaseOpService
    extends AtlasBaseOpGrpc.AtlasBaseOpImplBase {
        @Override
        public void startMonitorTask(EnvInfo envInfo, StreamObserver<RpcAtlasBaseOpRespons> responseObserver) {
            try {
                TaskManager.startMonitor((scala.collection.immutable.Map<String, String>)SparkRpcServices.getScalaMap(envInfo.getEnvParamsMap()));
                RpcAtlasBaseOpRespons rpcAtlasBaseOpRespons = RpcAtlasBaseOpRespons.newBuilder().setResponse("\u5b8c\u6210\u6267\u884c\u542f\u52a8\u76d1\u63a7\u547d\u4ee4!").build();
                responseObserver.onNext((Object)rpcAtlasBaseOpRespons);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                try {
                    responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                }
                catch (Throwable ignored) {
                    logger.error("\u8fd4\u56de\u62a5\u9519\u4fe1\u606f\u5931\u8d25!");
                }
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void startJob(AtlasJobInfo atlasJobInfo, StreamObserver<RpcAtlasBaseOpRespons> responseObserver) {
            try {
                String rawTaskId = atlasJobInfo.getTaskId();
                String taskId = StringUtils.replace((String)rawTaskId, (String)"-", (String)"");
                SparkRpcServices.initService(taskId);
                String response = JobManager.startJob(rawTaskId, atlasJobInfo.getJobId(), atlasJobInfo.getMessage());
                responseObserver.onNext((Object)RpcAtlasBaseOpRespons.newBuilder().setResponse(response).build());
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                try {
                    responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                }
                catch (Throwable ignored) {
                    logger.error("\u8fd4\u56de\u62a5\u9519\u4fe1\u606f\u5931\u8d25!");
                }
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void finishJob(AtlasJobInfo atlasJobInfo, StreamObserver<RpcAtlasBaseOpRespons> responseObserver) {
            try {
                String rawTaskId = atlasJobInfo.getTaskId();
                String taskId = StringUtils.replace((String)rawTaskId, (String)"-", (String)"");
                SparkRpcServices.initService(taskId);
                JobManager.finishJob(rawTaskId, atlasJobInfo.getJobId(), atlasJobInfo.getMessage());
                responseObserver.onNext((Object)RpcAtlasBaseOpRespons.newBuilder().setResponse("ok").build());
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                try {
                    responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                }
                catch (Throwable ignored) {
                    logger.error("\u8fd4\u56de\u62a5\u9519\u4fe1\u606f\u5931\u8d25!");
                }
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void cancelJob(AtlasJobInfo atlasJobInfo, StreamObserver<RpcAtlasBaseOpRespons> responseObserver) {
            try {
                String rawTaskId = atlasJobInfo.getTaskId();
                String taskId = StringUtils.replace((String)rawTaskId, (String)"-", (String)"");
                SparkRpcServices.initService(taskId);
                JobManager.cancelJob(rawTaskId, atlasJobInfo.getJobId(), atlasJobInfo.getMessage());
                responseObserver.onNext((Object)RpcAtlasBaseOpRespons.newBuilder().setResponse("ok").build());
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                try {
                    responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                }
                catch (Throwable ignored) {
                    logger.error("\u8fd4\u56de\u62a5\u9519\u4fe1\u606f\u5931\u8d25!");
                }
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void getResponse(AtlasJobInfo atlasJobInfo, StreamObserver<RpcAtlasBaseOpRespons> responseObserver) {
            try {
                String rawTaskId = atlasJobInfo.getTaskId();
                String taskId = StringUtils.replace((String)rawTaskId, (String)"-", (String)"");
                SparkRpcServices.initService(taskId);
                responseObserver.onNext((Object)RpcAtlasBaseOpRespons.newBuilder().setResponse(JobManager.getJobResponse(atlasJobInfo.getJobId())).build());
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                try {
                    responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                }
                catch (Throwable ignored) {
                    logger.error("\u8fd4\u56de\u62a5\u9519\u4fe1\u606f\u5931\u8d25!");
                }
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }
    }

    public static class SparkVectorProcessService
    extends SparkVectorProcessGrpc.SparkVectorProcessImplBase {
        @Override
        public void nilProcess(RpcNilProcessParams request, StreamObserver<RpcRespondMessage> responseObserver) {
            String processName = request.getProcess();
            java.util.Map<String, String> processParams = request.getProcessParamsMap();
            AtlasRpcDataName resultName = request.getResultDataTag().getDataName();
            java.util.Map<String, String> resultLabelMap = request.getResultDataTag().getDataLabelMap();
            String jobId = request.getJobId();
            String taskId = request.getTaskId();
            SparkRpcServices.initService(taskId);
            AtlasDataName resultDataName = SparkRpcServices.getAtlasDataName(resultName);
            Option<scala.collection.immutable.Map<String, String>> resultLabelOpt = SparkRpcServices.addTaskIdLabel(resultName, taskId, resultLabelMap, responseObserver);
            scala.collection.immutable.Map processParamsMap = SparkRpcServices.getScalaMap(processParams);
            Thread currentThread = Thread.currentThread();
            String nJobId = TaskManager.start(jobId, taskId, currentThread);
            try {
                SparkProcessSimpleApi.nilProcess((String)processName, (scala.collection.immutable.Map)processParamsMap, (AtlasDataName)resultDataName, resultLabelOpt);
                RpcRespondMessage dmRespond = RpcRespondMessage.newBuilder().setResponse("\u5904\u7406\u6d41\u7a0b:" + processName + " - \u6267\u884c\u6210\u529f!").build();
                TaskManager.success(nJobId, taskId, currentThread);
                responseObserver.onNext((Object)dmRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                TaskManager.failed(nJobId, taskId, currentThread);
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void unitaryProcess(RpcUnitaryProcessParams request, StreamObserver<RpcRespondMessage> responseObserver) {
            AtlasRpcDataName baseName = request.getDataTag().getDataName();
            java.util.Map<String, String> baseLabel = request.getDataTag().getDataLabelMap();
            String processName = request.getProcess();
            java.util.Map<String, String> processParams = request.getProcessParamsMap();
            AtlasRpcDataName resultName = request.getResultDataTag().getDataName();
            java.util.Map<String, String> resultLabelMap = request.getResultDataTag().getDataLabelMap();
            String jobId = request.getJobId();
            String taskId = request.getTaskId();
            SparkRpcServices.initService(taskId);
            AtlasDataName baseDataName = SparkRpcServices.getAtlasDataName(baseName);
            Option<scala.collection.immutable.Map<String, String>> baseLabelOpt = SparkRpcServices.addTaskIdLabel(baseName, taskId, baseLabel, responseObserver);
            AtlasDataName resultDataName = SparkRpcServices.getAtlasDataName(resultName);
            Option<scala.collection.immutable.Map<String, String>> resultLabelOpt = SparkRpcServices.addTaskIdLabel(resultName, taskId, resultLabelMap, responseObserver);
            scala.collection.immutable.Map processParamsMap = SparkRpcServices.getScalaMap(processParams);
            Thread currentThread = Thread.currentThread();
            String nJobId = TaskManager.start(jobId, taskId, currentThread);
            try {
                SparkProcessSimpleApi.unitaryProcess((AtlasDataName)baseDataName, baseLabelOpt, (String)processName, (scala.collection.immutable.Map)processParamsMap, (AtlasDataName)resultDataName, resultLabelOpt);
                RpcRespondMessage dmRespond = RpcRespondMessage.newBuilder().setResponse("\u6570\u636e - " + baseName + " - \u5904\u7406\u6d41\u7a0b:" + processName + " - \u6267\u884c\u6210\u529f!").build();
                TaskManager.success(nJobId, taskId, currentThread);
                responseObserver.onNext((Object)dmRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                TaskManager.failed(nJobId, taskId, currentThread);
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void listProcess(RpcListProcessParams request, StreamObserver<RpcRespondMessage> responseObserver) {
            List<AtlasRpcDataTag> atlasRpcDataTags = request.getDataTagsList();
            String processName = request.getProcess();
            java.util.Map<String, String> processParams = request.getProcessParamsMap();
            AtlasRpcDataName resultName = request.getResultDataTag().getDataName();
            java.util.Map<String, String> resultLabelMap = request.getResultDataTag().getDataLabelMap();
            String jobId = request.getJobId();
            String taskId = request.getTaskId();
            SparkRpcServices.initService(taskId);
            AtlasDataTag[] dataTags = new AtlasDataTag[atlasRpcDataTags.size()];
            for (int i = 0; i < dataTags.length; ++i) {
                AtlasRpcDataTag atlasRpcDataTag = atlasRpcDataTags.get(i);
                AtlasRpcDataName rpcDataName = atlasRpcDataTag.getDataName();
                java.util.Map<String, String> dataLabel = atlasRpcDataTag.getDataLabelMap();
                AtlasDataName dataName = SparkRpcServices.getAtlasDataName(rpcDataName);
                Option<scala.collection.immutable.Map<String, String>> dataLabelOpt = SparkRpcServices.addTaskIdLabel(rpcDataName, taskId, dataLabel, responseObserver);
                dataTags[i] = new AtlasDataTag(dataName, dataLabelOpt);
            }
            AtlasDataName resultDataName = SparkRpcServices.getAtlasDataName(resultName);
            Option<scala.collection.immutable.Map<String, String>> resultLabelOpt = SparkRpcServices.addTaskIdLabel(resultName, taskId, resultLabelMap, responseObserver);
            scala.collection.immutable.Map processParamsMap = SparkRpcServices.getScalaMap(processParams);
            Thread currentThread = Thread.currentThread();
            String nJobId = TaskManager.start(jobId, taskId, currentThread);
            try {
                logger.warn("\u51c6\u5907\u4f7f\u7528\u5904\u7406\u5668 " + processName + " \u8fdb\u884c\u6570\u636e\u5904\u7406\uff01");
                SparkProcessSimpleApi.listProcess((AtlasDataTag[])dataTags, (String)processName, (scala.collection.immutable.Map)processParamsMap, (AtlasDataName)resultDataName, resultLabelOpt);
                RpcRespondMessage dmRespond = RpcRespondMessage.newBuilder().setResponse("\u6570\u636e - " + Arrays.stream(dataTags).map(adt -> {
                    StringBuilder sb = new StringBuilder();
                    if (StringUtils.isNotBlank((CharSequence)adt.atlasDataName().nameSpace())) {
                        sb.append(adt.atlasDataName().nameSpace()).append("_");
                    }
                    return sb.append(adt.atlasDataName().localName());
                }).collect(Collectors.joining(",")) + " - \u5904\u7406\u6d41\u7a0b:" + processName + " - \u6267\u884c\u6210\u529f!").build();
                TaskManager.success(nJobId, taskId, currentThread);
                responseObserver.onNext((Object)dmRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                TaskManager.failed(nJobId, taskId, currentThread);
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void binaryProcess(RpcBinaryProcessParams request, StreamObserver<RpcRespondMessage> responseObserver) {
            AtlasRpcDataName baseName = request.getBaseDataTag().getDataName();
            java.util.Map<String, String> baseLabel = request.getBaseDataTag().getDataLabelMap();
            AtlasRpcDataName otherName = request.getOtherDataTag().getDataName();
            java.util.Map<String, String> otherLabel = request.getOtherDataTag().getDataLabelMap();
            String processName = request.getProcess();
            java.util.Map<String, String> processParams = request.getProcessParamsMap();
            AtlasRpcDataName resultName = request.getResultDataTag().getDataName();
            java.util.Map<String, String> resultLabelMap = request.getResultDataTag().getDataLabelMap();
            String jobId = request.getJobId();
            String taskId = request.getTaskId();
            SparkRpcServices.initService(taskId);
            AtlasDataName baseDataName = SparkRpcServices.getAtlasDataName(baseName);
            Option<scala.collection.immutable.Map<String, String>> baseLabelOpt = SparkRpcServices.addTaskIdLabel(baseName, taskId, baseLabel, responseObserver);
            AtlasDataName otherDataName = SparkRpcServices.getAtlasDataName(otherName);
            Option<scala.collection.immutable.Map<String, String>> otherLabelOpt = SparkRpcServices.addTaskIdLabel(otherName, taskId, otherLabel, responseObserver);
            AtlasDataName resultDataName = SparkRpcServices.getAtlasDataName(resultName);
            Option<scala.collection.immutable.Map<String, String>> resultLabelOpt = SparkRpcServices.addTaskIdLabel(resultName, taskId, resultLabelMap, responseObserver);
            scala.collection.immutable.Map processParamsMap = SparkRpcServices.getScalaMap(processParams);
            Thread currentThread = Thread.currentThread();
            String nJobId = TaskManager.start(jobId, taskId, currentThread);
            try {
                SparkProcessSimpleApi.binaryProcess((AtlasDataName)baseDataName, baseLabelOpt, (AtlasDataName)otherDataName, otherLabelOpt, (String)processName, (scala.collection.immutable.Map)processParamsMap, (AtlasDataName)resultDataName, resultLabelOpt);
                RpcRespondMessage dmRespond = RpcRespondMessage.newBuilder().setResponse("\u6570\u636e - " + baseName + " - \u5904\u7406\u6d41\u7a0b:" + processName + " - \u6267\u884c\u6210\u529f!").build();
                TaskManager.success(nJobId, taskId, currentThread);
                responseObserver.onNext((Object)dmRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                TaskManager.failed(nJobId, taskId, currentThread);
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void cancelTask(RpcTaskId request, StreamObserver<RpcTaskRespond> responseObserver) {
            String rawTaskId = request.getTaskId();
            String taskId = StringUtils.replace((String)rawTaskId, (String)"-", (String)"");
            SparkRpcServices.initService(taskId);
            try {
                TaskManager.cancelTask(taskId);
                responseObserver.onNext((Object)RpcTaskRespond.newBuilder().setRespond("\u79fb\u9664\u4efb\u52a1" + taskId + "\u76f8\u5173\u6570\u636e!").build());
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }
    }

    public static class SparkDataManagerService
    extends SparkDataManagerGrpc.SparkDataManagerImplBase {
        SparkDataManagerService() {
        }

        @Override
        public void loadData(RpcLoadDataParams request, StreamObserver<RpcRespondMessage> responseObserver) {
            String dataType = request.getDataType();
            AtlasRpcDataName rpcDataName = request.getDataTag().getDataName();
            java.util.Map<String, String> rpcDataLabelMap = request.getDataTag().getDataLabelMap();
            String rpcDataStoreFormat = request.getDataStoreFormat();
            java.util.Map<String, String> rpcLoadParamsMap = request.getLoadParamsMap();
            String jobId = request.getJobId();
            String taskId = request.getTaskId();
            SparkRpcServices.initService(taskId);
            AtlasDataName atlasDataName = SparkRpcServices.getAtlasDataName(rpcDataName);
            Option<scala.collection.immutable.Map<String, String>> dataLabelOpt = SparkRpcServices.addTaskIdLabel(rpcDataName, taskId, rpcDataLabelMap, responseObserver);
            scala.collection.immutable.Map loadParamsMap = SparkRpcServices.getScalaMap(rpcLoadParamsMap);
            Thread currentThread = Thread.currentThread();
            String nJobId = TaskManager.start(jobId, taskId, currentThread);
            try {
                java.util.HashMap<String, String> dataApiParams = new java.util.HashMap<String, String>();
                dataApiParams.put(AtlasCommonDataApi.ATLAS_IO_TYPE(), dataType);
                AtlasCommonDataApi dataApi = AtlasCommonDataApi.apply((scala.collection.immutable.Map)SparkRpcServices.getScalaMap(dataApiParams));
                dataApi.load(atlasDataName, dataLabelOpt, rpcDataStoreFormat, loadParamsMap);
                RpcRespondMessage dmRespond = RpcRespondMessage.newBuilder().setResponse("\u5b8c\u6210\u6570\u636e\u8f7d\u5165:" + rpcDataName).build();
                TaskManager.success(nJobId, taskId, currentThread);
                responseObserver.onNext((Object)dmRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                TaskManager.failed(nJobId, taskId, currentThread);
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void saveData(RpcSaveDataParams request, StreamObserver<RpcRespondMessage> responseObserver) {
            String dataType = request.getDataType();
            AtlasRpcDataName rpcDataName = request.getDataTag().getDataName();
            java.util.Map<String, String> rpcMatchDataLabelMap = request.getDataTag().getDataLabelMap();
            String rpcDataStoreFormat = request.getDataStoreFormat();
            java.util.Map<String, String> rpcSaveParamsMap = request.getSaveParamsMap();
            String jobId = request.getJobId();
            String taskId = request.getTaskId();
            SparkRpcServices.initService(taskId);
            AtlasDataName atlasDataName = SparkRpcServices.getAtlasDataName(rpcDataName);
            Option<scala.collection.immutable.Map<String, String>> matchDataLabelOpt = SparkRpcServices.addTaskIdLabel(rpcDataName, taskId, rpcMatchDataLabelMap, responseObserver);
            scala.collection.immutable.Map saveParamsMap = SparkRpcServices.getScalaMap(rpcSaveParamsMap);
            Thread currentThread = Thread.currentThread();
            String nJobId = TaskManager.start(jobId, taskId, currentThread);
            try {
                java.util.HashMap<String, String> dataApiParams = new java.util.HashMap<String, String>();
                dataApiParams.put(AtlasCommonDataApi.ATLAS_IO_TYPE(), dataType);
                AtlasCommonDataApi dataApi = AtlasCommonDataApi.apply((scala.collection.immutable.Map)SparkRpcServices.getScalaMap(dataApiParams));
                dataApi.save(atlasDataName, matchDataLabelOpt, rpcDataStoreFormat, saveParamsMap);
                RpcRespondMessage dmRespond = RpcRespondMessage.newBuilder().setResponse("\u5b8c\u6210\u6570\u636e\u8f93\u51fa:" + rpcDataName).build();
                TaskManager.success(nJobId, taskId, currentThread);
                responseObserver.onNext((Object)dmRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                TaskManager.failed(nJobId, taskId, currentThread);
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void showData(Empty request, StreamObserver<RpcShowDataRespond> responseObserver) {
            try {
                List rpcDataTags = DataManager.dataManager().dataSet().keySet().stream().map(x$0 -> SparkRpcServices.getAtlasRpcDataTag(x$0)).collect(Collectors.toList());
                RpcShowDataRespond dmRespond = RpcShowDataRespond.newBuilder().addAllDataTags(rpcDataTags).build();
                responseObserver.onNext((Object)dmRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void persistData(RpcPersistDataParams request, StreamObserver<RpcPersistRespond> responseObserver) {
            AtlasRpcDataTag rpcDataTag = request.getPersistDataTag();
            AtlasRpcDataName rpcDataName = rpcDataTag.getDataName();
            java.util.HashMap<String, String> dataLabelMap = new java.util.HashMap<String, String>(rpcDataTag.getDataLabelMap());
            String jobId = request.getJobId();
            String taskId = request.getTaskId();
            SparkRpcServices.initService(taskId);
            if (StringUtils.isBlank((CharSequence)rpcDataName.getNameSpace())) {
                if (StringUtils.isNotBlank((CharSequence)taskId)) {
                    dataLabelMap.put(DataManager.IDENTITY_SUFFIX(), taskId);
                } else {
                    NullException nullException = new NullException("\u5fc5\u987b\u8bbe\u7f6etaskId\u7528\u4e8e\u5220\u9664\u4e34\u65f6\u6570\u636e!", Thread.currentThread(), 3);
                    responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)nullException));
                    logger.error(ExceptionUtils.getStackTrace((Throwable)nullException));
                }
            }
            AtlasDataName atlasDataName = SparkRpcServices.getAtlasDataName(rpcDataName);
            dataLabelMap.put(DataManager$.MODULE$.DATA_TYPE(), DataManager.DataType$.MODULE$.VECTOR());
            Option<scala.collection.immutable.Map<String, String>> vectorDataLabelOpt = SparkRpcServices.getOptionMap(dataLabelMap);
            AtlasDataTag dataTag = DataManager.getDataTag((AtlasDataName)atlasDataName, vectorDataLabelOpt);
            Thread currentThread = Thread.currentThread();
            String nJobId = TaskManager.start(jobId, taskId, currentThread);
            try {
                if (dataTag == null) {
                    dataLabelMap.put(DataManager$.MODULE$.DATA_TYPE(), DataManager.DataType$.MODULE$.TABLE());
                    Option<scala.collection.immutable.Map<String, String>> tableDataLabelOpt = SparkRpcServices.getOptionMap(dataLabelMap);
                    dataTag = DataManager.getDataTag((AtlasDataName)atlasDataName, tableDataLabelOpt);
                }
                if (dataTag == null) {
                    throw new NotFoundException("\u672a\u627e\u5230\u6570\u636e\u6807\u7b7e\u5bf9\u5e94\u7684\u6570\u636e!", Thread.currentThread(), 3);
                }
                DataManager$.MODULE$.persistData(dataTag.atlasDataName(), dataTag.labelOptions());
                RpcPersistRespond descRespond = RpcPersistRespond.newBuilder().setMessage("\u5b8c\u6210\u6570\u636e\u6301\u4e45\u5316!").build();
                TaskManager.success(nJobId, taskId, currentThread);
                responseObserver.onNext((Object)descRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                TaskManager.failed(nJobId, taskId, currentThread);
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void unPersistData(RpcUnPersistDataParams request, StreamObserver<RpcUnPersistRespond> responseObserver) {
            AtlasRpcDataTag rpcDataTag = request.getUnpersistDataTag();
            AtlasRpcDataName rpcDataName = rpcDataTag.getDataName();
            java.util.HashMap<String, String> dataLabelMap = new java.util.HashMap<String, String>(rpcDataTag.getDataLabelMap());
            String jobId = request.getJobId();
            String taskId = request.getTaskId();
            SparkRpcServices.initService(taskId);
            if (StringUtils.isBlank((CharSequence)rpcDataName.getNameSpace())) {
                if (StringUtils.isNotBlank((CharSequence)taskId)) {
                    dataLabelMap.put(DataManager.IDENTITY_SUFFIX(), taskId);
                } else {
                    NullException nullException = new NullException("\u5fc5\u987b\u8bbe\u7f6etaskId\u7528\u4e8e\u5220\u9664\u4e34\u65f6\u6570\u636e!", Thread.currentThread(), 3);
                    responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)nullException));
                    logger.error(ExceptionUtils.getStackTrace((Throwable)nullException));
                }
            }
            AtlasDataName atlasDataName = SparkRpcServices.getAtlasDataName(rpcDataName);
            dataLabelMap.put(DataManager$.MODULE$.DATA_TYPE(), DataManager.DataType$.MODULE$.VECTOR());
            Option<scala.collection.immutable.Map<String, String>> vectorDataLabelOpt = SparkRpcServices.getOptionMap(dataLabelMap);
            AtlasDataTag dataTag = DataManager.getDataTag((AtlasDataName)atlasDataName, vectorDataLabelOpt);
            Thread currentThread = Thread.currentThread();
            String nJobId = TaskManager.start(jobId, taskId, currentThread);
            try {
                if (dataTag != null) {
                    DataManager$.MODULE$.unPersistData(dataTag.atlasDataName(), dataTag.labelOptions());
                } else {
                    dataLabelMap.put(DataManager$.MODULE$.DATA_TYPE(), DataManager.DataType$.MODULE$.TABLE());
                    Option<scala.collection.immutable.Map<String, String>> tableDataLabelOpt = SparkRpcServices.getOptionMap(dataLabelMap);
                    dataTag = DataManager.getDataTag((AtlasDataName)atlasDataName, tableDataLabelOpt);
                    if (dataTag != null) {
                        DataManager$.MODULE$.unPersistData(dataTag.atlasDataName(), dataTag.labelOptions());
                    }
                }
                RpcUnPersistRespond descRespond = RpcUnPersistRespond.newBuilder().setMessage("\u5b8c\u6210\u6570\u636e\u975e\u6301\u4e45\u5316!").build();
                TaskManager.success(nJobId, taskId, currentThread);
                responseObserver.onNext((Object)descRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                TaskManager.failed(nJobId, taskId, currentThread);
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void descData(RpcDescDataParams request, StreamObserver<RpcDescDataRespond> responseObserver) {
            try {
                AtlasRpcDataTag rpcDataTag = request.getDataTag();
                AtlasRpcDataName rpcDataName = rpcDataTag.getDataName();
                java.util.HashMap<String, String> dataLabelMap = new java.util.HashMap<String, String>(rpcDataTag.getDataLabelMap());
                String taskId = request.getTaskId();
                String jobId = request.getJobId();
                SparkRpcServices.initService(taskId);
                if (StringUtils.isBlank((CharSequence)rpcDataName.getNameSpace())) {
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        dataLabelMap.put(DataManager.IDENTITY_SUFFIX(), taskId);
                    } else {
                        NullException nullException = new NullException("\u5fc5\u987b\u8bbe\u7f6etaskId\u7528\u4e8e\u5220\u9664\u4e34\u65f6\u6570\u636e!", Thread.currentThread(), 3);
                        responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)nullException));
                        logger.error(ExceptionUtils.getStackTrace((Throwable)nullException));
                    }
                }
                AtlasDataName atlasDataName = SparkRpcServices.getAtlasDataName(rpcDataName);
                Option<scala.collection.immutable.Map<String, String>> dataLabelOpt = SparkRpcServices.getOptionMap(dataLabelMap);
                AtlasDataTag atlasDataTag = new AtlasDataTag(atlasDataName, dataLabelOpt);
                scala.collection.immutable.Map descMap = DataManager$.MODULE$.getAllDataInfo(atlasDataTag);
                java.util.HashMap<String, String> descResultMap = new java.util.HashMap<String, String>();
                Iterator descKeyIterator = descMap.keysIterator().toIterator();
                while (descKeyIterator.hasNext()) {
                    String descKey = (String)descKeyIterator.next();
                    if (!descMap.get((Object)descKey).isDefined() || descMap.get((Object)descKey).get() == null) continue;
                    descResultMap.put(descKey, (String)descMap.get((Object)descKey).get());
                }
                RpcDescDataRespond descRespond = RpcDescDataRespond.newBuilder().putAllDataDesc(descResultMap).build();
                responseObserver.onNext((Object)descRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void existData(RpcExistDataParams request, StreamObserver<RpcExistDataRespond> responseObserver) {
            try {
                AtlasRpcDataTag rpcDataTag = request.getDataTag();
                AtlasRpcDataName rpcDataName = rpcDataTag.getDataName();
                java.util.HashMap<String, String> dataLabelMap = new java.util.HashMap<String, String>(rpcDataTag.getDataLabelMap());
                String taskId = request.getTaskId();
                String jobId = request.getJobId();
                SparkRpcServices.initService(taskId);
                if (StringUtils.isBlank((CharSequence)rpcDataName.getNameSpace())) {
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        dataLabelMap.put(DataManager.IDENTITY_SUFFIX(), taskId);
                    } else {
                        NullException nullException = new NullException("\u5fc5\u987b\u8bbe\u7f6etaskId\u7528\u4e8e\u67e5\u8be2\u4e34\u65f6\u6570\u636e!", Thread.currentThread(), 3);
                        responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)nullException));
                        logger.error(ExceptionUtils.getStackTrace((Throwable)nullException));
                    }
                }
                AtlasDataName atlasDataName = SparkRpcServices.getAtlasDataName(rpcDataName);
                Option<scala.collection.immutable.Map<String, String>> dataLabelOpt = SparkRpcServices.getOptionMap(dataLabelMap);
                AtlasDataTag atlasDataTag = DataManager.getDataTag((AtlasDataName)atlasDataName, dataLabelOpt);
                RpcExistDataRespond.Builder builder = RpcExistDataRespond.newBuilder();
                builder.setExist(atlasDataTag != null);
                RpcExistDataRespond existDataRespond = builder.build();
                responseObserver.onNext((Object)existDataRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void renameData(RpcRenameDataParams request, StreamObserver<RpcRenameDataRespond> responseObserver) {
            try {
                NullException nullException;
                AtlasRpcDataTag rawDataTag = request.getRawDataTag();
                AtlasRpcDataTag newDataTag = request.getNewDataTag();
                AtlasRpcDataName rawDataName = rawDataTag.getDataName();
                java.util.HashMap<String, String> rawDataLabelMap = new java.util.HashMap<String, String>(rawDataTag.getDataLabelMap());
                AtlasRpcDataName newDataName = newDataTag.getDataName();
                java.util.HashMap<String, String> newDataLabelMap = new java.util.HashMap<String, String>(newDataTag.getDataLabelMap());
                String taskId = request.getTaskId();
                String jobId = request.getJobId();
                SparkRpcServices.initService(taskId);
                if (StringUtils.isBlank((CharSequence)rawDataName.getNameSpace())) {
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        rawDataLabelMap.put(DataManager.IDENTITY_SUFFIX(), taskId);
                    } else {
                        nullException = new NullException("\u5fc5\u987b\u8bbe\u7f6etaskId\u7528\u4e8e\u67e5\u8be2\u4e34\u65f6\u6570\u636e!", Thread.currentThread(), 3);
                        responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)nullException));
                        logger.error(ExceptionUtils.getStackTrace((Throwable)nullException));
                    }
                }
                if (StringUtils.isBlank((CharSequence)newDataName.getNameSpace())) {
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        newDataLabelMap.put(DataManager.IDENTITY_SUFFIX(), taskId);
                    } else {
                        nullException = new NullException("\u5fc5\u987b\u8bbe\u7f6etaskId\u7528\u4e8e\u67e5\u8be2\u4e34\u65f6\u6570\u636e!", Thread.currentThread(), 3);
                        responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)nullException));
                        logger.error(ExceptionUtils.getStackTrace((Throwable)nullException));
                    }
                }
                AtlasDataName atlasRawDataName = SparkRpcServices.getAtlasDataName(rawDataName);
                Option<scala.collection.immutable.Map<String, String>> atlasRawLabelOpt = SparkRpcServices.getOptionMap(rawDataLabelMap);
                AtlasDataName atlasNewDataName = SparkRpcServices.getAtlasDataName(newDataName);
                Option<scala.collection.immutable.Map<String, String>> atlasNewLabelOpt = SparkRpcServices.getOptionMap(newDataLabelMap);
                DataManager$.MODULE$.rename(atlasRawDataName, atlasRawLabelOpt, atlasNewDataName);
                RpcRenameDataRespond respond = RpcRenameDataRespond.newBuilder().setMessage("\u5b8c\u6210\u6570\u636e\u91cd\u547d\u540d " + atlasRawDataName + " -> " + atlasNewDataName).build();
                responseObserver.onNext((Object)respond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }

        @Override
        public void deleteData(RpcDeleteDataParams request, StreamObserver<RpcDeleteRespond> responseObserver) {
            try {
                AtlasRpcDataTag rpcDataTag = request.getDeleteDataTag();
                AtlasRpcDataName rpcDataName = rpcDataTag.getDataName();
                java.util.HashMap<String, String> dataLabelMap = new java.util.HashMap<String, String>(rpcDataTag.getDataLabelMap());
                String taskId = request.getTaskId();
                String jobId = request.getJobId();
                SparkRpcServices.initService(taskId);
                dataLabelMap.put(DataManager.IDENTITY_SUFFIX(), taskId);
                Option<scala.collection.immutable.Map<String, String>> dataLabelOpt = SparkRpcServices.getOptionMap(dataLabelMap);
                if (StringUtils.isBlank((CharSequence)rpcDataName.getNameSpace()) && StringUtils.isBlank((CharSequence)rpcDataName.getLocalName())) {
                    DataManager$.MODULE$.unregister(dataLabelOpt);
                } else {
                    AtlasDataName atlasDataName = SparkRpcServices.getAtlasDataName(rpcDataName);
                    DataManager$.MODULE$.unregister(atlasDataName, dataLabelOpt);
                }
                RpcDeleteRespond.Builder builder = RpcDeleteRespond.newBuilder();
                builder.setMessage("\u5220\u9664\u6570\u636e\u5b8c\u6210!");
                RpcDeleteRespond deleteDataRespond = builder.build();
                responseObserver.onNext((Object)deleteDataRespond);
                responseObserver.onCompleted();
            }
            catch (Throwable throwable) {
                responseObserver.onError((Throwable)GrpcExceptionUtil.wrapException((Throwable)throwable));
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }
    }
}

