/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.curve;

import java.io.Serializable;
import org.locationtech.geomesa.curve.NormalizedDimension;
import org.locationtech.geomesa.curve.SpaceFillingCurve;
import org.locationtech.sfcurve.IndexRange;
import org.locationtech.sfcurve.zorder.Z2$;
import org.locationtech.sfcurve.zorder.ZRange;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005q!B\b\u0011\u0011\u0003Ib!B\u000e\u0011\u0011\u0003a\u0002\"\u0002\u0017\u0002\t\u0003yh\u0001B\u000e\u0011\u0001yA\u0001\u0002K\u0002\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006Y\r!\t!\f\u0005\b_\r\u0011\r\u0011\"\u00011\u0011\u0019!4\u0001)A\u0005c!9Qg\u0001b\u0001\n\u0003\u0001\u0004B\u0002\u001c\u0004A\u0003%\u0011\u0007C\u00038\u0007\u0011\u0005\u0003\bC\u0004I\u0007E\u0005I\u0011A%\t\u000bQ\u001bA\u0011C+\t\u000ba\u001bA\u0011I-\t\u000b}\u001bA\u0011\t1\u0002\u000bi\u00134KR\"\u000b\u0005E\u0011\u0012!B2veZ,'BA\n\u0015\u0003\u001d9Wm\\7fg\u0006T!!\u0006\f\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0001\"AG\u0001\u000e\u0003A\u0011QA\u0017\u001aT\r\u000e\u001b\"!A\u000f\u0011\u0005i\u00191cA\u0002 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"A\u0007\u0014\n\u0005\u001d\u0002\"!E*qC\u000e,g)\u001b7mS:<7)\u001e:wK\u0006I\u0001O]3dSNLwN\u001c\t\u0003A)J!aK\u0011\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0003;9BQ\u0001K\u0003A\u0002%\n1\u0001\\8o+\u0005\t\u0004C\u0001\u000e3\u0013\t\u0019\u0004CA\nO_Jl\u0017\r\\5{K\u0012$\u0015.\\3og&|g.\u0001\u0003m_:\u0004\u0013a\u00017bi\u0006!A.\u0019;!\u0003\u0015Ig\u000eZ3y)\u0011ID(Q\"\u0011\u0005\u0001R\u0014BA\u001e\"\u0005\u0011auN\\4\t\u000buR\u0001\u0019\u0001 \u0002\u0003a\u0004\"\u0001I \n\u0005\u0001\u000b#A\u0002#pk\ndW\rC\u0003C\u0015\u0001\u0007a(A\u0001z\u0011\u001d!%\u0002%AA\u0002\u0015\u000bq\u0001\\3oS\u0016tG\u000f\u0005\u0002!\r&\u0011q)\t\u0002\b\u0005>|G.Z1o\u0003=Ig\u000eZ3yI\u0011,g-Y;mi\u0012\u001aT#\u0001&+\u0005\u0015[5&\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016!C;oG\",7m[3e\u0015\t\t\u0016%\u0001\u0006b]:|G/\u0019;j_:L!a\u0015(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007mK:LWM\u001c;J]\u0012,\u0007\u0010F\u0002:-^CQ!\u0010\u0007A\u0002yBQA\u0011\u0007A\u0002y\na!\u001b8wKJ$HC\u0001.^!\u0011\u00013L\u0010 \n\u0005q\u000b#A\u0002+va2,'\u0007C\u0003_\u001b\u0001\u0007\u0011(A\u0001{\u0003\u0019\u0011\u0018M\\4fgR!\u0011m]={!\r\u0011'.\u001c\b\u0003G\"t!\u0001Z4\u000e\u0003\u0015T!A\u001a\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013BA5\"\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\u0007M+\u0017O\u0003\u0002jCA\u0011a.]\u0007\u0002_*\u0011\u0001\u000fF\u0001\bg\u001a\u001cWO\u001d<f\u0013\t\u0011xN\u0001\u0006J]\u0012,\u0007PU1oO\u0016DQ\u0001\u001e\bA\u0002U\f!\u0001_=\u0011\u0007\tTg\u000f\u0005\u0004!ozrdHP\u0005\u0003q\u0006\u0012a\u0001V;qY\u0016$\u0004b\u0002\u0015\u000f!\u0003\u0005\r!\u000b\u0005\bw:\u0001\n\u00111\u0001}\u0003%i\u0017\r\u001f*b]\u001e,7\u000fE\u0002!{&J!A`\u0011\u0003\r=\u0003H/[8o)\u0005I\u0002")
public class Z2SFC
implements SpaceFillingCurve {
    private final NormalizedDimension lon;
    private final NormalizedDimension lat;

    @Override
    public Seq<IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y) {
        return SpaceFillingCurve.ranges$(this, x, y);
    }

    @Override
    public Seq<IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y, int precision) {
        return SpaceFillingCurve.ranges$(this, x, y, precision);
    }

    @Override
    public Seq<IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y, int precision, Option<Object> maxRanges) {
        return SpaceFillingCurve.ranges$(this, x, y, precision, maxRanges);
    }

    @Override
    public int ranges$default$2() {
        return SpaceFillingCurve.ranges$default$2$(this);
    }

    @Override
    public Option<Object> ranges$default$3() {
        return SpaceFillingCurve.ranges$default$3$(this);
    }

    public NormalizedDimension lon() {
        return this.lon;
    }

    public NormalizedDimension lat() {
        return this.lat;
    }

    @Override
    public long index(double x, double y, boolean lenient) {
        long l;
        try {
            Predef$.MODULE$.require(x >= this.lon().min() && x <= this.lon().max() && y >= this.lat().min() && y <= this.lat().max(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Value(s) out of bounds ([").append(this.lon().min()).append(",").append(this.lon().max()).append("], [").append(this.lat().min()).append(",").append(this.lat().max()).append("]): ").append(x).append(", ").append(y).toString());
            l = Z2$.MODULE$.apply(this.lon().normalize(x), this.lat().normalize(y));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof IllegalArgumentException) || !lenient) {
                throw throwable;
            }
            long l2 = this.lenientIndex(x, y);
            l = l2;
        }
        return l;
    }

    @Override
    public boolean index$default$3() {
        return false;
    }

    public long lenientIndex(double x, double y) {
        double bx;
        double d = x < this.lon().min() ? this.lon().min() : (bx = x > this.lon().max() ? this.lon().max() : x);
        double by = y < this.lat().min() ? this.lat().min() : (y > this.lat().max() ? this.lat().max() : y);
        return Z2$.MODULE$.apply(this.lon().normalize(bx), this.lat().normalize(by));
    }

    @Override
    public Tuple2<Object, Object> invert(long z) {
        Tuple2<Object, Object> tuple2 = Z2$.MODULE$.decode$extension(Z2$.MODULE$.apply(z));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int x = tuple2._1$mcI$sp();
        int y = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x, y);
        Tuple2.mcII.sp sp3 = sp2;
        int x2 = sp3._1$mcI$sp();
        int y2 = sp3._2$mcI$sp();
        return new Tuple2.mcDD.sp(this.lon().denormalize(x2), this.lat().denormalize(y2));
    }

    @Override
    public Seq<IndexRange> ranges(Seq<Tuple4<Object, Object, Object, Object>> xy, int precision, Option<Object> maxRanges) {
        Seq zbounds = (Seq)xy.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            ZRange zRange = new ZRange(this.index(xmin, ymin, this.index$default$3()), this.index(xmax, ymax, this.index$default$3()));
            return zRange;
        }, Seq$.MODULE$.canBuildFrom());
        return Z2$.MODULE$.zranges((ZRange[])zbounds.toArray(ClassTag$.MODULE$.apply(ZRange.class)), precision, maxRanges, Z2$.MODULE$.zranges$default$4());
    }

    public Z2SFC(int precision) {
        SpaceFillingCurve.$init$(this);
        this.lon = new NormalizedDimension.NormalizedLon(precision);
        this.lat = new NormalizedDimension.NormalizedLat(precision);
    }
}

