/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.index.common.geosot;

import com.geoway.atlas.common.error.NotSupportException;
import java.util.HashMap;
import java.util.Map;

public class GeoSot {
    static final char[] digits = new char[]{'0', '1', '2', '3'};
    static final Map<Character, Integer> decodeDigits = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf(digits[0]), 0);
            this.put(Character.valueOf(digits[1]), 1);
            this.put(Character.valueOf(digits[2]), 2);
            this.put(Character.valueOf(digits[3]), 3);
        }
    };

    public static String getCode(double x, double y, int level) {
        if (level < 2) {
            throw new NotSupportException("\u4e0d\u652f\u6301\u5c42\u5c0f\u4e8e2\u7684GEOSOT\u7f51\u683c!", Thread.currentThread(), 3);
        }
        StringBuilder sb = new StringBuilder("G0");
        int xDegree = (int)x;
        int yDegree = (int)y;
        if (level <= 9) {
            int nLength = level - 1;
            String degreeCode = GeoSot.getSubCode(xDegree, yDegree, 8 - nLength, nLength);
            sb.append(degreeCode);
            return sb.toString();
        }
        sb.append(GeoSot.getSubCode(xDegree, yDegree, 0, 8));
        double xMinuteDouble = (x - (double)xDegree) * 60.0;
        double yMinuteDouble = (y - (double)yDegree) * 60.0;
        int xMinute = (int)xMinuteDouble;
        int yMinute = (int)yMinuteDouble;
        sb.append("-");
        if (level <= 15) {
            int nLength = level - 9;
            String minuteCode = GeoSot.getSubCode(xMinute, yMinute, 6 - nLength, nLength);
            sb.append(minuteCode);
            return sb.toString();
        }
        sb.append(GeoSot.getSubCode(xMinute, yMinute, 0, 6));
        double xSecondDouble = (xMinuteDouble - (double)xMinute) * 60.0;
        double ySecondDouble = (yMinuteDouble - (double)yMinute) * 60.0;
        int xSecond = (int)xSecondDouble;
        int ySecond = (int)ySecondDouble;
        sb.append("-");
        if (level <= 21) {
            int nLength = level - 15;
            String secondCode = GeoSot.getSubCode(xSecond, ySecond, 6 - nLength, nLength);
            sb.append(secondCode);
            return sb.toString();
        }
        sb.append(GeoSot.getSubCode(xSecond, ySecond, 0, 6));
        double xSmallDouble = (xSecondDouble - (double)xSecond) * Math.pow(2.0, 11.0);
        double ySmallDouble = (ySecondDouble - (double)ySecond) * Math.pow(2.0, 11.0);
        int xSmall = (int)xSmallDouble;
        int ySmall = (int)ySmallDouble;
        sb.append("-");
        if (level <= 32) {
            int nLength = level - 21;
            String smallCode = GeoSot.getSubCode(xSmall, ySmall, 11 - nLength, nLength);
            sb.append(smallCode);
            return sb.toString();
        }
        throw new NotSupportException("\u4e0d\u652f\u6301\u5927\u4e8e32\u7ea7\u7f51\u683c!", Thread.currentThread(), 3);
    }

    public static double[] fromCode(String geoSotCode) {
        if (geoSotCode.startsWith("G0")) {
            int[] xySecond;
            int[] xyMinute;
            double x = 0.0;
            double y = 0.0;
            String subGeoSotCode = geoSotCode.substring(2);
            int subGeoSotLenght = subGeoSotCode.length();
            if (subGeoSotLenght <= 8) {
                int[] xyDegree = GeoSot.fromSubCode(subGeoSotCode, 8 - subGeoSotCode.length());
                double gridSize = 256.0 / Math.pow(2.0, subGeoSotCode.length());
                return new double[]{x += (double)xyDegree[0], x + gridSize, y += (double)xyDegree[1], y + gridSize};
            }
            int[] xyDegree = GeoSot.fromSubCode(subGeoSotCode.substring(0, 8), 0);
            x += (double)xyDegree[0];
            y += (double)xyDegree[1];
            subGeoSotLenght = (subGeoSotCode = subGeoSotCode.substring(9)).length();
            if (subGeoSotLenght <= 6) {
                xyMinute = GeoSot.fromSubCode(subGeoSotCode, 6 - subGeoSotCode.length());
                double gridSize = 64.0 / Math.pow(2.0, subGeoSotCode.length()) / 60.0;
                return new double[]{x += (double)xyMinute[0] / 60.0, x + gridSize, y += (double)xyMinute[1] / 60.0, y + gridSize};
            }
            xyMinute = GeoSot.fromSubCode(subGeoSotCode.substring(0, 6), 0);
            x += (double)xyMinute[0] / 60.0;
            y += (double)xyMinute[1] / 60.0;
            subGeoSotLenght = (subGeoSotCode = subGeoSotCode.substring(7)).length();
            if (subGeoSotLenght <= 6) {
                xySecond = GeoSot.fromSubCode(subGeoSotCode, 6 - subGeoSotCode.length());
                double gridSize = 64.0 / Math.pow(2.0, subGeoSotCode.length()) / 3600.0;
                return new double[]{x += (double)xySecond[0] / 3600.0, x + gridSize, y += (double)xySecond[1] / 3600.0, y + gridSize};
            }
            xySecond = GeoSot.fromSubCode(subGeoSotCode.substring(0, 6), 0);
            x += (double)xySecond[0] / 3600.0;
            y += (double)xySecond[1] / 3600.0;
            subGeoSotLenght = (subGeoSotCode = subGeoSotCode.substring(7)).length();
            if (subGeoSotLenght <= 11) {
                int[] xySmall = GeoSot.fromSubCode(subGeoSotCode, 11 - subGeoSotCode.length());
                double gridSize = 1.0 / Math.pow(2.0, subGeoSotLenght) / 3600.0;
                return new double[]{x += (double)xySmall[0] / (Math.pow(2.0, 11.0) * 3600.0), x + gridSize, y += (double)xySmall[1] / (Math.pow(2.0, 11.0) * 3600.0), y + gridSize};
            }
            throw new NotSupportException("\u4e0d\u652f\u6301\u5927\u4e8e32\u7ea7\u7f51\u683c!", Thread.currentThread(), 3);
        }
        throw new NotSupportException("\u4ec5\u652f\u6301GeoSot\u5927\u4e8e1\u7ea7\u7684\u89e3\u7801\uff01\u672a\u77e5\u7f16\u7801\uff1a" + geoSotCode, Thread.currentThread(), 3);
    }

    private static int[] fromSubCode(String code, int leftOffset) {
        int xValue = 0;
        int yValue = 0;
        for (int i = 0; i < code.length(); ++i) {
            int mergeCode = decodeDigits.get(Character.valueOf(code.charAt(i)));
            xValue <<= 1;
            yValue <<= 1;
            xValue += mergeCode & 1;
            yValue += mergeCode >> 1 & 1;
        }
        return new int[]{xValue <<= leftOffset, yValue <<= leftOffset};
    }

    private static String getSubCode(int x, int y, int rightOffset, int preLength) {
        int xOffset = x >> rightOffset;
        int yOffset = y >> rightOffset;
        char[] chars = new char[preLength];
        int chatPos = preLength;
        do {
            chars[--chatPos] = digits[(xOffset & 1) + ((yOffset & 1) << 1)];
            xOffset >>= 1;
            yOffset >>= 1;
        } while (chatPos > 0);
        return new String(chars);
    }
}

