/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.index.vector.common.partition.partitioner.impl.quadtree;

import com.geoway.atlas.common.io.MemoryStandardInput;
import com.geoway.atlas.common.io.MemoryStandardInput$;
import com.geoway.atlas.common.io.MemoryStandardOutput;
import com.geoway.atlas.common.io.MemoryStandardOutput$;
import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.common.io.StandardOutput;
import com.geoway.atlas.common.io.package;
import com.geoway.atlas.common.io.package$;
import com.geoway.atlas.common.utils.CollectionUtils$;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.quadtree.QuadNode;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.quadtree.QuadRectangle;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.quadtree.SpatialQuadTreeVectorPartitioner;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.quadtree.SpatialQuadTreeVectorPartitioner$;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.quadtree.StandardQuadTree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.List;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class StandardQuadTreeSerializer$ {
    public static StandardQuadTreeSerializer$ MODULE$;
    private final int cacheSize;

    static {
        new StandardQuadTreeSerializer$();
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public SpatialQuadTreeVectorPartitioner copy(SpatialQuadTreeVectorPartitioner sqTreeVectorPartitioner) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.cacheSize());
        MemoryStandardOutput standardOutput = MemoryStandardOutput$.MODULE$.apply(byteArrayOutputStream);
        this.serializeSpatialStandardQuadTree((StandardOutput)standardOutput, sqTreeVectorPartitioner);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        MemoryStandardInput standardInput = MemoryStandardInput$.MODULE$.apply(byteArrayInputStream);
        return (SpatialQuadTreeVectorPartitioner)this.deSerializeSpatialStandardQuadTree((StandardInput)standardInput).get();
    }

    public void serializeSpatialStandardQuadTree(StandardOutput out, SpatialQuadTreeVectorPartitioner sqTreeVectorPartitioner) {
        if (sqTreeVectorPartitioner.getNumPartitions() <= 0) {
            out.write(0);
        } else {
            out.write(1);
            StandardQuadTree<Object> quadTree = sqTreeVectorPartitioner.getQuadTree();
            this.serializeStandardQuadTree(out, quadTree);
        }
    }

    private void serializeStandardQuadTree(StandardOutput out, StandardQuadTree<Object> quadTree) {
        package$.MODULE$.RichStandardOutput(out).writeInt(quadTree.getMaxItemsPerZone(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(out).writeInt(quadTree.getMaxLevel(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(out).writeInt(quadTree.getLevel(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(out).writeInt(quadTree.getNodeNum(), ByteOrder.LITTLE_ENDIAN);
        this.serializeSubStandardQuadTree(out, quadTree);
        this.serializeCurrentNodeInfo(out, quadTree);
        this.serializeCurrentQuadRectangle(out, quadTree);
    }

    private void serializeSubStandardQuadTree(StandardOutput out, StandardQuadTree<Object> quadTree) {
        if (quadTree.getRegions() == null || quadTree.getRegions().length == 0) {
            out.write(0);
        } else {
            out.write(1);
            StandardQuadTree[] regions = quadTree.getRegions();
            package$.MODULE$.RichStandardOutput(out).writeInt(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])regions)).size(), ByteOrder.LITTLE_ENDIAN);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])regions)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> MODULE$.serializeStandardQuadTree(out, regions[i]));
        }
    }

    private void serializeCurrentNodeInfo(StandardOutput out, StandardQuadTree<Object> quadTree) {
        if (quadTree.getNodes().size() <= 0) {
            out.write(0);
        } else {
            out.write(1);
            List<QuadNode<Object>> nodes = quadTree.getNodes();
            package$.MODULE$.RichStandardOutput(out).writeInt(nodes.size(), ByteOrder.LITTLE_ENDIAN);
            int limit$macro$4 = nodes.size();
            for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                this.serializeQuadRectangle(out, nodes.get(index$macro$2).getR());
            }
        }
    }

    private void serializeCurrentQuadRectangle(StandardOutput out, StandardQuadTree<Object> quadTree) {
        if (quadTree.getZone() == null) {
            out.write(0);
        } else {
            out.write(1);
            this.serializeQuadRectangle(out, quadTree.getZone());
        }
    }

    private void serializeQuadRectangle(StandardOutput out, QuadRectangle rectangle) {
        package$.MODULE$.RichStandardOutput(out).writeDouble(rectangle.x, ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(out).writeDouble(rectangle.y, ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(out).writeDouble(rectangle.width, ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(out).writeDouble(rectangle.height, ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(out).writeInt(Predef$.MODULE$.Integer2int(rectangle.partitionId), ByteOrder.LITTLE_ENDIAN);
    }

    public Option<SpatialQuadTreeVectorPartitioner> deSerializeSpatialStandardQuadTree(StandardInput input) {
        None$ none$;
        ByteOrder x$1;
        boolean isEmpty;
        package.RichStandardInput qual$1 = package$.MODULE$.RichStandardInput(input);
        boolean bl = isEmpty = qual$1.readByte(x$1 = qual$1.readByte$default$1()) == 0;
        if (!isEmpty) {
            StandardQuadTree<Object> standardQuadTree = this.deSerializeStandardQuadTree(input);
            none$ = new Some((Object)SpatialQuadTreeVectorPartitioner$.MODULE$.apply(standardQuadTree));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private StandardQuadTree<Object> deSerializeStandardQuadTree(StandardInput input) {
        StandardQuadTree<Object> standardQuadTree;
        block1: {
            int maxItemsPerZone = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
            int maxLevel = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
            int level = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
            int nodeNum = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
            StandardQuadTree<Object>[] subStandardQuadTrees = this.deSerializeSubStandardQuadTree(input);
            QuadNode<Object>[] currentNodeInfos = this.deSerializeCurrentNodeInfo(input);
            QuadRectangle currentQuadRectangle = this.deSerializeCurrentQuadRectangle(input);
            standardQuadTree = new StandardQuadTree<Object>(currentQuadRectangle, level, maxItemsPerZone, maxLevel);
            standardQuadTree.setNodeNum(nodeNum);
            if (CollectionUtils$.MODULE$.nonEmpty((Seq)Predef$.MODULE$.wrapRefArray((Object[])currentNodeInfos))) {
                standardQuadTree.setNodes((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currentNodeInfos)).toBuffer()).asJava());
            }
            if (!CollectionUtils$.MODULE$.nonEmpty((Seq)Predef$.MODULE$.wrapRefArray((Object[])subStandardQuadTrees))) break block1;
            standardQuadTree.setRegions((StandardQuadTree[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subStandardQuadTrees)).toArray(ClassTag$.MODULE$.apply(StandardQuadTree.class)));
        }
        return standardQuadTree;
    }

    /*
     * WARNING - void declaration
     */
    private StandardQuadTree<Object>[] deSerializeSubStandardQuadTree(StandardInput input) {
        void var3_3;
        boolean isEmpty;
        boolean bl = isEmpty = package$.MODULE$.RichStandardInput(input).readByte(ByteOrder.LITTLE_ENDIAN) == 0;
        if (isEmpty) {
            return null;
        }
        StandardQuadTree[] result = new StandardQuadTree[package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN)];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            result$1[i] = MODULE$.deSerializeStandardQuadTree(input);
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private QuadNode<Object>[] deSerializeCurrentNodeInfo(StandardInput input) {
        void var3_3;
        boolean isEmpty;
        boolean bl = isEmpty = package$.MODULE$.RichStandardInput(input).readByte(ByteOrder.LITTLE_ENDIAN) == 0;
        if (isEmpty) {
            return null;
        }
        QuadNode[] result = new QuadNode[package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN)];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            result$2[i] = new QuadNode<Integer>(MODULE$.deSerializeQuadRectangle(input), BoxesRunTime.boxToInteger((int)-1));
        });
        return var3_3;
    }

    private QuadRectangle deSerializeQuadRectangle(StandardInput input) {
        double x = package$.MODULE$.RichStandardInput(input).readDouble(ByteOrder.LITTLE_ENDIAN);
        double y = package$.MODULE$.RichStandardInput(input).readDouble(ByteOrder.LITTLE_ENDIAN);
        double width = package$.MODULE$.RichStandardInput(input).readDouble(ByteOrder.LITTLE_ENDIAN);
        double height = package$.MODULE$.RichStandardInput(input).readDouble(ByteOrder.LITTLE_ENDIAN);
        int partitionId = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
        QuadRectangle qr = new QuadRectangle(x, y, width, height);
        qr.partitionId = Predef$.MODULE$.int2Integer(partitionId);
        return qr;
    }

    private QuadRectangle deSerializeCurrentQuadRectangle(StandardInput input) {
        boolean isEmpty;
        boolean bl = isEmpty = package$.MODULE$.RichStandardInput(input).readByte(ByteOrder.LITTLE_ENDIAN) == 0;
        if (isEmpty) {
            return null;
        }
        return this.deSerializeQuadRectangle(input);
    }

    private StandardQuadTreeSerializer$() {
        MODULE$ = this;
        this.cacheSize = 0x400000;
    }
}

