/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid;

import com.geoway.atlas.algorithm.vector.overlay.geom.AtlasOverlayOp$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.vector.common.envelope.package$;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.CodeFind;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.CodeRange;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.GridCode;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.GridGeometry;
import com.geoway.atlas.index.vector.common.partition.partitioner.impl.grid.GridTree$;
import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryUtils$;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\u0016-\u0001\u0005C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t?\u0002\u0011\t\u0011)A\u0005A\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!Y\u0007A!A!\u0002\u0013A\u0007\"\u00027\u0001\t\u0003i\u0007bB;\u0001\u0005\u0004%IA\u001e\u0005\u0007o\u0002\u0001\u000b\u0011\u00025\t\u000fa\u0004!\u0019!C\u0005m\"1\u0011\u0010\u0001Q\u0001\n!DqA\u001f\u0001C\u0002\u0013%1\u0010\u0003\u0004\u0000\u0001\u0001\u0006I\u0001 \u0005\u0007\u0003\u0003\u0001A\u0011\u0001<\t\r\u0005\r\u0001\u0001\"\u0001w\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAa!!\u0003\u0001\t\u00031\bBBA\u0006\u0001\u0011\u0005a\u000fC\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003+\u0002A\u0011AA,\u0011%\t)\u0007AI\u0001\n\u0003\t9\u0007C\u0004\u0002~\u0001!\t!a \t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0004bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!!/\u0001\t\u0003\t\t\rC\u0004\u0002:\u0002!\t!a2\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u00111\u001a\u0001\u0005\u0002\u0005]\u0007bBAq\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003G\u0004A\u0011AAs\u000f\u001d\ti\u000f\fE\u0001\u0003_4aa\u000b\u0017\t\u0002\u0005E\bB\u00027%\t\u0003\t\u0019\u0010C\u0005\u0002v\u0012\u0012\r\u0011\"\u0001\u0002\b!9\u0011q\u001f\u0013!\u0002\u0013\u0001\u0007\"CA}I\t\u0007I\u0011AA\u0004\u0011\u001d\tY\u0010\nQ\u0001\n\u0001D\u0011\"!@%\u0003\u0003%I!a@\u0003\u0011\u001d\u0013\u0018\u000e\u001a+sK\u0016T!!\f\u0018\u0002\t\u001d\u0014\u0018\u000e\u001a\u0006\u0003_A\nA![7qY*\u0011\u0011GM\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u00024i\u0005I\u0001/\u0019:uSRLwN\u001c\u0006\u0003kY\naaY8n[>t'BA\u001c9\u0003\u00191Xm\u0019;pe*\u0011\u0011HO\u0001\u0006S:$W\r\u001f\u0006\u0003wq\nQ!\u0019;mCNT!!\u0010 \u0002\r\u001d,wn^1z\u0015\u0005y\u0014aA2p[\u000e\u00011\u0003\u0002\u0001C\u0011.\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013a!\u00118z%\u00164\u0007CA\"J\u0013\tQEI\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002M!6\tQJ\u0003\u0002O\u001f\u0006\u0019An\\4\u000b\u0005UR\u0014BA)N\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0017=\u0014\u0018nZ5o!>Lg\u000e\u001e\t\u0003)vk\u0011!\u0016\u0006\u0003-^\u000bAaZ3p[*\u0011\u0001,W\u0001\u0004UR\u001c(B\u0001.\\\u00031awnY1uS>tG/Z2i\u0015\u0005a\u0016aA8sO&\u0011a,\u0016\u0002\u0006!>Lg\u000e^\u0001\nI&\u0014Xm\u0019;j_:\u0004\"aQ1\n\u0005\t$%aA%oi\u0006A!m\\;oI\u0006\u0014\u0018\u0010\u0005\u0002UK&\u0011a-\u0016\u0002\t\u000b:4X\r\\8qK\u0006A1-\u001a7m\u0011&<\u0007\u000e\u0005\u0002DS&\u0011!\u000e\u0012\u0002\u0007\t>,(\r\\3\u0002\u0015\r,G\u000e\\,fS\u001eDG/\u0001\u0004=S:LGO\u0010\u000b\u0007]B\f(o\u001d;\u0011\u0005=\u0004Q\"\u0001\u0017\t\u000bI3\u0001\u0019A*\t\u000b}3\u0001\u0019\u00011\t\u000b\r4\u0001\u0019\u00013\t\u000b\u001d4\u0001\u0019\u00015\t\u000b-4\u0001\u0019\u00015\u0002\u000bi,'o\u001c-\u0016\u0003!\faA_3s_b\u0003\u0013!\u0002>fe>L\u0016A\u0002>fe>L\u0006%A\u0005d_\u0012,'+\u00198hKV\tA\u0010\u0005\u0002p{&\u0011a\u0010\f\u0002\n\u0007>$WMU1oO\u0016\f!bY8eKJ\u000bgnZ3!\u0003!9W\r\u001e.fe>D\u0016\u0001C4fij+'o\\-\u0002\u0019\u001d,G\u000fR5sK\u000e$\u0018n\u001c8\u0016\u0003\u0001\f1bZ3u\u0007\u0016dG\u000eS5hQ\u0006iq-\u001a;DK2dw+Z5hQR\f1bZ3u\u0005>,h\u000eZ1ssV\tA-A\u0007gS:$wI]5e\u0007>$Wm\u001d\u000b\u0004y\u0006U\u0001BBA\f'\u0001\u0007A-\u0001\u0005f]Z,Gn\u001c9f\u0003E1\u0017N\u001c3TC\u001a,wI]5e\u0007>$Wm\u001d\u000b\u0004y\u0006u\u0001BBA\f)\u0001\u0007A-\u0001\ngS:$W\t_1di\u001e\u0013\u0018\u000eZ\"pI\u0016\u001cHCBA\u0012\u0003\u0003\nY\u0005\u0005\u0004\u0002&\u0005U\u00121\b\b\u0005\u0003O\t\tD\u0004\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti\u0003Q\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015K1!a\rE\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000e\u0002:\t\u00191+Z9\u000b\u0007\u0005MB\tE\u0002p\u0003{I1!a\u0010-\u0005!9%/\u001b3D_\u0012,\u0007bBA\"+\u0001\u0007\u0011QI\u0001\tO\u0016|W.\u001a;ssB\u0019A+a\u0012\n\u0007\u0005%SK\u0001\u0005HK>lW\r\u001e:z\u0011\u001d\ti%\u0006a\u0001\u0003\u001f\n!\u0001]7\u0011\u0007Q\u000b\t&C\u0002\u0002TU\u0013a\u0002\u0015:fG&\u001c\u0018n\u001c8N_\u0012,G.\u0001\u0006ta2LGOU1oO\u0016$b!!\u0017\u0002b\u0005\r\u0004CBA\u0013\u0003k\tY\u0006E\u0002p\u0003;J1!a\u0018-\u000519%/\u001b3HK>lW\r\u001e:z\u0011\u001d\t\u0019E\u0006a\u0001\u0003\u000bB\u0011\"!\u0014\u0017!\u0003\u0005\r!a\u0014\u0002)M\u0004H.\u001b;SC:<W\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tIG\u000b\u0003\u0002P\u0005-4FAA7!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]D)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001f\u0002r\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001dM\u0004H.\u001b;SC:<WmU1gKR1\u0011\u0011LAA\u0003\u0007Cq!a\u0011\u0019\u0001\u0004\t)\u0005C\u0005\u0002Na\u0001\n\u00111\u0001\u0002P\u0005A2\u000f\u001d7jiJ\u000bgnZ3TC\u001a,G\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bM\u0004H.\u001b;HK>lW\r\u001e:z))\tY)!%\u0002\u0014\u0006U\u0015\u0011\u0016\t\u0004\u0007\u00065\u0015bAAH\t\n!QK\\5u\u0011\u0015Q(\u00041\u0001}\u0011\u001d\t\u0019E\u0007a\u0001\u0003\u000bBq!a&\u001b\u0001\u0004\tI*\u0001\u0004sKN,H\u000e\u001e\t\u0007\u00037\u000b)+a\u0017\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bq!\\;uC\ndWMC\u0002\u0002$\u0012\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9+!(\u0003\r\t+hMZ3s\u0011\u001d\tiE\u0007a\u0001\u0003\u001f\n\u0011bZ3u\u0007\u0016tG/\u001a:\u0015\t\u0005=\u0016Q\u0017\t\u0004)\u0006E\u0016bAAZ+\nQ1i\\8sI&t\u0017\r^3\t\u000f\u0005]6\u00041\u0001\u0002<\u0005AqM]5e\u0007>$W-A\u0006hKR,eN^3m_B,Gc\u00013\u0002>\"1\u0011q\u0018\u000fA\u0002q\fQA]1oO\u0016$2\u0001ZAb\u0011\u0019\t)-\ba\u0001A\u0006!1m\u001c3f)\r!\u0017\u0011\u001a\u0005\b\u0003os\u0002\u0019AA\u001e\u0003\u001d9W\r^\"pI\u0016$B!a4\u0002VB!1)!5a\u0013\r\t\u0019\u000e\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003\u007f{\u0002\u0019\u0001?\u0015\t\u0005e\u0017q\u001c\t\u0004_\u0006m\u0017bAAoY\tA1i\u001c3f\r&tG\rC\u0004\u00028\u0002\u0002\r!a\u000f\u0002\u0019\u001d,GoQ8eK\u000e{WO\u001c;\u0002!\u001d,G\u000fT8oO\u000e{G-Z\"pk:$XCAAt!\r\u0019\u0015\u0011^\u0005\u0004\u0003W$%\u0001\u0002'p]\u001e\f\u0001b\u0012:jIR\u0013X-\u001a\t\u0003_\u0012\u001a2\u0001\n\"I)\t\ty/\u0001\u0007E\u0013J+5\tV%P\u001d~\u0013F+A\u0007E\u0013J+5\tV%P\u001d~\u0013F\u000bI\u0001\r\t&\u0013Vi\u0011+J\u001f:{&\u000bR\u0001\u000e\t&\u0013Vi\u0011+J\u001f:{&\u000b\u0012\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0003\u0001BAa\u0001\u0003\u000e5\u0011!Q\u0001\u0006\u0005\u0005\u000f\u0011I!\u0001\u0003mC:<'B\u0001B\u0006\u0003\u0011Q\u0017M^1\n\t\t=!Q\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class GridTree
implements scala.Serializable,
LazyLogging {
    private final int direction;
    private final Envelope boundary;
    private final double cellHigh;
    private final double cellWeight;
    private final double zeroX;
    private final double zeroY;
    private final CodeRange codeRange;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static int DIRECTION_RD() {
        return GridTree$.MODULE$.DIRECTION_RD();
    }

    public static int DIRECTION_RT() {
        return GridTree$.MODULE$.DIRECTION_RT();
    }

    private Logger logger$lzycompute() {
        GridTree gridTree = this;
        synchronized (gridTree) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private double zeroX() {
        return this.zeroX;
    }

    private double zeroY() {
        return this.zeroY;
    }

    private CodeRange codeRange() {
        return this.codeRange;
    }

    public double getZeroX() {
        return this.zeroX();
    }

    public double getZeroY() {
        return this.zeroY();
    }

    public int getDirection() {
        return this.direction;
    }

    public double getCellHigh() {
        return this.cellHigh;
    }

    public double getCellWeight() {
        return this.cellWeight;
    }

    public Envelope getBoundary() {
        return this.boundary;
    }

    public CodeRange findGridCodes(Envelope envelope) {
        int colMin = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((envelope.getMinX() - this.zeroX()) / this.cellWeight));
        int colMax = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((envelope.getMaxX() - this.zeroX()) / this.cellWeight));
        int rowMin = -1;
        int rowMax = -1;
        if (this.direction == GridTree$.MODULE$.DIRECTION_RT()) {
            rowMin = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((envelope.getMinY() - this.zeroY()) / this.cellHigh));
            rowMax = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((envelope.getMaxY() - this.zeroY()) / this.cellHigh));
        } else if (this.direction == GridTree$.MODULE$.DIRECTION_RD()) {
            rowMin = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((this.zeroY() - envelope.getMaxY()) / this.cellHigh));
            rowMax = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((this.zeroY() - envelope.getMinY()) / this.cellHigh));
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u65b9\u5411:").append(this.direction).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return new CodeRange(colMin, rowMin, colMax, rowMax);
    }

    /*
     * WARNING - void declaration
     */
    public CodeRange findSafeGridCodes(Envelope envelope) {
        void var2_2;
        CodeRange cr = this.findGridCodes(envelope);
        return this.codeRange() != null ? this.codeRange().intersection(cr) : var2_2;
    }

    public Seq<GridCode> findExactGridCodes(Geometry geometry, PrecisionModel pm) {
        return (Seq)this.splitRangeSafe(geometry, pm).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.gridCode(), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<GridGeometry> splitRange(Geometry geometry, PrecisionModel pm) {
        CodeRange codeRange = this.findGridCodes(geometry.getEnvelopeInternal());
        ArrayBuffer result = new ArrayBuffer();
        this.splitGeometry(codeRange, geometry, (Buffer<GridGeometry>)result, pm);
        return result;
    }

    public PrecisionModel splitRange$default$2() {
        return null;
    }

    public Seq<GridGeometry> splitRangeSafe(Geometry geometry, PrecisionModel pm) {
        ArrayBuffer result;
        block0: {
            CodeRange codeRange = this.findSafeGridCodes(geometry.getEnvelopeInternal());
            result = new ArrayBuffer();
            if (codeRange == null) break block0;
            this.splitGeometry(codeRange, geometry, (Buffer<GridGeometry>)result, pm);
        }
        return result;
    }

    public PrecisionModel splitRangeSafe$default$2() {
        return null;
    }

    private void splitGeometry(CodeRange codeRange, Geometry geometry, Buffer<GridGeometry> result, PrecisionModel pm) {
        if (codeRange.colMax() == codeRange.colMin() && codeRange.rowMin() == codeRange.rowMax()) {
            result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GridGeometry[]{new GridGeometry(new GridCode(codeRange.colMin(), codeRange.rowMin()), geometry)}));
        } else {
            int colSpan = codeRange.colMax() - codeRange.colMin() + 1;
            int rowSpan = codeRange.rowMax() - codeRange.rowMin() + 1;
            ArrayBuffer codeRanges = new ArrayBuffer();
            int maxBinaryColSpan = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)colSpan / 2.0));
            int maxBinaryRowSpan = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)rowSpan / 2.0));
            CodeRange codeRange1 = new CodeRange(codeRange.colMin(), codeRange.rowMin(), codeRange.colMin() + maxBinaryColSpan - 1, codeRange.rowMin() + maxBinaryRowSpan - 1);
            codeRanges.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CodeRange[]{codeRange1}));
            boolean hasMoreCol = false;
            boolean hasMoreRow = false;
            if (maxBinaryColSpan < colSpan) {
                hasMoreCol = true;
                codeRanges.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CodeRange[]{new CodeRange(codeRange.colMin() + maxBinaryColSpan, codeRange.rowMin(), codeRange.colMax(), codeRange.rowMin() + maxBinaryRowSpan - 1)}));
            }
            if (maxBinaryRowSpan < rowSpan) {
                hasMoreRow = true;
                codeRanges.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CodeRange[]{new CodeRange(codeRange.colMin(), codeRange.rowMin() + maxBinaryRowSpan, codeRange.colMin() + maxBinaryColSpan - 1, codeRange.rowMax())}));
            }
            if (hasMoreCol && hasMoreRow) {
                codeRanges.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CodeRange[]{new CodeRange(codeRange.colMin() + maxBinaryColSpan, codeRange.rowMin() + maxBinaryRowSpan, codeRange.colMax(), codeRange.rowMax())}));
            }
            for (int codeRangeIndex = 0; codeRangeIndex < codeRanges.size(); ++codeRangeIndex) {
                CodeRange cr = (CodeRange)codeRanges.apply(codeRangeIndex);
                Geometry eGeometry = package$.MODULE$.RicheEnvelope(this.getEnvelope(cr)).toGeometry();
                Geometry sGeometry = pm == null ? AtlasOverlayOp$.MODULE$.intersection(eGeometry, geometry) : AtlasOverlayOp$.MODULE$.intersection(eGeometry, geometry, pm);
                if (!GeometryUtils$.MODULE$.nonEmpty(sGeometry)) continue;
                this.splitGeometry(cr, sGeometry, result, pm);
            }
        }
    }

    public Coordinate getCenter(GridCode gridCode) {
        double d;
        double d2 = ((double)gridCode.col() + 0.5) * this.cellWeight + this.zeroX();
        if (this.direction == GridTree$.MODULE$.DIRECTION_RT()) {
            d = ((double)gridCode.row() + 0.5) * this.cellHigh + this.zeroY();
        } else if (this.direction == GridTree$.MODULE$.DIRECTION_RD()) {
            d = this.zeroY() - ((double)gridCode.row() + 0.5) * this.cellHigh;
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u65b9\u5411:").append(this.direction).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return new Coordinate(d2, d);
    }

    public Envelope getEnvelope(CodeRange range) {
        double xMin = (double)range.colMin() * this.cellWeight + this.zeroX();
        double xMax = (double)(range.colMax() + 1) * this.cellWeight + this.zeroX();
        double yMin = -1.0;
        double yMax = -1.0;
        if (this.direction == GridTree$.MODULE$.DIRECTION_RT()) {
            yMin = (double)range.rowMin() * this.cellHigh + this.zeroY();
            yMax = (double)(range.rowMax() + 1) * this.cellHigh + this.zeroY();
        } else if (this.direction == GridTree$.MODULE$.DIRECTION_RD()) {
            yMin = this.zeroY() - (double)(range.rowMax() + 1) * this.cellHigh;
            yMax = this.zeroY() - (double)range.rowMin() * this.cellHigh;
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u65b9\u5411:").append(this.direction).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return new Envelope(xMin, xMax, yMin, yMax);
    }

    public Envelope getEnvelope(int code) {
        if (this.codeRange() == null) {
            String x$1 = "\u6ca1\u6709\u8bbe\u7f6e\u5207\u5206\u8303\u56f4\u65e0\u6cd5\u8ba1\u7b97\u7f16\u7801!";
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return this.getEnvelope(new GridCode(code % this.codeRange().colSpan() + this.codeRange().colMin(), code / this.codeRange().colSpan() + this.codeRange().rowMin()));
    }

    public Envelope getEnvelope(GridCode gridCode) {
        double xMin = (double)gridCode.col() * this.cellWeight + this.zeroX();
        double xMax = (double)(gridCode.col() + 1) * this.cellWeight + this.zeroX();
        double yMin = -1.0;
        double yMax = -1.0;
        if (this.direction == GridTree$.MODULE$.DIRECTION_RT()) {
            yMin = (double)gridCode.row() * this.cellHigh + this.zeroY();
            yMax = (double)(gridCode.row() + 1) * this.cellHigh + this.zeroY();
        } else if (this.direction == GridTree$.MODULE$.DIRECTION_RD()) {
            yMin = this.zeroY() - (double)(gridCode.row() + 1) * this.cellHigh;
            yMax = this.zeroY() - (double)gridCode.row() * this.cellHigh;
        } else {
            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u65b9\u5411:").append(this.direction).toString();
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return new Envelope(xMin, xMax, yMin, yMax);
    }

    public int[] getCode(CodeRange range) {
        if (this.codeRange() == null) {
            String x$1 = "\u6ca1\u6709\u8bbe\u7f6e\u5207\u5206\u8303\u56f4\u65e0\u6cd5\u8ba1\u7b97\u7f16\u7801!";
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        CodeRange resultRange = range;
        if (!this.codeRange().contain(range)) {
            this.logger().warn(new StringBuilder(13).append("\u8f93\u5165\u8303\u56f4").append(range).append("\u4e0d\u5305\u542b\u5728\u7f16\u7801\u8303\u56f4\u5185").append(this.codeRange()).toString());
            resultRange = this.codeRange().intersection(range);
            if (resultRange == null) {
                return (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int());
            }
        }
        int[] codes = new int[resultRange.colSpan() * resultRange.rowSpan()];
        int codeIndex = 0;
        int end$macro$8 = resultRange.rowMax();
        for (int index$macro$7 = resultRange.rowMin(); index$macro$7 <= end$macro$8; ++index$macro$7) {
            int end$macro$3 = resultRange.colMax();
            for (int index$macro$2 = resultRange.colMin(); index$macro$2 <= end$macro$3; ++index$macro$2) {
                codes[codeIndex] = (index$macro$7 - this.codeRange().rowMin()) * this.codeRange().colSpan() + (index$macro$2 - this.codeRange().colMin());
                ++codeIndex;
            }
        }
        return codes;
    }

    public CodeFind getCode(GridCode gridCode) {
        CodeFind codeFind;
        if (this.codeRange() == null) {
            String x$1 = "\u6ca1\u6709\u8bbe\u7f6e\u5207\u5206\u8303\u56f4\u65e0\u6cd5\u8ba1\u7b97\u5e8f\u53f7!";
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        if (this.codeRange().contain(gridCode)) {
            codeFind = new CodeFind(true, (gridCode.row() - this.codeRange().rowMin()) * this.codeRange().colSpan() + (gridCode.col() - this.codeRange().colMin()));
        } else {
            this.logger().warn(new StringBuilder(13).append("\u8f93\u5165\u7f16\u53f7").append(gridCode).append("\u4e0d\u5305\u542b\u5728\u7f16\u7801\u8303\u56f4\u5185").append(this.codeRange()).toString());
            codeFind = new CodeFind(false, -1);
        }
        return codeFind;
    }

    public int getCodeCount() {
        if (this.codeRange() == null) {
            this.logger().warn("\u6ca1\u6709\u8bbe\u7f6e\u5207\u5206\u8303\u56f4\u65e0\u6cd5\u8ba1\u7b97\u7f51\u683c\u6570\u91cf!");
            return -1;
        }
        return this.codeRange().colSpan() * this.codeRange().rowSpan();
    }

    public long getLongCodeCount() {
        if (this.codeRange() == null) {
            String x$1 = "\u6ca1\u6709\u8bbe\u7f6e\u5207\u5206\u8303\u56f4\u65e0\u6cd5\u8ba1\u7b97\u7f51\u683c\u6570\u91cf!";
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        return (long)this.codeRange().colSpan() * (long)this.codeRange().rowSpan();
    }

    public GridTree(Point originPoint, int direction, Envelope boundary, double cellHigh, double cellWeight) {
        this.direction = direction;
        this.boundary = boundary;
        this.cellHigh = cellHigh;
        this.cellWeight = cellWeight;
        LazyLogging.$init$((LazyLogging)this);
        this.zeroX = originPoint.getX();
        this.zeroY = originPoint.getY();
        this.codeRange = boundary != null && !boundary.isNull() ? this.findGridCodes(boundary) : null;
    }
}

