/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.index.vector.common.geomesa.xz2;

import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.data.vector.common.crs.CrsUtils$;
import com.geoway.atlas.index.common.geomesa.utils.ByteArrays$;
import com.geoway.atlas.index.vector.common.geomesa.IndexKeySpace;
import com.geoway.atlas.index.vector.common.geomesa.api.ShardStrategy;
import java.nio.charset.StandardCharsets;
import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001\u0002\u000b\u0016\u0001\u0019B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005g!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0015\r\u0011\"\u0001F\u0011!a\u0005A!A!\u0002\u00131\u0005\"B'\u0001\t\u0003q\u0005b\u0002+\u0001\u0005\u0004%\t!\u0016\u0005\u0007A\u0002\u0001\u000b\u0011\u0002,\t\u000f\u0005\u0004!\u0019!C\u0001E\"1a\r\u0001Q\u0001\n\rDQa\u001a\u0001\u0005B!DQ!\u001b\u0001\u0005\u0002)Dq!\u001c\u0001C\u0002\u0013\u0005a\u000e\u0003\u0004w\u0001\u0001\u0006Ia\u001c\u0005\u0006o\u0002!\t\u0001\u001f\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002\\\u0001!\t!!\u0018\u0003!aS&'\u00138eKb\\U-_*qC\u000e,'B\u0001\f\u0018\u0003\rA(P\r\u0006\u00031e\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u001b7\u000511m\\7n_:T!\u0001H\u000f\u0002\rY,7\r^8s\u0015\tqr$A\u0003j]\u0012,\u0007P\u0003\u0002!C\u0005)\u0011\r\u001e7bg*\u0011!eI\u0001\u0007O\u0016|w/Y=\u000b\u0003\u0011\n1aY8n\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011afL\u0007\u0002/%\u0011\u0001g\u0006\u0002\u000e\u0013:$W\r_&fsN\u0003\u0018mY3\u0002\u0007M4G/F\u00014!\t!T(D\u00016\u0015\t1t'\u0001\u0004tS6\u0004H.\u001a\u0006\u0003qe\nqAZ3biV\u0014XM\u0003\u0002;w\u00059q\u000e]3oO&\u001c(\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?k\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0002\tM4G\u000fI\u0001\fqj\u0004&/Z2jg&|g\u000e\u0005\u0002)\u0005&\u00111)\u000b\u0002\u0006'\"|'\u000f^\u0001\tg\"\f'\u000fZ5oOV\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002J/\u0005\u0019\u0011\r]5\n\u0005-C%!D*iCJ$7\u000b\u001e:bi\u0016<\u00170A\u0005tQ\u0006\u0014H-\u001b8hA\u00051A(\u001b8jiz\"BaT)S'B\u0011\u0001\u000bA\u0007\u0002+!)\u0011G\u0002a\u0001g!)\u0001I\u0002a\u0001\u0003\")AI\u0002a\u0001\r\u0006Y1M]:C_VtG-\u0019:z+\u00051\u0006CA,_\u001b\u0005A&BA-[\u0003\u00119Wm\\7\u000b\u0005mc\u0016a\u00016ug*\u0011QlO\u0001\rY>\u001c\u0017\r^5p]R,7\r[\u0005\u0003?b\u0013\u0001\"\u00128wK2|\u0007/Z\u0001\rGJ\u001c(i\\;oI\u0006\u0014\u0018\u0010I\u0001\tKB\u001cxmQ8eKV\t1\r\u0005\u0002)I&\u0011Q-\u000b\u0002\u0004\u0013:$\u0018!C3qg\u001e\u001cu\u000eZ3!\u0003\u001d9W\r\u001e\"jiN$\u0012aY\u0001\u0007I&<\u0017\u000e^:\u0015\u0005\r\\\u0007\"\u00027\r\u0001\u0004\u0019\u0017\u0001\u00022jiN\f1a\u001d4d+\u0005y\u0007C\u00019u\u001b\u0005\t(B\u0001:t\u0003\u0015\u0019WO\u001d<f\u0015\tAB,\u0003\u0002vc\n1\u0001L\u0017\u001aT\r\u000e\u000bAa\u001d4dA\u0005Yq-\u001a;J]\u0012,\u0007pS3z)\tIx\u0010E\u0002)urL!a_\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005!j\u0018B\u0001@*\u0005\u0011\u0011\u0015\u0010^3\t\raz\u0001\u0019AA\u0001!\r!\u00141A\u0005\u0004\u0003\u000b)$!D*j[BdWMR3biV\u0014X-A\u0005hKR\u0014\u0016M\\4fgR1\u00111BA\u0018\u0003g\u0001b!!\u0004\u0002\u001e\u0005\rb\u0002BA\b\u00033qA!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+)\u0013A\u0002\u001fs_>$h(C\u0001+\u0013\r\tY\"K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty\"!\t\u0003\u0007M+\u0017OC\u0002\u0002\u001c%\u0002B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003Sa\u0016aB:gGV\u0014h/Z\u0005\u0005\u0003[\t9C\u0001\u0006J]\u0012,\u0007PU1oO\u0016Da!!\r\u0011\u0001\u00041\u0016\u0001C3om\u0016dw\u000e]3\t\u000f\u0005U\u0002\u00031\u0001\u00028\u0005y\u0001/\u001a:QCJ$\u0018\u000e^5p]:+X\u000e\u0005\u0003)\u0003s\u0019\u0017bAA\u001eS\t1q\n\u001d;j_:\f\u0001cZ3u!\u0006\u0014H/\u001b;j_:t\u0015-\\3\u0015\t\u0005\u0005\u00131\u000b\t\u0007\u0003\u001b\ti\"a\u0011\u0011\t\u0005\u0015\u0013Q\n\b\u0005\u0003\u000f\nI\u0005E\u0002\u0002\u0012%J1!a\u0013*\u0003\u0019\u0001&/\u001a3fM&!\u0011qJA)\u0005\u0019\u0019FO]5oO*\u0019\u00111J\u0015\t\ra\n\u0002\u0019AA\u0001\u0003%9W\r^*qY&$8/\u0006\u0002\u0002ZA)\u0011QBA\u000fs\u0006iQ.^:u\r>,h\u000eZ#qg\u001e$B!a\u0018\u0002fA\u0019\u0001&!\u0019\n\u0007\u0005\r\u0014F\u0001\u0003V]&$\b\"B1\u0014\u0001\u0004\u0019\u0007")
public class XZ2IndexKeySpace
implements IndexKeySpace {
    private final SimpleFeatureType sft;
    private final short xzPrecision;
    private final ShardStrategy sharding;
    private final Envelope crsBoundary;
    private final int epsgCode;
    private final XZ2SFC sfc;
    private final String format;

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public void com$geoway$atlas$index$vector$common$geomesa$IndexKeySpace$_setter_$format_$eq(String x$1) {
        this.format = x$1;
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    public ShardStrategy sharding() {
        return this.sharding;
    }

    public Envelope crsBoundary() {
        return this.crsBoundary;
    }

    public int epsgCode() {
        return this.epsgCode;
    }

    @Override
    public int getBits() {
        return this.digits(this.xzPrecision * 2);
    }

    public int digits(int bits) {
        return (int)package$.MODULE$.ceil((double)(bits / 2 + 1) * package$.MODULE$.log10(4.0) - package$.MODULE$.log10(3.0));
    }

    public XZ2SFC sfc() {
        return this.sfc;
    }

    @Override
    public byte[] getIndexKey(SimpleFeature feature) {
        Geometry geom = (Geometry)feature.getDefaultGeometry();
        Envelope envelope = geom.getEnvelopeInternal();
        long xz = this.sfc().index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), this.sfc().index$default$5());
        byte[] shard = this.sharding().apply(feature.getID());
        byte[] featureId = feature.getID().getBytes(StandardCharsets.UTF_8);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 8 + featureId.length, ClassTag$.MODULE$.Byte());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).isEmpty()) {
            ByteArrays$.MODULE$.writeLong(xz, bytes, 0);
            System.arraycopy(featureId, 0, bytes, 8, featureId.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).head());
            ByteArrays$.MODULE$.writeLong(xz, bytes, 1);
            System.arraycopy(featureId, 0, bytes, 9, featureId.length);
        }
        return bytes;
    }

    @Override
    public Seq<IndexRange> getRanges(Envelope envelope, Option<Object> perPartitionNum) {
        Tuple4 tuple4 = this.sfc().getBounds();
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double xMin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double xMax = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double yMin = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double yMax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xMin), (Object)BoxesRunTime.boxToDouble((double)xMax), (Object)BoxesRunTime.boxToDouble((double)yMin), (Object)BoxesRunTime.boxToDouble((double)yMax));
        Tuple4 tuple43 = tuple42;
        double xMin2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        double xMax2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
        double yMin2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double yMax2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        Envelope nEnv = envelope.intersection(new Envelope(xMin2, xMax2, yMin2, yMax2));
        return nEnv.isNull() ? (Seq)Nil$.MODULE$ : this.sfc().ranges(nEnv.getMinX(), nEnv.getMinY(), nEnv.getMaxX(), nEnv.getMaxY(), perPartitionNum);
    }

    @Override
    public Seq<String> getPartitionName(SimpleFeature feature) {
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        Envelope envelope = geometry.getEnvelopeInternal();
        return (Seq)new .colon.colon((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)this.sfc().index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), this.sfc().index$default$5()))), this.format()), (List)Nil$.MODULE$);
    }

    @Override
    public Seq<byte[]> getSplits() {
        return (Seq)this.sharding().shards().drop(1);
    }

    public void mustFoundEpsg(int epsgCode) {
        if (epsgCode <= 0) {
            String x$1 = "\u65e0\u6cd5\u627e\u5230epsg\u4ee3\u7801!";
            Thread x$2 = NotFoundException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotFoundException$.MODULE$.apply$default$3(x$1);
            throw new NotFoundException(x$1, x$2, x$3);
        }
    }

    public XZ2IndexKeySpace(SimpleFeatureType sft, short xzPrecision, ShardStrategy sharding) {
        this.sft = sft;
        this.xzPrecision = xzPrecision;
        this.sharding = sharding;
        IndexKeySpace.$init$(this);
        this.crsBoundary = CrsUtils$.MODULE$.getEncodeBoundary(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType(sft).getCRS());
        this.epsgCode = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType(sft).getCRS());
        this.mustFoundEpsg(this.epsgCode());
        this.sfc = XZ2SFC$.MODULE$.apply(new XZ2SFC.Xz2SfcKey(xzPrecision, com.geoway.atlas.data.vector.common.crs.package$.MODULE$.FIND_SRID(com.geoway.atlas.data.vector.common.feature.sft.package$.MODULE$.RichSimpleFeatureType(sft).getCRS())), (Tuple2)new Tuple2.mcDD.sp(this.crsBoundary().getMinX(), this.crsBoundary().getMaxX()), (Tuple2)new Tuple2.mcDD.sp(this.crsBoundary().getMinY(), this.crsBoundary().getMaxY()));
    }
}

