/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.gis.toolkit.log.es.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.geoway.atlas.gis.toolkit.log.EsLogMsg;
import com.geoway.atlas.gis.toolkit.log.EsProvider;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class EsHttpClient {
    protected static final Logger STATUS_LOGGER = StatusLogger.getLogger();
    protected static final Logger LOGGER = LogManager.getLogger(EsHttpClient.class);
    protected static final ObjectMapper MAPPER_INDENT = new ObjectMapper();
    private static int ESTABLISH_TIMEOUT;
    private static int SOCKET_TIMEOUT;
    private static int GET_FROM_POOL_TIMEOUT;
    private static int POOL_SIZE;
    private final String host;
    private final String user;
    private final String password;
    private final String index;
    private final CloseableHttpClient httpClient;

    public EsHttpClient(String host, String user, String password, String index) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.index = index;
        this.httpClient = this.getHttpClient();
    }

    public boolean needCreateIndex() {
        int code = this.head("http://" + this.host + "/" + this.index);
        return code != 200 && code != -1;
    }

    public boolean createIndex() {
        String response = this.put("http://" + this.host + "/" + this.index, EsHttpClient.getLogIndex(), ContentType.APPLICATION_JSON.getMimeType());
        if (StringUtils.isNotEmpty((CharSequence)response)) {
            Map responseMap = new HashMap();
            try {
                responseMap = (Map)EsProvider.OBJECT_MAPPER.readValue(response, Map.class);
                if (responseMap.containsKey("acknowledged") && ((Boolean)responseMap.get("acknowledged")).booleanValue()) {
                    return true;
                }
                LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25\uff0c\u54cd\u5e94\u4fe1\u606f\u4e3a:" + response);
                return false;
            }
            catch (JsonProcessingException e) {
                LOGGER.error("\u65e0\u6cd5\u89e3\u6790\u521b\u5efa\u7d22\u5f15\u54cd\u5e94\u4fe1\u606f:" + response);
                return false;
            }
        }
        return false;
    }

    public static String getLogIndex() {
        return "{\"mappings\":{\"properties\":{\"className\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"hostName\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"ip\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"jobId\":{\"type\":\"keyword\"},\"level\":{\"type\":\"keyword\"},\"message\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"processId\":{\"type\":\"long\"},\"stackTrace\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"taskId\":{\"type\":\"keyword\"},\"threadName\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"applicationName\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"timeStamp\":{\"type\":\"date\",\"format\":\"yyyy-MM-ddHH:mm:ss.SSS||strict_date_optional_time||epoch_millis\"},\"userName\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"clientIp\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"url\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"eventType\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"operationObject\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"description\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"result\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"label\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}},\"customize\":{\"type\":\"text\",\"fields\":{\"raw\":{\"type\":\"keyword\"}}}}},\"settings\":{\"index\":{\"number_of_shards\":\"3\",\"number_of_replicas\":\"1\"}}}";
    }

    public void bulk(List<EsLogMsg> logMsgList) {
        if (logMsgList != null && !logMsgList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String indexHeader = "{\"index\":{ \"_index\" : \"" + this.index + "\"}}";
            for (EsLogMsg esLogMsg : logMsgList) {
                String jsonLog = this.toJSON(esLogMsg);
                if (jsonLog == null) continue;
                sb.append(indexHeader).append("\n").append(jsonLog).append("\n");
            }
            this.post("http://" + this.host + "/_bulk", sb.toString(), "application/x-ndjson");
        }
    }

    private String toJSON(Object object) {
        try {
            return MAPPER_INDENT.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            LOGGER.info("\u65e0\u6cd5\u5e8f\u5217\u5316\u65e5\u5fd7\u5bf9\u8c61!");
            return null;
        }
    }

    private String get(String url) {
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(url));
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)StandardCharsets.UTF_8.toString());
            }
            STATUS_LOGGER.error("GET\u8bf7\u6c42ES\u63a5\u53e3" + url + "\u9519\u8bef\uff0c\u54cd\u5e94\u4ee3\u7801\u4e3a:" + response.getStatusLine().getStatusCode());
            response.close();
            return null;
        }
        catch (Throwable throwable) {
            STATUS_LOGGER.error("GET\u8bf7\u6c42ES\u63a5\u53e3" + url + "\u9519\u8bef!", throwable);
            return null;
        }
    }

    private int head(String url) {
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpHead(url));
            int code = response.getStatusLine().getStatusCode();
            response.close();
            return code;
        }
        catch (Throwable throwable) {
            STATUS_LOGGER.error("HEAD\u8bf7\u6c42ES\u63a5\u53e3" + url + "\u9519\u8bef!", throwable);
            return -1;
        }
    }

    private String put(String url, Object object, String contentType) {
        try {
            HttpPut httpPut = new HttpPut(url);
            if (ContentType.APPLICATION_JSON.getMimeType().equals(contentType)) {
                if (object instanceof String) {
                    httpPut.setEntity((HttpEntity)new StringEntity((String)object, ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8)));
                } else {
                    httpPut.setEntity((HttpEntity)new StringEntity(EsProvider.OBJECT_MAPPER.writeValueAsString(object), ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8)));
                }
            } else {
                httpPut.setEntity((HttpEntity)new StringEntity((String)object, ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8)));
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPut);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)StandardCharsets.UTF_8.toString());
            }
            STATUS_LOGGER.error("PUT\u8bf7\u6c42ES\u63a5\u53e3" + url + "\u9519\u8bef\uff0c\u54cd\u5e94\u4ee3\u7801\u4e3a:" + response.getStatusLine().getStatusCode());
            response.close();
            return null;
        }
        catch (Throwable throwable) {
            STATUS_LOGGER.error("PUT\u8bf7\u6c42ES\u63a5\u53e3" + url + "\u9519\u8bef!", throwable);
            return null;
        }
    }

    private String post(String url, Object object, String contentType) {
        try {
            HttpPost httpPost = new HttpPost(url);
            if (ContentType.APPLICATION_JSON.getMimeType().equals(contentType)) {
                if (object instanceof String) {
                    httpPost.setEntity((HttpEntity)new StringEntity((String)object, ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8)));
                } else {
                    httpPost.setEntity((HttpEntity)new StringEntity(EsProvider.OBJECT_MAPPER.writeValueAsString(object), ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8)));
                }
            } else {
                httpPost.setEntity((HttpEntity)new StringEntity((String)object, ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8)));
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)StandardCharsets.UTF_8.toString());
            }
            STATUS_LOGGER.error("POST\u8bf7\u6c42ES\u63a5\u53e3" + url + "\u9519\u8bef\uff0c\u54cd\u5e94\u4ee3\u7801\u4e3a:" + response.getStatusLine().getStatusCode());
            response.close();
            return null;
        }
        catch (Throwable throwable) {
            STATUS_LOGGER.error("POST\u8bf7\u6c42ES\u63a5\u53e3" + url + "\u9519\u8bef!", (Object)ExceptionUtils.getRootCauseMessage((Throwable)throwable));
            return null;
        }
    }

    private CloseableHttpClient getHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(ESTABLISH_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).setConnectionRequestTimeout(GET_FROM_POOL_TIMEOUT).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(POOL_SIZE * 5);
        connectionManager.setDefaultMaxPerRoute(POOL_SIZE);
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("Content-Type", "application/json"));
        if (StringUtils.isNotEmpty((CharSequence)this.user)) {
            defaultHeaders.add(new BasicHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])String.format("%s:%s", this.user, this.password).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8)));
        }
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultHeaders(defaultHeaders).setDefaultRequestConfig(requestConfig).build();
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        MAPPER_INDENT.disable(SerializationFeature.INDENT_OUTPUT);
        ESTABLISH_TIMEOUT = 10000;
        SOCKET_TIMEOUT = 120000;
        GET_FROM_POOL_TIMEOUT = 10000;
        POOL_SIZE = 10;
    }
}

