/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.test.data.shapefile;

import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.common.io.StandardInputFactory;
import com.geoway.atlas.common.io.StandardInputFactory$;
import com.geoway.atlas.data.vector.shapefile.common.dbf.DbaseFileReader;
import com.geoway.atlas.data.vector.shapefile.common.dbf.DbaseFileReader$;
import com.geoway.atlas.data.vector.shapefile.common.dbf.IndexDbaseFileReader;
import com.geoway.atlas.data.vector.shapefile.common.dbf.IndexDbaseFileReader$;
import com.geoway.atlas.data.vector.shapefile.common.sbn.SbnReader;
import com.geoway.atlas.data.vector.shapefile.common.sbn.SbnReader$;
import com.geoway.atlas.data.vector.shapefile.common.sbn.query.SearchResult;
import com.geoway.atlas.data.vector.shapefile.common.shp.ShpReader;
import com.geoway.atlas.data.vector.shapefile.common.shp.ShpReader$;
import com.geoway.atlas.data.vector.shapefile.common.shp.ShxReader;
import com.geoway.atlas.data.vector.shapefile.common.shp.ShxReader$;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;

public final class ShapeFileHandler$ {
    public static ShapeFileHandler$ MODULE$;

    static {
        new ShapeFileHandler$();
    }

    public ShxReader getShxFileReader(String path) {
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.local"), (Object)path)}));
        StandardInputFactory inputFactory = StandardInputFactory$.MODULE$.apply(params);
        StandardInput standardInput = inputFactory.getStandardInput(params);
        return ShxReader$.MODULE$.apply(standardInput);
    }

    public ShpReader getShpFileReader(String path) {
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.local"), (Object)path)}));
        StandardInputFactory inputFactory = StandardInputFactory$.MODULE$.apply(params);
        StandardInput standardInput = inputFactory.getStandardInput(params);
        return ShpReader$.MODULE$.apply(standardInput);
    }

    public DbaseFileReader getDbaseFileReader(String path) {
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.local"), (Object)path)}));
        StandardInputFactory inputFactory = StandardInputFactory$.MODULE$.apply(params);
        StandardInput standardInput = inputFactory.getStandardInput(params);
        return DbaseFileReader$.MODULE$.apply(standardInput);
    }

    public IndexDbaseFileReader getIndexedDbaseFileReader(String path) {
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.local"), (Object)path)}));
        StandardInputFactory inputFactory = StandardInputFactory$.MODULE$.apply(params);
        StandardInput standardInput = inputFactory.getStandardInput(params);
        return IndexDbaseFileReader$.MODULE$.apply(standardInput);
    }

    public SbnReader getSbnReader(String path) {
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.local"), (Object)path)}));
        StandardInputFactory inputFactory = StandardInputFactory$.MODULE$.apply(params);
        StandardInput standardInput = inputFactory.getStandardInput(params);
        return SbnReader$.MODULE$.apply(standardInput);
    }

    public SearchResult readSpatialIndex(SbnReader sbnReader, Envelope envelope) {
        return sbnReader.sbnSearchDiskTree(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public SimpleFeatureSource getFeatureSource(String filePath) {
        File file = new File(filePath);
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        map.put((Object)"url", (Object)file.toURI().toURL());
        map.put((Object)"charset", (Object)StandardCharsets.UTF_8);
        ShapefileDataStore shapefileDataStore = (ShapefileDataStore)DataStoreFinder.getDataStore((Map)((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(map).asJava()));
        String typeName = shapefileDataStore.getTypeNames()[0];
        ContentFeatureSource sfs = shapefileDataStore.getFeatureSource(typeName);
        shapefileDataStore.dispose();
        return sfs;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureCollection readShapefile(String filePath, Filter filter) {
        void var3_3;
        SimpleFeatureCollection featureCollection = null;
        SimpleFeatureSource featureSource = this.getFeatureSource(filePath);
        featureCollection = featureSource.getFeatures(filter);
        return var3_3;
    }

    public SimpleFeatureCollection readShapefile(String filePath) {
        File file = new File(filePath);
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        map.put((Object)"url", (Object)file.toURI().toURL());
        map.put((Object)"charset", (Object)StandardCharsets.UTF_8);
        SimpleFeatureCollection featureCollection = null;
        DataStore shapefileDataStore = DataStoreFinder.getDataStore((Map)((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(map).asJava()));
        String typeName = shapefileDataStore.getTypeNames()[0];
        SimpleFeatureSource featureSource = shapefileDataStore.getFeatureSource(typeName);
        shapefileDataStore.dispose();
        featureCollection = featureSource.getFeatures((Filter)Filter.INCLUDE);
        return featureCollection;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeature[] readSimpleFeature(SimpleFeatureCollection sfc) {
        void var3_3;
        SimpleFeatureIterator sfi = sfc.features();
        SimpleFeature[] sfs = new SimpleFeature[sfc.size()];
        int i = 0;
        while (sfi.hasNext()) {
            SimpleFeature sf;
            sfs[i] = sf = (SimpleFeature)sfi.next();
            ++i;
        }
        sfi.close();
        return var3_3;
    }

    public SimpleFeatureCollection geometryToFeature(Seq<Geometry> geometries, Class<?> geomClass) {
        Buffer features = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("Type");
        typeBuilder.add("the_geom", geomClass);
        typeBuilder.setDefaultGeometry("the_geom");
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        for (int index$macro$1 = 0; index$macro$1 < geometries.length(); ++index$macro$1) {
            Geometry geometry = (Geometry)geometries.apply(index$macro$1);
            if (geometry == null) continue;
            featureBuilder.add((Object)geometry);
            SimpleFeature feature = featureBuilder.buildFeature("null");
            features.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{feature}));
        }
        return new ListFeatureCollection(featureType, (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(features).asJava());
    }

    public void writeShapeFile(String filePath, SimpleFeatureCollection sfc, String coding, CoordinateReferenceSystem crs) {
        List list;
        ContentFeatureSource featureSource;
        File file = new File(filePath);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        scala.collection.mutable.Map param = (scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        param.put((Object)"url", (Object)file.toURI().toURL());
        param.put((Object)"create spatial index", (Object)Predef$.MODULE$.boolean2Boolean(true));
        ShapefileDataStore ds = (ShapefileDataStore)dataStoreFactory.createNewDataStore((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(param).asJava());
        ds.setCharset(Charset.forName(coding));
        SimpleFeatureType featureType = (SimpleFeatureType)sfc.getSchema();
        ds.createSchema(featureType);
        ds.forceSchemaCRS(crs);
        String typeName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames())).head();
        ContentFeatureSource contentFeatureSource = featureSource = ds.getFeatureSource(typeName);
        if (contentFeatureSource instanceof SimpleFeatureStore) {
            SimpleFeatureStore simpleFeatureStore = (SimpleFeatureStore)contentFeatureSource;
            simpleFeatureStore.setTransaction(null);
            try {
                try {
                    list = simpleFeatureStore.addFeatures((FeatureCollection)sfc);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    list = BoxedUnit.UNIT;
                }
            }
            finally {
                this.cpgwriter(filePath, coding);
            }
        } else {
            throw new MatchError((Object)contentFeatureSource);
        }
        List list2 = list;
        System.out.println("Write Shapefile successfully");
    }

    public void cpgwriter(String filePath, String coding) {
        String cfgPath = new StringBuilder(4).append(filePath.substring(0, filePath.lastIndexOf("."))).append(".cpg").toString();
        String code = coding.toUpperCase();
        File file = new File(cfgPath);
        FileWriter out = new FileWriter(file);
        out.write(code);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private ShapeFileHandler$() {
        MODULE$ = this;
    }
}

