/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.component.serverCenter.redis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.atlas.web.api.v2.component.serverCenter.RegisterInfo;
import com.geoway.atlas.web.api.v2.component.serverCenter.ServerHandle;
import com.geoway.atlas.web.api.v2.component.serverCenter.redis.RedisRegisterInfo;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import java.time.Duration;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.spark.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import scala.runtime.BoxedUnit;

public class RedisServerHandle
implements ServerHandle {
    private static final Logger log = LoggerFactory.getLogger(RedisServerHandle.class);
    public static final String NAME = "REDIS";
    public static final String PATH_HEARTBEAT = "/atlas/heartbeat";
    public static final String STOP_INSTRUCTION = "STOP";
    public static final String HEARTBEAT_INSTRUCTION = "HEART";
    public static final Integer REDIS_SHUTDOWN_PRIORITY = 100;
    public static final Integer MAX_WAIT = 10000;
    public final JedisPool jedisPool;
    public final String redisPath;
    public Thread monitorThread;
    public String cacheKey = null;
    private String taskId = null;
    private String jobId = null;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RedisServerHandle(String redisIp, String redisPath, String userName, String password, String taskId, String jobId) {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(8);
        jedisPoolConfig.setMaxIdle(8);
        jedisPoolConfig.setMinIdle(0);
        jedisPoolConfig.setMaxWait(Duration.ofMillis(MAX_WAIT.intValue()));
        int port = 6379;
        int indexPort = redisIp.indexOf(":");
        if (indexPort != -1) {
            port = Integer.parseInt(StringUtils.substring((String)redisIp, (int)(indexPort + 1)));
        }
        this.jedisPool = StringUtils.isNotBlank((CharSequence)userName) ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, StringUtils.substringBefore((String)redisIp, (String)":"), port, MAX_WAIT.intValue(), userName, password) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, StringUtils.substringBefore((String)redisIp, (String)":"), port, MAX_WAIT.intValue());
        this.redisPath = redisPath;
        this.taskId = taskId;
        this.jobId = jobId;
    }

    public Jedis getJedis() {
        return this.jedisPool.getResource();
    }

    @Override
    public void register(RegisterInfo registerInfo) {
        RedisRegisterInfo redisRegisterInfo = new RedisRegisterInfo();
        String pluginName = this.redisPath + ":" + registerInfo.getPort();
        redisRegisterInfo.setName(pluginName);
        redisRegisterInfo.setIp(registerInfo.getIp());
        redisRegisterInfo.setPort(Integer.parseInt(registerInfo.getPort()));
        redisRegisterInfo.setCpu(registerInfo.getCpu().intValue());
        redisRegisterInfo.setMemorySize(registerInfo.getMemorySize().intValue());
        Jedis jedis = this.getJedis();
        ShutdownHookManager.addShutdownHook((int)REDIS_SHUTDOWN_PRIORITY, () -> {
            this.stop();
            return BoxedUnit.UNIT;
        });
        String key = this.getRedisKey(registerInfo);
        try {
            jedis.set(this.getRedisKey(registerInfo), this.objectMapper.writeValueAsString((Object)redisRegisterInfo));
        }
        catch (JsonProcessingException e) {
            throw new AtlasException("\u65e0\u6cd5\u6ce8\u518credis\u670d\u52a1", (Throwable)e);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        log.info("\u5fc3\u8df3\u6ce8\u518c\u6210\u529f");
        this.cacheKey = key;
    }

    private String getRedisKey(RegisterInfo registerInfo) {
        return this.redisPath + ":" + (StringUtils.isNotBlank((CharSequence)this.taskId) ? this.taskId : registerInfo.getIp() + "-" + registerInfo.getPort());
    }

    @Override
    public void monitor(RegisterInfo registerInfo) {
        String redisKey = this.getRedisKey(registerInfo);
        HashMap<String, String> heartbeat = new HashMap<String, String>();
        heartbeat.put("instruction", HEARTBEAT_INSTRUCTION);
        heartbeat.put("serviceKey", redisKey);
        Runnable runnable = () -> {
            while (true) {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    throw new AtlasException((Throwable)e);
                }
                Jedis jedis = null;
                try {
                    jedis = this.getJedis();
                    jedis.publish(PATH_HEARTBEAT, this.objectMapper.writeValueAsString((Object)heartbeat));
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new AtlasException("\u53d1\u9001\u5fc3\u8df3\u5931\u8d25\uff01", (Throwable)e);
                }
                finally {
                    if (jedis == null) continue;
                    this.jedisPool.returnResource(jedis);
                    continue;
                }
                break;
            }
        };
        this.monitorThread = new Thread(runnable, "redis-heartbeat");
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
        log.info("\u542f\u52a8\u5fc3\u8df3\u670d\u52a1");
    }

    @Override
    public void registerRpc(RegisterInfo registerInfo) {
    }

    @Override
    public void monitorRpc(RegisterInfo registerInfo) {
    }

    @Override
    public void stop() {
        if (StringUtils.isNotBlank((CharSequence)this.cacheKey)) {
            Jedis jedis = this.getJedis();
            try {
                jedis.del(this.cacheKey);
                HashMap<String, String> heartbeat = new HashMap<String, String>();
                heartbeat.put("instruction", STOP_INSTRUCTION);
                heartbeat.put("serviceKey", this.cacheKey);
                jedis.publish(PATH_HEARTBEAT, this.objectMapper.writeValueAsString(heartbeat));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.jedisPool.returnResource(jedis);
            }
        }
        if (!this.jedisPool.isClosed()) {
            this.jedisPool.close();
        }
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
        }
    }
}

