/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.component.rpc;

import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.data.vector.spark.common.rpc.server.SparkRpcServerApi;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Component;

@Component
public class RpcServiceProxy {
    private static final Logger log = LoggerFactory.getLogger(RpcServiceProxy.class);
    public static final String RPC_PORT = "atlas.rpc.port";
    @Autowired
    private ApplicationArguments arguments;
    private SparkRpcServerApi sparkRpcServerApi;
    @Autowired
    @Qualifier(value="rpcServerPool")
    private ExecutorService rpcServerPool;

    public void init() {
        String address = null;
        List serverPortOpt = this.arguments.getOptionValues(RPC_PORT);
        if (CollectionUtils.isNotEmpty((Collection)serverPortOpt) && serverPortOpt.size() == 1) {
            int port = Integer.parseInt((String)serverPortOpt.get(0));
            List addressOpt = this.arguments.getOptionValues("server.address");
            if (CollectionUtils.isNotEmpty((Collection)addressOpt)) {
                address = (String)addressOpt.get(0);
            }
            this.sparkRpcServerApi = StringUtils.isNotBlank(address) ? new SparkRpcServerApi(address, port, this.rpcServerPool) : new SparkRpcServerApi(port, this.rpcServerPool);
            try {
                this.sparkRpcServerApi.start();
            }
            catch (IOException ioException) {
                log.error(ExceptionUtils.getStackTrace((Throwable)ioException));
                throw new IoException("\u65e0\u6cd5\u542f\u52a8rpc\u670d\u52a1:" + ExceptionUtils.getRootCauseMessage((Throwable)ioException), Thread.currentThread(), 3);
            }
        } else {
            log.warn("\u65e0\u6cd5\u627e\u5230\u5408\u6cd5\u7684rpc\u7aef\u53e3\u53f7\uff0c\u6ca1\u6709\u542f\u52a8rpc\u670d\u52a1!");
        }
    }

    @PreDestroy
    public void stop() throws InterruptedException {
        if (this.sparkRpcServerApi != null) {
            this.sparkRpcServerApi.stop();
        }
    }
}

