/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.job;

import com.geoway.atlas.data.vector.spark.common.rpc.common.AtlasRpcServerException;
import com.geoway.atlas.web.api.v2.component.bean.AtlasGisToolkitBeanFactory;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobManager {
    public static final String JOB_ID = "jobid";
    public static final String TASK_ID = "taskid";
    private final AtomicInteger autoId = new AtomicInteger(0);
    @Autowired
    private RpcClientProxy rpcClientProxy;
    private ConcurrentMap<String, ConcurrentMap<String, Future<?>>> futureConcurrentMap = new ConcurrentHashMap();

    public String getJobId(HttpServletRequest request) {
        String jobId = request.getParameter(JOB_ID);
        if (StringUtils.isBlank((CharSequence)jobId)) {
            jobId = Integer.toString(this.autoId.getAndIncrement());
        }
        return jobId;
    }

    public String getTaskId(HttpServletRequest request) {
        String taskId = request.getParameter(TASK_ID);
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u7684taskid!");
        }
        return taskId;
    }

    public String toJSON(Map<String, Object> map) {
        return AtlasGisToolkitBeanFactory.getObjectMapper().writeValueAsString(map);
    }

    public Map<String, Object> fromJSON(String jsonString) {
        return (Map)AtlasGisToolkitBeanFactory.getObjectMapper().readValue(jsonString, Map.class);
    }

    public String startJob(String rawTaskId, String jobId, Map<String, Object> response) {
        return this.rpcClientProxy.getSparkRpcClientApi().startJob(rawTaskId, jobId, this.toJSON(response));
    }

    public synchronized void putFuture(String rawTaskId, String jobId, Future<?> future) {
        ConcurrentMap<String, Future<?>> futureMap;
        if (!this.futureConcurrentMap.containsKey(rawTaskId)) {
            futureMap = new ConcurrentHashMap();
            this.futureConcurrentMap.put(rawTaskId, futureMap);
        } else {
            futureMap = (ConcurrentMap)this.futureConcurrentMap.get(rawTaskId);
        }
        futureMap.put(jobId, future);
    }

    public synchronized void finishJob(String rawTaskId, String jobId, Map<String, Object> response) {
        int WAIT_FOR_CHECK = 50;
        int MAX_TRY = 2000;
        int initTaskTry = 0;
        while (!this.futureConcurrentMap.containsKey(rawTaskId) && initTaskTry < MAX_TRY) {
            try {
                Thread.sleep(WAIT_FOR_CHECK);
                ++initTaskTry;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (initTaskTry == MAX_TRY && !this.futureConcurrentMap.containsKey(rawTaskId)) {
            this.rpcClientProxy.getSparkRpcClientApi().finishJob(rawTaskId, jobId, this.toJSON(response));
            return;
        }
        int initJobTry = 0;
        while (!((ConcurrentMap)this.futureConcurrentMap.get(rawTaskId)).containsKey(jobId) && initJobTry < MAX_TRY) {
            try {
                Thread.sleep(WAIT_FOR_CHECK);
                ++initJobTry;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (initJobTry == MAX_TRY && !((ConcurrentMap)this.futureConcurrentMap.get(rawTaskId)).containsKey(jobId)) {
            this.rpcClientProxy.getSparkRpcClientApi().finishJob(rawTaskId, jobId, this.toJSON(response));
            return;
        }
        ((ConcurrentMap)this.futureConcurrentMap.get(rawTaskId)).remove(jobId);
        this.rpcClientProxy.getSparkRpcClientApi().finishJob(rawTaskId, jobId, this.toJSON(response));
    }

    public synchronized void stopFutures(String rawTaskId) {
        if (this.futureConcurrentMap.containsKey(rawTaskId)) {
            for (Future future : ((ConcurrentMap)this.futureConcurrentMap.get(rawTaskId)).values()) {
                try {
                    future.cancel(true);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public synchronized void cancelJob(String taskId, String jobId) {
        Map<String, Object> failedObj = ResponseBuilder.buildFailed((Throwable)new AtlasRpcServerException("\u4efb\u52a1" + taskId + "\u5df2\u88ab\u505c\u6b62!"));
        this.rpcClientProxy.getSparkRpcClientApi().cancelJob(taskId, jobId, this.toJSON(failedObj));
    }

    public Map<String, Object> getJobInfo(String jobId) {
        String response = this.rpcClientProxy.getSparkRpcClientApi().getJobReponse("", jobId);
        if (StringUtils.isNotBlank((CharSequence)response)) {
            return this.fromJSON(response);
        }
        return ResponseBuilder.buildFailed(new RuntimeException("\u65e0\u6cd5\u627e\u5230\u4efb\u52a1id"));
    }

    public ConcurrentMap<String, ConcurrentMap<String, Future<?>>> getFutureConcurrentMap() {
        return this.futureConcurrentMap;
    }
}

