/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.service.pkg.impl;

import com.geoway.atlas.common.utils.UUIDUtils;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.service.DataServer;
import com.geoway.atlas.web.api.v2.service.pkg.GraphAnalysisServer;
import com.geoway.atlas.web.api.v2.utils.AtlasTagUtils;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GraphAnalysisServerImpl
implements GraphAnalysisServer {
    private static final Logger log = LoggerFactory.getLogger(GraphAnalysisServerImpl.class);
    @Autowired
    private DataServer dataServer;
    @Autowired
    private RpcClientProxy client;

    @Override
    public Map<String, Object> commonProcess(String baseIdentity, String processName, Map<String, String> bfsParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId, String response) {
        String baseLayerName = this.dataServer.loadGraphLayer(baseIdentity, new HashMap<String, String>(), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, bfsParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveGraphLayer(resultLayerName, resultUrl, new HashMap<String, String>(), taskId, jobId);
        }
        return ResponseBuilder.buildSuccess(response);
    }
}

